/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project.meta;

import com.google.gson.Gson;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.project.meta.PuppetMetadata;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetModuleMetadata
implements PuppetMetadata {
    private static final Gson myGson = new Gson();
    @Nullable
    private String name;
    @Nullable
    private String version;
    @Nullable
    private String author;
    @Nullable
    private String license;
    @Nullable
    private String summary;
    @Nullable
    private String source;
    @Nullable
    private List<Dependency> dependencies;
    @Nullable
    private String project_page;
    @Nullable
    private String issues_url;
    @Nullable
    private List<OsSupport> operatingsystem_support;
    @Nullable
    private List<String> tags;
    @Nullable
    private String data_provider;
    private final transient AtomicNotNullLazyValue<List<Dependency>> myDependencyProvider = new AtomicNotNullLazyValue<List<Dependency>>(){

        @NotNull
        protected List<Dependency> compute() {
            if (PuppetModuleMetadata.this.dependencies == null) {
                List<Dependency> list = Collections.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }
            List list = ContainerUtil.filter((Collection)PuppetModuleMetadata.this.dependencies, dependency -> dependency != null);
            if (list == null) {
                1.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/puppet/project/meta/PuppetModuleMetadata$1", "compute"));
        }
    };

    public String toString() {
        return this.getName() + " " + this.getVersion();
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    protected void setName(@Nullable String newName) {
        this.name = newName;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String moduleName = this.getName();
        String moduleVersion = this.getVersion();
        if (StringUtil.isEmpty((String)moduleName)) {
            String string = PuppetBundle.message("puppet.module.name.unnamed", new Object[0]);
            if (string == null) {
                PuppetModuleMetadata.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (StringUtil.isEmpty((String)moduleVersion)) {
            moduleVersion = PuppetBundle.message("puppet.module.unknown.version", new Object[0]);
        }
        String string = PuppetBundle.message("puppet.module.name", moduleName, moduleVersion);
        if (string == null) {
            PuppetModuleMetadata.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getAuthor() {
        return this.author;
    }

    @Nullable
    public String getLicense() {
        return this.license;
    }

    @Nullable
    public String getSummary() {
        return this.summary;
    }

    @Nullable
    public String getSource() {
        return this.source;
    }

    @NotNull
    public List<Dependency> getDependencies() {
        List list = (List)this.myDependencyProvider.getValue();
        if (list == null) {
            PuppetModuleMetadata.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public String getProjectPage() {
        return this.project_page;
    }

    @Nullable
    public String getIssuesUrl() {
        return this.issues_url;
    }

    @NotNull
    public List<OsSupport> getOperatingSystemSupport() {
        List<Object> list = this.operatingsystem_support == null ? Collections.emptyList() : this.operatingsystem_support;
        if (list == null) {
            PuppetModuleMetadata.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<String> getTags() {
        List<Object> list = this.tags == null ? Collections.emptyList() : this.tags;
        if (list == null) {
            PuppetModuleMetadata.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public String getDataProvider() {
        return this.data_provider;
    }

    public static PuppetModuleMetadata readMetadata(@NotNull VirtualFile sourceFile) {
        if (sourceFile == null) {
            PuppetModuleMetadata.$$$reportNull$$$0(5);
        }
        try {
            return (PuppetModuleMetadata)myGson.fromJson(new String(sourceFile.contentsToByteArray(false), StandardCharsets.UTF_8), PuppetModuleMetadata.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/project/meta/PuppetModuleMetadata";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperatingSystemSupport";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTags";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/project/meta/PuppetModuleMetadata";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readMetadata";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class OsSupport {
        @Nullable
        private String operatingsystem;
        @Nullable
        private List<String> operatingsystemrelease;

        @Nullable
        public String getOperatingSystem() {
            return this.operatingsystem;
        }

        @NotNull
        public List<String> getOperatingSystemRelease() {
            List<Object> list = this.operatingsystemrelease == null ? Collections.emptyList() : this.operatingsystemrelease;
            if (list == null) {
                OsSupport.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/puppet/project/meta/PuppetModuleMetadata$OsSupport", "getOperatingSystemRelease"));
        }
    }

    public static class Dependency {
        @Nullable
        private String name;
        @Nullable
        private String version_requirement;

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getVersionRequirement() {
            return this.version_requirement;
        }
    }
}

