/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.intellij.datalore.DataloreBundle;
import com.jetbrains.intellij.datalore.actions.AuthorizedAction;
import com.jetbrains.intellij.datalore.actions.handlers.CreateDataloreWorkbookActionHandler;
import com.jetbrains.intellij.datalore.forms.IPythonNotebookSelector;
import com.jetbrains.intellij.datalore.forms.PackageList;
import com.jetbrains.intellij.datalore.forms.WorkbookNameDialog;
import com.jetbrains.intellij.datalore.models.PackageItem;
import com.jetbrains.intellij.datalore.models.WorkbookInfo;
import com.jetbrains.intellij.datalore.models.notebooks.DataloreWorkbookSheet;
import com.jetbrains.intellij.datalore.services.IPythonService;
import com.jetbrains.intellij.datalore.services.PackageService;
import com.jetbrains.intellij.datalore.services.ProjectService;
import com.jetbrains.intellij.datalore.util.NotificationUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\tH\u0002J&\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J \u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/intellij/datalore/actions/CreateDataloreWorkbookAction;", "Lcom/jetbrains/intellij/datalore/actions/AuthorizedAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "exportProject", "project", "Lcom/intellij/openapi/project/Project;", "fail", "nameDialog", "", "notebookDialog", "", "Lcom/jetbrains/intellij/datalore/models/notebooks/DataloreWorkbookSheet;", "notebooks", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageDialog", "Lcom/jetbrains/intellij/datalore/models/PackageItem;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "Companion", "datalore-intellij-plugin"})
public final class CreateDataloreWorkbookAction
extends AuthorizedAction {
    private static final Logger LOG;
    public static final Companion Companion;

    public void actionPerformed(@NotNull AnActionEvent e) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) break block0;
            Project project2 = project;
            boolean bl = false;
            boolean bl2 = false;
            Project it = project2;
            boolean bl3 = false;
            Project project3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"it");
            this.exportProject(project3);
        }
    }

    private final void exportProject(Project project) {
        Collection<VirtualFile> notebooksFiles;
        ProjectService projectService = ProjectService.Companion.getInstance(project);
        Sdk sdk = ProjectService.Companion.getInstance(project).getProjectSdk();
        if (sdk == null) {
            return;
        }
        Sdk sdk2 = sdk;
        ProjectService.Companion.saveAllFiles();
        if (projectService.getProjectFiles().isEmpty()) {
            NotificationUtil.INSTANCE.fireTextPopup(project, DataloreBundle.INSTANCE.message("datalore.create_workbook.not_available.title", new Object[0]), DataloreBundle.INSTANCE.message("datalore.create_workbook.not_available.text", new Object[0])).showCenteredInCurrentWindow(project);
            return;
        }
        CreateDataloreWorkbookActionHandler handler2 = new CreateDataloreWorkbookActionHandler(project);
        String string = this.nameDialog(project);
        if (string == null) {
            return;
        }
        handler2.setName(string);
        PackageService packageService = PackageService.Companion.getInstance(project);
        if (packageService.getActivePackages().isEmpty()) {
            List<PackageItem> list = this.packageDialog(project, sdk2);
            if (list == null) {
                return;
            }
            List<PackageItem> packages = list;
            packageService.setActivePackages((Collection<PackageItem>)packages);
        }
        Collection<VirtualFile> collection = notebooksFiles = projectService.getIPythonNotebookFiles();
        boolean bl = false;
        if (!collection.isEmpty()) {
            List<DataloreWorkbookSheet> list = this.notebookDialog(project, notebooksFiles);
            if (list == null) {
                return;
            }
            handler2.setNotebooks(list);
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, handler2, project){
            final /* synthetic */ CreateDataloreWorkbookAction this$0;
            final /* synthetic */ CreateDataloreWorkbookActionHandler $handler;
            final /* synthetic */ Project $project;

            public final void run() {
                WorkbookInfo info = this.$handler.createWorkbook();
                if (info != null) {
                    NotificationUtil.INSTANCE.fireOkNotification(this.$project, DataloreBundle.INSTANCE.message("datalore.create_workbook.notification.ok", info.getUrl()));
                } else {
                    CreateDataloreWorkbookAction.access$fail(this.this$0, this.$project);
                }
            }
            {
                this.this$0 = createDataloreWorkbookAction;
                this.$handler = createDataloreWorkbookActionHandler;
                this.$project = project;
            }
        });
    }

    private final void fail(Project project) {
        NotificationUtil.INSTANCE.fireErrorNotification(project, DataloreBundle.INSTANCE.message("datalore.create_workbook.notification.fail", new Object[0]));
    }

    private final String nameDialog(Project project) {
        WorkbookNameDialog nameDialog = new WorkbookNameDialog(project);
        nameDialog.show();
        return nameDialog.isOK() ? nameDialog.getName() : null;
    }

    private final List<PackageItem> packageDialog(Project project, Sdk sdk) {
        PackageList packageSelector = new PackageList(project, sdk, DataloreBundle.INSTANCE.message("datalore.packages_select.save.during_creation", new Object[0]));
        packageSelector.show();
        if (packageSelector.isOK()) {
            return packageSelector.getSelectedPackages();
        }
        return null;
    }

    private final List<DataloreWorkbookSheet> notebookDialog(Project project, Collection<? extends VirtualFile> notebooks) {
        block2: {
            Object object;
            block4: {
                block3: {
                    IPythonNotebookSelector selector = new IPythonNotebookSelector(project, notebooks, false, 4, null);
                    selector.show();
                    if (!selector.isOK()) break block2;
                    DataloreWorkbookSheet sheet = IPythonService.Companion.getInstance().generateSheet(selector.getSelectedNotebook());
                    object = sheet;
                    if (object == null) break block3;
                    DataloreWorkbookSheet dataloreWorkbookSheet = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    DataloreWorkbookSheet it = dataloreWorkbookSheet;
                    boolean bl3 = false;
                    object = CollectionsKt.listOf((Object)it);
                    if (object != null) break block4;
                }
                object = CollectionsKt.emptyList();
            }
            return object;
        }
        return null;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(CreateDataloreWorkbookAction.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Creat\u2026rkbookAction::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$fail(CreateDataloreWorkbookAction $this, Project project) {
        $this.fail(project);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/intellij/datalore/actions/CreateDataloreWorkbookAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "datalore-intellij-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

