/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler.callgraph;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.jetbrains.python.profiler.FunctionStat;
import com.jetbrains.python.profiler.ProfileDataKt;
import com.jetbrains.python.profiler.ProfileStats;
import com.jetbrains.python.profiler.callgraph.CallGraphDiagramProvider;
import com.jetbrains.python.profiler.callgraph.CallGraphEdge;
import com.jetbrains.python.profiler.callgraph.CallGraphNode;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u000e\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\u001d0\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0018H\u0016J\u0016\u0010\u0014\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00020\u00180\u001cH\u0016J\b\u0010#\u001a\u00020\u001bH\u0016R!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u000bj\b\u0012\u0004\u0012\u00020\u0013`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/jetbrains/python/profiler/callgraph/CallGraphDiagramModel;", "Lcom/intellij/diagram/DiagramDataModel;", "Lcom/jetbrains/python/profiler/FunctionStat;", "project", "Lcom/intellij/openapi/project/Project;", "profileStats", "Lcom/jetbrains/python/profiler/ProfileStats;", "functionsStats", "", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/profiler/ProfileStats;Ljava/util/List;)V", "edges", "Ljava/util/HashSet;", "Lcom/jetbrains/python/profiler/callgraph/CallGraphEdge;", "Lkotlin/collections/HashSet;", "getEdges", "()Ljava/util/HashSet;", "getFunctionsStats", "()Ljava/util/List;", "nodes", "Lcom/jetbrains/python/profiler/callgraph/CallGraphNode;", "getNodes", "getProfileStats", "()Lcom/jetbrains/python/profiler/ProfileStats;", "addElement", "Lcom/intellij/diagram/DiagramNode;", "element", "dispose", "", "", "Lcom/intellij/diagram/DiagramEdge;", "getModificationTracker", "Lcom/intellij/psi/util/PsiModificationTracker;", "getNodeName", "", "n", "refreshDataModel", "intellij.python.profiler"})
public final class CallGraphDiagramModel
extends DiagramDataModel<FunctionStat> {
    @NotNull
    private final HashSet<CallGraphNode> nodes;
    @NotNull
    private final HashSet<CallGraphEdge> edges;
    @NotNull
    private final ProfileStats profileStats;
    @NotNull
    private final List<FunctionStat> functionsStats;

    @NotNull
    public final HashSet<CallGraphNode> getNodes() {
        return this.nodes;
    }

    @NotNull
    public final HashSet<CallGraphEdge> getEdges() {
        return this.edges;
    }

    @NotNull
    public String getNodeName(@Nullable DiagramNode<FunctionStat> n) {
        DiagramNode<FunctionStat> diagramNode = n;
        if (diagramNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.python.profiler.callgraph.CallGraphNode");
        }
        return ((CallGraphNode)diagramNode).getCallStat().getName();
    }

    @NotNull
    public Collection<? extends DiagramEdge<FunctionStat>> getEdges() {
        return this.edges;
    }

    @NotNull
    public Collection<? extends DiagramNode<FunctionStat>> getNodes() {
        return this.nodes;
    }

    @Nullable
    public DiagramNode<FunctionStat> addElement(@Nullable FunctionStat element) {
        throw (Throwable)new UnsupportedOperationException();
    }

    public void refreshDataModel() {
    }

    @NotNull
    public PsiModificationTracker getModificationTracker() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"PsiManager.getInstance(project)");
        PsiModificationTracker psiModificationTracker = psiManager.getModificationTracker();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiModificationTracker, (String)"PsiManager.getInstance(p\u2026ject).modificationTracker");
        return psiModificationTracker;
    }

    public void dispose() {
    }

    @NotNull
    public final ProfileStats getProfileStats() {
        return this.profileStats;
    }

    @NotNull
    public final List<FunctionStat> getFunctionsStats() {
        return this.functionsStats;
    }

    /*
     * WARNING - void declaration
     */
    public CallGraphDiagramModel(@NotNull Project project, @NotNull ProfileStats profileStats, @NotNull List<? extends FunctionStat> functionsStats) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)profileStats, (String)"profileStats");
        Intrinsics.checkParameterIsNotNull(functionsStats, (String)"functionsStats");
        super(project, (DiagramProvider)CallGraphDiagramProvider.INSTANCE);
        this.profileStats = profileStats;
        this.functionsStats = functionsStats;
        this.nodes = new HashSet();
        this.edges = new HashSet();
        Iterable $this$sortedBy$iv = this.functionsStats;
        boolean $i$f$sortedBy = false;
        Object object = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                FunctionStat stat = (FunctionStat)a;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(-((double)stat.getTotalTimeMs()) / (double)stat.getBaseTotalTime());
                stat = (FunctionStat)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = -((double)stat.getTotalTimeMs()) / (double)stat.getBaseTotalTime();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        };
        for (FunctionStat call : CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)object, (Comparator)comparator), (int)50)) {
            this.nodes.add(new CallGraphNode(call));
        }
        Iterable $this$associateBy$iv = this.nodes;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        object = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            CallGraphNode callGraphNode = (CallGraphNode)((Object)element$iv$iv);
            Map map = destination$iv$iv;
            boolean bl2 = false;
            Triple<String, String, Integer> triple = ProfileDataKt.callId(it.getIdentifyingElement());
            map.put(triple, element$iv$iv);
        }
        Map idToNodes = destination$iv$iv;
        for (FunctionStat call : this.functionsStats) {
            for (FunctionStat caller : call.getCallers()) {
                CallGraphNode source = (CallGraphNode)((Object)idToNodes.get(ProfileDataKt.callId(caller)));
                CallGraphNode target = (CallGraphNode)((Object)idToNodes.get(ProfileDataKt.callId(call)));
                if (source == null || target == null) continue;
                this.edges.add(new CallGraphEdge(source, target));
            }
        }
    }
}

