/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.util.ui.JBUI;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.ui.WebServerCombo;
import com.jetbrains.plugins.webDeployment.ui.config.ServerOrGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugins/webDeployment/UploadCommitOptions;", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "publishConfig", "Lcom/jetbrains/plugins/webDeployment/config/PublishConfig;", "tempSelection", "Lcom/jetbrains/plugins/webDeployment/ui/config/ServerOrGroup;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/plugins/webDeployment/config/PublishConfig;Lcom/jetbrains/plugins/webDeployment/ui/config/ServerOrGroup;)V", "checkBox", "Ljavax/swing/JCheckBox;", "combo", "Lcom/jetbrains/plugins/webDeployment/ui/WebServerCombo;", "label", "Ljavax/swing/JLabel;", "panel", "Ljavax/swing/JPanel;", "dispose", "", "getComponent", "Ljavax/swing/JComponent;", "refresh", "restoreState", "saveState", "intellij.webDeployment"})
public final class UploadCommitOptions
implements RefreshableOnComponent,
Disposable {
    private final JLabel label;
    private final WebServerCombo combo;
    private final JCheckBox checkBox;
    private final JPanel panel;
    private final PublishConfig publishConfig;
    private final ServerOrGroup tempSelection;

    @NotNull
    public JComponent getComponent() {
        return this.panel;
    }

    public void refresh() {
        if (this.publishConfig.isPersistUploadOnCheckin()) {
            this.combo.resetToServerOrGroup(this.publishConfig.getUploadOnCheckin());
            this.checkBox.setSelected(true);
        } else {
            this.combo.resetToServerOrGroup(this.tempSelection);
            this.checkBox.setSelected(false);
        }
    }

    public void saveState() {
        if (this.checkBox.isSelected()) {
            this.publishConfig.setPersistUploadOnCheckin(true);
            this.publishConfig.setUploadOnCheckin(this.combo.getSelected());
            this.tempSelection.clean();
        } else {
            this.publishConfig.setPersistUploadOnCheckin(false);
            this.publishConfig.setUploadOnCheckin(new ServerOrGroup());
            this.tempSelection.copy(this.combo.getSelected());
        }
    }

    public void restoreState() {
        this.refresh();
    }

    public void dispose() {
    }

    public UploadCommitOptions(@NotNull Project project, @NotNull PublishConfig publishConfig, @NotNull ServerOrGroup tempSelection) {
        JPanel jPanel;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)publishConfig, (String)"publishConfig");
        Intrinsics.checkParameterIsNotNull((Object)tempSelection, (String)"tempSelection");
        this.publishConfig = publishConfig;
        this.tempSelection = tempSelection;
        this.label = new JLabel(WDBundle.message("upload.on.checkin.checkbox.label", new Object[0]));
        this.combo = new WebServerCombo(true, -1, true, true);
        this.checkBox = new JCheckBox(WDBundle.message("always.use.selected.server", new Object[0]));
        JPanel jPanel2 = new JPanel(new BorderLayout(0, JBUI.scale((int)3)));
        UploadCommitOptions uploadCommitOptions = this;
        boolean bl = false;
        boolean bl2 = false;
        JPanel $this$apply = jPanel2;
        boolean bl3 = false;
        $this$apply.add((Component)this.label, "North");
        $this$apply.add((Component)((Object)this.combo), "Center");
        $this$apply.add((Component)this.checkBox, "South");
        uploadCommitOptions.panel = jPanel = jPanel2;
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.combo));
        this.combo.setProject(project);
    }
}

