/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl;

import java.io.Serializable;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class BitString
implements Serializable {
    private final long myLength;
    private final byte[] myBytes;

    private BitString(byte[] bytes, long length) {
        this.myLength = length;
        this.myBytes = bytes;
    }

    public long getLength() {
        return this.myLength;
    }

    public byte[] getBytes() {
        return this.myBytes;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitString)) {
            return false;
        }
        BitString bitString = (BitString)o;
        return Arrays.equals(this.myBytes, bitString.myBytes) && this.myLength == ((BitString)o).myLength;
    }

    public int hashCode() {
        return Arrays.hashCode(this.myBytes) + (int)this.myLength;
    }

    @Nullable
    public static BitString of(@Nullable byte[] bytes) {
        return BitString.of(bytes, bytes == null ? 0L : (long)bytes.length * 8L);
    }

    @Nullable
    public static BitString of(@Nullable byte[] bytes, long precision) {
        return bytes == null ? null : new BitString(bytes, precision);
    }
}

