/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeavyAwareExecutor
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExecutingHeavyOrPowerSaveListener myListener;
    private final int myLongActivityDurationMs;

    public HeavyAwareExecutor(@NotNull Project project, int delayMs, int longActivityDurationMs, @NotNull Disposable parent) {
        if (project == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myLongActivityDurationMs = longActivityDurationMs;
        this.myListener = new ExecutingHeavyOrPowerSaveListener(project, delayMs, this);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public Future<?> executeOutOfHeavyOrPowerSave(@NotNull Consumer<? super ProgressIndicator> task2, @NotNull String title, @NotNull ProgressIndicator indicator) {
        if (task2 == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(2);
        }
        if (title == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(4);
        }
        return Futures.transformAsync(this.myListener.addTask(() -> {
            Disposable disposable = Disposer.newDisposable();
            ListenableFuture<?> future = HeavyAwareExecutor.runAsync(this.myProject, task2, title, indicator, () -> Disposer.dispose((Disposable)disposable));
            new CancellingOnHeavyOrPowerSaveListener(this.myProject, indicator, this.myLongActivityDurationMs, disposable);
            return future;
        }), input -> input, (Executor)MoreExecutors.directExecutor());
    }

    public void dispose() {
    }

    @NotNull
    private static ListenableFuture<?> runAsync(@NotNull Project project, final @NotNull Consumer<? super ProgressIndicator> task2, @NotNull String title, @NotNull ProgressIndicator indicator, @NotNull Runnable continuation) {
        if (project == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(5);
        }
        if (task2 == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(6);
        }
        if (title == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(8);
        }
        if (continuation == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(9);
        }
        final SettableFuture future = SettableFuture.create();
        Task.Backgroundable wrapper = new Task.Backgroundable(project, title, true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    task2.consume((Object)indicator);
                }
                finally {
                    future.set(null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/impl/HeavyAwareExecutor$1", "run"));
            }
        };
        ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(wrapper, indicator, continuation);
        SettableFuture settableFuture = future;
        if (settableFuture == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(10);
        }
        return settableFuture;
    }

    public static void executeOutOfHeavyProcessLater(@NotNull Runnable command, int delayMs) {
        if (command == null) {
            HeavyAwareExecutor.$$$reportNull$$$0(11);
        }
        HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> JobScheduler.getScheduler().schedule(() -> {
            if (HeavyProcessLatch.INSTANCE.isRunning()) {
                HeavyAwareExecutor.executeOutOfHeavyProcessLater(command, delayMs);
            } else {
                command.run();
            }
        }, (long)delayMs, TimeUnit.MILLISECONDS));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "continuation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/HeavyAwareExecutor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/HeavyAwareExecutor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "runAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeOutOfHeavyOrPowerSave";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runAsync";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeOutOfHeavyProcessLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExecutingHeavyOrPowerSaveListener
    implements PowerSaveMode.Listener {
        @NotNull
        private final AtomicReference<List<Runnable>> myTasksToRun;
        private final int myDelayMs;

        ExecutingHeavyOrPowerSaveListener(@NotNull Project project, int delayMs, @NotNull Disposable parent) {
            if (project == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(1);
            }
            this.myTasksToRun = new AtomicReference(new ArrayList());
            this.myDelayMs = delayMs;
            project.getMessageBus().connect(parent).subscribe(PowerSaveMode.TOPIC, (Object)this);
        }

        @NotNull
        public <T> ListenableFuture<ListenableFuture<T>> addTask(@NotNull Computable<? extends ListenableFuture<T>> task2) {
            if (task2 == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(2);
            }
            SettableFuture future = SettableFuture.create();
            this.myTasksToRun.getAndUpdate(tasks -> ContainerUtil.concat((List)tasks, Collections.singletonList(ExecutingHeavyOrPowerSaveListener.wrap(task2, future))));
            this.tryRun();
            SettableFuture settableFuture = future;
            if (settableFuture == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(3);
            }
            return settableFuture;
        }

        @NotNull
        private static <T> Runnable wrap(@NotNull Computable<? extends ListenableFuture<T>> task2, @NotNull SettableFuture<? super ListenableFuture<T>> future) {
            if (task2 == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(4);
            }
            if (future == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(5);
            }
            Runnable runnable = () -> {
                try {
                    future.set(task2.compute());
                }
                catch (Throwable t) {
                    future.setException(t);
                }
            };
            if (runnable == null) {
                ExecutingHeavyOrPowerSaveListener.$$$reportNull$$$0(6);
            }
            return runnable;
        }

        public void powerSaveStateChanged() {
            this.tryRun();
        }

        private void tryRun() {
            if (!PowerSaveMode.isEnabled()) {
                HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> JobScheduler.getScheduler().schedule(() -> {
                    if (!HeavyProcessLatch.INSTANCE.isRunning() && !PowerSaveMode.isEnabled()) {
                        List tasks = this.myTasksToRun.getAndSet(new ArrayList());
                        tasks.forEach(Runnable::run);
                    } else {
                        this.tryRun();
                    }
                }, (long)this.myDelayMs, TimeUnit.MILLISECONDS));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/impl/HeavyAwareExecutor$ExecutingHeavyOrPowerSaveListener";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "future";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/impl/HeavyAwareExecutor$ExecutingHeavyOrPowerSaveListener";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addTask";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addTask";
                    break;
                }
                case 3: 
                case 6: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "wrap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CancellingOnHeavyOrPowerSaveListener
    implements HeavyProcessLatch.HeavyProcessListener,
    PowerSaveMode.Listener {
        @NotNull
        private final ProgressIndicator myIndicator;
        private final int myLongActivityDurationMs;
        @Nullable
        private ScheduledFuture<?> myFuture;

        CancellingOnHeavyOrPowerSaveListener(@NotNull Project project, @NotNull ProgressIndicator indicator, int logActivityDurationMs, @NotNull Disposable disposable) {
            if (project == null) {
                CancellingOnHeavyOrPowerSaveListener.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                CancellingOnHeavyOrPowerSaveListener.$$$reportNull$$$0(1);
            }
            if (disposable == null) {
                CancellingOnHeavyOrPowerSaveListener.$$$reportNull$$$0(2);
            }
            this.myFuture = null;
            this.myIndicator = indicator;
            this.myLongActivityDurationMs = logActivityDurationMs;
            HeavyProcessLatch.INSTANCE.addListener((HeavyProcessLatch.HeavyProcessListener)this, disposable);
            project.getMessageBus().connect(disposable).subscribe(PowerSaveMode.TOPIC, (Object)this);
            this.scheduleCancel();
            this.powerSaveStateChanged();
        }

        public void processStarted() {
            this.scheduleCancel();
        }

        public void processFinished() {
            this.doNotCancel();
        }

        public void powerSaveStateChanged() {
            if (PowerSaveMode.isEnabled() && this.myIndicator.isRunning()) {
                this.myIndicator.cancel();
            }
        }

        private synchronized void scheduleCancel() {
            if (HeavyProcessLatch.INSTANCE.isRunning() && this.myFuture == null) {
                this.myFuture = JobScheduler.getScheduler().schedule(() -> {
                    if (HeavyProcessLatch.INSTANCE.isRunning() && this.myIndicator.isRunning()) {
                        this.myIndicator.cancel();
                    }
                }, (long)this.myLongActivityDurationMs, TimeUnit.MILLISECONDS);
            }
        }

        private synchronized void doNotCancel() {
            if (!HeavyProcessLatch.INSTANCE.isRunning() && this.myFuture != null) {
                ScheduledFuture<?> future = this.myFuture;
                this.myFuture = null;
                future.cancel(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "disposable";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/impl/HeavyAwareExecutor$CancellingOnHeavyOrPowerSaveListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

