
class TreeView {
  /**
   * @param valueMessage
   * @param {WebConsole} console
   */
  constructor(valueMessage, console) {
    this.console = console;
    this.container = createElement("div", "tree-view");
    this.list = createElement("ul", "tree-root");
    this.valueID = valueMessage.id;
    this.rootItem = this.treeItem(valueMessage);
    this.list.appendChild(this.rootItem);
    this.container.appendChild(this.list);
  }

  treeItem(valueMessage) {
    let hasChildren = valueMessage.type === 'tree';
    let item = createElement("li", "tree-item");
    let state = hasChildren ? 'collapsed' : "leaf";
    item.classList.add(state)
    let preview = createTextNode(valueMessage);
    preview.classList.add("preview");
    preview.classList.add(...valueMessage.styleClasses);
    if (valueMessage.iconURL != null) {
      let iconElement = WebConsole._createDynamicIcon(valueMessage, "node-icon");
      preview.insertAdjacentElement("afterbegin", iconElement);
    }
    item.appendChild(preview);
    if (hasChildren) {
      let childrenElem = createElement("ul", "group-container");
      item.appendChild(childrenElem);
      let clickHandler = (event) => {
        event.stopPropagation();
        let visible = toggle_visibility(item);
        if (visible) {
          let callbackId = callJVM('expand', [valueMessage.id], ([add, children]) => {
            if (add) {
              for (let childAndIndex of children) {
                let child = childAndIndex.first;
                let childItem = this.treeItem(child);
                if (child.type === 'message-tree-node') {
                  childItem.ondblclick = (event) => {
                    callJVM('messageNodeCallback', [child.id]);
                  }
                }
                let index = childAndIndex.second;
                if (index != null) {
                  childrenElem.insertBefore(childItem, childrenElem.childNodes[index]);
                }
                else {
                  childrenElem.appendChild(childItem);
                }
              }
            }
            else {
              for (let index of children) {
                childrenElem.removeChild(childrenElem.childNodes[index]);
              }
            }
          }, true);
          valueMessage.callbackId = callbackId;
        } else {
          clearContainer(childrenElem);
          callbackMap.delete(valueMessage.callbackId);
          callJVM("collapse", [valueMessage.id]);
        }
      };
      preview.onclick = clickHandler;
      item.onclick = (event) => {
        if (event.target !== event.currentTarget) return;
        clickHandler(event);
      }
    } else if (valueMessage.type === 'tree-link') {
      preview.onclick = (e) => {
        callJVM("nodeLinkClick", [valueMessage.id]);
      }
    }
    return item;
  }

  rootElement() {
    return this.container;
  }

}