/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.intellij.docker.agent.DockerRepoTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\f\u0010\b\u001a\u00020\u0007*\u00020\u0007H\u0000\u001a\f\u0010\t\u001a\u00020\u0005*\u00020\u0005H\u0002\u001a\f\u0010\n\u001a\u00020\u0005*\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"DIGEST_REGEXP", "Lkotlin/text/Regex;", "isValidRepoTag", "", "reference", "", "validDockerRepoTagFromString", "Lcom/intellij/docker/agent/DockerRepoTag;", "toValidDockerRepoTag", "toValidLowerCasePiece", "toValidTagPiece", "intellij.clouds.docker.agent.rt"})
public final class DockerRepoTagsKt {
    private static final Regex DIGEST_REGEXP;

    @NotNull
    public static final DockerRepoTag validDockerRepoTagFromString(@NotNull String reference) {
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        DockerRepoTag dockerRepoTag = DockerRepoTag.fromString(reference);
        Intrinsics.checkExpressionValueIsNotNull((Object)dockerRepoTag, (String)"DockerRepoTag.fromString(reference)");
        return DockerRepoTagsKt.toValidDockerRepoTag(dockerRepoTag);
    }

    public static final boolean isValidRepoTag(@NotNull String reference) {
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        return DockerRepoTag.fromString(reference).isValidReferenceFormat();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DockerRepoTag toValidDockerRepoTag(@NotNull DockerRepoTag $this$toValidDockerRepoTag) {
        DockerRepoTag validTag;
        block5: {
            String string;
            Object object;
            void $this$mapTo$iv$iv;
            String it;
            boolean bl;
            String string2;
            Intrinsics.checkParameterIsNotNull((Object)$this$toValidDockerRepoTag, (String)"$this$toValidDockerRepoTag");
            DockerRepoTag dockerRepoTag = $this$toValidDockerRepoTag.clone();
            Intrinsics.checkExpressionValueIsNotNull((Object)dockerRepoTag, (String)"this.clone()");
            validTag = dockerRepoTag;
            String string3 = $this$toValidDockerRepoTag.getNamespace();
            if (string3 != null) {
                string2 = string3;
                bl = false;
                boolean bl2 = false;
                it = string2;
                boolean bl3 = false;
                String string4 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it");
                validTag.setNamespace(DockerRepoTagsKt.toValidLowerCasePiece(string4));
            }
            String string5 = $this$toValidDockerRepoTag.getSimpleRepositoryName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"this.simpleRepositoryName");
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string5, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string6 = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl4 = false;
                string = DockerRepoTagsKt.toValidLowerCasePiece((String)it2);
                object.add(string);
            }
            string2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
            bl = false;
            boolean bl5 = false;
            it = string2;
            boolean bl6 = false;
            validTag.setRepository(it);
            if ($this$toValidDockerRepoTag.hasCustomTag()) {
                string2 = $this$toValidDockerRepoTag.getTagNotNull();
                object = validTag;
                bl = false;
                bl5 = false;
                it = string2;
                boolean bl7 = false;
                String string7 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"it");
                String string8 = string = !StringsKt.isBlank((CharSequence)string7) ? string2 : null;
                ((DockerRepoTag)object).setTag(string8 != null ? DockerRepoTagsKt.toValidTagPiece(string8) : null);
            }
            String string9 = $this$toValidDockerRepoTag.getDigest();
            if (string9 == null) break block5;
            string2 = string9;
            bl = false;
            bl5 = false;
            it = string2;
            boolean bl8 = false;
            String string10 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"it");
            Object object2 = string10;
            boolean bl9 = false;
            if (!StringsKt.isBlank((CharSequence)object2)) {
                object2 = it;
                Regex regex = DIGEST_REGEXP;
                boolean bl10 = false;
                if (!regex.matches((CharSequence)object2)) {
                    validTag.setDigest(null);
                }
            }
        }
        return validTag;
    }

    private static final String toValidTagPiece(@NotNull String $this$toValidTagPiece) {
        CharSequence charSequence = $this$toValidTagPiece;
        String string = "[^\\w.-]";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "_";
        boolean bl2 = false;
        return string.replace(charSequence, string2);
    }

    private static final String toValidLowerCasePiece(@NotNull String $this$toValidLowerCasePiece) {
        String string = DockerRepoTagsKt.toValidTagPiece($this$toValidLowerCasePiece);
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        return string3;
    }

    static {
        String string = "[A-Za-z][A-Za-z0-9]*(?:[-_+.][A-Za-z][A-Za-z0-9]*)*[:][0-9a-f]{64,}";
        boolean bl = false;
        DIGEST_REGEXP = new Regex(string);
    }
}

