/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorHexUtil {
    @NotNull
    public static Color fromHex(@NotNull String str) {
        Color color;
        if (str == null) {
            ColorHexUtil.$$$reportNull$$$0(0);
        }
        if ((color = ColorHexUtil.fromHexOrNull(str)) != null) {
            Color color2 = color;
            if (color2 == null) {
                ColorHexUtil.$$$reportNull$$$0(1);
            }
            return color2;
        }
        throw new IllegalArgumentException("unsupported length:" + str);
    }

    @Nullable
    public static Color fromHexOrNull(@Nullable String str) {
        if (str == null) {
            return null;
        }
        int pos = str.startsWith("#") ? 1 : (str.startsWith("0x") ? 2 : 0);
        int len = str.length() - pos;
        if (len == 3) {
            return new Color(ColorHexUtil.fromHex1(str, pos), ColorHexUtil.fromHex1(str, pos + 1), ColorHexUtil.fromHex1(str, pos + 2), 255);
        }
        if (len == 4) {
            return new Color(ColorHexUtil.fromHex1(str, pos), ColorHexUtil.fromHex1(str, pos + 1), ColorHexUtil.fromHex1(str, pos + 2), ColorHexUtil.fromHex1(str, pos + 3));
        }
        if (len == 6) {
            return new Color(ColorHexUtil.fromHex2(str, pos), ColorHexUtil.fromHex2(str, pos + 2), ColorHexUtil.fromHex2(str, pos + 4), 255);
        }
        if (len == 8) {
            return new Color(ColorHexUtil.fromHex2(str, pos), ColorHexUtil.fromHex2(str, pos + 2), ColorHexUtil.fromHex2(str, pos + 4), ColorHexUtil.fromHex2(str, pos + 6));
        }
        return null;
    }

    @Nullable
    public static Color fromHex(@Nullable String str, @Nullable Color defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return ColorHexUtil.fromHex(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static int fromHex(@NotNull String str, int pos) {
        char ch;
        if (str == null) {
            ColorHexUtil.$$$reportNull$$$0(2);
        }
        if ((ch = str.charAt(pos)) >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("unsupported char at " + pos + ":" + str);
    }

    private static int fromHex1(@NotNull String str, int pos) {
        if (str == null) {
            ColorHexUtil.$$$reportNull$$$0(3);
        }
        return 17 * ColorHexUtil.fromHex(str, pos);
    }

    private static int fromHex2(@NotNull String str, int pos) {
        if (str == null) {
            ColorHexUtil.$$$reportNull$$$0(4);
        }
        return 16 * ColorHexUtil.fromHex(str, pos) + ColorHexUtil.fromHex(str, pos + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ColorHexUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ColorHexUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "fromHex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromHex";
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromHex1";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromHex2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

