/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.Deque;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;

public final class HeavyProcessLatch {
    private static final Logger LOG = Logger.getInstance(HeavyProcessLatch.class);
    public static final HeavyProcessLatch INSTANCE = new HeavyProcessLatch();
    private final Set<String> myHeavyProcesses = ContainerUtil.newConcurrentSet();
    private final EventDispatcher<HeavyProcessListener> myEventDispatcher = EventDispatcher.create(HeavyProcessListener.class);
    private final Deque<Runnable> toExecuteOutOfHeavyActivity = new ConcurrentLinkedDeque<Runnable>();

    private HeavyProcessLatch() {
    }

    @NotNull
    public AccessToken processStarted(final @NotNull String operationName) {
        if (operationName == null) {
            HeavyProcessLatch.$$$reportNull$$$0(0);
        }
        this.myHeavyProcesses.add(operationName);
        this.myEventDispatcher.getMulticaster().processStarted();
        return new AccessToken(){

            @Override
            public void finish() {
                HeavyProcessLatch.this.processFinished(operationName);
            }
        };
    }

    private void processFinished(@NotNull String operationName) {
        Runnable runnable;
        if (operationName == null) {
            HeavyProcessLatch.$$$reportNull$$$0(1);
        }
        this.myHeavyProcesses.remove(operationName);
        this.myEventDispatcher.getMulticaster().processFinished();
        if (this.isRunning()) {
            return;
        }
        while ((runnable = this.toExecuteOutOfHeavyActivity.pollFirst()) != null) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    public boolean isRunning() {
        return !this.myHeavyProcesses.isEmpty();
    }

    public String getRunningOperationName() {
        if (this.myHeavyProcesses.isEmpty()) {
            return null;
        }
        Iterator<String> iterator = this.myHeavyProcesses.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public void addListener(@NotNull HeavyProcessListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            HeavyProcessLatch.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            HeavyProcessLatch.$$$reportNull$$$0(3);
        }
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    public void executeOutOfHeavyProcess(@NotNull Runnable runnable) {
        if (runnable == null) {
            HeavyProcessLatch.$$$reportNull$$$0(4);
        }
        if (this.isRunning()) {
            this.toExecuteOutOfHeavyActivity.add(runnable);
        } else {
            runnable.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/storage/HeavyProcessLatch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processStarted";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processFinished";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "executeOutOfHeavyProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface HeavyProcessListener
    extends EventListener {
        default public void processStarted() {
        }

        public void processFinished();
    }
}

