/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.util;

import com.intellij.openapi.progress.ProgressIndicator;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubApiResponse;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u000fJ3\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/authentication/util/GHSecurityUtil;", "", "()V", "DEFAULT_CLIENT_NAME", "", "GIST_SCOPE", "MASTER_SCOPES", "", "getMASTER_SCOPES", "()Ljava/util/List;", "READ_ORG_SCOPE", "REPO_SCOPE", "isEnoughScopes", "", "grantedScopes", "isEnoughScopes$intellij_vcs_github", "loadCurrentUserWithScopes", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "loadCurrentUserWithScopes$intellij_vcs_github", "intellij.vcs.github"})
public final class GHSecurityUtil {
    private static final String REPO_SCOPE = "repo";
    private static final String GIST_SCOPE = "gist";
    private static final String READ_ORG_SCOPE = "read:org";
    @NotNull
    private static final List<String> MASTER_SCOPES;
    @NotNull
    public static final String DEFAULT_CLIENT_NAME = "Github Integration Plugin";
    public static final GHSecurityUtil INSTANCE;

    @NotNull
    public final List<String> getMASTER_SCOPES() {
        return MASTER_SCOPES;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Pair<GithubAuthenticatedUser, String> loadCurrentUserWithScopes$intellij_vcs_github(@NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator progressIndicator, @NotNull GithubServerPath server) {
        void scopes;
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        GithubAuthenticatedUser details2 = (GithubAuthenticatedUser)executor.execute(progressIndicator, new GithubApiRequest.Get.Json<GithubAuthenticatedUser>((Ref.ObjectRef)scopes, server, GithubApiRequests.INSTANCE.getUrl(server, new String[]{GithubApiRequests.CurrentUser.INSTANCE.getUrlSuffix()}), GithubAuthenticatedUser.class){
            final /* synthetic */ Ref.ObjectRef $scopes;
            final /* synthetic */ GithubServerPath $server;

            @NotNull
            public GithubAuthenticatedUser extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                this.$scopes.element = response.findHeader("X-OAuth-Scopes");
                return (GithubAuthenticatedUser)super.extractResult(response);
            }
            {
                this.$scopes = $captured_local_variable$0;
                this.$server = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, null, 4, null);
            }
        }.withOperationName("get profile information"));
        return TuplesKt.to((Object)details2, (Object)((String)scopes.element));
    }

    @JvmStatic
    public static final boolean isEnoughScopes$intellij_vcs_github(@NotNull String grantedScopes) {
        boolean bl;
        block6: {
            Intrinsics.checkParameterIsNotNull((Object)grantedScopes, (String)"grantedScopes");
            List scopesArray = StringsKt.split$default((CharSequence)grantedScopes, (String[])new String[]{", "}, (boolean)false, (int)0, (int)6, null);
            if (scopesArray.isEmpty()) {
                return false;
            }
            if (!scopesArray.contains(REPO_SCOPE)) {
                return false;
            }
            if (!scopesArray.contains(GIST_SCOPE)) {
                return false;
            }
            Iterable $this$none$iv = scopesArray;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)it, (String)":org", (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return !bl;
    }

    private GHSecurityUtil() {
    }

    static {
        GHSecurityUtil gHSecurityUtil;
        INSTANCE = gHSecurityUtil = new GHSecurityUtil();
        MASTER_SCOPES = CollectionsKt.listOf((Object[])new String[]{REPO_SCOPE, GIST_SCOPE, READ_ORG_SCOPE});
    }
}

