/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.AuthData;
import git4idea.remote.GitHttpAuthDataProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.extensions.GithubAccountGitAuthenticationFailureManager;
import org.jetbrains.plugins.github.extensions.GithubHttpAuthDataProviderKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/extensions/GithubHttpAuthDataProvider;", "Lgit4idea/remote/GitHttpAuthDataProvider;", "()V", "forgetPassword", "", "project", "Lcom/intellij/openapi/project/Project;", "url", "", "authData", "Lcom/intellij/util/AuthData;", "getAuthData", "Lorg/jetbrains/plugins/github/extensions/GithubHttpAuthDataProvider$GithubAccountAuthData;", "login", "getSuitableAccounts", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "isSilent", "", "GithubAccountAuthData", "intellij.vcs.github"})
public final class GithubHttpAuthDataProvider
implements GitHttpAuthDataProvider {
    @Nullable
    public GithubAccountAuthData getAuthData(@NotNull Project project, @NotNull String url) {
        GithubAccountAuthData githubAccountAuthData;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        GithubAccount githubAccount = (GithubAccount)CollectionsKt.singleOrNull((Iterable)this.getSuitableAccounts(project, url, null));
        if (githubAccount != null) {
            GithubAccountAuthData githubAccountAuthData2;
            GithubAccount githubAccount2 = githubAccount;
            boolean bl = false;
            boolean bl2 = false;
            GithubAccount account = githubAccount2;
            boolean bl3 = false;
            try {
                String string = GithubAuthenticationManager.Companion.getInstance().getTokenForAccount$intellij_vcs_github(account);
                if (string == null) {
                    return null;
                }
                String token = string;
                boolean $i$f$service = false;
                Object object = ApplicationManager.getApplication().getService(GithubAccountInformationProvider.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
                String string2 = ((GithubAccountInformationProvider)object).getInformation(GithubApiRequestExecutor.Factory.Companion.getInstance().create(token), (ProgressIndicator)new DumbProgressIndicator(), account).getLogin();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"service<GithubAccountInf\u2026           account).login");
                String username = string2;
                githubAccountAuthData2 = new GithubAccountAuthData(account, username, token);
            }
            catch (IOException e) {
                GithubHttpAuthDataProviderKt.access$getLOG$p().info("Cannot load username for " + account, (Throwable)e);
                githubAccountAuthData2 = null;
            }
            githubAccountAuthData = githubAccountAuthData2;
        } else {
            githubAccountAuthData = null;
        }
        return githubAccountAuthData;
    }

    public boolean isSilent() {
        return true;
    }

    @Nullable
    public GithubAccountAuthData getAuthData(@NotNull Project project, @NotNull String url, @NotNull String login) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
        GithubAccount githubAccount = (GithubAccount)CollectionsKt.singleOrNull((Iterable)this.getSuitableAccounts(project, url, login));
        if (githubAccount != null) {
            GithubAccountAuthData githubAccountAuthData;
            GithubAccount githubAccount2 = githubAccount;
            boolean bl = false;
            boolean bl2 = false;
            GithubAccount account = githubAccount2;
            boolean bl3 = false;
            String string = GithubAuthenticationManager.Companion.getInstance().getTokenForAccount$intellij_vcs_github(account);
            if (string != null) {
                String string2 = string;
                boolean bl4 = false;
                boolean bl5 = false;
                String it = string2;
                boolean bl6 = false;
                githubAccountAuthData = new GithubAccountAuthData(account, login, it);
            } else {
                githubAccountAuthData = null;
            }
            return githubAccountAuthData;
        }
        return null;
    }

    public void forgetPassword(@NotNull Project project, @NotNull String url, @NotNull AuthData authData) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)authData, (String)"authData");
        if (authData instanceof GithubAccountAuthData) {
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(GithubAccountGitAuthenticationFailureManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
            ((GithubAccountGitAuthenticationFailureManager)object).ignoreAccount(url, ((GithubAccountAuthData)authData).getAccount());
        }
    }

    @NotNull
    public final Set<GithubAccount> getSuitableAccounts(@NotNull Project project, @NotNull String url, @Nullable String login) {
        GithubAccount defaultAccount;
        GithubAccount it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GithubAccountGitAuthenticationFailureManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getService(T::class.java)");
        GithubAccountGitAuthenticationFailureManager authenticationFailureManager = (GithubAccountGitAuthenticationFailureManager)object;
        GithubAuthenticationManager authenticationManager = GithubAuthenticationManager.Companion.getInstance();
        Iterable $this$filter$iv = authenticationManager.getAccounts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GithubAccount)element$iv$iv;
            boolean bl = false;
            if (!it.getServer().matches(url)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GithubAccount)element$iv$iv;
            boolean bl = false;
            if (!(!authenticationFailureManager.isAccountIgnored(url, it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List potentialAccounts = (List)destination$iv$iv;
        if (login != null) {
            $this$filter$iv = potentialAccounts;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                it = (GithubAccount)element$iv$iv;
                boolean bl2 = false;
                try {
                    boolean $i$f$service2 = false;
                    Object object2 = ApplicationManager.getApplication().getService(GithubAccountInformationProvider.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
                    bl = Intrinsics.areEqual((Object)((GithubAccountInformationProvider)object2).getInformation(GithubApiRequestExecutorManager.Companion.getInstance().getExecutor(it), (ProgressIndicator)new DumbProgressIndicator(), it).getLogin(), (Object)login);
                }
                catch (IOException e) {
                    GithubHttpAuthDataProviderKt.access$getLOG$p().info("Cannot load username for " + it, (Throwable)e);
                    bl = false;
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            potentialAccounts = (List)destination$iv$iv;
        }
        if ((defaultAccount = authenticationManager.getDefaultAccount(project)) != null && potentialAccounts.contains(defaultAccount)) {
            return SetsKt.setOf((Object)defaultAccount);
        }
        return CollectionsKt.toSet((Iterable)potentialAccounts);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/extensions/GithubHttpAuthDataProvider$GithubAccountAuthData;", "Lcom/intellij/util/AuthData;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "login", "", "password", "(Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Ljava/lang/String;Ljava/lang/String;)V", "getAccount", "()Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "intellij.vcs.github"})
    public static final class GithubAccountAuthData
    extends AuthData {
        @NotNull
        private final GithubAccount account;

        @NotNull
        public final GithubAccount getAccount() {
            return this.account;
        }

        public GithubAccountAuthData(@NotNull GithubAccount account, @NotNull String login, @NotNull String password) {
            Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
            Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            super(login, password);
            this.account = account;
        }
    }
}

