/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.repo.GitRepository;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHCommit;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangeDiffData;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangesProvider;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001e\u0010\u0006\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b0\u0007\u00a2\u0006\u0002\u0010\nJ \u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001b\u001a\u00020\fH\u0016J,\u0010\u001c\u001a\u0004\u0018\u00010\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00052\b\u0010 \u001a\u0004\u0018\u00010\u0005H\u0002J \u0010!\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010#\u0012\u0006\u0012\u0004\u0018\u00010#0\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR&\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00070\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangesProviderImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangesProvider;", "repository", "Lgit4idea/repo/GitRepository;", "mergeBaseRef", "", "commitsWithDiffs", "", "Lkotlin/Triple;", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "(Lgit4idea/repo/GitRepository;Ljava/lang/String;Ljava/util/List;)V", "changes", "Lcom/intellij/openapi/vcs/changes/Change;", "getChanges", "()Ljava/util/List;", "changesByCommits", "", "getChangesByCommits", "()Ljava/util/Map;", "diffDataByChange", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData;", "createChangeFromPatch", "beforeRef", "afterRef", "patch", "Lcom/intellij/openapi/diff/impl/patch/FilePatch;", "findChangeDiffData", "change", "findPatchByFilePaths", "patches", "", "beforePath", "afterPath", "getPatchPaths", "Lkotlin/Pair;", "Lcom/intellij/openapi/vcs/FilePath;", "Companion", "intellij.vcs.github"})
public final class GHPRChangesProviderImpl
implements GHPRChangesProvider {
    @NotNull
    private final List<Change> changes;
    @NotNull
    private final Map<GHCommit, List<Change>> changesByCommits;
    private final Map<Change, GHPRChangeDiffData> diffDataByChange;
    private final GitRepository repository;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<Change> getChanges() {
        return this.changes;
    }

    @Override
    @NotNull
    public Map<GHCommit, List<Change>> getChangesByCommits() {
        return this.changesByCommits;
    }

    /*
     * WARNING - void declaration
     */
    private final Change createChangeFromPatch(String beforeRef, String afterRef, FilePatch patch) {
        ContentRevision contentRevision;
        ContentRevision contentRevision2;
        boolean bl;
        void beforePath;
        Project project = this.repository.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"repository.project");
        Project project2 = project;
        Pair<FilePath, FilePath> pair = this.getPatchPaths(patch);
        FilePath filePath = (FilePath)pair.component1();
        FilePath afterPath = (FilePath)pair.component2();
        void v1 = beforePath;
        if (v1 != null) {
            void var8_8 = v1;
            boolean bl2 = false;
            bl = false;
            void it = var8_8;
            boolean bl3 = false;
            contentRevision2 = GitContentRevision.createRevision((FilePath)it, (VcsRevisionNumber)((VcsRevisionNumber)new GitRevisionNumber(beforeRef)), (Project)project2);
        } else {
            contentRevision2 = null;
        }
        ContentRevision beforeRevision = contentRevision2;
        FilePath filePath2 = afterPath;
        if (filePath2 != null) {
            FilePath filePath3 = filePath2;
            bl = false;
            boolean bl4 = false;
            FilePath it = filePath3;
            boolean bl5 = false;
            contentRevision = GitContentRevision.createRevision((FilePath)it, (VcsRevisionNumber)((VcsRevisionNumber)new GitRevisionNumber(afterRef)), (Project)project2);
        } else {
            contentRevision = null;
        }
        ContentRevision afterRevision = contentRevision;
        return new Change(beforeRevision, afterRevision);
    }

    private final Pair<FilePath, FilePath> getPatchPaths(FilePatch patch) {
        FilePath filePath;
        FilePath filePath2;
        String it;
        boolean bl;
        boolean bl2;
        String string;
        String beforeName = patch.isNewFile() ? null : patch.getBeforeName();
        String afterName = patch.isDeletedFile() ? null : patch.getAfterName();
        String string2 = beforeName;
        if (string2 != null) {
            string = string2;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl3 = false;
            filePath2 = VcsUtil.getFilePath((VirtualFile)this.repository.getRoot(), (String)it);
        } else {
            filePath2 = null;
        }
        String string3 = afterName;
        if (string3 != null) {
            string = string3;
            FilePath filePath3 = filePath2;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl4 = false;
            FilePath filePath4 = VcsUtil.getFilePath((VirtualFile)this.repository.getRoot(), (String)it);
            filePath2 = filePath3;
            filePath = filePath4;
        } else {
            filePath = null;
        }
        return TuplesKt.to(filePath2, filePath);
    }

    private final FilePatch findPatchByFilePaths(Collection<? extends FilePatch> patches, String beforePath, String afterPath) {
        Object v0;
        block1: {
            Iterable iterable = patches;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                FilePatch it = (FilePatch)t;
                boolean bl3 = false;
                if (!(afterPath != null && Intrinsics.areEqual((Object)it.getAfterName(), (Object)afterPath) || afterPath == null && Intrinsics.areEqual((Object)it.getBeforeName(), (Object)beforePath))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @Nullable
    public GHPRChangeDiffData findChangeDiffData(@NotNull Change change) {
        Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
        return this.diffDataByChange.get(change);
    }

    /*
     * WARNING - void declaration
     */
    public GHPRChangesProviderImpl(@NotNull GitRepository repository, @NotNull String mergeBaseRef, @NotNull List<Triple<GHCommit, String, String>> commitsWithDiffs) {
        void $this$mapKeysTo$iv$iv;
        Object beforePath;
        Map commitDiff;
        Object object;
        Object object2;
        GHCommit $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)mergeBaseRef, (String)"mergeBaseRef");
        Intrinsics.checkParameterIsNotNull(commitsWithDiffs, (String)"commitsWithDiffs");
        this.repository = repository;
        this.changesByCommits = new LinkedHashMap();
        this.diffDataByChange = (Map)new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<Change>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(@Nullable Change o1, @Nullable Change o2) {
                if (!Intrinsics.areEqual((Object)o1, (Object)o2)) return false;
                Change change = o1;
                Change change2 = o2;
                if (!Intrinsics.areEqual((Object)(change != null ? change.getBeforeRevision() : null), (Object)(change2 != null ? change2.getBeforeRevision() : null))) return false;
                Change change3 = o2;
                Change change4 = o2;
                if (!Intrinsics.areEqual((Object)(change3 != null ? change3.getAfterRevision() : null), (Object)(change4 != null ? change4.getAfterRevision() : null))) return false;
                return true;
            }

            public int computeHashCode(@Nullable Change change) {
                Object[] objectArray = new Object[3];
                objectArray[0] = change;
                Change change2 = change;
                objectArray[1] = change2 != null ? change2.getBeforeRevision() : null;
                Change change3 = change;
                objectArray[2] = change3 != null ? change3.getAfterRevision() : null;
                return Objects.hash(objectArray);
            }
        });
        boolean bl = false;
        Map fileHistoriesByLastKnownFilePath = new LinkedHashMap();
        String lastCommitSha = mergeBaseRef;
        List lastCumulativePatches = null;
        Triple<GHCommit, String, String> $this$map$iv22 = (Triple<GHCommit, String, String>)commitsWithDiffs;
        boolean $i$f$map = false;
        Triple<GHCommit, String, String> triple = $this$map$iv22;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            Triple triple2 = (Triple)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl2 = false;
            object = ((GHCommit)it.getFirst()).getOid();
            object2.add(object);
        }
        List commitsHashes = (List)destination$iv$iv;
        for (Triple<GHCommit, String, String> $this$map$iv22 : commitsWithDiffs) {
            void commit;
            $this$mapTo$iv$iv = (GHCommit)$this$map$iv22.component1();
            destination$iv$iv = (String)$this$map$iv22.component2();
            String diffFromMergeBase = (String)$this$map$iv22.component3();
            String commitSha = commit.getOid();
            boolean it = false;
            List commitChanges = new ArrayList();
            List commitPatches = GHPRChangesProviderImpl.Companion.readAllPatches((String)((Object)commitDiff));
            List cumulativePatches = GHPRChangesProviderImpl.Companion.readAllPatches(diffFromMergeBase);
            for (FilePatch patch : commitPatches) {
                TextFilePatch cumulativePatch;
                GHPRChangeDiffData.FileHistory historyBefore;
                GHPRChangeDiffData.FileHistory fileHistory;
                GHPRChangeDiffData.FileHistory fileHistory2;
                boolean bl3;
                Change change = this.createChangeFromPatch(lastCommitSha, commitSha, patch);
                commitChanges.add(change);
                if (!(patch instanceof TextFilePatch)) continue;
                beforePath = ((TextFilePatch)patch).getBeforeName();
                String afterPath = ((TextFilePatch)patch).getAfterName();
                if (beforePath != null) {
                    Object object3;
                    boolean bl4 = false;
                    bl3 = false;
                    Object it2 = object3;
                    boolean bl5 = false;
                    fileHistory2 = (GHPRChangeDiffData.FileHistory)fileHistoriesByLastKnownFilePath.remove(it2);
                } else {
                    fileHistory2 = null;
                }
                if ((fileHistory = (historyBefore = fileHistory2)) == null) {
                    fileHistory = new GHPRChangeDiffData.FileHistory(commitsHashes);
                }
                GHPRChangeDiffData.FileHistory fileHistory3 = fileHistory;
                bl3 = false;
                boolean bl6 = false;
                GHPRChangeDiffData.FileHistory $this$apply = fileHistory3;
                boolean bl7 = false;
                $this$apply.append(commitSha, (TextFilePatch)patch);
                GHPRChangeDiffData.FileHistory fileHistory4 = fileHistory3;
                String string = afterPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"afterPath");
                fileHistoriesByLastKnownFilePath.put(string, fileHistory4);
                String initialPath = fileHistory4.getInitialFilePath();
                FilePatch filePatch = this.findPatchByFilePaths(cumulativePatches, initialPath, afterPath);
                if (!(filePatch instanceof TextFilePatch)) {
                    filePatch = null;
                }
                if ((cumulativePatch = (TextFilePatch)filePatch) == null) {
                    LOG.debug("Unable to find cumulative patch for commit patch");
                    continue;
                }
                this.diffDataByChange.put(change, new GHPRChangeDiffData.Commit(commitSha, GHPRChangesProviderImpl.Companion.getFilePath((TextFilePatch)patch), (TextFilePatch)patch, cumulativePatch, fileHistory4));
            }
            this.getChangesByCommits().put((GHCommit)commit, commitChanges);
            lastCommitSha = commitSha;
            lastCumulativePatches = cumulativePatches;
        }
        object2 = this;
        boolean $this$map$iv22 = false;
        ((GHPRChangesProviderImpl)object2).changes = object = (List)new ArrayList();
        Map $this$mapKeys$iv = fileHistoriesByLastKnownFilePath;
        boolean $i$f$mapKeys = false;
        commitDiff = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Object it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl8 = false;
            object = ((GHPRChangeDiffData.FileHistory)it.getValue()).getFilePath();
            beforePath = (Map.Entry)element$iv$iv$iv;
            Object object4 = object;
            Object object5 = object2;
            boolean bl9 = false;
            it = it$iv$iv.getValue();
            object5.put(object4, it);
        }
        Map fileHistoriesBySummaryFilePath = destination$iv$iv2;
        List list2 = lastCumulativePatches;
        if (list2 != null) {
            List list3 = list2;
            boolean bl10 = false;
            boolean bl11 = false;
            List it = list3;
            boolean bl12 = false;
            for (FilePatch patch : it) {
                Change change = this.createChangeFromPatch(mergeBaseRef, lastCommitSha, patch);
                this.getChanges().add(change);
                if (!(patch instanceof TextFilePatch)) continue;
                String filePath = GHPRChangesProviderImpl.Companion.getFilePath((TextFilePatch)patch);
                GHPRChangeDiffData.FileHistory fileHistory = (GHPRChangeDiffData.FileHistory)fileHistoriesBySummaryFilePath.get(filePath);
                if (fileHistory == null) {
                    LOG.debug("Unable to find file history for cumulative patch for " + filePath);
                    continue;
                }
                this.diffDataByChange.put(change, new GHPRChangeDiffData.Cumulative(lastCommitSha, filePath, (TextFilePatch)patch, fileHistory));
            }
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GHPRChangesProvider.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangesProviderImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "filePath", "", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "getFilePath", "(Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;)Ljava/lang/String;", "readAllPatches", "", "Lcom/intellij/openapi/diff/impl/patch/FilePatch;", "diffFile", "intellij.vcs.github"})
    public static final class Companion {
        private final String getFilePath(@NotNull TextFilePatch $this$filePath) {
            String string = $this$filePath.getAfterName();
            if (string == null) {
                string = $this$filePath.getBeforeName();
            }
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }

        private final List<FilePatch> readAllPatches(String diffFile) {
            PatchReader reader = new PatchReader((CharSequence)diffFile, true);
            reader.parseAllPatches();
            List list2 = reader.getAllPatches();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"reader.allPatches");
            return list2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

