/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.timeline;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.HorizontalBox;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import icons.GithubIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHCommit;
import org.jetbrains.plugins.github.api.data.GHGitActor;
import org.jetbrains.plugins.github.api.data.GHIssueComment;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestCommit;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReview;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.pullrequest.avatars.GHAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadComponent;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadModel;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRReviewServiceAdapter;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewThreadDiffComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewThreadsModel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewThreadsPanel;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRReviewsThreadsModelsProvider;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineEventComponentFactory;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRTimelineItemComponentFactory$WhenMappings;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;
import org.jetbrains.plugins.github.util.GithubUIUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0002!\"B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory;", "", "reviewService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRReviewServiceAdapter;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/GHAvatarIconsProvider;", "reviewsThreadsModelsProvider", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewsThreadsModelsProvider;", "reviewDiffComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewThreadDiffComponentFactory;", "eventComponentFactory", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactory;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineEvent;", "currentUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "(Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRReviewServiceAdapter;Lorg/jetbrains/plugins/github/pullrequest/avatars/GHAvatarIconsProvider;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewsThreadsModelsProvider;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRReviewThreadDiffComponentFactory;Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineEventComponentFactory;Lorg/jetbrains/plugins/github/api/data/GHUser;)V", "commitTitle", "Ljavax/swing/JComponent;", "commit", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "createComponent", "Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "model", "Lorg/jetbrains/plugins/github/api/data/GHIssueComment;", "review", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReview;", "item", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "userAvatar", "Ljavax/swing/JLabel;", "user", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "Lorg/jetbrains/plugins/github/api/data/GHGitActor;", "Companion", "Item", "intellij.vcs.github"})
public final class GHPRTimelineItemComponentFactory {
    private final GHPRReviewServiceAdapter reviewService;
    private final GHAvatarIconsProvider avatarIconsProvider;
    private final GHPRReviewsThreadsModelsProvider reviewsThreadsModelsProvider;
    private final GHPRReviewThreadDiffComponentFactory reviewDiffComponentFactory;
    private final GHPRTimelineEventComponentFactory<GHPRTimelineEvent> eventComponentFactory;
    private final GHUser currentUser;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Item createComponent(@NotNull GHPRTimelineItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        try {
            Item item2;
            GHPRTimelineItem gHPRTimelineItem = item;
            if (gHPRTimelineItem instanceof GHPullRequestCommit) {
                Icon icon = AllIcons.Vcs.CommitNode;
                Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Vcs.CommitNode");
                item2 = new Item(icon, this.commitTitle(((GHPullRequestCommit)item).getCommit()), null, 4, null);
            } else if (gHPRTimelineItem instanceof GHIssueComment) {
                item2 = this.createComponent((GHIssueComment)item);
            } else if (gHPRTimelineItem instanceof GHPullRequestReview) {
                item2 = this.createComponent((GHPullRequestReview)item);
            } else if (gHPRTimelineItem instanceof GHPRTimelineEvent) {
                item2 = this.eventComponentFactory.createComponent((GHPRTimelineEvent)item);
            } else {
                throw (Throwable)new IllegalStateException("Unknown item type");
            }
            return item2;
        }
        catch (Exception e) {
            Icon icon = AllIcons.General.Warning;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.General.Warning");
            return new Item(icon, (JComponent)new HtmlEditorPane("Cannot display item - " + e.getMessage()), null, 4, null);
        }
    }

    private final Item createComponent(GHIssueComment model2) {
        return new Item(this.userAvatar(model2.getAuthor()), Companion.actionTitle(model2.getAuthor(), "commented", model2.getCreatedAt()), (JComponent)new HtmlEditorPane(model2.getBodyHtml()));
    }

    private final Item createComponent(GHPullRequestReview review) {
        String string;
        Icon icon;
        GHPRReviewThreadsModel reviewThreadsModel = this.reviewsThreadsModelsProvider.getReviewThreadsModel(review.getId());
        VerticalBox verticalBox = new VerticalBox();
        boolean bl = false;
        boolean bl2 = false;
        VerticalBox $this$apply = verticalBox;
        boolean bl3 = false;
        $this$apply.add(Box.createRigidArea((Dimension)new JBDimension(0, 4)));
        Object object = review.getBodyHTML();
        boolean bl4 = false;
        if (object.length() > 0) {
            object = new HtmlEditorPane(review.getBodyHTML());
            VerticalBox verticalBox2 = $this$apply;
            bl4 = false;
            boolean bl5 = false;
            Object $this$apply2 = object;
            boolean bl6 = false;
            ((JComponent)$this$apply2).setBorder((Border)JBUI.Borders.emptyBottom((int)12));
            Object object2 = object;
            verticalBox2.add((Component)object2);
        }
        $this$apply.add((Component)new GHPRReviewThreadsPanel(reviewThreadsModel, (Function1<? super GHPRReviewThreadModel, ? extends JComponent>)((Function1)new Function1<GHPRReviewThreadModel, JComponent>(this, review, reviewThreadsModel){
            final /* synthetic */ GHPRTimelineItemComponentFactory this$0;
            final /* synthetic */ GHPullRequestReview $review$inlined;
            final /* synthetic */ GHPRReviewThreadsModel $reviewThreadsModel$inlined;
            {
                this.this$0 = gHPRTimelineItemComponentFactory;
                this.$review$inlined = gHPullRequestReview;
                this.$reviewThreadsModel$inlined = gHPRReviewThreadsModel;
                super(1);
            }

            @NotNull
            public final JComponent invoke(@NotNull GHPRReviewThreadModel it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return GHPRReviewThreadComponent.INSTANCE.createWithDiff(it, GHPRTimelineItemComponentFactory.access$getReviewService$p(this.this$0), GHPRTimelineItemComponentFactory.access$getReviewDiffComponentFactory$p(this.this$0), GHPRTimelineItemComponentFactory.access$getAvatarIconsProvider$p(this.this$0), GHPRTimelineItemComponentFactory.access$getCurrentUser$p(this.this$0));
            }
        })));
        VerticalBox reviewPanel = verticalBox;
        switch (GHPRTimelineItemComponentFactory$WhenMappings.$EnumSwitchMapping$0[review.getState().ordinal()]) {
            case 1: {
                icon = GithubIcons.ReviewAccepted;
                break;
            }
            case 2: {
                icon = GithubIcons.ReviewRejected;
                break;
            }
            case 3: {
                icon = GithubIcons.Review;
                break;
            }
            case 4: {
                icon = GithubIcons.Review;
                break;
            }
            case 5: {
                icon = GithubIcons.Review;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"when (review.state) {\n  \u2026 GithubIcons.Review\n    }");
        Icon icon2 = icon;
        switch (GHPRTimelineItemComponentFactory$WhenMappings.$EnumSwitchMapping$1[review.getState().ordinal()]) {
            case 1: {
                string = "approved these changes";
                break;
            }
            case 2: {
                string = "rejected these changes";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "reviewed";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String actionText = string;
        return new Item(icon2, Companion.actionTitle(this.avatarIconsProvider, review.getAuthor(), actionText, review.getCreatedAt()), (JComponent)reviewPanel);
    }

    private final JLabel userAvatar(GHActor user) {
        return Companion.userAvatar(this.avatarIconsProvider, user);
    }

    private final JLabel userAvatar(GHGitActor user) {
        GHGitActor gHGitActor = user;
        return (JLabel)new LinkLabel("", this.avatarIconsProvider.getIcon(gHGitActor != null ? gHGitActor.getAvatarUrl() : null), (LinkListener)new LinkListener<Object>(user){
            final /* synthetic */ GHGitActor $user;

            public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                block0: {
                    Object object = this.$user;
                    if (object == null || (object = ((GHGitActor)object).getUrl()) == null) break block0;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    BrowserUtil.browse((String)it);
                }
            }
            {
                this.$user = gHGitActor;
            }
        });
    }

    private final JComponent commitTitle(GHCommit commit) {
        String text = commit.getMessageHeadlineHTML() + " <a href='" + commit.getUrl() + "'>" + commit.getAbbreviatedOid() + "</a>";
        HorizontalBox horizontalBox = new HorizontalBox();
        boolean bl = false;
        boolean bl2 = false;
        HorizontalBox $this$apply = horizontalBox;
        boolean bl3 = false;
        $this$apply.add((Component)this.userAvatar(commit.getAuthor()));
        $this$apply.add(Box.createRigidArea((Dimension)new JBDimension(8, 0)));
        $this$apply.add((Component)new HtmlEditorPane(text));
        return (JComponent)horizontalBox;
    }

    public GHPRTimelineItemComponentFactory(@NotNull GHPRReviewServiceAdapter reviewService, @NotNull GHAvatarIconsProvider avatarIconsProvider, @NotNull GHPRReviewsThreadsModelsProvider reviewsThreadsModelsProvider, @NotNull GHPRReviewThreadDiffComponentFactory reviewDiffComponentFactory, @NotNull GHPRTimelineEventComponentFactory<GHPRTimelineEvent> eventComponentFactory, @NotNull GHUser currentUser) {
        Intrinsics.checkParameterIsNotNull((Object)reviewService, (String)"reviewService");
        Intrinsics.checkParameterIsNotNull((Object)avatarIconsProvider, (String)"avatarIconsProvider");
        Intrinsics.checkParameterIsNotNull((Object)reviewsThreadsModelsProvider, (String)"reviewsThreadsModelsProvider");
        Intrinsics.checkParameterIsNotNull((Object)reviewDiffComponentFactory, (String)"reviewDiffComponentFactory");
        Intrinsics.checkParameterIsNotNull(eventComponentFactory, (String)"eventComponentFactory");
        Intrinsics.checkParameterIsNotNull((Object)currentUser, (String)"currentUser");
        this.reviewService = reviewService;
        this.avatarIconsProvider = avatarIconsProvider;
        this.reviewsThreadsModelsProvider = reviewsThreadsModelsProvider;
        this.reviewDiffComponentFactory = reviewDiffComponentFactory;
        this.eventComponentFactory = eventComponentFactory;
        this.currentUser = currentUser;
    }

    public static final /* synthetic */ GHPRReviewServiceAdapter access$getReviewService$p(GHPRTimelineItemComponentFactory $this) {
        return $this.reviewService;
    }

    public static final /* synthetic */ GHPRReviewThreadDiffComponentFactory access$getReviewDiffComponentFactory$p(GHPRTimelineItemComponentFactory $this) {
        return $this.reviewDiffComponentFactory;
    }

    public static final /* synthetic */ GHAvatarIconsProvider access$getAvatarIconsProvider$p(GHPRTimelineItemComponentFactory $this) {
        return $this.avatarIconsProvider;
    }

    public static final /* synthetic */ GHUser access$getCurrentUser$p(GHPRTimelineItemComponentFactory $this) {
        return $this.currentUser;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \r2\u00020\u0001:\u0001\rB#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007B!\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item;", "Ljavax/swing/JPanel;", "markerIcon", "Ljavax/swing/Icon;", "title", "Ljavax/swing/JComponent;", "content", "(Ljavax/swing/Icon;Ljavax/swing/JComponent;Ljavax/swing/JComponent;)V", "marker", "Ljavax/swing/JLabel;", "(Ljavax/swing/JLabel;Ljavax/swing/JComponent;Ljavax/swing/JComponent;)V", "getMarker", "()Ljavax/swing/JLabel;", "Companion", "intellij.vcs.github"})
    public static final class Item
    extends JPanel {
        @NotNull
        private final JLabel marker;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final JLabel getMarker() {
            return this.marker;
        }

        public Item(@NotNull JLabel marker, @NotNull JComponent title, @Nullable JComponent content2) {
            Intrinsics.checkParameterIsNotNull((Object)marker, (String)"marker");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            this.marker = marker;
            this.setOpaque(false);
            MigLayout migLayout = new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fill());
            Item item = this;
            boolean bl = false;
            boolean bl2 = false;
            MigLayout $this$apply = migLayout;
            boolean bl3 = false;
            $this$apply.setColumnConstraints((Object)("[]" + UI.scale((int)8) + "[]"));
            MigLayout migLayout2 = migLayout;
            item.setLayout((LayoutManager)migLayout2);
            this.add((Component)this.marker, new CC().pushY());
            this.add((Component)title, new CC().growX().pushX());
            if (content2 != null) {
                this.add((Component)content2, new CC().newline().skip().grow().push());
            }
        }

        public /* synthetic */ Item(JLabel jLabel, JComponent jComponent, JComponent jComponent2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                jComponent2 = null;
            }
            this(jLabel, jComponent, jComponent2);
        }

        public Item(@NotNull Icon markerIcon, @NotNull JComponent title, @Nullable JComponent content2) {
            Intrinsics.checkParameterIsNotNull((Object)markerIcon, (String)"markerIcon");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            this(Item.Companion.createMarkerLabel(markerIcon), title, content2);
        }

        public /* synthetic */ Item(Icon icon, JComponent jComponent, JComponent jComponent2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                jComponent2 = null;
            }
            this(icon, jComponent, jComponent2);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Item$Companion;", "", "()V", "createMarkerLabel", "Ljavax/swing/JLabel;", "markerIcon", "Ljavax/swing/Icon;", "intellij.vcs.github"})
        public static final class Companion {
            private final JLabel createMarkerLabel(Icon markerIcon) {
                JLabel jLabel = new JLabel(markerIcon);
                boolean bl = false;
                boolean bl2 = false;
                JLabel $this$apply = jLabel;
                boolean bl3 = false;
                float verticalGap = markerIcon.getIconHeight() < 20 ? (20.0f - (float)markerIcon.getIconHeight()) / (float)2 : 0.0f;
                float horizontalGap = markerIcon.getIconWidth() < 20 ? (20.0f - (float)markerIcon.getIconWidth()) / (float)2 : 0.0f;
                JLabel jLabel2 = $this$apply;
                boolean bl4 = false;
                float f = (float)Math.floor(verticalGap);
                int n = (int)f;
                bl4 = false;
                float f2 = (float)Math.floor(horizontalGap);
                int n2 = (int)f2;
                bl4 = false;
                float f3 = (float)Math.ceil(verticalGap);
                int n3 = (int)f3;
                bl4 = false;
                float f4 = (float)Math.ceil(horizontalGap);
                jLabel2.setBorder((Border)JBUI.Borders.empty((int)n, (int)n2, (int)n3, (int)((int)f4)));
                return jLabel;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/timeline/GHPRTimelineItemComponentFactory$Companion;", "", "()V", "actionTitle", "Ljavax/swing/JComponent;", "actor", "Lorg/jetbrains/plugins/github/api/data/GHActor;", "actionHTML", "", "date", "Ljava/util/Date;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/GHAvatarIconsProvider;", "userAvatar", "Ljavax/swing/JLabel;", "user", "intellij.vcs.github"})
    public static final class Companion {
        @NotNull
        public final JLabel userAvatar(@NotNull GHAvatarIconsProvider avatarIconsProvider, @Nullable GHActor user) {
            Intrinsics.checkParameterIsNotNull((Object)avatarIconsProvider, (String)"avatarIconsProvider");
            GHActor gHActor = user;
            return (JLabel)new LinkLabel("", avatarIconsProvider.getIcon(gHActor != null ? gHActor.getAvatarUrl() : null), (LinkListener)new LinkListener<Object>(user){
                final /* synthetic */ GHActor $user;

                public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                    block0: {
                        Object object = this.$user;
                        if (object == null || (object = object.getUrl()) == null) break block0;
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl3 = false;
                        BrowserUtil.browse((String)it);
                    }
                }
                {
                    this.$user = gHActor;
                }
            });
        }

        @NotNull
        public final JComponent actionTitle(@NotNull GHAvatarIconsProvider avatarIconsProvider, @Nullable GHActor actor, @Language(value="HTML") @NotNull String actionHTML, @NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)avatarIconsProvider, (String)"avatarIconsProvider");
            Intrinsics.checkParameterIsNotNull((Object)actionHTML, (String)"actionHTML");
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            HorizontalBox horizontalBox = new HorizontalBox();
            boolean bl = false;
            boolean bl2 = false;
            HorizontalBox $this$apply = horizontalBox;
            boolean bl3 = false;
            $this$apply.add((Component)Companion.userAvatar(avatarIconsProvider, actor));
            $this$apply.add(Box.createRigidArea((Dimension)new JBDimension(8, 0)));
            $this$apply.add((Component)Companion.actionTitle(actor, actionHTML, date));
            return (JComponent)horizontalBox;
        }

        @NotNull
        public final JComponent actionTitle(@Nullable GHActor actor, @NotNull String actionHTML, @NotNull Date date) {
            Intrinsics.checkParameterIsNotNull((Object)actionHTML, (String)"actionHTML");
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            GHActor gHActor = actor;
            StringBuilder stringBuilder = new StringBuilder().append("<a href='").append(gHActor != null ? gHActor.getUrl() : null).append("'>");
            Object object = actor;
            if (object == null || (object = object.getLogin()) == null) {
                object = "unknown";
            }
            String text = stringBuilder.append((String)object).append("</a> ").append(actionHTML).append(' ').append(GithubUIUtil.INSTANCE.formatActionDate(date)).toString();
            HtmlEditorPane htmlEditorPane = new HtmlEditorPane(text);
            boolean bl = false;
            boolean bl2 = false;
            HtmlEditorPane $this$apply = htmlEditorPane;
            boolean bl3 = false;
            $this$apply.setForeground(UIUtil.getContextHelpForeground());
            return htmlEditorPane;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

