/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.ImageLoader;
import java.awt.Image;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.util.CachingGithubUserAvatarLoader;
import org.jetbrains.plugins.github.util.NonReusableEmptyProgressIndicator;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rn\u0010\u0006\u001ab\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u000b \t*\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\n0\n \t*0\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u000b \t*\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\n0\n\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;", "Lcom/intellij/openapi/Disposable;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "avatarCache", "Lcom/google/common/cache/Cache;", "", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/Image;", "progressIndicator", "Lcom/intellij/openapi/progress/EmptyProgressIndicator;", "dispose", "", "loadAndDownscale", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "url", "maximumSize", "", "requestAvatar", "Companion", "intellij.vcs.github"})
public final class CachingGithubUserAvatarLoader
implements Disposable {
    private final Logger LOG;
    private final EmptyProgressIndicator progressIndicator;
    private final Cache<String, CompletableFuture<Image>> avatarCache;
    private static final int MAXIMUM_ICON_SIZE = 40;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CompletableFuture<Image> requestAvatar(@NotNull GithubApiRequestExecutor requestExecutor, @NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        EmptyProgressIndicator indicator = this.progressIndicator;
        int imageSize = 240;
        Object object = this.avatarCache.get((Object)url, (Callable)new Callable<CompletableFuture<Image>>(this, requestExecutor, indicator, url, imageSize){
            final /* synthetic */ CachingGithubUserAvatarLoader this$0;
            final /* synthetic */ GithubApiRequestExecutor $requestExecutor;
            final /* synthetic */ EmptyProgressIndicator $indicator;
            final /* synthetic */ String $url;
            final /* synthetic */ int $imageSize;

            public final CompletableFuture<Image> call() {
                return CompletableFuture.supplyAsync((Supplier)new Supplier<Image>(this){
                    final /* synthetic */ requestAvatar.1 this$0;

                    @Nullable
                    public final Image get() {
                        Image image;
                        try {
                            image = (Image)ProgressManager.getInstance().runProcess((Computable)new Computable<Image>(this){
                                final /* synthetic */ requestAvatar.1 this$0;

                                @Nullable
                                public final Image compute() {
                                    return CachingGithubUserAvatarLoader.access$loadAndDownscale(this.this$0.this$0.this$0, this.this$0.this$0.$requestExecutor, this.this$0.this$0.$indicator, this.this$0.this$0.$url, this.this$0.this$0.$imageSize);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            }, (ProgressIndicator)this.this$0.$indicator);
                        }
                        catch (ProcessCanceledException e) {
                            image = null;
                        }
                        return image;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, ProcessIOExecutorService.INSTANCE);
            }
            {
                this.this$0 = cachingGithubUserAvatarLoader;
                this.$requestExecutor = githubApiRequestExecutor;
                this.$indicator = emptyProgressIndicator;
                this.$url = string;
                this.$imageSize = n;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"avatarCache.get(url) {\n \u2026orService.INSTANCE)\n    }");
        return (CompletableFuture)object;
    }

    private final Image loadAndDownscale(GithubApiRequestExecutor requestExecutor, EmptyProgressIndicator indicator, String url, int maximumSize) {
        try {
            Image image = requestExecutor.execute((ProgressIndicator)indicator, GithubApiRequests.CurrentUser.getAvatar(url));
            return image.getWidth(null) <= maximumSize && image.getHeight(null) <= maximumSize ? image : ImageLoader.scaleImage((Image)image, (int)maximumSize);
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        catch (Exception e) {
            this.LOG.debug("Error loading image from " + url, (Throwable)e);
            return null;
        }
    }

    public void dispose() {
        this.progressIndicator.cancel();
    }

    public CachingGithubUserAvatarLoader() {
        Logger logger;
        CachingGithubUserAvatarLoader cachingGithubUserAvatarLoader = this;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(CachingGithubUserAvatarLoader.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        cachingGithubUserAvatarLoader.LOG = logger = logger2;
        this.progressIndicator = new NonReusableEmptyProgressIndicator();
        this.avatarCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        LowMemoryWatcher.register((Runnable)new Runnable(){

            @Override
            public final void run() {
                avatarCache.invalidateAll();
            }
        }, (Disposable)this);
    }

    public static final /* synthetic */ Image access$loadAndDownscale(CachingGithubUserAvatarLoader $this, GithubApiRequestExecutor requestExecutor, EmptyProgressIndicator indicator, String url, int maximumSize) {
        return $this.loadAndDownscale(requestExecutor, indicator, url, maximumSize);
    }

    @JvmStatic
    @NotNull
    public static final CachingGithubUserAvatarLoader getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader$Companion;", "", "()V", "MAXIMUM_ICON_SIZE", "", "getInstance", "Lorg/jetbrains/plugins/github/util/CachingGithubUserAvatarLoader;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final CachingGithubUserAvatarLoader getInstance() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(CachingGithubUserAvatarLoader.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return (CachingGithubUserAvatarLoader)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

