/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.terminal.TerminalShellCommandHandler;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u0000 \u0010*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0010B\u001b\u0012\u0014\u0010\u0003\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\fH\u0016J*\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\fH\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/debugger/DebugAnythingTerminalBridge;", "T", "Lcom/intellij/terminal/TerminalShellCommandHandler;", "providerClass", "Ljava/lang/Class;", "Lcom/intellij/ide/actions/runAnything/activity/RunAnythingProvider;", "(Ljava/lang/Class;)V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "", "localSession", "command", "matches", "Companion", "intellij.javascript.impl"})
public abstract class DebugAnythingTerminalBridge<T>
implements TerminalShellCommandHandler {
    private final Class<? extends RunAnythingProvider<T>> providerClass;
    public static final Companion Companion = new Companion(null);

    public boolean matches(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command) {
        RunAnythingProvider provider;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        RunAnythingProvider runAnythingProvider = provider = (RunAnythingProvider)RunAnythingProvider.EP_NAME.findExtension(this.providerClass);
        return (runAnythingProvider != null ? runAnythingProvider.findMatchingValue(DebugAnythingTerminalBridge.Companion.createDataContext(project, localSession, workingDirectory), command) : null) != null;
    }

    public boolean execute(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        RunAnythingProvider runAnythingProvider = (RunAnythingProvider)RunAnythingProvider.EP_NAME.findExtension(this.providerClass);
        if (runAnythingProvider == null) {
            return false;
        }
        RunAnythingProvider provider = runAnythingProvider;
        DataContext dataContext = DebugAnythingTerminalBridge.Companion.createDataContext(project, localSession, workingDirectory);
        Object object = provider.findMatchingValue(dataContext, command);
        if (object == null) {
            return false;
        }
        Object runInfo = object;
        provider.execute(dataContext, runInfo);
        return true;
    }

    public DebugAnythingTerminalBridge(@NotNull Class<? extends RunAnythingProvider<T>> providerClass) {
        Intrinsics.checkParameterIsNotNull(providerClass, (String)"providerClass");
        this.providerClass = providerClass;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/debugger/DebugAnythingTerminalBridge$Companion;", "", "()V", "createDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "project", "Lcom/intellij/openapi/project/Project;", "localSession", "", "workingDirectory", "", "intellij.javascript.impl"})
    public static final class Companion {
        private final DataContext createDataContext(Project project, boolean localSession, String workingDirectory) {
            Map data = new HashMap();
            DataKey dataKey = CommonDataKeys.PROJECT;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataKey, (String)"CommonDataKeys.PROJECT");
            String string = dataKey.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CommonDataKeys.PROJECT.name");
            data.put(string, project);
            if (localSession && workingDirectory != null) {
                DataKey dataKey2 = CommonDataKeys.VIRTUAL_FILE;
                Intrinsics.checkExpressionValueIsNotNull((Object)dataKey2, (String)"CommonDataKeys.VIRTUAL_FILE");
                String string2 = dataKey2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"CommonDataKeys.VIRTUAL_FILE.name");
                data.put(string2, LocalFileSystem.getInstance().findFileByPath(workingDirectory));
            }
            DataKey dataKey3 = RunAnythingAction.EXECUTOR_KEY;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataKey3, (String)"RunAnythingAction.EXECUTOR_KEY");
            String string3 = dataKey3.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"RunAnythingAction.EXECUTOR_KEY.name");
            data.put(string3, DefaultDebugExecutor.getDebugExecutorInstance());
            DataContext dataContext = SimpleDataContext.getSimpleContext((Map)data, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"SimpleDataContext.getSimpleContext(data, null)");
            return dataContext;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

