/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadService;
import com.intellij.javascript.nodejs.interpreter.local.NodeAsdfUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsLocalInterpreterUtil {
    static final String NODE_INTERPRETER_BASE_NAME = SystemInfo.isWindows ? "node.exe" : "node";
    private static final FileFilter NODE_FILTER = pathname -> {
        String path;
        if (SystemInfo.isWindows && (path = pathname.getAbsolutePath()).contains("Microsoft HPC Pack")) {
            return false;
        }
        return !SystemInfo.isUnix || !"/usr/sbin/node".equals(path = pathname.getAbsolutePath());
    };

    private NodeJsLocalInterpreterUtil() {
    }

    @Nullable
    public static File findInterpreterInPath() {
        File interpreter = PathEnvironmentVariableUtil.findInPath((String)NODE_INTERPRETER_BASE_NAME, (FileFilter)NODE_FILTER);
        if (interpreter != null) {
            return interpreter;
        }
        ArrayList<File> interpreters = new ArrayList<File>();
        NodeJsLocalInterpreterUtil.addInterpretersFromNvm(interpreters);
        NodeJsLocalInterpreterUtil.addInterpretersFromHomeBrew(interpreters);
        NodeJsLocalInterpreterUtil.addDownloadedInterpreters(interpreters);
        if (interpreters.size() == 1) {
            return (File)ContainerUtil.getFirstItem(interpreters);
        }
        return null;
    }

    @NotNull
    public static List<File> detectAllLocalInterpreters() {
        List fromPath = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)NODE_INTERPRETER_BASE_NAME, (FileFilter)NODE_FILTER);
        ArrayList<File> interpreters = new ArrayList<File>(fromPath);
        NodeJsLocalInterpreterUtil.addInterpretersFromNvm(interpreters);
        NodeJsLocalInterpreterUtil.addInterpretersFromHomeBrew(interpreters);
        NodeJsLocalInterpreterUtil.addInterpretersFromNodist(interpreters);
        NodeJsLocalInterpreterUtil.addInterpretersFromN(interpreters);
        NodeJsLocalInterpreterUtil.addInterpretersFromAsdf(interpreters);
        NodeJsLocalInterpreterUtil.addDownloadedInterpreters(interpreters);
        ArrayList<File> arrayList = interpreters;
        if (arrayList == null) {
            NodeJsLocalInterpreterUtil.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static void addDownloadedInterpreters(List<File> interpreters) {
        NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, new File(NodeJsDownloadService.getInstallDirectory()), true, File::isDirectory);
    }

    private static void addInterpretersFromNodist(@NotNull List<File> interpreters) {
        File nodistPrefixDir;
        String nodistPrefix;
        if (interpreters == null) {
            NodeJsLocalInterpreterUtil.$$$reportNull$$$0(1);
        }
        if (SystemInfo.isWindows && !StringUtil.isEmpty((String)(nodistPrefix = EnvironmentUtil.getValue((String)"NODIST_PREFIX"))) && (nodistPrefixDir = new File(nodistPrefix)).isAbsolute() && nodistPrefixDir.isDirectory()) {
            NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, new File(nodistPrefixDir, "v"), false);
            NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, new File(nodistPrefixDir, "v-x64"), false);
        }
    }

    static void addInterpretersFromNvm(@NotNull List<File> interpreters) {
        File nvmVersionsNodeDir;
        if (interpreters == null) {
            NodeJsLocalInterpreterUtil.$$$reportNull$$$0(2);
        }
        if ((nvmVersionsNodeDir = NodeJsLocalInterpreterUtil.findNvmVersionsNodeDir()) != null) {
            NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, nvmVersionsNodeDir, true);
        }
    }

    @Nullable
    static File findNvmVersionsNodeDir() {
        File result2;
        String nvmDirPath = NodeJsLocalInterpreterUtil.getNvmDirPath();
        if (nvmDirPath == null) {
            return null;
        }
        File nvmDir = new File(nvmDirPath);
        if (nvmDir.isAbsolute() && (result2 = new File(nvmDir, "versions" + File.separator + "node")).isDirectory()) {
            return result2;
        }
        return null;
    }

    @Nullable
    private static String getNvmDirPath() {
        String nvmDirPath = EnvironmentUtil.getValue((String)"NVM_DIR");
        if (SystemInfo.isUnix && StringUtil.isEmpty((String)nvmDirPath)) {
            nvmDirPath = SystemProperties.getUserHome() + "/.nvm";
        }
        return StringUtil.nullize((String)nvmDirPath);
    }

    private static void addInterpretersFromHomeBrew(@NotNull List<File> interpreters) {
        if (interpreters == null) {
            NodeJsLocalInterpreterUtil.$$$reportNull$$$0(3);
        }
        NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, new File("/usr/local/Cellar/node"), true);
    }

    private static void addInterpretersFromVersionsDir(@NotNull List<File> interpreters, @NotNull File versionsDir, boolean interpreterInsideBinDir) {
        if (interpreters == null) {
            NodeJsLocalInterpreterUtil.$$$reportNull$$$0(4);
        }
        if (versionsDir == null) {
            NodeJsLocalInterpreterUtil.$$$reportNull$$$0(5);
        }
        NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, versionsDir, interpreterInsideBinDir, dir -> NodeJsLocalInterpreterUtil.parseSemVer(dir.getName()) != null);
    }

    private static void addInterpretersFromVersionsDir(@NotNull List<File> interpreters, @NotNull File versionsDir, boolean interpreterInsideBinDir, Function<File, Boolean> isNode) {
        if (interpreters == null) {
            NodeJsLocalInterpreterUtil.$$$reportNull$$$0(6);
        }
        if (versionsDir == null) {
            NodeJsLocalInterpreterUtil.$$$reportNull$$$0(7);
        }
        if (!versionsDir.isDirectory()) {
            return;
        }
        File[] dirs = versionsDir.listFiles();
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            String relativePath;
            File interpreter;
            if (!isNode.apply(dir).booleanValue() || !(interpreter = new File(dir, relativePath = interpreterInsideBinDir ? "bin" + File.separator + NODE_INTERPRETER_BASE_NAME : NODE_INTERPRETER_BASE_NAME)).isFile() || !interpreter.canExecute()) continue;
            interpreters.add(interpreter);
        }
    }

    private static void addInterpretersFromN(@NotNull List<File> interpreters) {
        File nPrefixDir;
        String nPrefix;
        if (interpreters == null) {
            NodeJsLocalInterpreterUtil.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmpty((String)(nPrefix = EnvironmentUtil.getValue((String)"N_PREFIX")))) {
            if (SystemInfo.isUnix) {
                nPrefix = SystemProperties.getUserHome() + "/n";
            } else {
                return;
            }
        }
        if (!(nPrefixDir = new File(nPrefix)).isAbsolute() || !nPrefixDir.isDirectory()) {
            return;
        }
        File currentNode = new File(nPrefixDir, "bin" + File.separator + NODE_INTERPRETER_BASE_NAME);
        if (currentNode.isFile() && currentNode.canExecute()) {
            interpreters.add(currentNode);
        }
        NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, new File(nPrefixDir, "n/versions/node"), true);
        NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, new File(nPrefixDir, "n/versions/io"), true);
    }

    public static void addInterpretersFromAsdf(@NotNull List<File> interpreters) {
        String asdfDirPath;
        File asdfDir;
        if (interpreters == null) {
            NodeJsLocalInterpreterUtil.$$$reportNull$$$0(9);
        }
        File file2 = asdfDir = StringUtil.isNotEmpty((String)(asdfDirPath = NodeAsdfUtil.getAsdfDirSystemIndependentPath())) ? new File(asdfDirPath) : null;
        if (asdfDir == null || !asdfDir.isAbsolute() || !asdfDir.isDirectory()) {
            return;
        }
        File currentNode = new File(asdfDir, "shims" + File.separator + NODE_INTERPRETER_BASE_NAME);
        if (currentNode.isFile() && currentNode.canExecute()) {
            interpreters.add(currentNode);
        }
        NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, new File(asdfDir, "installs/nodejs"), true);
    }

    @Nullable
    private static SemVer parseSemVer(@NotNull String name) {
        if (name == null) {
            NodeJsLocalInterpreterUtil.$$$reportNull$$$0(10);
        }
        return SemVer.parseFromText((String)StringUtil.trimStart((String)name, (String)"v"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionsDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllLocalInterpreters";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addInterpretersFromNodist";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addInterpretersFromNvm";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addInterpretersFromHomeBrew";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addInterpretersFromVersionsDir";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addInterpretersFromN";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addInterpretersFromAsdf";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseSemVer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

