/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreterType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WslCommandLineConfigurator
extends NodeCommandLineConfigurator {
    private static final Key<Boolean> WSL_FLAG = Key.create((String)"WSL_FLAG");
    private static final String WSLENV = "WSLENV";
    private static final String PATH = "PATH";
    private static final String UNC_PREFIX = "\\\\wsl$\\";
    private final WslNodeInterpreter myInterpreter;

    public WslCommandLineConfigurator(@NotNull WslNodeInterpreter interpreter) {
        if (interpreter == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(0);
        }
        this.myInterpreter = interpreter;
    }

    @Override
    public void configure(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(1);
        }
        if (!WslNodeInterpreterType.getInstance().isAvailable()) {
            throw new ExecutionException("WSL is not available");
        }
        WSLDistribution distribution = this.myInterpreter.getDistribution();
        if (distribution == null) {
            throw new ExecutionException("WSL " + this.myInterpreter.getWslDistributionId() + " is not available");
        }
        commandLine.setExePath(this.myInterpreter.getWslInterpreterPath());
        List parameters = commandLine.getParametersList().getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            String wslPath = WslCommandLineConfigurator.convertPathToWsl((String)parameters.get(i), distribution);
            if (wslPath == null) continue;
            commandLine.getParametersList().set(i, wslPath);
        }
        HashMap envs = new HashMap(commandLine.getEnvironment());
        commandLine.getEnvironment().clear();
        this.fixPathIfNeeded(commandLine);
        commandLine = distribution.patchCommandLine(commandLine, null, null, false);
        commandLine.getEnvironment().clear();
        commandLine.getEnvironment().putAll(envs);
        WslCommandLineConfigurator.setWSLENV(commandLine);
        commandLine.putUserData(WSL_FLAG, (Object)true);
    }

    @Nullable
    private static String convertPathToWsl(@NotNull String value, @NotNull WSLDistribution distribution) {
        if (value == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(2);
        }
        if (distribution == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(3);
        }
        if (WslCommandLineConfigurator.isWindowsAbsolutePath(value)) {
            return distribution.getWslPath(value);
        }
        String convertedFromUnc = WslCommandLineConfigurator.convertUncPathToWsl(value, distribution);
        if (convertedFromUnc != null) {
            return convertedFromUnc;
        }
        if (value.startsWith("/")) {
            return FileUtil.toSystemIndependentName((String)value);
        }
        return null;
    }

    @Nullable
    private static String convertUncPathToWsl(@NotNull String windowsPath, @NotNull WSLDistribution distribution) {
        String root;
        if (windowsPath == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(4);
        }
        if (distribution == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(5);
        }
        if (windowsPath.startsWith(root = UNC_PREFIX + distribution.getMsId())) {
            String wslPath = windowsPath.substring(root.length());
            if (wslPath.isEmpty()) {
                return "/";
            }
            if (wslPath.startsWith("/") || wslPath.startsWith("\\")) {
                return FileUtil.toSystemIndependentName((String)wslPath);
            }
        }
        return null;
    }

    @Override
    public String convertLocalPathToRemote(@NotNull String localPath) {
        if (localPath == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(6);
        }
        return NodeInterpreterUtil.convertLocalPathToRemote(localPath, this.myInterpreter);
    }

    @Override
    @NotNull
    protected NodeJsInterpreter getInterpreter() {
        WslNodeInterpreter wslNodeInterpreter = this.myInterpreter;
        if (wslNodeInterpreter == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(7);
        }
        return wslNodeInterpreter;
    }

    private static boolean isWindowsAbsolutePath(@NotNull String value) {
        if (value == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(8);
        }
        return FileUtil.isWindowsAbsolutePath((String)value) && value.length() >= 3;
    }

    private void fixPathIfNeeded(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(9);
        }
        String defaultPath2 = "/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/games:/usr/local/games";
        String binDir = PathUtil.getParentPath((String)this.myInterpreter.getWslInterpreterPath());
        if (!StringUtil.split((String)defaultPath2, (String)":").contains(binDir)) {
            String prevPath = "$PATH";
            if ("UBUNTU_LEGACY".equals(this.myInterpreter.getWslDistributionId())) {
                prevPath = "'" + prevPath + "'";
            }
            commandLine.getEnvironment().put(PATH, PathUtil.getParentPath((String)this.myInterpreter.getWslInterpreterPath()) + ":" + prevPath);
        }
    }

    private static void setWSLENV(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(10);
        }
        StringBuilder builder = new StringBuilder();
        for (String envName : commandLine.getEnvironment().keySet()) {
            if (!StringUtil.isNotEmpty((String)envName)) continue;
            if (builder.length() > 0) {
                builder.append(":");
            }
            builder.append(envName).append("/u");
        }
        if (builder.length() > 0) {
            String prevValue = (String)commandLine.getParentEnvironment().get(WSLENV);
            String value = prevValue != null ? StringUtil.trimEnd((String)prevValue, (char)':') + ':' + builder.toString() : builder.toString();
            commandLine.getEnvironment().put(WSLENV, value);
        }
    }

    public static boolean isWslConfigured(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            WslCommandLineConfigurator.$$$reportNull$$$0(11);
        }
        return commandLine.getUserData(WSL_FLAG) == Boolean.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/wsl/WslCommandLineConfigurator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/wsl/WslCommandLineConfigurator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertPathToWsl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertUncPathToWsl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertLocalPathToRemote";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isWindowsAbsolutePath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fixPathIfNeeded";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setWSLENV";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isWslConfigured";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

