/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ecmascript6.psi.impl.JSNodeModulesHandlerScope;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.library.download.TypeScriptDefinitionFilesDirectory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSImportScope
extends JSNodeModulesHandlerScope {
    @NotNull
    private final ProjectFileIndex myIndex;
    @NotNull
    private final JSFile.ModuleStatus myStatus;
    @NotNull
    private final Set<VirtualFile> myPredefinedLibraryFiles;
    @NotNull
    private final VirtualFile myDirectoryOfContext;
    @Nullable
    private final VirtualFile myGlobalNodeModules;
    @NotNull
    private final PsiManager myPsiManager;

    public JSImportScope(@NotNull Project project, @NotNull VirtualFile contextFile, @NotNull GlobalSearchScope baseScope, @NotNull JSFile.ModuleStatus status) {
        if (project == null) {
            JSImportScope.$$$reportNull$$$0(0);
        }
        if (contextFile == null) {
            JSImportScope.$$$reportNull$$$0(1);
        }
        if (baseScope == null) {
            JSImportScope.$$$reportNull$$$0(2);
        }
        if (status == null) {
            JSImportScope.$$$reportNull$$$0(3);
        }
        super(project, contextFile, baseScope);
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.myIndex = ProjectFileIndex.getInstance((Project)project);
        this.myStatus = status;
        HashSet<VirtualFile> predefinedLibraryFiles = new HashSet<VirtualFile>(JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles());
        predefinedLibraryFiles.addAll(JSCorePredefinedLibrariesProvider.getFlowJSPredefinedLibraryFiles());
        this.myPredefinedLibraryFiles = predefinedLibraryFiles;
        this.myDirectoryOfContext = contextFile.getParent();
        VirtualFile globalCandidate = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory();
        this.myGlobalNodeModules = globalCandidate == null || !globalCandidate.isValid() ? null : globalCandidate.getParent();
    }

    @Override
    protected boolean isAcceptableProjectFile(@NotNull VirtualFile toCheck) {
        if (toCheck == null) {
            JSImportScope.$$$reportNull$$$0(4);
        }
        return super.isAcceptableProjectFile(toCheck) && !this.myIndex.isInLibrary(toCheck) && !this.myPredefinedLibraryFiles.contains(toCheck);
    }

    @Override
    protected boolean isAcceptableNodeModulesFile(@NotNull VirtualFile toCheck, @NotNull VirtualFile module, @NotNull VirtualFile nodeModules) {
        if (toCheck == null) {
            JSImportScope.$$$reportNull$$$0(5);
        }
        if (module == null) {
            JSImportScope.$$$reportNull$$$0(6);
        }
        if (nodeModules == null) {
            JSImportScope.$$$reportNull$$$0(7);
        }
        if (!super.isAcceptableNodeModulesFile(toCheck, module, nodeModules)) {
            return false;
        }
        if (!TypeScriptUtil.isDefinitionFile(toCheck) && !this.isAcceptableES6File(toCheck, this.myPsiManager)) {
            return false;
        }
        VirtualFile parent = nodeModules.getParent();
        if (parent == null) {
            return false;
        }
        return VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)this.myDirectoryOfContext, (boolean)false) || this.myGlobalNodeModules != null && nodeModules.equals(this.myGlobalNodeModules);
    }

    private boolean isAcceptableES6File(@NotNull VirtualFile file2, @NotNull PsiManager manager2) {
        PsiFile psiFile;
        if (file2 == null) {
            JSImportScope.$$$reportNull$$$0(8);
        }
        if (manager2 == null) {
            JSImportScope.$$$reportNull$$$0(9);
        }
        return (psiFile = manager2.findFile(file2)) instanceof JSFile && ((JSFile)psiFile).getModuleStatus() == this.myStatus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCheck";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModules";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/JSImportScope";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptableProjectFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptableNodeModulesFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptableES6File";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

