/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberInfo;
import com.intellij.lang.ecmascript6.refactoring.ES6ReferenceExpressionsInfo;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.inspections.FileHeaderKeeper;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAssertion;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.ui.UsageViewDescriptorAdapter;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MoveModuleMembersProcessor
extends BaseRefactoringProcessor {
    public static final Comparator<PsiElement> ELEMENT_START_OFFSET_COMPARATOR = Comparator.comparingInt(el -> el.getTextRange().getStartOffset());
    @NotNull
    private final List<ES6ModuleMemberInfo.MovedElementRange> mySourceElements;
    private final Map<JSQualifiedNamedElement, ES6ReferenceExpressionsInfo> myReferenceExpressionsInfos;
    @NotNull
    private final PsiElement myDestinationModule;
    @NotNull
    private final PsiElement mySourceModule;
    @Nullable
    private final Consumer<? super Collection<JSQualifiedNamedElement>> myCallback;
    private final boolean myEscalateVisibility;
    private Collection<ES6ImportExportDeclaration> mySourceModuleImportOrExportReferences;
    private List<ES6ExportDeclaration> myDestinationModuleNamespaceExportReferences;

    public ES6MoveModuleMembersProcessor(@NotNull List<JSQualifiedNamedElement> elements, @NotNull PsiElement destinationModule, @NotNull PsiElement sourceModuleOrFile, boolean escalateVisibility, @Nullable Consumer<? super Collection<JSQualifiedNamedElement>> callbackForResults) {
        if (elements == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(0);
        }
        if (destinationModule == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(1);
        }
        if (sourceModuleOrFile == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(2);
        }
        super(sourceModuleOrFile.getProject());
        this.mySourceElements = ContainerUtil.map(elements, ES6ModuleMemberInfo::findMovedRange);
        this.myReferenceExpressionsInfos = ContainerUtil.map2Map(this.mySourceElements, range -> Pair.create((Object)range.main, (Object)ES6ReferenceExpressionsInfo.getInfoForRange(range.first, range.last)));
        this.mySourceModule = sourceModuleOrFile;
        this.myEscalateVisibility = escalateVisibility;
        this.myDestinationModule = destinationModule;
        this.myCallback = callbackForResults;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(3);
        }
        return new UsageViewDescriptorAdapter(){

            public PsiElement @NotNull [] getElements() {
                PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.map2Array((Collection)ES6MoveModuleMembersProcessor.this.mySourceElements, PsiElement.class, range -> range.main);
                if (psiElementArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            public String getProcessedElementsHeader() {
                return ES6MoveModuleMembersProcessor.this.getCommandName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor$1", "getElements"));
            }
        };
    }

    @NotNull
    protected String getCommandName() {
        String string = JavaScriptBundle.message((String)"es6.move.module.members.refactoring.name", (Object[])new Object[0]);
        if (string == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected UsageInfo @NotNull [] findUsages() {
        ArrayList result2 = new ArrayList();
        for (ES6ModuleMemberInfo.MovedElementRange element : this.mySourceElements) {
            ReferencesSearch.search((PsiElement)element.main).forEach(reference -> {
                if (!this.isInMovedElement(reference.getElement())) {
                    result2.add(new MoveRenameUsageInfo(reference, (PsiElement)element.main));
                }
            });
        }
        this.mySourceModuleImportOrExportReferences = this.getSourceModuleImportOrExportReferences();
        this.myDestinationModuleNamespaceExportReferences = this.getDestinationModuleNamespaceExportReferences();
        UsageInfo[] usageInfoArray = result2.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(5);
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(6);
        }
        return this.showConflicts(this.getConflicts((UsageInfo[])refUsages.get()), (UsageInfo[])refUsages.get());
    }

    @NotNull
    private MultiMap<PsiElement, String> getConflicts(UsageInfo @NotNull [] usages) {
        JSFile.ModuleStatus moduleStatus;
        if (usages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(7);
        }
        MultiMap conflicts = new MultiMap();
        if (this.myDestinationModule instanceof JSFile && (moduleStatus = ((JSFile)this.myDestinationModule).getModuleStatus()) != JSFile.ModuleStatus.ES6 && moduleStatus != JSFile.ModuleStatus.NONE) {
            conflicts.putValue((Object)this.myDestinationModule, (Object)JavaScriptBundle.message((String)"es6.move.module.members.destination.not.es6", (Object[])new Object[]{((JSFile)this.myDestinationModule).getName()}));
        }
        if (this.mySourceModule.getLanguage() != this.myDestinationModule.getLanguage()) {
            this.validateChangedLanguage((MultiMap<PsiElement, String>)conflicts);
        }
        this.validateDestinationModuleDeclarations((MultiMap<PsiElement, String>)conflicts);
        for (Map.Entry<JSQualifiedNamedElement, ES6ReferenceExpressionsInfo> entry : this.myReferenceExpressionsInfos.entrySet()) {
            ES6ReferenceExpressionsInfo.addValidations(entry.getValue(), (JSPsiElementBase)entry.getKey(), (Condition<? super PsiElement>)((Condition)this::isInMovedElement), (MultiMap<PsiElement, String>)conflicts);
        }
        for (UsageInfo usage : usages) {
            String elementDescription;
            PsiFile file2;
            PsiElement referenceElement;
            PsiElement element;
            PsiElement psiElement = element = usage instanceof MoveRenameUsageInfo ? ((MoveRenameUsageInfo)usage).getReferencedElement() : null;
            if (element == null) continue;
            PsiElement psiElement2 = referenceElement = usage.getReference() != null ? usage.getReference().getElement() : null;
            if (referenceElement == null) continue;
            PsiElement referenceModule = ES6PsiUtil.findExternalModule(referenceElement);
            if (ES6PsiUtil.isExternalModule(this.mySourceModule) && referenceModule == null) {
                file2 = referenceElement.getContainingFile();
                elementDescription = StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)element, (boolean)false));
                String message = JavaScriptBundle.message((String)"es6.move.module.members.non.es6.module.usage", (Object[])new Object[]{elementDescription, file2.getName()});
                conflicts.putValue((Object)referenceElement, (Object)message);
                continue;
            }
            if (this.myEscalateVisibility || referenceModule == null || ES6ImportHandler.isExportedWithNameOrDefault(element)) continue;
            file2 = referenceElement.getContainingFile();
            elementDescription = RefactoringUIUtil.getDescription((PsiElement)element, (boolean)false);
            conflicts.putValue((Object)referenceElement, (Object)JavaScriptBundle.message((String)"es6.move.module.members.has.local.usage.message", (Object[])new Object[]{elementDescription, file2.getName()}));
        }
        MultiMap multiMap = conflicts;
        if (multiMap == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(8);
        }
        return multiMap;
    }

    private void validateChangedLanguage(@NotNull MultiMap<PsiElement, String> conflicts) {
        if (conflicts == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(9);
        }
        for (ES6ModuleMemberInfo.MovedElementRange elementRange : this.mySourceElements) {
            boolean destinationIsJSX = DialectDetector.isJSX(this.myDestinationModule);
            String elementDescription = StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)elementRange.main, (boolean)false));
            for (PsiElement element : elementRange.getElements()) {
                if (!destinationIsJSX && ES6MoveModuleMembersProcessor.hasJSXTags(element)) {
                    conflicts.putValue((Object)element, (Object)JavaScriptBundle.message((String)"es6.move.module.members.destination.does.not.support.jsx", (Object[])new Object[]{elementDescription}));
                    continue;
                }
                if (this.mySourceModule.getLanguage() == this.myDestinationModule.getLanguage() || !this.errorCountChanged(elementRange)) continue;
                conflicts.putValue((Object)element, (Object)JavaScriptBundle.message((String)"es6.move.module.members.syntax.errors", (Object[])new Object[]{elementDescription}));
            }
        }
    }

    private boolean errorCountChanged(@NotNull ES6ModuleMemberInfo.MovedElementRange range) {
        if (range == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(10);
        }
        int errorsBefore = ES6MoveModuleMembersProcessor.getErrorsCount(range.first, range.last);
        PsiFile sourceDialectFile = JSChangeUtil.createJSFileFromText(this.mySourceModule.getProject(), "", DialectDetector.languageDialectOfElement(this.mySourceModule));
        sourceDialectFile.addRange(range.first, range.last);
        this.convertToTSXIfNeeded(sourceDialectFile.getFirstChild(), sourceDialectFile.getLastChild());
        PsiFile toDialectFile = JSChangeUtil.createJSFileFromText(this.myDestinationModule.getProject(), sourceDialectFile.getText(), DialectDetector.languageDialectOfElement(this.myDestinationModule));
        return toDialectFile.getChildren().length == 0 || ES6MoveModuleMembersProcessor.getErrorsCount(toDialectFile.getFirstChild(), toDialectFile.getLastChild()) > errorsBefore;
    }

    private static int getErrorsCount(@NotNull PsiElement first, @NotNull PsiElement last) {
        if (first == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(11);
        }
        if (last == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(12);
        }
        return JSPsiImplUtils.getSiblingsForward(first, last).stream().map(element -> SyntaxTraverser.psiTraverser((PsiElement)element).filter(PsiErrorElement.class).size()).mapToInt(value -> value).sum();
    }

    private static boolean hasJSXTags(PsiElement element) {
        return !SyntaxTraverser.psiTraverser((PsiElement)element).filter(JSXXmlLiteralExpressionImpl.class).isEmpty();
    }

    private boolean isInMovedElement(@NotNull PsiElement element) {
        if (element == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(13);
        }
        for (ES6ModuleMemberInfo.MovedElementRange member : this.mySourceElements) {
            for (PsiElement moved : member.getElements()) {
                if (!PsiTreeUtil.isAncestor((PsiElement)moved, (PsiElement)element, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    protected void execute(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(14);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)this.mySourceModule)) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)this.myDestinationModule)) {
            return;
        }
        super.execute(usages);
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        MultiMap<PsiElement, UsageInfo> elementToUsages = ES6MoveModuleMembersProcessor.splitUsagesByElements(usages);
        if (this.myEscalateVisibility) {
            for (Map.Entry entry : elementToUsages.entrySet()) {
                PsiElement element = (PsiElement)entry.getKey();
                if (!(element instanceof JSAttributeListOwner) || ES6ImportHandler.isExportedWithNameOrDefault(element) || ((Collection)entry.getValue()).isEmpty()) continue;
                ES6MoveModuleMembersProcessor.addExportModifier((JSAttributeListOwner)element);
            }
        }
        for (ES6ModuleMemberInfo.MovedElementRange range : this.mySourceElements) {
            this.convertToTSXIfNeeded(range.first, range.last);
        }
        ArrayList<FormatFixer> postponedFormatters = new ArrayList<FormatFixer>();
        FileHeaderKeeper keeper = new FileHeaderKeeper(this.myDestinationModule);
        keeper.saveStateAndCutHeader();
        List newElements = ContainerUtil.map(this.moveElementsAndUpdateUsages(elementToUsages, postponedFormatters), el -> this.createPointer((JSQualifiedNamedElement)el));
        ES6CreateImportUtil.addRequiredImports(this.myReferenceExpressionsInfos.values(), (Condition<? super PsiElement>)((Condition)this::isInMovedElement), this.myDestinationModule);
        ES6CreateImportUtil.optimizeImports(this.myDestinationModule);
        keeper.restoreHeaderForSavedState();
        this.deleteTargetElements();
        ES6CreateImportUtil.optimizeImports(this.mySourceModule);
        JSRefactoringUtil.format(postponedFormatters);
        if (this.myCallback != null) {
            List result2 = newElements.stream().map(el -> (JSQualifiedNamedElement)el.getElement()).filter(el -> el != null).collect(Collectors.toList());
            this.myCallback.consume(result2);
        }
    }

    private void convertToTSXIfNeeded(@NotNull PsiElement first, @NotNull PsiElement last) {
        if (first == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(16);
        }
        if (last == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(17);
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(this.mySourceModule);
        DialectOptionHolder toDialect = DialectDetector.dialectOfElement(this.myDestinationModule);
        if (dialect != null && !dialect.isTSX && toDialect != null && toDialect.isTSX) {
            final ArrayList<PsiElement> typeAssertions = new ArrayList<PsiElement>();
            final ArrayList<PsiElement> arrowFunctions = new ArrayList<PsiElement>();
            JSRecursiveWalkingElementVisitor visitor = new JSRecursiveWalkingElementVisitor(){

                public void visitJSFunctionExpression(JSFunctionExpression node) {
                    super.visitJSFunctionExpression(node);
                    if (JSPsiImplUtils.isArrowFunction((JSFunction)node)) {
                        arrowFunctions.add(node);
                    }
                }

                public void visitTypeScriptCastExpression(TypeScriptCastExpression node) {
                    super.visitTypeScriptCastExpression(node);
                    if (node instanceof TypeScriptTypeAssertion) {
                        typeAssertions.add((TypeScriptTypeAssertion)node);
                    }
                }
            };
            for (PsiElement psiElement : JSPsiImplUtils.getSiblingsForward(first, last)) {
                psiElement.accept((PsiElementVisitor)visitor);
            }
            typeAssertions.sort(ELEMENT_START_OFFSET_COMPARATOR.reversed());
            arrowFunctions.sort(ELEMENT_START_OFFSET_COMPARATOR.reversed());
            for (TypeScriptTypeAssertion typeScriptTypeAssertion : typeAssertions) {
                JSExpression expression = typeScriptTypeAssertion.getExpression();
                TypeScriptType type = typeScriptTypeAssertion.getType();
                String asCast = (expression != null ? expression.getText() : "") + " as " + (type != null ? type.getText() : "");
                typeScriptTypeAssertion.replace(JSPsiElementFactory.createJSExpression(asCast, this.myDestinationModule));
            }
            for (JSFunctionExpression jSFunctionExpression : arrowFunctions) {
                JSFunctionsRefactoringUtil.convertGenericArrowParameterForTSX((JSFunction)jSFunctionExpression);
            }
        }
    }

    @NotNull
    private SmartPsiElementPointer<JSQualifiedNamedElement> createPointer(@NotNull JSQualifiedNamedElement el) {
        if (el == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(18);
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)el);
        if (smartPsiElementPointer == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(19);
        }
        return smartPsiElementPointer;
    }

    private void validateDestinationModuleDeclarations(MultiMap<PsiElement, String> conflicts) {
        for (ES6ModuleMemberInfo.MovedElementRange movedRange : this.mySourceElements) {
            List<PsiElement> elements;
            PsiElement resolved;
            String name;
            JSQualifiedNamedElement element = movedRange.main;
            JSElement destinationModuleDefaultExport = ES6PsiUtil.findDefaultExport(this.myDestinationModule);
            if (element.isExportedWithDefault() && destinationModuleDefaultExport != null) {
                conflicts.putValue((Object)destinationModuleDefaultExport, (Object)JavaScriptBundle.message((String)"es6.move.module.members.destination.contains.default.export", (Object[])new Object[0]));
            }
            if (StringUtil.isEmpty((String)(name = element.getName())) || (resolved = JSStubBasedPsiTreeUtil.resolveLocally(name, this.myDestinationModule, false)) == null || element.equals(resolved) || (resolved instanceof ES6ImportExportSpecifier ? (elements = JSResolveResult.toElements(((ES6ImportExportSpecifier)resolved).multiResolve(false))).contains(element) : resolved instanceof ES6ImportExportDeclarationPart && this.isFromPartEqualsSource((ES6ImportExportDeclarationPart)resolved))) continue;
            conflicts.putValue((Object)resolved, (Object)("Destination module contains a symbol with name \"" + name + "\""));
        }
    }

    private boolean isFromPartEqualsSource(@NotNull ES6ImportExportDeclarationPart importPart) {
        Collection elements;
        ES6ImportExportDeclaration declaration;
        ES6FromClause clause;
        if (importPart == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(20);
        }
        ES6FromClause eS6FromClause = clause = (declaration = importPart.getDeclaration()) == null ? null : declaration.getFromClause();
        return clause != null && (elements = clause.resolveReferencedElements()).contains(this.mySourceModule);
    }

    private List<JSQualifiedNamedElement> moveElementsAndUpdateUsages(@NotNull MultiMap<PsiElement, UsageInfo> elementToUsages, @NotNull List<FormatFixer> postponedFormatters) {
        if (elementToUsages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(21);
        }
        if (postponedFormatters == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(22);
        }
        ArrayList<JSQualifiedNamedElement> newElements = new ArrayList<JSQualifiedNamedElement>();
        PsiElement anchor = this.getInsertionAnchor(elementToUsages.values());
        for (ES6ModuleMemberInfo.MovedElementRange member : ContainerUtil.reverse(this.mySourceElements)) {
            RefactoringElementListener elementListener = this.getTransaction().getElementListener((PsiElement)member.main);
            Collection elementUsages = elementToUsages.get((Object)member.main);
            JSQualifiedNamedElement newMember = this.moveElement(member, elementUsages, postponedFormatters, anchor);
            if (newMember != null) {
                newElements.add(newMember);
                anchor = JSPsiImplUtils.findLeadingCommentOrSelf(ES6ModuleMemberInfo.getTopLevelDeclaration(newMember));
            }
            elementListener.elementMoved((PsiElement)(newMember == null ? member.main : newMember));
        }
        return newElements;
    }

    @Nullable
    private PsiElement getInsertionAnchor(@NotNull Collection<? extends UsageInfo> elementUsages) {
        if (elementUsages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(23);
        }
        PsiFile myToFile = this.myDestinationModule.getContainingFile();
        List usagesStatements = elementUsages.stream().map(el -> {
            PsiFile file2 = el.getFile();
            if (!myToFile.isEquivalentTo((PsiElement)file2)) {
                return null;
            }
            PsiReference reference = el.getReference();
            if (reference == null) {
                return null;
            }
            PsiElement element = reference.getElement();
            if (element instanceof ES6ImportExportSpecifier || element instanceof ES6ImportedBinding) {
                return null;
            }
            return PsiTreeUtil.findFirstParent((PsiElement)element, e -> this.myDestinationModule.isEquivalentTo(e.getParent()));
        }).filter(el -> el != null).sorted(ELEMENT_START_OFFSET_COMPARATOR).collect(Collectors.toList());
        if (usagesStatements.isEmpty()) {
            return null;
        }
        return JSPsiImplUtils.findLeadingCommentOrSelf((PsiElement)usagesStatements.get(0));
    }

    private void deleteTargetElements() {
        for (ES6ModuleMemberInfo.MovedElementRange member : this.mySourceElements) {
            PostprocessReformattingAspect.getInstance((Project)member.main.getProject()).disablePostprocessFormattingInside(() -> member.first.getParent().deleteChildRange(member.first, member.last));
        }
    }

    private JSQualifiedNamedElement moveElement(@NotNull ES6ModuleMemberInfo.MovedElementRange movedRange, @NotNull Collection<UsageInfo> elementUsages, @NotNull List<FormatFixer> postponedFormatters, @Nullable PsiElement anchor) {
        if (movedRange == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(24);
        }
        if (elementUsages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(25);
        }
        if (postponedFormatters == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(26);
        }
        ArrayList<PsiElement> toRemoveElements = new ArrayList<PsiElement>();
        Pair<PsiElement, PsiElement> newElementRange = JSChangeUtil.doAddRangeBefore(this.myDestinationModule, movedRange.first, movedRange.last, anchor);
        if (this.myDestinationModule instanceof JSEmbeddedContent) {
            if (((PsiElement)newElementRange.second).getNextSibling() == null) {
                JSChangeUtil.addWs(this.myDestinationModule.getNode(), null, "\n");
            }
            if (((PsiElement)newElementRange.first).getPrevSibling() == null) {
                JSChangeUtil.addWs(this.myDestinationModule.getNode(), ((PsiElement)newElementRange.first).getNode(), "\n");
            }
        }
        postponedFormatters.add(FormatFixer.create((PsiElement)newElementRange.first, (PsiElement)newElementRange.second, FormatFixer.Mode.Reformat));
        PsiElement firstCreatedElement = (PsiElement)newElementRange.first;
        while (firstCreatedElement instanceof PsiComment || firstCreatedElement instanceof PsiWhiteSpace) {
            firstCreatedElement = firstCreatedElement.getNextSibling();
        }
        JSQualifiedNamedElement newMember = ES6ModuleMemberInfo.getMember(firstCreatedElement);
        if (newMember == null) {
            return null;
        }
        HashMap<PsiElement, String> updatedModules = new HashMap<PsiElement, String>();
        String oldName = movedRange.main.getName();
        for (UsageInfo usage : elementUsages) {
            this.updateUsage(usage, newMember, oldName, toRemoveElements, updatedModules);
        }
        if (!newMember.isExportedWithDefault()) {
            this.updateExportAllDeclarations(newMember);
        }
        for (PsiElement element : toRemoveElements) {
            ES6MoveModuleMembersProcessor.deletePsiElement(element);
        }
        for (PsiElement module : updatedModules.keySet()) {
            ES6CreateImportUtil.optimizeImports(module);
        }
        return newMember;
    }

    private void updateExportAllDeclarations(@NotNull JSQualifiedNamedElement newMember) {
        if (newMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(27);
        }
        for (ES6ImportExportDeclaration declaration : this.mySourceModuleImportOrExportReferences) {
            String newName;
            PsiElement declarationModule;
            if (!(declaration instanceof ES6ExportDeclaration) || !((ES6ExportDeclaration)declaration).isExportAll() || (declarationModule = ES6PsiUtil.findExternalModule((PsiElement)declaration)) == null || this.containsDestinationModuleNamespaceExport(declarationModule) || (newName = newMember.getName()) == null) continue;
            ES6CreateImportUtil.insertExport(newMember, ES6ImportPsiUtil.ImportExportType.SPECIFIER, newName, newName, (PsiElement)declaration);
        }
    }

    private boolean containsDestinationModuleNamespaceExport(@NotNull PsiElement containingModule) {
        if (containingModule == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(28);
        }
        for (ES6ExportDeclaration declaration : this.myDestinationModuleNamespaceExportReferences) {
            if (!containingModule.isEquivalentTo(ES6PsiUtil.findExternalModule((PsiElement)declaration))) continue;
            return true;
        }
        return false;
    }

    private void updateUsage(@NotNull UsageInfo usage, @NotNull JSQualifiedNamedElement newMember, @Nullable String oldName, @NotNull List<PsiElement> toRemoveElements, @NotNull Map<PsiElement, String> updatedModules) {
        PsiReference reference;
        PsiElement refElement;
        if (usage == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(29);
        }
        if (newMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(30);
        }
        if (toRemoveElements == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(31);
        }
        if (updatedModules == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(32);
        }
        PsiElement psiElement = refElement = (reference = usage.getReference()) != null ? reference.getElement() : null;
        if (refElement instanceof JSReferenceExpression) {
            this.updateReferenceExpressionUsage((JSReferenceExpression)refElement, newMember, toRemoveElements, updatedModules);
        } else if (refElement instanceof ES6ImportSpecifier) {
            this.updateImportSpecifier((ES6ImportSpecifier)refElement, newMember, oldName, toRemoveElements);
        } else if (refElement instanceof ES6ExportSpecifier) {
            this.updateExportSpecifier((ES6ExportSpecifier)refElement, newMember, toRemoveElements);
        } else if (refElement instanceof ES6ImportedBinding) {
            this.updateImportedBinding((ES6ImportedBinding)refElement, newMember, oldName, toRemoveElements);
        } else if (refElement instanceof XmlTag) {
            if (ReactXmlExtension.hasQualifiedName((XmlTag)refElement)) {
                this.updateQualifiedUsage(reference, newMember, updatedModules, (newName, element) -> ((XmlTag)element).setName(newName));
            } else {
                this.updateUnqualifiedReferenceUsage(reference, newMember, toRemoveElements);
            }
        }
    }

    private void updateExportSpecifier(@NotNull ES6ExportSpecifier specifier, @NotNull JSQualifiedNamedElement newMember, @NotNull List<PsiElement> toRemoveElements) {
        ES6ExportDeclaration declaration;
        if (specifier == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(33);
        }
        if (newMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(34);
        }
        if (toRemoveElements == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(35);
        }
        if (this.skipDeclaration((ES6ImportExportDeclaration)(declaration = specifier.getDeclaration()))) {
            return;
        }
        String name = specifier.getDeclaredName();
        if (name == null) {
            return;
        }
        PsiElement declarationModule = ES6PsiUtil.findExternalModule((PsiElement)declaration);
        if (declaration.getFromClause() == null) {
            if (this.mySourceModule.isEquivalentTo(declarationModule)) {
                ES6CreateImportUtil.insertExportName(ES6ImportPsiUtil.ImportExportType.SPECIFIER, name, newMember.getName(), this.getDestinationPlace());
                toRemoveElements.add((PsiElement)specifier);
            }
            return;
        }
        boolean fromDestinationModule = this.myDestinationModule.isEquivalentTo(declarationModule);
        if (fromDestinationModule) {
            toRemoveElements.add((PsiElement)specifier);
            return;
        }
        if (specifier.isDefault()) {
            ES6CreateImportUtil.insertExport(newMember, ES6ImportPsiUtil.ImportExportType.SPECIFIER, name, "default", (PsiElement)declaration);
        } else {
            ES6CreateImportUtil.insertExport(newMember, ES6ImportPsiUtil.ImportExportType.SPECIFIER, name, newMember.getName(), (PsiElement)declaration);
        }
        toRemoveElements.add((PsiElement)specifier);
    }

    @NotNull
    private PsiElement getDestinationPlace() {
        PsiElement psiElement = (PsiElement)ObjectUtils.coalesce((Object)this.myDestinationModule.getFirstChild(), (Object)this.myDestinationModule);
        if (psiElement == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(36);
        }
        return psiElement;
    }

    private void updateImportedBinding(@NotNull ES6ImportedBinding binding, @NotNull JSQualifiedNamedElement newMember, @Nullable String oldName, @NotNull List<PsiElement> toRemoveElements) {
        if (binding == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(37);
        }
        if (newMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(38);
        }
        if (toRemoveElements == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(39);
        }
        this.updateImportPart((ES6ImportExportDeclarationPart)binding, (JSNamedElement)binding, newMember, oldName, toRemoveElements);
    }

    private void updateImportSpecifier(@NotNull ES6ImportSpecifier specifier, @NotNull JSQualifiedNamedElement newMember, @Nullable String oldName, @NotNull List<PsiElement> toRemoveElements) {
        if (specifier == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(40);
        }
        if (newMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(41);
        }
        if (toRemoveElements == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(42);
        }
        this.updateImportPart((ES6ImportExportDeclarationPart)specifier, (JSNamedElement)specifier.getAlias(), newMember, oldName, toRemoveElements);
    }

    private void updateImportPart(@NotNull ES6ImportExportDeclarationPart importPart, @Nullable JSNamedElement localDefinition, @NotNull JSQualifiedNamedElement newMember, @Nullable String oldName, @NotNull List<PsiElement> toRemoveElements) {
        if (importPart == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(43);
        }
        if (newMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(44);
        }
        if (toRemoveElements == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(45);
        }
        String declaredName = importPart.getDeclaredName();
        boolean fromDestinationModule = this.myDestinationModule.isEquivalentTo(ES6PsiUtil.findExternalModule((PsiElement)importPart));
        if (fromDestinationModule) {
            if (localDefinition != null && !StringUtil.equals((CharSequence)oldName, (CharSequence)declaredName)) {
                LocalSearchScope fileScope = new LocalSearchScope((PsiElement)this.myDestinationModule.getContainingFile());
                for (PsiReference reference : ReferencesSearch.search((PsiElement)localDefinition, (SearchScope)fileScope).findAll()) {
                    reference.bindToElement((PsiElement)newMember);
                }
            }
            toRemoveElements.add((PsiElement)importPart);
            return;
        }
        ES6ImportExportDeclaration declaration = importPart.getDeclaration();
        if (this.skipDeclaration(declaration)) {
            return;
        }
        ES6CreateImportUtil.insertImport((PsiElement)declaration, newMember, declaredName);
        toRemoveElements.add((PsiElement)importPart);
    }

    private boolean skipDeclaration(@Nullable ES6ImportExportDeclaration declaration) {
        if (declaration == null) {
            return true;
        }
        ES6FromClause clause = declaration.getFromClause();
        if (clause == null) {
            return false;
        }
        Collection elements = clause.resolveReferencedElements();
        return elements.size() != 0 && !elements.contains(this.mySourceModule);
    }

    private static void deletePsiElement(@NotNull PsiElement element) {
        if (element == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(46);
        }
        JSRefactoringUtil.deleteWithNoPostponedFormatting(element);
    }

    private void updateQualifiedUsage(@NotNull PsiReference reference, @NotNull JSQualifiedNamedElement newMember, @NotNull Map<PsiElement, String> updatedModules, @NotNull BiFunction<String, PsiElement, PsiElement> elementReplacementProducer) {
        boolean hasImportFromPrevUsage;
        List<PsiElement> elements;
        PsiElement refElement;
        PsiElement module;
        if (reference == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(47);
        }
        if (newMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(48);
        }
        if (updatedModules == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(49);
        }
        if (elementReplacementProducer == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(50);
        }
        if ((module = ES6PsiUtil.findExternalModule(refElement = reference.getElement())) == null) {
            return;
        }
        List<PsiElement> list2 = elements = reference instanceof PsiPolyVariantReference ? JSResolveResult.toElements(((PsiPolyVariantReference)reference).multiResolve(false)) : ContainerUtil.createMaybeSingletonList((Object)reference.resolve());
        if (elements.isEmpty()) {
            return;
        }
        for (PsiElement element : elements) {
            if (this.isInMovedElement(element)) continue;
            ES6MoveModuleMembersProcessor.throwErrorUpdateUsage(refElement);
        }
        String name = newMember.getName();
        if (name == null) {
            ES6MoveModuleMembersProcessor.throwErrorUpdateUsage(refElement);
        }
        boolean isDestinationModule = this.myDestinationModule.isEquivalentTo(module);
        String updatedName = updatedModules.get(module);
        boolean bl = hasImportFromPrevUsage = updatedName != null;
        if (!isDestinationModule) {
            if (updatedName == null) {
                PsiElement element = JSStubBasedPsiTreeUtil.resolveLocally(name, module, false);
                if (element != null) {
                    name = JSNameSuggestionsUtil.ensureUniqueVariableName(name, module, ContainerUtil.newArrayList((Object[])new String[]{name}), false);
                }
            } else {
                name = updatedName;
            }
        }
        PsiElement newElement = elementReplacementProducer.apply(name, refElement);
        if (!isDestinationModule && !hasImportFromPrevUsage) {
            ES6CreateImportUtil.insertImport(newElement, newMember, name);
            updatedModules.put(module, name);
        }
    }

    private static void addExportModifier(@NotNull JSAttributeListOwner attributeListOwner) {
        if (attributeListOwner == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(51);
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper(attributeListOwner);
        wrapper.overrideModifier(JSAttributeList.ModifierType.EXPORT, true);
        wrapper.applyTo(attributeListOwner);
    }

    private static void throwErrorUpdateUsage(@NotNull PsiElement reference) {
        if (reference == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(52);
        }
        throw new IncorrectOperationException("Cannot update usage " + reference.getText() + " from " + reference.getContainingFile().getVirtualFile().getPath());
    }

    private void updateReferenceExpressionUsage(@NotNull JSReferenceExpression reference, @NotNull JSQualifiedNamedElement newMember, @NotNull List<PsiElement> toRemoveElements, @NotNull Map<PsiElement, String> updatedModules) {
        if (reference == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(53);
        }
        if (newMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(54);
        }
        if (toRemoveElements == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(55);
        }
        if (updatedModules == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(56);
        }
        if (reference.getQualifier() != null) {
            this.updateQualifiedUsage((PsiReference)reference, newMember, updatedModules, (newName, element) -> element.replace((PsiElement)JSPsiElementFactory.createJSExpression(newName, element)));
            return;
        }
        this.updateUnqualifiedReferenceUsage((PsiReference)reference, newMember, toRemoveElements);
    }

    private void updateUnqualifiedReferenceUsage(@NotNull PsiReference reference, @NotNull JSQualifiedNamedElement newMember, @NotNull List<PsiElement> toRemoveElements) {
        PsiElement refElement;
        PsiElement module;
        if (reference == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(57);
        }
        if (newMember == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(58);
        }
        if (toRemoveElements == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(59);
        }
        if ((module = ES6PsiUtil.findExternalModule(refElement = reference.getElement())) == null) {
            module = refElement.getContainingFile();
        }
        if (this.mySourceModule.isEquivalentTo(module)) {
            String name = newMember.getName();
            if (name == null) {
                return;
            }
            PsiElement parent = refElement.getParent();
            if (parent instanceof ES6ExportDefaultAssignment) {
                ES6CreateImportUtil.insertExportName(ES6ImportPsiUtil.ImportExportType.DEFAULT, name, name, this.getDestinationPlace());
                toRemoveElements.add(parent);
            } else {
                ES6CreateImportUtil.insertImport(this.mySourceModule.getFirstChild(), newMember, name);
            }
        }
    }

    @NotNull
    private Collection<ES6ImportExportDeclaration> getSourceModuleImportOrExportReferences() {
        ArrayList<ES6ImportExportDeclaration> result2 = new ArrayList<ES6ImportExportDeclaration>();
        ReferencesSearch.search((PsiElement)this.mySourceModule, (SearchScope)this.mySourceModule.getUseScope()).forEach(el -> {
            PsiElement parent;
            PsiElement element = el.getElement();
            if (element instanceof ES6FromClause && (parent = element.getParent()) instanceof ES6ImportExportDeclaration) {
                result2.add((ES6ImportExportDeclaration)parent);
            }
            return true;
        });
        ArrayList<ES6ImportExportDeclaration> arrayList = result2;
        if (arrayList == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(60);
        }
        return arrayList;
    }

    @NotNull
    private List<ES6ExportDeclaration> getDestinationModuleNamespaceExportReferences() {
        ArrayList<ES6ExportDeclaration> result2 = new ArrayList<ES6ExportDeclaration>();
        ReferencesSearch.search((PsiElement)this.myDestinationModule, (SearchScope)this.myDestinationModule.getUseScope()).forEach(el -> {
            PsiElement parent;
            PsiElement element = el.getElement();
            if (element instanceof ES6FromClause && (parent = element.getParent()) instanceof ES6ExportDeclaration && ((ES6ExportDeclaration)parent).isExportAll()) {
                result2.add((ES6ExportDeclaration)parent);
            }
        });
        ArrayList<ES6ExportDeclaration> arrayList = result2;
        if (arrayList == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(61);
        }
        return arrayList;
    }

    @NotNull
    private static MultiMap<PsiElement, UsageInfo> splitUsagesByElements(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(62);
        }
        MultiMap result2 = MultiMap.create();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof MoveRenameUsageInfo)) continue;
            result2.putValue((Object)((MoveRenameUsageInfo)usage).getReferencedElement(), (Object)usage);
        }
        MultiMap multiMap = result2;
        if (multiMap == null) {
            ES6MoveModuleMembersProcessor.$$$reportNull$$$0(63);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 19: 
            case 36: 
            case 60: 
            case 61: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 19: 
            case 36: 
            case 60: 
            case 61: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationModule";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceModuleOrFile";
                break;
            }
            case 3: 
            case 7: 
            case 14: 
            case 15: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 19: 
            case 36: 
            case 60: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 13: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 20: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPart";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToUsages";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postponedFormatters";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementUsages";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedRange";
                break;
            }
            case 27: 
            case 30: 
            case 34: 
            case 38: 
            case 41: 
            case 44: 
            case 48: 
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMember";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingModule";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 31: 
            case 35: 
            case 39: 
            case 42: 
            case 45: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemoveElements";
                break;
            }
            case 32: 
            case 49: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updatedModules";
                break;
            }
            case 33: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 47: 
            case 52: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementReplacementProducer";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeListOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflicts";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDestinationPlace";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceModuleImportOrExportReferences";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getDestinationModuleNamespaceExportReferences";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "splitUsagesByElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 19: 
            case 36: 
            case 60: 
            case 61: 
            case 63: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConflicts";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateChangedLanguage";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "errorCountChanged";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getErrorsCount";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isInMovedElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertToTSXIfNeeded";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createPointer";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isFromPartEqualsSource";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "moveElementsAndUpdateUsages";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getInsertionAnchor";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "moveElement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateExportAllDeclarations";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "containsDestinationModuleNamespaceExport";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "updateUsage";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateExportSpecifier";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "updateImportedBinding";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "updateImportSpecifier";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "updateImportPart";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "deletePsiElement";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "updateQualifiedUsage";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addExportModifier";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "throwErrorUpdateUsage";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "updateReferenceExpressionUsage";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "updateUnqualifiedReferenceUsage";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "splitUsagesByElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 19: 
            case 36: 
            case 60: 
            case 61: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

