/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.arrangement;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.arrangement.JSArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSElementArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSSectionArrangementEntry;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSectionDetector;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSectionRuleAwareSettings;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSRearrangerBase
implements Rearranger<JSArrangementEntry>,
ArrangementStandardSettingsAware,
ArrangementSectionRuleAwareSettings {
    private static final Logger LOG = Logger.getInstance((String)JSRearrangerBase.class.getName());
    public static boolean dumpArrangementEntries = false;

    @Nullable
    public Pair<JSArrangementEntry, List<JSArrangementEntry>> parseWithNew(@NotNull PsiElement root, @Nullable Document document2, @NotNull Collection<TextRange> ranges, @NotNull PsiElement element, @NotNull ArrangementSettings settings) {
        if (root == null) {
            JSRearrangerBase.$$$reportNull$$$0(0);
        }
        if (ranges == null) {
            JSRearrangerBase.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSRearrangerBase.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            JSRearrangerBase.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(root instanceof JSClass, (Object)String.format("Expected instance of JSClass but was %s", root.getClass().getName()));
        List<JSArrangementEntry> newEntries = this.processPsiElement(element, document2, Collections.singletonList(element.getTextRange()), settings);
        JSArrangementEntry newEntry = (JSArrangementEntry)ContainerUtil.getFirstItem(newEntries);
        if (newEntry == null) {
            return null;
        }
        return Pair.create((Object)newEntry, this.processPsiElement(root, document2, ranges, settings));
    }

    @NotNull
    public List<JSArrangementEntry> parse(@NotNull PsiElement root, @Nullable Document document2, @NotNull Collection<TextRange> ranges, @NotNull ArrangementSettings settings) {
        if (root == null) {
            JSRearrangerBase.$$$reportNull$$$0(4);
        }
        if (ranges == null) {
            JSRearrangerBase.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            JSRearrangerBase.$$$reportNull$$$0(6);
        }
        if (!(root instanceof JSFile) && !(root instanceof JSEmbeddedContent)) {
            List<JSArrangementEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                JSRearrangerBase.$$$reportNull$$$0(7);
            }
            return list2;
        }
        return this.processPsiElement(root, document2, ranges, settings);
    }

    @NotNull
    private List<JSArrangementEntry> processPsiElement(@NotNull PsiElement root, @Nullable Document document2, @NotNull Collection<TextRange> ranges, @NotNull ArrangementSettings settings) {
        if (root == null) {
            JSRearrangerBase.$$$reportNull$$$0(8);
        }
        if (ranges == null) {
            JSRearrangerBase.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            JSRearrangerBase.$$$reportNull$$$0(10);
        }
        if (!this.isAcceptableElement(root)) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSRearrangerBase.$$$reportNull$$$0(11);
            }
            return list2;
        }
        ArrangementInfo arrangementInfo = new ArrangementInfo(root.getLanguage(), ranges, document2, settings);
        root.accept((PsiElementVisitor)this.createVisitor(arrangementInfo));
        if (ApplicationManager.getApplication().isUnitTestMode() && dumpArrangementEntries) {
            JSRearrangerBase.dumpArrangementEntries(document2, arrangementInfo.getTopLevelEntries());
        }
        List<JSArrangementEntry> list3 = arrangementInfo.getTopLevelEntries();
        if (list3 == null) {
            JSRearrangerBase.$$$reportNull$$$0(12);
        }
        return list3;
    }

    protected boolean isAcceptableElement(@NotNull PsiElement element) {
        if (element == null) {
            JSRearrangerBase.$$$reportNull$$$0(13);
        }
        return true;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return Collections.singletonList(new CompositeArrangementSettingsToken(StdArrangementTokens.Grouping.GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER));
    }

    public boolean isEnabled(@NotNull ArrangementSettingsToken token, @Nullable ArrangementMatchCondition current) {
        if (token == null) {
            JSRearrangerBase.$$$reportNull$$$0(14);
        }
        if (current == null) {
            return true;
        }
        ArrangementSettingsToken type = ArrangementUtil.parseType((ArrangementMatchCondition)current);
        Map currentTokens = ArrangementUtil.extractTokens((ArrangementMatchCondition)current);
        if (StdArrangementTokens.Regexp.NAME.equals((Object)token) || StdArrangementTokens.Order.KEEP.equals((Object)token) || StdArrangementTokens.Order.BY_NAME.equals((Object)token)) {
            return type != StdArrangementTokens.EntryType.CONSTRUCTOR && type != StdArrangementTokens.EntryType.STATIC_INIT;
        }
        if (type == null) {
            return true;
        }
        if (currentTokens.containsKey(StdArrangementTokens.Modifier.OVERRIDDEN)) {
            return token == StdArrangementTokens.EntryType.FIELD || token == StdArrangementTokens.EntryType.METHOD || token == StdArrangementTokens.EntryType.PROPERTY || token == StdArrangementTokens.Modifier.OVERRIDDEN;
        }
        if (ContainerUtil.or(currentTokens.keySet(), currentToken -> this.getVisibilityModifiers().contains(currentToken)) && token == StdArrangementTokens.Modifier.OVERRIDDEN) {
            return false;
        }
        if (this.getSupportedTypes().contains(token)) {
            return true;
        }
        return this.isModifierEnabled(token, type, currentTokens.keySet());
    }

    @NotNull
    public Collection<Set<ArrangementSettingsToken>> getMutexes() {
        ArrayList<Set<ArrangementSettingsToken>> result2 = new ArrayList<Set<ArrangementSettingsToken>>();
        result2.add(this.getSupportedTypes());
        LinkedHashSet<ArrangementSettingsToken> exclusiveModifiers = new LinkedHashSet<ArrangementSettingsToken>(this.getVisibilityModifiers());
        exclusiveModifiers.add(StdArrangementTokens.Modifier.OVERRIDDEN);
        result2.add(exclusiveModifiers);
        ArrayList<Set<ArrangementSettingsToken>> arrayList = result2;
        if (arrayList == null) {
            JSRearrangerBase.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedMatchingTokens() {
        return ContainerUtil.newArrayList((Object[])new CompositeArrangementSettingsToken[]{new CompositeArrangementSettingsToken(StdArrangementTokens.General.TYPE, this.getSupportedTypes()), new CompositeArrangementSettingsToken(StdArrangementTokens.General.MODIFIER, this.getSupportedModifiers()), new CompositeArrangementSettingsToken((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME), new CompositeArrangementSettingsToken(StdArrangementTokens.General.ORDER, new ArrangementSettingsToken[]{StdArrangementTokens.Order.KEEP, StdArrangementTokens.Order.BY_NAME})});
    }

    @NotNull
    protected Visitor createVisitor(@NotNull ArrangementInfo arrangementInfo) {
        if (arrangementInfo == null) {
            JSRearrangerBase.$$$reportNull$$$0(16);
        }
        return new Visitor(arrangementInfo);
    }

    protected void postprocessClassMembers(@NotNull JSClass jsClass, @NotNull ClassArrangementInfo classArrangementInfo, @NotNull ArrangementInfo arrangementInfo) {
        if (jsClass == null) {
            JSRearrangerBase.$$$reportNull$$$0(17);
        }
        if (classArrangementInfo == null) {
            JSRearrangerBase.$$$reportNull$$$0(18);
        }
        if (arrangementInfo == null) {
            JSRearrangerBase.$$$reportNull$$$0(19);
        }
        for (Map.Entry<JSNamedElement, JSElementArrangementEntry> mapEntry : classArrangementInfo.methodToEntry.entrySet()) {
            JSNamedElement function2 = mapEntry.getKey();
            String name = function2.getName();
            if (!(function2 instanceof JSFunction) || !((JSFunction)function2).isSetProperty() || name == null) continue;
            JSElementArrangementEntry setterEntry = mapEntry.getValue();
            JSFunction getter = jsClass.findFunctionByNameAndKind(name, JSFunction.FunctionKind.GETTER);
            JSElementArrangementEntry getterEntry = classArrangementInfo.methodToEntry.get(getter);
            if (getterEntry == null) continue;
            setterEntry.addDependency((ArrangementEntry)getterEntry);
        }
        if (JSRearrangerBase.hasGroupingRule(arrangementInfo.getSettings(), StdArrangementTokens.Grouping.GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER)) {
            JSCodeStyleSettings codeStyleSettings = JSCodeStyleSettings.getSettings((PsiElement)jsClass);
            for (Map.Entry<JSField, JSElementArrangementEntry> mapEntry : classArrangementInfo.fieldToEntry.entrySet()) {
                JSElementArrangementEntry propertyEntry;
                JSField jsVar = mapEntry.getKey();
                JSElementArrangementEntry varEntry = mapEntry.getValue();
                if (jsVar.isConst() || !StringUtil.startsWith((CharSequence)StringUtil.notNullize((String)jsVar.getName()), (CharSequence)codeStyleSettings.FIELD_PREFIX)) continue;
                String propertyName = JSRefactoringUtil.transformVarNameToAccessorName(jsVar.getName(), (PsiElement)jsClass);
                JSFunction getterOrSetter = jsClass.findFunctionByNameAndKind(propertyName, JSFunction.FunctionKind.GETTER);
                if (getterOrSetter == null) {
                    getterOrSetter = jsClass.findFunctionByNameAndKind(propertyName, JSFunction.FunctionKind.SETTER);
                }
                if ((propertyEntry = getterOrSetter == null ? null : classArrangementInfo.methodToEntry.get(getterOrSetter)) == null || propertyEntry.getType() == null) continue;
                varEntry.setType(propertyEntry.getType());
                varEntry.setModifiers(propertyEntry.getModifiers());
                propertyEntry.addDependency((ArrangementEntry)varEntry);
            }
        }
    }

    @NotNull
    protected ArrangementSettingsToken detectFieldType(@NotNull ArrangementSettings settings, @NotNull JSVariable variable) {
        if (settings == null) {
            JSRearrangerBase.$$$reportNull$$$0(20);
        }
        if (variable == null) {
            JSRearrangerBase.$$$reportNull$$$0(21);
        }
        ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.FIELD;
        if (arrangementSettingsToken == null) {
            JSRearrangerBase.$$$reportNull$$$0(22);
        }
        return arrangementSettingsToken;
    }

    protected abstract boolean isModifierEnabled(@NotNull ArrangementSettingsToken var1, @NotNull ArrangementSettingsToken var2, @NotNull Set<ArrangementSettingsToken> var3);

    @NotNull
    protected ArrangementSettingsToken detectFunctionType(@NotNull JSFunction function2) {
        if (function2 == null) {
            JSRearrangerBase.$$$reportNull$$$0(23);
        }
        if (function2.isConstructor()) {
            ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.CONSTRUCTOR;
            if (arrangementSettingsToken == null) {
                JSRearrangerBase.$$$reportNull$$$0(24);
            }
            return arrangementSettingsToken;
        }
        if (function2.isGetProperty()) {
            ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.PROPERTY;
            if (arrangementSettingsToken == null) {
                JSRearrangerBase.$$$reportNull$$$0(25);
            }
            return arrangementSettingsToken;
        }
        if (function2.isSetProperty()) {
            ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.PROPERTY;
            if (arrangementSettingsToken == null) {
                JSRearrangerBase.$$$reportNull$$$0(26);
            }
            return arrangementSettingsToken;
        }
        ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.METHOD;
        if (arrangementSettingsToken == null) {
            JSRearrangerBase.$$$reportNull$$$0(27);
        }
        return arrangementSettingsToken;
    }

    @NotNull
    protected abstract Set<ArrangementSettingsToken> detectModifiers(@NotNull JSAttributeListOwner var1);

    protected List<OverrideInfo> detectOverrides(@NotNull JSQualifiedNamedElement member) {
        if (member == null) {
            JSRearrangerBase.$$$reportNull$$$0(28);
        }
        return ContainerUtil.emptyList();
    }

    @NotNull
    protected abstract Set<ArrangementSettingsToken> getSupportedTypes();

    @NotNull
    protected abstract Set<ArrangementSettingsToken> getVisibilityModifiers();

    @NotNull
    protected abstract Set<ArrangementSettingsToken> getSupportedModifiers();

    @NotNull
    public ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition) throws IllegalArgumentException {
        if (condition == null) {
            JSRearrangerBase.$$$reportNull$$$0(29);
        }
        throw new IllegalArgumentException("Can't build a matcher for condition " + condition);
    }

    private static <T extends ArrangementEntry> void dumpArrangementEntries(@Nullable Document document2, List<T> entries) {
        StringBuilder builder = new StringBuilder();
        JSRearrangerBase.dumpArrangementEntries(document2, entries, 0, builder);
        LOG.debug(builder.toString());
    }

    private static <T extends ArrangementEntry> void dumpArrangementEntries(@Nullable Document document2, List<T> entries, int level, StringBuilder stringBuilder) {
        for (ArrangementEntry entry : entries) {
            stringBuilder.append(StringUtil.repeat((String)"\t", (int)level)).append(entry.toString()).append("\n").append(document2 != null ? document2.getText(TextRange.create((int)entry.getStartOffset(), (int)entry.getEndOffset())) + "\n" : "");
            JSRearrangerBase.dumpArrangementEntries(document2, entry.getChildren(), level + 1, stringBuilder);
        }
    }

    protected static boolean hasGroupingRule(@NotNull ArrangementSettings settings, @NotNull ArrangementSettingsToken token) {
        if (settings == null) {
            JSRearrangerBase.$$$reportNull$$$0(30);
        }
        if (token == null) {
            JSRearrangerBase.$$$reportNull$$$0(31);
        }
        return JSRearrangerBase.findGroupingRule(settings, token) != null;
    }

    @Nullable
    protected static ArrangementGroupingRule findGroupingRule(@NotNull ArrangementSettings settings, @NotNull ArrangementSettingsToken token) {
        if (settings == null) {
            JSRearrangerBase.$$$reportNull$$$0(32);
        }
        if (token == null) {
            JSRearrangerBase.$$$reportNull$$$0(33);
        }
        return (ArrangementGroupingRule)ContainerUtil.find((Iterable)settings.getGroupings(), rule -> rule.getGroupingType() == token);
    }

    protected static void addRule(List<? super StdArrangementMatchRule> rules, ArrangementSettingsToken ... conditions) {
        if (conditions == null) {
            JSRearrangerBase.$$$reportNull$$$0(34);
        }
        if (conditions.length == 1) {
            rules.add((StdArrangementMatchRule)new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)new ArrangementAtomMatchCondition(conditions[0]))));
            return;
        }
        ArrangementCompositeMatchCondition composite = new ArrangementCompositeMatchCondition();
        for (ArrangementSettingsToken condition : conditions) {
            composite.addOperand((ArrangementMatchCondition)new ArrangementAtomMatchCondition(condition));
        }
        rules.add((StdArrangementMatchRule)new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)composite)));
    }

    private static boolean isWithinBounds(@NotNull TextRange range, @NotNull Collection<TextRange> ranges) {
        if (range == null) {
            JSRearrangerBase.$$$reportNull$$$0(35);
        }
        if (ranges == null) {
            JSRearrangerBase.$$$reportNull$$$0(36);
        }
        return ContainerUtil.or(ranges, range1 -> range1.intersects(range));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 20: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/arrangement/JSRearrangerBase";
                break;
            }
            case 14: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrangementInfo";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classArrangementInfo";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/arrangement/JSRearrangerBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "processPsiElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutexes";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFieldType";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFunctionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseWithNew";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processPsiElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "postprocessClassMembers";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "detectFieldType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "detectFunctionType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "detectOverrides";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "buildMatcher";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "hasGroupingRule";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findGroupingRule";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addRule";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isWithinBounds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class OverrideInfo {
        @NotNull
        public final JSPsiElementBase superMember;
        @NotNull
        public final JSQualifiedNamedElement member;

        public OverrideInfo(@NotNull JSQualifiedNamedElement member, @NotNull JSPsiElementBase superMember) {
            if (member == null) {
                OverrideInfo.$$$reportNull$$$0(0);
            }
            if (superMember == null) {
                OverrideInfo.$$$reportNull$$$0(1);
            }
            this.superMember = superMember;
            this.member = member;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "member";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "superMember";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/arrangement/JSRearrangerBase$OverrideInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class ArrangementInfo {
        private final Collection<TextRange> allowedRanges;
        private final Document document;
        private final ArrangementSettings mySettings;
        private final Stack<JSElementArrangementEntry> stack;
        private final Set<PsiComment> mySectionComments;
        private final List<JSArrangementEntry> topLevelEntries;
        private final ArrangementSectionDetector mySectionDetector;
        private final Language myLanguage;

        public ArrangementInfo(@NotNull Language language, @NotNull Collection<TextRange> allowedRanges, @Nullable Document document2, @NotNull ArrangementSettings settings) {
            if (language == null) {
                ArrangementInfo.$$$reportNull$$$0(0);
            }
            if (allowedRanges == null) {
                ArrangementInfo.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                ArrangementInfo.$$$reportNull$$$0(2);
            }
            this.mySectionComments = new HashSet<PsiComment>();
            this.topLevelEntries = new ArrayList<JSArrangementEntry>();
            this.allowedRanges = allowedRanges;
            this.document = document2;
            this.mySettings = settings;
            this.stack = new Stack();
            this.myLanguage = language;
            this.mySectionDetector = new ArrangementSectionDetector(this.document, this.mySettings, data -> {
                JSElementArrangementEntry parent = this.getCurrentEntry();
                this.addEntry(parent, new JSSectionArrangementEntry((ArrangementEntry)parent, this.myLanguage, data.getTextRange(), data.getToken(), data.getText()));
            });
        }

        public <T extends JSElement> void processWithCurrentEntry(@NotNull JSElementArrangementEntry entry, @NotNull T element, @NotNull Consumer<T> consumer) {
            if (entry == null) {
                ArrangementInfo.$$$reportNull$$$0(3);
            }
            if (element == null) {
                ArrangementInfo.$$$reportNull$$$0(4);
            }
            if (consumer == null) {
                ArrangementInfo.$$$reportNull$$$0(5);
            }
            this.stack.push(entry);
            consumer.consume(element);
            this.stack.pop();
        }

        @NotNull
        public List<JSArrangementEntry> getTopLevelEntries() {
            List<JSArrangementEntry> list2 = this.topLevelEntries;
            if (list2 == null) {
                ArrangementInfo.$$$reportNull$$$0(6);
            }
            return list2;
        }

        @NotNull
        public ArrangementSettings getSettings() {
            ArrangementSettings arrangementSettings = this.mySettings;
            if (arrangementSettings == null) {
                ArrangementInfo.$$$reportNull$$$0(7);
            }
            return arrangementSettings;
        }

        @Nullable
        public JSElementArrangementEntry addEntryFromPsi(@NotNull JSElement element, @NotNull ArrangementSettingsToken type, @NotNull Set<ArrangementSettingsToken> modifiers, @Nullable String name) {
            if (element == null) {
                ArrangementInfo.$$$reportNull$$$0(8);
            }
            if (type == null) {
                ArrangementInfo.$$$reportNull$$$0(9);
            }
            if (modifiers == null) {
                ArrangementInfo.$$$reportNull$$$0(10);
            }
            return this.addEntryFromRange((PsiElement)element, (PsiElement)element, type, modifiers, name);
        }

        @Nullable
        public JSElementArrangementEntry addContainerEntry(@NotNull JSNamedElement element, @NotNull ArrangementSettingsToken type) {
            if (element == null) {
                ArrangementInfo.$$$reportNull$$$0(11);
            }
            if (type == null) {
                ArrangementInfo.$$$reportNull$$$0(12);
            }
            return this.addEntryFromRange((PsiElement)element, (PsiElement)element, ContainerUtil.set((Object[])new ArrangementSettingsToken[]{type}), Collections.emptySet(), element.getName(), false);
        }

        @Nullable
        public JSElementArrangementEntry addEntryFromRange(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull ArrangementSettingsToken type, @NotNull Set<ArrangementSettingsToken> modifiers, @Nullable String name) {
            if (startElement == null) {
                ArrangementInfo.$$$reportNull$$$0(13);
            }
            if (endElement == null) {
                ArrangementInfo.$$$reportNull$$$0(14);
            }
            if (type == null) {
                ArrangementInfo.$$$reportNull$$$0(15);
            }
            if (modifiers == null) {
                ArrangementInfo.$$$reportNull$$$0(16);
            }
            return this.addEntryFromRange(startElement, endElement, ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{type}), modifiers, name, true);
        }

        @Nullable
        private JSElementArrangementEntry addEntryFromRange(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull Set<ArrangementSettingsToken> types2, @NotNull Set<ArrangementSettingsToken> modifiers, @Nullable String name, boolean canBeMatched) {
            if (startElement == null) {
                ArrangementInfo.$$$reportNull$$$0(17);
            }
            if (endElement == null) {
                ArrangementInfo.$$$reportNull$$$0(18);
            }
            if (types2 == null) {
                ArrangementInfo.$$$reportNull$$$0(19);
            }
            if (modifiers == null) {
                ArrangementInfo.$$$reportNull$$$0(20);
            }
            PsiComment leadingComment = this.processSectionComment(JSPsiImplUtils.findLeadingComment(startElement));
            PsiComment trailingComment = this.processSectionComment(JSPsiImplUtils.findTrailingEndOfLineComment(endElement));
            TextRange textRange = new TextRange(leadingComment != null ? leadingComment.getTextRange().getStartOffset() : startElement.getTextRange().getStartOffset(), trailingComment != null ? trailingComment.getTextRange().getEndOffset() : endElement.getTextRange().getEndOffset());
            TextRange range = this.document == null ? textRange : ArrangementUtil.expandToLineIfPossible((TextRange)textRange, (Document)this.document);
            JSElementArrangementEntry parent = this.getCurrentEntry();
            return this.addEntry(parent, new JSElementArrangementEntry((ArrangementEntry)parent, this.myLanguage, name, types2, modifiers, range, canBeMatched));
        }

        @Nullable
        public PsiComment processSectionComment(@Nullable PsiComment comment) {
            if (comment == null || this.mySectionComments.contains(comment)) {
                return null;
            }
            if (this.mySectionDetector.processComment(comment)) {
                this.mySectionComments.add(comment);
                return null;
            }
            return comment;
        }

        @Nullable
        public <T extends JSArrangementEntry> T addEntry(@Nullable JSElementArrangementEntry parent, @NotNull T entry) {
            if (entry == null) {
                ArrangementInfo.$$$reportNull$$$0(21);
            }
            if (!JSRearrangerBase.isWithinBounds(new TextRange(entry.getStartOffset(), entry.getEndOffset()), this.allowedRanges)) {
                return null;
            }
            if (parent != null) {
                parent.addChild((ArrangementEntry)entry);
            } else {
                this.topLevelEntries.add(entry);
            }
            return entry;
        }

        @Nullable
        private JSElementArrangementEntry getCurrentEntry() {
            return this.stack.isEmpty() ? null : this.stack.peek();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allowedRanges";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: 
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 4: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo";
                    break;
                }
                case 9: 
                case 12: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 10: 
                case 16: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiers";
                    break;
                }
                case 13: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 14: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTopLevelEntries";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "processWithCurrentEntry";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addEntryFromPsi";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "addContainerEntry";
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "addEntryFromRange";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "addEntry";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class ClassArrangementInfo {
        @NotNull
        public final Map<JSField, JSElementArrangementEntry> fieldToEntry = new LinkedHashMap<JSField, JSElementArrangementEntry>();
        @NotNull
        public final Map<JSNamedElement, JSElementArrangementEntry> methodToEntry = new THashMap();
        @NotNull
        public final MultiMap<JSClass, OverrideInfo> overrides = new MultiMap();

        protected ClassArrangementInfo() {
        }

        public void registerOverridden(@NotNull List<OverrideInfo> overrideInfos) {
            if (overrideInfos == null) {
                ClassArrangementInfo.$$$reportNull$$$0(0);
            }
            for (OverrideInfo info : overrideInfos) {
                JSClass superClass = JSUtils.getMemberContainingClass((PsiElement)info.superMember);
                if (superClass == null) continue;
                this.overrides.putValue((Object)superClass, (Object)info);
            }
        }

        @NotNull
        public Map<JSNamedElement, JSElementArrangementEntry> getMemberEntries() {
            Map map = ContainerUtil.union(this.fieldToEntry, this.methodToEntry);
            if (map == null) {
                ClassArrangementInfo.$$$reportNull$$$0(1);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "overrideInfos";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ClassArrangementInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ClassArrangementInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "registerOverridden";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected class Visitor
    extends JSRecursiveElementVisitor {
        protected ArrangementInfo myArrangementInfo;
        private ClassArrangementInfo myClassArrangementInfo;

        public Visitor(ArrangementInfo arrangementInfo) {
            this.myArrangementInfo = arrangementInfo;
        }

        public void visitJSClass(JSClass jsClass) {
            JSElementArrangementEntry classEntry = this.myArrangementInfo.addContainerEntry((JSNamedElement)jsClass, StdArrangementTokens.EntryType.CLASS);
            if (classEntry == null) {
                return;
            }
            ClassArrangementInfo previousClassInfo = this.myClassArrangementInfo;
            this.myClassArrangementInfo = new ClassArrangementInfo();
            this.visitWithCurrentEntry((JSElement)jsClass, classEntry);
            JSRearrangerBase.this.postprocessClassMembers(jsClass, this.myClassArrangementInfo, this.myArrangementInfo);
            this.myClassArrangementInfo = previousClassInfo;
        }

        public void visitJSVarStatement(JSVarStatement varStatement) {
            JSElementArrangementEntry entry;
            if (!this.isClassMember((JSElement)varStatement)) {
                super.visitJSVarStatement(varStatement);
                return;
            }
            JSVariable variable = (JSVariable)ArrayUtil.getFirstElement((Object[])varStatement.getVariables());
            if (variable == null) {
                return;
            }
            ArrangementSettingsToken type = JSRearrangerBase.this.detectFieldType(this.myArrangementInfo.getSettings(), variable);
            Set<ArrangementSettingsToken> modifiers = JSRearrangerBase.this.detectModifiers((JSAttributeListOwner)variable);
            List<OverrideInfo> overrides = JSRearrangerBase.this.detectOverrides((JSQualifiedNamedElement)variable);
            if (!overrides.isEmpty()) {
                modifiers.add(StdArrangementTokens.Modifier.OVERRIDDEN);
                this.myClassArrangementInfo.registerOverridden(overrides);
            }
            if ((entry = this.myArrangementInfo.addEntryFromPsi((JSElement)varStatement, type, modifiers, variable.getName())) != null) {
                this.visitWithCurrentEntry((JSElement)varStatement, entry);
                JSVariable[] variables = varStatement.getVariables();
                if (variables.length == 1 && this.myClassArrangementInfo != null && variables[0] instanceof JSField) {
                    this.myClassArrangementInfo.fieldToEntry.put((JSField)variables[0], entry);
                }
            }
        }

        public void visitJSFunctionDeclaration(JSFunction function2) {
            JSElementArrangementEntry entry;
            if (!this.isClassMember((JSElement)function2)) {
                super.visitJSFunctionDeclaration(function2);
                return;
            }
            List<OverrideInfo> overrides = JSRearrangerBase.this.detectOverrides((JSQualifiedNamedElement)function2);
            Set<ArrangementSettingsToken> modifiers = JSRearrangerBase.this.detectModifiers((JSAttributeListOwner)function2);
            if (!overrides.isEmpty()) {
                modifiers.add(StdArrangementTokens.Modifier.OVERRIDDEN);
                this.myClassArrangementInfo.registerOverridden(overrides);
            }
            if ((entry = this.myArrangementInfo.addEntryFromPsi((JSElement)function2, JSRearrangerBase.this.detectFunctionType(function2), modifiers, function2.getName())) != null && this.myClassArrangementInfo != null) {
                this.myClassArrangementInfo.methodToEntry.put((JSNamedElement)function2, entry);
                this.visitWithCurrentEntry((JSElement)function2, entry);
            }
        }

        public void visitJSBlock(JSBlockStatement initializer) {
            if (!this.isClassMember((JSElement)initializer)) {
                super.visitJSBlock(initializer);
                return;
            }
            JSElementArrangementEntry entry = this.myArrangementInfo.addEntryFromPsi((JSElement)initializer, StdArrangementTokens.EntryType.STATIC_INIT, Collections.emptySet(), null);
            if (entry != null) {
                this.visitWithCurrentEntry((JSElement)initializer, entry);
            }
        }

        public void visitComment(@NotNull PsiComment comment) {
            if (comment == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            this.myArrangementInfo.processSectionComment(comment);
        }

        private boolean isClassMember(@NotNull JSElement element) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            return element.getParent() instanceof JSClass;
        }

        protected void visitWithCurrentEntry(@NotNull JSElement varStatement, @NotNull JSElementArrangementEntry entry) {
            if (varStatement == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (entry == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            this.myArrangementInfo.processWithCurrentEntry(entry, varStatement, theEntry -> theEntry.acceptChildren((PsiElementVisitor)this));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varStatement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/arrangement/JSRearrangerBase$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitComment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isClassMember";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWithCurrentEntry";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

