/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class JSCodeCompletionConfigurable
implements Configurable {
    private static final int LEFT_GAP = 20;
    private static final int VERT_GAP = 2;
    private JBCheckBox myOnlyTypeBasedCompletion;
    private JBCheckBox myOptChainCompletion;
    private JBCheckBox myVarNamesCompletion;
    private JBCheckBox myVarNamesWithTypes;
    private JBCheckBox myFieldNames;
    private JBCheckBox myOverridesCompletion;

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return JavaScriptBundle.message((String)"configurable.JSCodeCompletionConfigurable.display.name", (Object[])new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        this.myOnlyTypeBasedCompletion = new JBCheckBox(JavaScriptBundle.message((String)"settings.javascript.only.type.based.completion", (Object[])new Object[0]));
        this.myOptChainCompletion = new JBCheckBox(JavaScriptBundle.message((String)"settings.javascript.opt.chain.completion", (Object[])new Object[0]));
        this.myVarNamesCompletion = new JBCheckBox(JavaScriptBundle.message((String)"settings.javascript.var.names.completion", (Object[])new Object[0]));
        this.myFieldNames = new JBCheckBox(JavaScriptBundle.message((String)"settings.javascript.field.names.completion", (Object[])new Object[0]));
        this.myVarNamesWithTypes = new JBCheckBox(JavaScriptBundle.message((String)"settings.javascript.var.names.completion.types", (Object[])new Object[0]));
        this.myVarNamesCompletion.addChangeListener(e -> {
            Object source = e.getSource();
            if (source instanceof JBCheckBox) {
                this.myVarNamesWithTypes.setEnabled(((JBCheckBox)source).isSelected());
            }
        });
        this.myOverridesCompletion = new JBCheckBox(JavaScriptBundle.message((String)"settings.javascript.overrides.completion", (Object[])new Object[0]));
        FormBuilder builder = FormBuilder.createFormBuilder().addLabeledComponent((JComponent)new JLabel(JavaScriptBundle.message((String)"javascript.language.simple.name", (Object[])new Object[0])), (JComponent)new JSeparator()).setFormLeftIndent(20).addVerticalGap(2);
        JSCodeCompletionConfigurable.addWithComment(builder, (JComponent)this.myOnlyTypeBasedCompletion, JavaScriptBundle.message((String)"settings.javascript.only.type.based.completion.tooltip", (Object[])new Object[0]));
        this.myOnlyTypeBasedCompletion.setSelected(JSApplicationSettings.getInstance().isOnlyTypeBasedCompletion());
        builder.addComponent((JComponent)this.myOptChainCompletion);
        this.myOptChainCompletion.setSelected(JSApplicationSettings.getInstance().isOptChainCompletion());
        builder.addComponent((JComponent)this.myOverridesCompletion).addVerticalGap(2);
        builder.addComponent((JComponent)new JLabel(JavaScriptBundle.message((String)"settings.javascript.var.names.completion.desc", (Object[])new Object[0]))).addVerticalGap(2).addComponent((JComponent)this.myVarNamesCompletion).addComponent((JComponent)this.myFieldNames).addComponent((JComponent)this.myVarNamesWithTypes);
        this.myVarNamesCompletion.setSelected(JSApplicationSettings.getInstance().isUseVarNamesCompletion());
        this.myFieldNames.setSelected(JSApplicationSettings.getInstance().isUseFieldNamesCompletion());
        this.setVariableCompletionKind(JSApplicationSettings.getInstance().getVariableCompletionKind());
        this.myOverridesCompletion.setSelected(JSApplicationSettings.getInstance().isUseOverridesCompletion());
        return builder.getPanel();
    }

    private static void addWithComment(FormBuilder builder, JComponent box, String s) {
        builder.addComponent((JComponent)new ComponentPanelBuilder(box).withComment(s).createPanel());
    }

    public boolean isModified() {
        return JSApplicationSettings.getInstance().isOnlyTypeBasedCompletion() != this.myOnlyTypeBasedCompletion.isSelected() || JSApplicationSettings.getInstance().isUseVarNamesCompletion() != this.myVarNamesCompletion.isSelected() || JSApplicationSettings.getInstance().isUseFieldNamesCompletion() != this.myFieldNames.isSelected() || JSApplicationSettings.getInstance().getVariableCompletionKind() != this.getVariableCompletionKind() || JSApplicationSettings.getInstance().isOptChainCompletion() != this.myOptChainCompletion.isSelected() || JSApplicationSettings.getInstance().isUseOverridesCompletion() != this.myOverridesCompletion.isSelected();
    }

    public void apply() throws ConfigurationException {
        JSApplicationSettings.getInstance().setOnlyTypeBasedCompletion(this.myOnlyTypeBasedCompletion.isSelected());
        JSApplicationSettings.getInstance().setUseVarNamesCompletion(this.myVarNamesCompletion.isSelected());
        JSApplicationSettings.getInstance().setUseFieldNamesCompletion(this.myFieldNames.isSelected());
        JSApplicationSettings.getInstance().setVariableCompletionKind(this.getVariableCompletionKind());
        JSApplicationSettings.getInstance().setUseOverridesCompletion(this.myOverridesCompletion.isSelected());
        JSApplicationSettings.getInstance().setOptChainCompletion(this.myOptChainCompletion.isSelected());
    }

    private JSApplicationSettings.VariableCompletionKind getVariableCompletionKind() {
        return this.myVarNamesWithTypes.isSelected() ? JSApplicationSettings.VariableCompletionKind.TYPES_FOR_PARAMS : JSApplicationSettings.VariableCompletionKind.NAMES_ONLY;
    }

    private void setVariableCompletionKind(JSApplicationSettings.VariableCompletionKind kind) {
        this.myVarNamesWithTypes.setSelected(kind != JSApplicationSettings.VariableCompletionKind.NAMES_ONLY);
    }
}

