/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportScope;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupElementInfo;
import com.intellij.lang.javascript.completion.JSLookupElementInfoImpl;
import com.intellij.lang.javascript.completion.JSLookupElementMerger;
import com.intellij.lang.javascript.completion.JSLookupElementRenderer;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.ES6DefaultAssignmentModuleIndex;
import com.intellij.lang.javascript.psi.stubs.ES6ExportedNamesIndex;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImportCompletionUtil {
    public static final JSLookupPriority IMPORT_PRIORITY = JSLookupPriority.LOWEST_PRIORITY;
    public static final InsertHandler<LookupElement> IMPORTS_POPUP_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            JSImportCompletionUtil.importForElement(context, item, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/completion/JSImportCompletionUtil$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public static void addExportedVariants(@NotNull JSReferenceExpression expression, @NotNull Collection<LookupElement> sinkResults, @NotNull CompletionResultSet completionResultSet) {
        if (expression == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(0);
        }
        if (sinkResults == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(1);
        }
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(2);
        }
        assert (expression.getQualifier() == null);
        JSImportCompletionUtil.addExportedVariants((PsiElement)expression, sinkResults, completionResultSet);
    }

    public static void addExportedVariants(@NotNull ES6ImportExportDeclarationPart specifier, @NotNull Collection<LookupElement> sinkResults, @NotNull CompletionResultSet completionResultSet) {
        if (specifier == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(3);
        }
        if (sinkResults == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(4);
        }
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(5);
        }
        JSImportCompletionUtil.addExportedVariants((PsiElement)specifier, sinkResults, completionResultSet);
    }

    private static void addExportedVariants(@NotNull PsiElement place, @NotNull Collection<LookupElement> localAndGlobalElements, @NotNull CompletionResultSet completionResultSet) {
        ImportContext importContext;
        JSImportPlaceInfo info;
        PrefixMatcher matcher;
        Set<String> localAndProcessedElements;
        AtomicInteger counter;
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(6);
        }
        if (localAndGlobalElements == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(7);
        }
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(8);
        }
        if (JSImportCompletionUtil.skipPlace(place)) {
            return;
        }
        int count = localAndGlobalElements.size();
        if (!JSImportCompletionUtil.checkLimit(completionResultSet, JSCompletionUtil.getCompletionLimit(), count)) {
            return;
        }
        PsiElement originalPlace = CompletionUtilCoreImpl.getOriginalElement((PsiElement)place);
        if (originalPlace != null) {
            place = originalPlace;
        }
        if (!JSImportCompletionUtil.processExportedES6Elements(place, completionResultSet, counter = new AtomicInteger(count), localAndProcessedElements = JSImportCompletionUtil.getLocalElementNames(localAndGlobalElements, place, matcher = completionResultSet.getPrefixMatcher()), info = new JSImportPlaceInfo(place), importContext = place instanceof ES6ImportSpecifier ? ImportContext.SPECIFIER : (place instanceof ES6ImportedBinding ? ImportContext.DEFAULT_BINDING : ImportContext.SIMPLE))) {
            return;
        }
        JSImportCompletionUtil.processExportedCommonJSElements(place, completionResultSet, counter, localAndProcessedElements, info, importContext);
    }

    private static void processExportedCommonJSElements(@NotNull PsiElement place, @NotNull CompletionResultSet completionResultSet, @NotNull AtomicInteger counter, @NotNull Set<String> localElements, @NotNull JSImportPlaceInfo info, @NotNull ImportContext importContext) {
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(9);
        }
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(10);
        }
        if (counter == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(11);
        }
        if (localElements == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(12);
        }
        if (info == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(13);
        }
        if (importContext == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(14);
        }
        if (importContext != ImportContext.SIMPLE || DialectDetector.isTypeScript(place)) {
            return;
        }
        PrefixMatcher matcher = completionResultSet.getPrefixMatcher();
        JSImportScope scope = new JSImportScope(place.getProject(), info.getFile(), JSResolveUtil.getResolveScope(place), JSFile.ModuleStatus.COMMONJS);
        Collection<JSPsiElementBase> elements = JSClassResolver.getInstance().findNamespaceMembers("exports", (GlobalSearchScope)scope, true);
        int limit = JSCompletionUtil.getCompletionLimit();
        HashSet<String> visited = new HashSet<String>();
        JSLookupElementMerger merger = new JSLookupElementMerger(place, (el, priority) -> true, limit, true);
        for (JSPsiElementBase element : elements) {
            ProgressManager.checkCanceled();
            String name = element.getName();
            if (localElements.contains(name) || name == null || !matcher.prefixMatches(name) || !visited.add(name) || !JSNamesValidation.isIdentifier(name, place)) continue;
            if (!JSImportCompletionUtil.checkLimit(completionResultSet, limit, counter.get())) {
                return;
            }
            if (!(element instanceof JSDefinitionExpression)) continue;
            PsiElement resolved = null;
            String reference = JSPsiImplUtils.getInitializerReference((JSInitializerOwner)((JSDefinitionExpression)element));
            if (reference != null) {
                resolved = JSStubBasedPsiTreeUtil.resolveLocally(reference, (PsiElement)element);
            } else {
                JSExpression expression = ((JSDefinitionExpression)element).getInitializerOrStub();
                if (expression instanceof JSObjectLiteralExpression || expression instanceof JSQualifiedNamedElement) {
                    resolved = expression;
                }
            }
            if (resolved == null) continue;
            counter.incrementAndGet();
            JSImportCompletionUtil.fillLookupItemForElements(completionResultSet, JSInsertHandler.DEFAULT, name, Collections.singleton(element), merger);
        }
    }

    private static boolean processExportedES6Elements(@NotNull PsiElement place, @NotNull CompletionResultSet completionResultSet, @NotNull AtomicInteger counter, @NotNull Set<String> localElements, @NotNull JSImportPlaceInfo info, @NotNull ImportContext importContext) {
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(15);
        }
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(16);
        }
        if (counter == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(17);
        }
        if (localElements == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(18);
        }
        if (info == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(19);
        }
        if (importContext == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(20);
        }
        int limit = JSCompletionUtil.getCompletionLimit();
        PsiFile containingFile = place.getContainingFile().getOriginalFile();
        Project project = place.getProject();
        PrefixMatcher prefixMatcher = completionResultSet.getPrefixMatcher();
        GlobalSearchScope scope = ES6CreateImportUtil.createSymbolToImportSearchScope(project, (PsiElement)containingFile);
        boolean skipNodeModulesImports = !DialectDetector.isTypeScript(place) && (!(containingFile instanceof JSFile) || ((JSFile)containingFile).getModuleStatus() != JSFile.ModuleStatus.ES6);
        boolean excludeNonLatin = JSImportCompletionUtil.isExcludeWithNonLatinFirstSymbol(completionResultSet);
        JSCompletionPlaceFilter completionPlaceFilter = JSCompletionPlaceFilter.forPlace(place);
        Predicate<String> keyFilter = el -> !el.isEmpty() && !localElements.contains(el) && prefixMatcher.prefixMatches(el) && (!excludeNonLatin || JSImportCompletionUtil.isLatin(el.charAt(0)));
        JSLookupElementMerger merger = new JSLookupElementMerger(place, (el, priority) -> el instanceof JSPsiElementBase && completionPlaceFilter.isAcceptable((JSPsiElementBase)el), limit, true);
        Predicate<PsiElement> placeFilter = key -> !(key instanceof JSPsiElementBase) || completionPlaceFilter.isAcceptable((JSPsiElementBase)key);
        return JSImportCompletionUtil.processExportedES6Elements(info, importContext, keyFilter, placeFilter, scope, (PairProcessor<Collection<JSElement>, String>)((PairProcessor)(elements, name) -> {
            localElements.add((String)name);
            InsertHandler<LookupElement> insertHandler = JSImportCompletionUtil.getImportInsertHandler(containingFile, elements, skipNodeModulesImports);
            JSImportCompletionUtil.fillLookupItemForElements(completionResultSet, insertHandler, name, elements, merger);
            counter.incrementAndGet();
            return JSImportCompletionUtil.checkLimit(completionResultSet, limit, counter.get());
        }));
    }

    public static boolean processExportedES6Elements(@NotNull JSImportPlaceInfo info, @NotNull ImportContext importContext, @NotNull Predicate<String> keyFilter, @NotNull Predicate<PsiElement> placeFilter, @NotNull GlobalSearchScope scope, @NotNull PairProcessor<Collection<JSElement>, String> processor) {
        if (info == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(21);
        }
        if (importContext == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(22);
        }
        if (keyFilter == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(23);
        }
        if (placeFilter == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(25);
        }
        if (processor == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(26);
        }
        Project project = info.getPlace().getProject();
        boolean isTypeScript = DialectDetector.isTypeScript(info.getPlace());
        Set namedKeys = StubIndex.getInstance().getAllKeys(ES6ExportedNamesIndex.KEY, project).stream().filter(keyFilter).collect(Collectors.toSet());
        ProgressManager.checkCanceled();
        Set defaultAssignmentKeys = importContext == ImportContext.SPECIFIER ? Collections.emptySet() : StubIndex.getInstance().getAllKeys(ES6DefaultAssignmentModuleIndex.KEY, project).stream().filter(keyFilter).collect(Collectors.toSet());
        List names = Stream.concat(namedKeys.stream(), defaultAssignmentKeys.stream()).sorted().collect(Collectors.toList());
        for (String name : names) {
            ProgressManager.checkCanceled();
            Collection elements = new HashSet();
            Predicate<JSElement> elementFilter = element -> JSImportCompletionUtil.isAcceptableForImport(info, importContext, element) && placeFilter.test((PsiElement)element);
            if (namedKeys.contains(name)) {
                StubIndex.getElements(ES6ExportedNamesIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, JSElement.class).stream().filter(elementFilter).forEach(elements::add);
            }
            ProgressManager.checkCanceled();
            if (defaultAssignmentKeys.contains(name)) {
                StubIndex.getElements(ES6DefaultAssignmentModuleIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, JSExportAssignment.class).stream().filter(elementFilter).forEach(elements::add);
            }
            ProgressManager.checkCanceled();
            if (!elements.isEmpty() && elements.stream().anyMatch(el -> JSImportCompletionUtil.needToCheckConfigAccess(el.getContainingFile(), isTypeScript))) {
                elements = (Collection)((StreamEx)StreamEx.of(elements).filter(el -> TypeScriptConfigService.Provider.isAccessible(project, info.getFile(), el.getContainingFile().getVirtualFile()))).collect(Collectors.toSet());
            }
            if (elements.isEmpty() || processor.process(elements, (Object)name)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static InsertHandler<LookupElement> getImportInsertHandler(@NotNull PsiFile containingFile, @NotNull Collection<JSElement> elements, boolean skipNodeModules) {
        if (containingFile == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(27);
        }
        if (elements == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(28);
        }
        if (containingFile instanceof JSExpressionCodeFragment) {
            InsertHandler<LookupElement> insertHandler = JSInsertHandler.DEFAULT;
            if (insertHandler == null) {
                JSImportCompletionUtil.$$$reportNull$$$0(29);
            }
            return insertHandler;
        }
        JSElement item = (JSElement)ContainerUtil.getFirstItem(elements);
        if (item == null) {
            InsertHandler<LookupElement> insertHandler = JSInsertHandler.DEFAULT;
            if (insertHandler == null) {
                JSImportCompletionUtil.$$$reportNull$$$0(30);
            }
            return insertHandler;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)item);
        if (skipNodeModules && file2 != null && NodeModuleUtil.hasNodeModulesDirInPath(file2, null)) {
            InsertHandler<LookupElement> insertHandler = JSInsertHandler.DEFAULT;
            if (insertHandler == null) {
                JSImportCompletionUtil.$$$reportNull$$$0(31);
            }
            return insertHandler;
        }
        JSElement toImport = JSLookupElementMerger.mergeOverloads(elements, item);
        return toImport == null ? IMPORTS_POPUP_INSERT_HANDLER : new ImportInsertHandler((PsiElement)toImport);
    }

    private static boolean isExcludeWithNonLatinFirstSymbol(@NotNull CompletionResultSet completionResultSet) {
        PrefixMatcher matcher;
        String prefix;
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(32);
        }
        if ((prefix = (matcher = completionResultSet.getPrefixMatcher()).getPrefix()).isEmpty()) {
            completionResultSet.restartCompletionOnAnyPrefixChange();
            return true;
        }
        return JSImportCompletionUtil.isLatin(prefix.charAt(0));
    }

    private static boolean checkLimit(@NotNull CompletionResultSet completionResultSet, int limit, int count) {
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(33);
        }
        if (count <= limit) {
            return true;
        }
        JSCompletionUtil.handleOverflow(completionResultSet);
        return false;
    }

    private static boolean needToCheckConfigAccess(@NotNull PsiFile file2, boolean isTypeScript) {
        if (file2 == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(34);
        }
        return isTypeScript && (!(file2 instanceof JSFile) || !((JSFile)file2).isCommonJSModule());
    }

    private static boolean isAcceptableForImport(@NotNull JSImportPlaceInfo info, @NotNull ImportContext importContext, @NotNull JSElement element) {
        JSElement container;
        if (info == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(35);
        }
        if (importContext == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(36);
        }
        if (element == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(37);
        }
        if ((container = ES6PsiUtil.getExportScope((PsiElement)element)) == info.getContainer()) {
            return false;
        }
        if (importContext == ImportContext.DEFAULT_BINDING) {
            if (element instanceof JSElementBase && ((JSElementBase)element).isExportedWithDefault()) {
                return true;
            }
            return element instanceof ES6ExportDefaultAssignment;
        }
        if (element instanceof ES6ExportSpecifier && !ES6CreateImportUtil.isAcceptableExportSpecifier((ES6ExportSpecifier)element)) {
            return false;
        }
        return element instanceof JSExportAssignment || (importContext == ImportContext.SPECIFIER ? ES6ImportHandler.isExternalModuleExport(element) : ES6CreateImportUtil.isAvailableForImport((PsiElement)element, info));
    }

    private static boolean skipPlace(@NotNull PsiElement place) {
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(38);
        }
        return TypeScriptPsiUtil.isTsIndexerType(place) || place.getContext() instanceof JSExportAssignment;
    }

    @NotNull
    public static Set<String> getLocalElementNames(@NotNull Collection<LookupElement> sinkResults, @NotNull PsiElement place, @NotNull PrefixMatcher matcher) {
        if (sinkResults == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(39);
        }
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(40);
        }
        if (matcher == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(41);
        }
        THashSet localElements = new THashSet();
        JSImportCompletionUtil.fillImportedElements(place, (Set<String>)localElements);
        PsiFile containingFile = place.getContainingFile();
        Set<VirtualFile> libraries = TypeScriptLibraryProvider.getAllLibraries(containingFile.getProject());
        for (LookupElement lookupElement : sinkResults) {
            PsiFile currentFile;
            PsiElement currentElement = lookupElement.getPsiElement();
            if (currentElement != null && (currentFile = currentElement.getContainingFile()) != null && currentFile.getOriginalFile() != containingFile) {
                double priority = JSCompletionUtil.getLookupElementPriority(lookupElement);
                if (libraries.contains(currentFile.getVirtualFile()) || (double)JSLookupPriority.SMART_MATCHED_PARAMETER_NAME.getPriorityValue() > priority) continue;
            }
            if (!matcher.prefixMatches(lookupElement)) continue;
            localElements.add((Object)lookupElement.getLookupString());
        }
        THashSet tHashSet = localElements;
        if (tHashSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(42);
        }
        return tHashSet;
    }

    private static void fillImportedElements(@NotNull PsiElement place, @NotNull Set<String> localElements) {
        if (place == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(43);
        }
        if (localElements == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(44);
        }
        JSElement scope = ES6PsiUtil.getExportScope(place);
        while (scope != null) {
            List<ES6ImportDeclaration> declarations = ES6ImportPsiUtil.getImportDeclarations((PsiElement)scope);
            for (ES6ImportDeclaration declaration : declarations) {
                String name;
                ES6ImportedBinding[] bindings;
                ES6ImportSpecifier[] specifiers = declaration.getImportSpecifiers();
                for (ES6ImportedBinding eS6ImportedBinding : bindings = declaration.getImportedBindings()) {
                    name = eS6ImportedBinding.getDeclaredName();
                    localElements.add(name);
                }
                for (ES6ImportedBinding eS6ImportedBinding : specifiers) {
                    name = eS6ImportedBinding.getDeclaredName();
                    localElements.add(name);
                }
            }
            if (scope instanceof PsiFile) break;
            scope = ES6PsiUtil.getExportScope((PsiElement)scope);
        }
    }

    private static void fillLookupItemForElements(@NotNull CompletionResultSet completionResultSet, @NotNull InsertHandler<LookupElement> insertImportHandler, @NotNull String name, @NotNull Collection<JSElement> elements, @NotNull JSLookupElementMerger merger) {
        Collection<JSLookupElementInfo> infos;
        Collection<LookupElement> merged;
        LookupElement item;
        if (completionResultSet == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(45);
        }
        if (insertImportHandler == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(46);
        }
        if (name == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(47);
        }
        if (elements == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(48);
        }
        if (merger == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(49);
        }
        if ((item = (LookupElement)ContainerUtil.getFirstItem(merged = merger.merge(name, infos = JSImportCompletionUtil.createInfos(name, elements), true))) != null) {
            if (item instanceof PrioritizedLookupElement) {
                item = ((PrioritizedLookupElement)item).getDelegate();
            }
            if (item instanceof LookupElementBuilder) {
                item = ((LookupElementBuilder)item).withInsertHandler(insertImportHandler);
            }
            item = JSCompletionUtil.withJSLookupPriority(item, IMPORT_PRIORITY);
            completionResultSet.addElement(item);
        }
    }

    @NotNull
    private static Set<PsiElement> expandElements(Collection<JSElement> elements) {
        Set<PsiElement> set = elements.stream().flatMap(el -> {
            if (el instanceof ES6ExportSpecifier || el instanceof ES6ExportSpecifierAlias || el instanceof ES6ExportDefaultAssignment && (((ES6ExportDefaultAssignment)el).getStubSafeElement() != null || ((ES6ExportDefaultAssignment)el).getInitializerReference() != null)) {
                return ES6PsiUtil.expandElements((PsiElement)el, Collections.singleton(el)).stream();
            }
            return Stream.of(el);
        }).collect(Collectors.toSet());
        if (set == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(50);
        }
        return set;
    }

    private static boolean isLatin(char symbol) {
        return symbol >= 'A' && symbol <= 'Z' || symbol >= 'a' && symbol <= 'z';
    }

    private static void importForElement(@NotNull InsertionContext context, @NotNull LookupElement item, @Nullable PsiElement element) {
        if (context == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(51);
        }
        if (item == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(52);
        }
        JSImportCompletionUtil.insertLookupItem(context, item, element, (Consumer<? super JSElement>)((Consumer)importedElement -> {
            if (importedElement != null) {
                JSElement elementToHandle = importedElement;
                PsiElement originalElement = context.getFile().findElementAt(context.getStartOffset());
                if (originalElement != null) {
                    PsiElement toProcessPlace;
                    PsiElement psiElement = toProcessPlace = originalElement.getNode().getElementType() == JSTokenTypes.IDENTIFIER ? originalElement.getParent() : originalElement;
                    if (toProcessPlace instanceof JSReferenceExpression && toProcessPlace.isValid()) {
                        context.commitDocument();
                        PsiElement resolved = ((JSReferenceExpression)toProcessPlace).resolve();
                        if (resolved != null) {
                            elementToHandle = resolved;
                        }
                    }
                }
                PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
                if (item.getPsiElement() != null) {
                    new JSInsertHandler().handleInsert(context, item);
                } else if (item instanceof LookupElementBuilder) {
                    new JSInsertHandler().handleInsert(context, (LookupElement)((LookupElementBuilder)item).withPsiElement((PsiElement)elementToHandle));
                }
            }
        }));
    }

    @NotNull
    private static Collection<JSLookupElementInfo> createInfos(@NotNull String name, Collection<JSElement> elements) {
        if (name == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(53);
        }
        Set<PsiElement> expandedElements = JSImportCompletionUtil.expandElements(elements);
        List list2 = ContainerUtil.map(expandedElements, el -> JSImportCompletionUtil.createInfo(name, el));
        if (list2 == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(54);
        }
        return list2;
    }

    private static JSLookupElementInfo createInfo(final @NotNull String name, final @NotNull PsiElement element) {
        if (name == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(55);
        }
        if (element == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(56);
        }
        return new JSLookupElementInfoImpl(element, name, IMPORT_PRIORITY, BaseJSSymbolProcessor.MatchType.COMPLETE, null){

            @Override
            public LookupElement toLookupElement() {
                return LookupElementBuilder.create((Object)element, (String)name).withRenderer((LookupElementRenderer)new JSLookupElementRenderer(name, element, IMPORT_PRIORITY, false, null));
            }
        };
    }

    public static void insertLookupItem(@NotNull InsertionContext context, @NotNull LookupElement item, @Nullable PsiElement psiElement, @Nullable Consumer<? super JSElement> afterInsert) {
        if (context == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(57);
        }
        if (item == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(58);
        }
        context.commitDocument();
        CaretModel model = context.getEditor().getCaretModel();
        if (model.getCaretCount() > 1 && model.getPrimaryCaret() != model.getCurrentCaret()) {
            return;
        }
        PsiElement originalElement = context.getFile().findElementAt(context.getStartOffset());
        if (originalElement == null || !JSImportCompletionUtil.shouldAddImportFromCompletion(originalElement)) {
            return;
        }
        String name = item.getLookupString();
        ES6ImportAction action = ES6CreateImportUtil.createImportAction(context.getEditor(), originalElement, name, null, ES6ImportAction.DEFAULT_FILTER);
        if (psiElement instanceof JSElement) {
            action.executeFor((JSElement)psiElement, afterInsert);
        } else {
            action.executeForAllVariants(afterInsert);
        }
    }

    private static boolean shouldAddImportFromCompletion(@NotNull PsiElement element) {
        if (element == null) {
            JSImportCompletionUtil.$$$reportNull$$$0(59);
        }
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        return DialectDetector.isTypeScript(element) ? settings.hasTSImportCompletionEffective(element.getProject()) : settings.isUseJavaScriptAutoImport();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 42: 
            case 50: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 42: 
            case 50: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sinkResults";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 16: 
            case 32: 
            case 33: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionResultSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 6: 
            case 9: 
            case 15: 
            case 38: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localAndGlobalElements";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "counter";
                break;
            }
            case 12: 
            case 18: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localElements";
                break;
            }
            case 13: 
            case 19: 
            case 21: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: 
            case 20: 
            case 22: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importContext";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeFilter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 28: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 42: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSImportCompletionUtil";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 37: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertImportHandler";
                break;
            }
            case 47: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "merger";
                break;
            }
            case 51: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 52: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSImportCompletionUtil";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportInsertHandler";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalElementNames";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "expandElements";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addExportedVariants";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processExportedCommonJSElements";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processExportedES6Elements";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getImportInsertHandler";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 42: 
            case 50: 
            case 54: {
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isExcludeWithNonLatinFirstSymbol";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkLimit";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "needToCheckConfigAccess";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableForImport";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "skipPlace";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getLocalElementNames";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "fillImportedElements";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "fillLookupItemForElements";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "importForElement";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createInfos";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "insertLookupItem";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddImportFromCompletion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 42: 
            case 50: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ImportInsertHandler
    implements InsertHandler<LookupElement> {
        private final SmartPsiElementPointer<PsiElement> myElement;

        private ImportInsertHandler(@NotNull PsiElement element) {
            if (element == null) {
                ImportInsertHandler.$$$reportNull$$$0(0);
            }
            this.myElement = SmartPointerManager.createPointer((PsiElement)element);
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                ImportInsertHandler.$$$reportNull$$$0(1);
            }
            if (item == null) {
                ImportInsertHandler.$$$reportNull$$$0(2);
            }
            JSImportCompletionUtil.importForElement(context, item, this.myElement.getElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/completion/JSImportCompletionUtil$ImportInsertHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleInsert";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum ImportContext {
        SIMPLE,
        SPECIFIER,
        DEFAULT_BINDING;

    }
}

