/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypeEx;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.lookup.CommaTailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSPipeExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeArgumentsOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6DecoratorDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentsListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInsertHandler
implements InsertHandler<LookupElement> {
    public static final InsertHandler<LookupElement> DEFAULT = new JSInsertHandler();
    public static final Key<ForcedCompleteFunctionType> FORCED_COMPLETE_FUNCTION = Key.create((String)"js.forced.complete.function");
    public static final Key<TailType> FORCED_TAIL_TYPE = Key.create((String)"forced.tail.type");

    protected JSInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        TailType tailType;
        if (context == null) {
            JSInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            JSInsertHandler.$$$reportNull$$$0(1);
        }
        if (context.getCompletionChar() != '\r') {
            context.setAddCompletionChar(false);
        }
        if (context.getCompletionChar() == '(') {
            tailType = TailTypeEx.SMART_LPARENTH;
        } else {
            tailType = LookupItem.getDefaultTailType((char)context.getCompletionChar());
            TailType forcedTailType = (TailType)item.getUserData(FORCED_TAIL_TYPE);
            if (forcedTailType != null) {
                tailType = forcedTailType;
            }
            if (tailType == null) {
                tailType = TailType.NONE;
            }
        }
        tailType.processTail(context.getEditor(), context.getSelectionEndOffset());
        int offsetToImport = context.getStartOffset();
        PsiElement elementAtOffset = context.getFile().findElementAt(offsetToImport);
        PsiElement contextElement = elementAtOffset != null ? elementAtOffset.getParent().getParent() : null;
        boolean showParameterInfo = false;
        char completionChar = context.getCompletionChar();
        AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)context.getProject());
        if (tailType == TailType.DOT || completionChar == '.' || (showParameterInfo = (tailType == CommaTailType.INSTANCE || completionChar == ',') && contextElement instanceof JSArgumentList)) {
            if (showParameterInfo) {
                autoPopupController.autoPopupParameterInfo(context.getEditor(), null);
            } else {
                autoPopupController.autoPopupMemberLookup(context.getEditor(), null);
            }
        }
        CaretModel caretModel = context.getEditor().getCaretModel();
        if (item.getLookupString().endsWith("()") || item.getLookupString().endsWith("[]")) {
            caretModel.moveCaretRelatively(-1, 0, false, false, true);
        } else {
            Object object;
            PsiElement itemPsiElement = item.getPsiElement();
            PsiElement element = itemPsiElement != null && itemPsiElement.isValid() ? itemPsiElement : null;
            boolean weAreNearCall = JSInsertHandler.weAreNearCall(context.getFile().findElementAt(context.getTailOffset()), completionChar);
            if (completionChar != '.' && completionChar != ',' && completionChar != ' ') {
                JSFunction constructor;
                JSExpression elvisContext;
                Collection<JSFunctionWithSubstitutor> functions;
                JSFunction functionInitializer;
                JSElement parent;
                if (element instanceof JSProperty && !((parent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, (Class[])new Class[]{JSObjectLiteralExpression.class, JSExpressionStatement.class, JSVariable.class})) instanceof JSObjectLiteralExpression) && (functionInitializer = ((JSProperty)element).tryGetFunctionInitializer()) != null && !JSResolveUtil.isFromPredefinedFile(functionInitializer.getContainingFile())) {
                    element = functionInitializer;
                }
                JSFunctionItem possibleFun = (functions = JSInsertHandler.computePossibleFunctions(contextElement, elvisContext = JSInsertHandler.getElvisContext(elementAtOffset), element)).size() > 0 ? ((JSFunctionWithSubstitutor)ContainerUtil.getFirstItem(functions)).myFunctionItem : null;
                boolean atNew = contextElement instanceof JSNewExpression;
                if (element instanceof JSClass && atNew && (constructor = ((JSClass)element).getConstructor()) != null) {
                    possibleFun = constructor;
                }
                if (JSInsertHandler.needGenerics(contextElement, element, context.getTailOffset())) {
                    JSInsertHandler.insertGenericType(context, (TypeScriptTypeParameterListOwner)element, (JSTypeArgumentsOwner)contextElement);
                }
                ForcedCompleteFunctionType forcedCompleteFunctionType = (ForcedCompleteFunctionType)((Object)item.getUserData(FORCED_COMPLETE_FUNCTION));
                if (possibleFun != null && !possibleFun.isGetProperty() && !possibleFun.isSetProperty() || forcedCompleteFunctionType != null) {
                    int offset = caretModel.getOffset();
                    boolean completingWithLParen = completionChar == '(';
                    boolean needParens = true;
                    if (!completingWithLParen) {
                        TypeScriptTypeArgumentList list2;
                        needParens = JSInsertHandler.needParensByContext(elementAtOffset, offset);
                        if (possibleFun != null && !(contextElement instanceof JSNewExpression) && JSSymbolUtil.isConstructorSymbol((JSPsiElementBase)possibleFun)) {
                            needParens = false;
                        }
                        if (possibleFun instanceof ES6DecoratorDeclaration && possibleFun.getParameters().length == 0) {
                            needParens = false;
                        }
                        if (contextElement instanceof JSTypeArgumentsOwner && (list2 = (TypeScriptTypeArgumentList)PsiTreeUtil.getStubChildOfType((PsiElement)contextElement, TypeScriptTypeArgumentList.class)) != null) {
                            needParens = false;
                        }
                        if (possibleFun != null && !(contextElement instanceof JSNewExpression) && DialectDetector.isTypeScript(element)) {
                            JSType type = JSResolveUtil.getElementJSType(element);
                            if (elvisContext != null) {
                                type = JSTypeUtils.removeNullableComponents(type);
                            }
                            if (type != null) {
                                JSRecordType record = type.asRecordType();
                                for (JSRecordType.TypeMember member : record.getTypeMembers()) {
                                    if (TypeScriptPsiUtil.isObjectBuiltInTypeProperty(member) || member instanceof JSRecordType.CallSignature) continue;
                                    needParens = false;
                                    break;
                                }
                            }
                        }
                        if (needParens && !weAreNearCall) {
                            JSInsertHandler.insertParens(context);
                        }
                    }
                    boolean shiftInsideParens = false;
                    if (needParens) {
                        if (possibleFun != null) {
                            shiftInsideParens = functions.size() > 1 || possibleFun.getParameters().length > 0 || possibleFun.isReferencesArguments();
                        } else {
                            boolean bl = shiftInsideParens = forcedCompleteFunctionType == ForcedCompleteFunctionType.WITH_PARAMETERS;
                        }
                    }
                    if (completingWithLParen) {
                        if (shiftInsideParens) {
                            autoPopupController.autoPopupParameterInfo(context.getEditor(), (PsiElement)possibleFun);
                        } else {
                            caretModel.moveToOffset(offset + 1);
                        }
                    } else if (shiftInsideParens) {
                        caretModel.moveToOffset(offset + 1);
                        autoPopupController.autoPopupParameterInfo(context.getEditor(), (PsiElement)possibleFun);
                    } else {
                        caretModel.moveToOffset(offset + (needParens ? 2 : 0));
                    }
                    if (shiftInsideParens) {
                        TabOutScopesTracker.getInstance().registerEmptyScopeAtCaret(context.getEditor());
                    }
                } else if (element instanceof JSProperty) {
                    PsiElement grandParent;
                    int offset = caretModel.getOffset();
                    PsiElement psiElement = context.getFile().findElementAt(offset - 1);
                    if (psiElement != null && JSKeywordSets.IDENTIFIER_NAMES.contains(psiElement.getNode().getElementType()) && psiElement.getParent() instanceof JSReferenceExpression && (grandParent = psiElement.getParent().getParent()) instanceof ES6Property && ((ES6Property)grandParent).isShorthanded()) {
                        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(element);
                        String beforeColon = settings.SPACE_BEFORE_PROPERTY_COLON ? " " : "";
                        String afterColon = settings.SPACE_AFTER_PROPERTY_COLON ? " " : "";
                        String toInsert = beforeColon + ":" + afterColon;
                        context.getEditor().getDocument().insertString(offset, (CharSequence)toInsert);
                        caretModel.moveToOffset(offset + toInsert.length());
                    }
                } else if (element instanceof JSClass && atNew && !weAreNearCall && completionChar != '(') {
                    int offset = caretModel.getOffset();
                    JSInsertHandler.insertParens(context);
                    caretModel.moveToOffset(offset + 2);
                }
            }
            PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
            if (elementAtOffset != null && !elementAtOffset.isValid()) {
                elementAtOffset = context.getFile().findElementAt(offsetToImport);
            }
            if ((elementAtOffset = JSInsertHandler.addActionScriptImport(context, offsetToImport, elementAtOffset, element)) != null && elementAtOffset.getNode().getElementType() == JSDocTokenTypes.DOC_TAG_NAME && (object = item.getObject()) instanceof String && ("return".equals(object) || "returns".equals(object))) {
                JSDocumentationProvider.setReturnTag((String)object);
            }
        }
    }

    @Nullable
    private static JSExpression getElvisContext(@Nullable PsiElement elementAtOffset) {
        if (elementAtOffset == null) {
            return null;
        }
        PsiElement parent = elementAtOffset.getParent();
        if (!(parent instanceof JSReferenceExpression)) {
            return null;
        }
        if (!JSPsiImplUtils.isElvisOrInOptChain((JSElvisOwner)((JSReferenceExpression)parent))) {
            return null;
        }
        return (JSExpression)parent;
    }

    @NotNull
    private static Collection<JSFunctionWithSubstitutor> computePossibleFunctions(@Nullable PsiElement contextElement, @Nullable JSExpression elvisContext, @Nullable PsiElement resolvedElement) {
        if (resolvedElement == null || resolvedElement instanceof TypeScriptPropertySignature) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSInsertHandler.$$$reportNull$$$0(2);
            }
            return list2;
        }
        Collection<JSFunctionWithSubstitutor> functions = JSStubBasedPsiTreeUtil.calculatePossibleFunctions(resolvedElement, contextElement, true);
        if (!functions.isEmpty()) {
            Collection<JSFunctionWithSubstitutor> collection = functions;
            if (collection == null) {
                JSInsertHandler.$$$reportNull$$$0(3);
            }
            return collection;
        }
        if (elvisContext == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                JSInsertHandler.$$$reportNull$$$0(4);
            }
            return list3;
        }
        JSType qualifierType = JSTypeUtils.removeNullableComponents(JSResolveUtil.getExpressionJSType(elvisContext));
        if (qualifierType == null) {
            List list4 = ContainerUtil.emptyList();
            if (list4 == null) {
                JSInsertHandler.$$$reportNull$$$0(5);
            }
            return list4;
        }
        Collection collection = qualifierType.getFunctionTypes(new ProcessingContext(), false).filter(t -> t instanceof JSFunctionType).map(t -> ((JSFunctionType)t).getSourceFunctionItem()).filter(t -> t != null).map(t -> new JSFunctionWithSubstitutor((JSFunctionItem)t, JSTypeSubstitutor.EMPTY)).collect(Collectors.toList());
        if (collection == null) {
            JSInsertHandler.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private static boolean needGenerics(@Nullable PsiElement contextElement, @Nullable PsiElement element, int offset) {
        TypeScriptTypeParameter[] parameters;
        if (contextElement == null || element == null) {
            return false;
        }
        if (!DialectDetector.isTypeScript(contextElement)) {
            return false;
        }
        if (!(element instanceof TypeScriptTypeParameterListOwner)) {
            return false;
        }
        if (!(contextElement instanceof JSTypeArgumentsOwner) || contextElement instanceof JSCallExpression) {
            return false;
        }
        if (contextElement instanceof TypeScriptTypeArgumentsListOwner && ((TypeScriptTypeArgumentsListOwner)contextElement).getTypeArgumentList() != null) {
            return false;
        }
        if (JSInsertHandler.isFollowedBySomethingNoBreak(contextElement, offset)) {
            return false;
        }
        TypeScriptTypeParameterListOwner listOwner = (TypeScriptTypeParameterListOwner)element;
        for (TypeScriptTypeParameter parameter : parameters = listOwner.getTypeParameters()) {
            if (parameter.getDefault() != null) continue;
            return true;
        }
        return false;
    }

    private static boolean isFollowedBySomethingNoBreak(@NotNull PsiElement contextElement, int offset) {
        if (contextElement == null) {
            JSInsertHandler.$$$reportNull$$$0(7);
        }
        if (contextElement instanceof TypeScriptSingleType && contextElement.getTextRange().contains(offset)) {
            return true;
        }
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)contextElement);
        if (nextLeaf instanceof PsiErrorElement) {
            nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
        }
        if (nextLeaf instanceof PsiWhiteSpace) {
            PsiElement psiElement = nextLeaf = nextLeaf.getText().contains("\n") ? null : PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
        }
        if (nextLeaf instanceof JSAttributeList && StringUtil.isEmpty((String)nextLeaf.getText())) {
            nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
        }
        return PsiUtilCore.getElementType((PsiElement)nextLeaf) == JSTokenTypes.IDENTIFIER;
    }

    @Nullable
    private static PsiElement addActionScriptImport(@NotNull InsertionContext context, int offsetToImport, @Nullable PsiElement elementAtOffset, @Nullable PsiElement element) {
        if (context == null) {
            JSInsertHandler.$$$reportNull$$$0(8);
        }
        if (elementAtOffset == null || element == null || !DialectDetector.isActionScript(element)) {
            return elementAtOffset;
        }
        PsiElement elementForQNameImport = element;
        String qNameToImport = null;
        JSReferenceExpression contextExpr = (JSReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, JSReferenceExpression.class);
        if (elementForQNameImport instanceof JSAttributeListOwner) {
            JSClass contextClass;
            JSClass clazz;
            JSAttributeList attributeList = ((JSAttributeListOwner)elementForQNameImport).getAttributeList();
            if (elementForQNameImport instanceof JSVariable && attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && (clazz = JSUtils.getMemberContainingClass(elementForQNameImport)) != null && ((contextClass = JSResolveUtil.getClassOfContext(elementAtOffset)) == null || !JSInheritanceUtil.isParentClass(contextClass, clazz, false))) {
                elementForQNameImport = clazz;
                offsetToImport = (contextExpr = JSInsertHandler.updateContextExpr(contextExpr)) != null ? contextExpr.getTextRange().getStartOffset() : 0;
            }
            String qName = ((JSQualifiedNamedElement)elementForQNameImport).getQualifiedName();
            if (contextExpr != null && qName != null && StringUtil.isNotEmpty((String)StringUtil.getPackageName((String)qName))) {
                qNameToImport = qName;
            }
        }
        if (qNameToImport != null) {
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getEditor().getDocument());
            elementAtOffset = context.getFile().findElementAt(offsetToImport);
            if (elementAtOffset != null) {
                ImportUtils.doImport(elementAtOffset, qNameToImport, true);
            }
        }
        return elementAtOffset;
    }

    protected static boolean needParensByContext(PsiElement elementAtOffset, int offset) {
        JSType expectedType;
        boolean allAlwaysAssignable;
        PsiElement grandParentElementAtOffset;
        PsiElement parentElementAtOffset = elementAtOffset != null ? elementAtOffset.getParent() : null;
        PsiElement psiElement = grandParentElementAtOffset = parentElementAtOffset != null ? parentElementAtOffset.getParent() : null;
        if (grandParentElementAtOffset instanceof JSPipeExpression && ((JSPipeExpression)grandParentElementAtOffset).getMethodExpression() == parentElementAtOffset) {
            return false;
        }
        if (grandParentElementAtOffset instanceof JSBinaryExpression && ((JSBinaryExpression)grandParentElementAtOffset).getOperationSign() == JSTokenTypes.INSTANCEOF_KEYWORD && parentElementAtOffset == ((JSBinaryExpression)grandParentElementAtOffset).getROperand() || (grandParentElementAtOffset instanceof JSVariable || grandParentElementAtOffset instanceof JSFunction) && parentElementAtOffset.getPrevSibling() != null && parentElementAtOffset.getPrevSibling().getNode().getElementType() == JSTokenTypes.COLON || grandParentElementAtOffset instanceof JSImportStatement || parentElementAtOffset instanceof JSDocTagValue || parentElementAtOffset instanceof JSAttributeNameValuePair || parentElementAtOffset instanceof PsiComment) {
            return false;
        }
        if (parentElementAtOffset instanceof JSExpression && !(grandParentElementAtOffset instanceof JSAssignmentExpression) && !(allAlwaysAssignable = JSTypeUtils.getFunctionType(expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parentElementAtOffset), false, elementAtOffset).allMatch(el -> JSTypeCastUtil.isAlwaysAssignableType(el, parentElementAtOffset)))) {
            return false;
        }
        if (parentElementAtOffset instanceof JSReferenceExpression && grandParentElementAtOffset instanceof ES6Property && ((ES6Property)grandParentElementAtOffset).getNameIdentifier() == parentElementAtOffset) {
            return false;
        }
        if (parentElementAtOffset instanceof JSVariable && grandParentElementAtOffset instanceof JSDestructuringShorthandedProperty) {
            return false;
        }
        if (parentElementAtOffset instanceof JSReferenceExpression) {
            return true;
        }
        if (parentElementAtOffset instanceof JSLiteralExpression && grandParentElementAtOffset instanceof JSIndexedPropertyAccessExpression) {
            return offset != -1 && offset > elementAtOffset.getTextRange().getEndOffset() && ((JSLiteralExpression)parentElementAtOffset).isQuotedLiteral();
        }
        return false;
    }

    private static void insertGenericType(@NotNull InsertionContext insertionContext, @NotNull TypeScriptTypeParameterListOwner resolveElement, @NotNull JSTypeArgumentsOwner place) {
        TypeScriptTypeParameterList list2;
        if (insertionContext == null) {
            JSInsertHandler.$$$reportNull$$$0(9);
        }
        if (resolveElement == null) {
            JSInsertHandler.$$$reportNull$$$0(10);
        }
        if (place == null) {
            JSInsertHandler.$$$reportNull$$$0(11);
        }
        if ((list2 = resolveElement.getTypeParameterList()) == null) {
            return;
        }
        Project project = insertionContext.getProject();
        Editor editor = insertionContext.getEditor();
        JSCompletionUtil.createAndStartAddGenericsTemplate(project, editor, place, list2);
    }

    public static boolean weAreNearCall(PsiElement elementAt, char ch) {
        if (elementAt != null) {
            if (ch == '\t') {
                if (JSInsertHandler.isIdentifier(elementAt)) {
                    elementAt = PsiTreeUtil.nextLeaf((PsiElement)elementAt);
                }
                if (elementAt instanceof PsiWhiteSpace && !elementAt.textContains('\n')) {
                    elementAt = PsiTreeUtil.nextLeaf((PsiElement)elementAt);
                }
            }
            return elementAt != null && elementAt.getText().equals("(");
        }
        return false;
    }

    @Contract(value="null -> false")
    private static boolean isIdentifier(@Nullable PsiElement elementAt) {
        if (elementAt == null) {
            return false;
        }
        ASTNode node = elementAt.getNode();
        return node != null && JSKeywordSets.IDENTIFIER_TOKENS_SET.contains(node.getElementType());
    }

    @NotNull
    public static <T extends LookupElement> InsertHandler<T> insertBracesIfNeeded(@NotNull PsiElement element, @Nullable PsiElement place) {
        if (element == null) {
            JSInsertHandler.$$$reportNull$$$0(12);
        }
        InsertHandler insertHandler = (context, item) -> JSInsertHandler.insertBracesIfNeeded(context, element, place);
        if (insertHandler == null) {
            JSInsertHandler.$$$reportNull$$$0(13);
        }
        return insertHandler;
    }

    public static void insertBracesIfNeeded(@NotNull InsertionContext insertionContext, @NotNull PsiElement element, @Nullable PsiElement place) {
        if (insertionContext == null) {
            JSInsertHandler.$$$reportNull$$$0(14);
        }
        if (element == null) {
            JSInsertHandler.$$$reportNull$$$0(15);
        }
        if (!JSInsertHandler.isAcceptablePlace(element, place)) {
            return;
        }
        JSFunction function2 = null;
        if (element instanceof JSFunction) {
            if (((JSFunction)element).isGetProperty()) {
                return;
            }
            function2 = (JSFunction)element;
        }
        if (element instanceof JSClass) {
            function2 = ((JSClass)element).getConstructor();
        }
        JSInsertHandler.insertBracesIfNeeded(insertionContext, function2 == null || function2.getParameters().length == 0 ? 2 : 1);
    }

    public static boolean isAcceptablePlace(@NotNull PsiElement element, @Nullable PsiElement place) {
        if (element == null) {
            JSInsertHandler.$$$reportNull$$$0(16);
        }
        if (element instanceof JSFunction) {
            return true;
        }
        return element instanceof JSClass && place instanceof JSReferenceExpression && place.getParent() instanceof JSNewExpression;
    }

    public static void insertBracesIfNeeded(@NotNull InsertionContext context, int toMoveCaret) {
        if (context == null) {
            JSInsertHandler.$$$reportNull$$$0(17);
        }
        char completionChar = context.getCompletionChar();
        if (!JSInsertHandler.weAreNearCall(context.getFile().findElementAt(context.getTailOffset()), completionChar) && completionChar != '(') {
            JSInsertHandler.insertParens(context);
            context.getEditor().getCaretModel().moveToOffset(context.getEditor().getCaretModel().getOffset() + toMoveCaret);
            if (toMoveCaret == 1) {
                TabOutScopesTracker.getInstance().registerEmptyScopeAtCaret(context.getEditor());
            }
        }
    }

    public static void insertParens(@NotNull InsertionContext context) {
        if (context == null) {
            JSInsertHandler.$$$reportNull$$$0(18);
        }
        char completionChar = context.getCompletionChar();
        int offset = context.getEditor().getCaretModel().getOffset();
        int diff = completionChar == '\n' || completionChar == '\t' || completionChar == '\r' || completionChar == '\u0000' ? 0 : 1;
        boolean shouldInsertRPar = completionChar != '\r';
        String text = shouldInsertRPar ? "()" : "(";
        context.getEditor().getDocument().insertString(offset - diff, (CharSequence)text);
    }

    private static JSReferenceExpression updateContextExpr(JSReferenceExpression contextExpr) {
        JSExpression contextExprParent;
        JSExpression jSExpression = contextExprParent = contextExpr != null ? contextExpr.getQualifier() : null;
        if (contextExprParent instanceof JSReferenceExpression) {
            contextExpr = (JSReferenceExpression)contextExprParent;
        }
        return contextExpr;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSInsertHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertionContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSInsertHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computePossibleFunctions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "insertBracesIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFollowedBySomethingNoBreak";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addActionScriptImport";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "insertGenericType";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "insertBracesIfNeeded";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptablePlace";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "insertParens";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ForcedCompleteFunctionType {
        WITH_PARAMETERS,
        EMPTY_PARAMETERS;

    }
}

