/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSDocParamReferenceCompletion;
import com.intellij.lang.javascript.completion.JSTextReferenceCompletion;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCompletionProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.resolve.JSIndexBasedResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSIndexableImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSNonGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataStructureImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IdIterator;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(1);
        }
        LegacyCompletionContributor.processReferences((CompletionParameters)parameters, (CompletionResultSet)result2, (reference, set) -> {
            if (reference instanceof JSTextReference) {
                JSTextReferenceCompletion.addVariants((JSTextReference)reference, parameters, set);
            } else if (reference instanceof JSDocParamReference) {
                set.addAllElements(JSDocParamReferenceCompletion.getVariants((JSDocParamReference)reference));
            } else if (reference instanceof JSPropertyNameReference) {
                JSReferenceCompletionContributor.calcPropertyNameReferenceVariants(((JSPropertyNameReference)reference).getElement(), parameters, set, null);
            }
        });
    }

    public static void calcPropertyNameReferenceVariants(@NotNull JSProperty property, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet, @Nullable Function<Collection<? extends LookupElement>, Collection<? extends LookupElement>> transformResults) {
        boolean stop;
        if (property == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(3);
        }
        if (resultSet == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(4);
        }
        VariantsProcessor processor = new VariantsProcessor(property.getContainingFile(), (PsiElement)property, false, parameters, resultSet);
        PsiElement context = JSReferenceCompletionContributor.getShorthandedPropertyContext(property);
        if (!processor.getTypeInfo().hasExplicitNamespace() && processor.getTypeInfo().getRecordTypes().stream().noneMatch(JSRecordType::hasProperties) && context != null) {
            if (DialectDetector.isTypeScript(context) && processor.addOnlyCompleteMatches()) {
                Collection<LookupElement> results = processor.getFinalResults();
                processor.populateCompletionList(results, true, resultSet);
                return;
            }
            CompletionResultSink sink = new CompletionResultSink(context, resultSet.getPrefixMatcher());
            SinkResolveProcessor<CompletionResultSink> localProcessor = new SinkResolveProcessor<CompletionResultSink>(sink);
            JSReferenceExpressionImpl.doProcessLocalDeclarations(context, null, localProcessor, false, true, null);
            processor.populateCompletionList(sink.getResultsAsObjects(), true, resultSet);
        }
        boolean bl = stop = !JSReferenceCompletionContributor.processIndexedSymbols((PsiElement)property, processor, resultSet, null);
        if (stop) {
            return;
        }
        Collection<LookupElement> results = processor.getFinalResults();
        processor.populateCompletionList(transformResults == null ? results : transformResults.apply(results), false, resultSet);
    }

    @Nullable
    private static PsiElement getShorthandedPropertyContext(@NotNull JSProperty property) {
        DialectOptionHolder holder;
        if (property == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(5);
        }
        if ((holder = DialectDetector.dialectOfElement((PsiElement)property)) == null || !holder.hasFeature(JSLanguageFeature.SHORTHAND_PROPERTY_NAMES)) {
            return null;
        }
        if (property instanceof ES6Property && ((ES6Property)property).isShorthanded() && property.getValue() instanceof JSReferenceExpression) {
            return property.getValue();
        }
        if (property.getNextSibling() instanceof PsiErrorElement) {
            return property.getNameIdentifier();
        }
        return null;
    }

    public static boolean processIndexedSymbols(@NotNull PsiElement referenceElement, @NotNull VariantsProcessor processor, @NotNull CompletionResultSet resultSet, @Nullable List<? super Collection<LookupElement>> populatedResults) {
        if (referenceElement == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(7);
        }
        if (resultSet == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(8);
        }
        boolean tooMuch = !JSReferenceCompletionContributor.processCompeteMatchedElements(processor);
        Collection<LookupElement> completeMatchResults = processor.getCurrentResults();
        processor.populateCompletionList(completeMatchResults, true, resultSet);
        if (populatedResults != null) {
            populatedResults.add(completeMatchResults);
        }
        if (tooMuch) {
            JSCompletionUtil.handleOverflow(resultSet);
            return false;
        }
        Project project = referenceElement.getProject();
        PsiFile file2 = referenceElement.getContainingFile();
        if (!JSReferenceCompletionContributor.processElementsInInjectedContext(processor, file2)) {
            JSCompletionUtil.handleOverflow(resultSet);
            return true;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(referenceElement);
        if (!processor.addOnlyCompleteMatches() && !JSReferenceCompletionContributor.processAllIndexedSymbols(processor, project, scope, referenceElement)) {
            JSCompletionUtil.handleOverflow(resultSet);
            return true;
        }
        if (DialectDetector.isActionScript(referenceElement)) {
            return true;
        }
        boolean result2 = JSReferenceCompletionContributor.processImplicitElements(processor, project, scope);
        if (!result2) {
            JSCompletionUtil.handleOverflow(resultSet);
        }
        return true;
    }

    public static boolean processElementsInInjectedContext(JSCompletionProcessor processor, PsiFile file2) {
        return JSResolveUtil.tryProcessAllElementsInInjectedContext(file2, (Processor<? super JSPsiElementBase>)((Processor)base -> processor.doAdd((JSPsiElementBase)base)));
    }

    public static boolean processImplicitElements(final JSCompletionProcessor processor, Project project, GlobalSearchScope scope) {
        return JSIndexBasedResolveUtil.processImplicitElementProxies(null, scope, project, new JSIndexBasedResolveUtil.JSSymbolProcessor(){

            @Override
            public boolean acceptsFile(@NotNull PsiFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return true;
            }

            @Override
            public boolean process(@NotNull JSPsiElementBase element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                return processor.doAdd(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSReferenceCompletionContributor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptsFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean processCompeteMatchedElements(@NotNull VariantsProcessor processor) {
        if (processor == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(9);
        }
        JSTypeInfo typeInfo = processor.getTypeInfo();
        boolean globalAdded = false;
        for (JSContextLevel level : typeInfo.myContextLevels) {
            globalAdded |= level.myNamespace.getQualifiedName() == null;
        }
        List<JSContextLevel> contextLevels = typeInfo.myContextLevels;
        if (!globalAdded && typeInfo.isGlobalContext()) {
            contextLevels = new ArrayList<JSContextLevel>(contextLevels);
            JSNamespace namespace = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.create("", null), JSContext.UNKNOWN, null, true);
            contextLevels.add(new JSContextLevel(namespace, 0));
        }
        if (typeInfo.isGlobalContext() && typeInfo.isEmpty()) {
            processor.setAddOnlyCompleteMatches();
        }
        GlobalSearchScope allScope = JSResolveUtil.getResolveScope(processor.getContext());
        THashSet visitedNamespaces = new THashSet();
        for (JSContextLevel level : contextLevels) {
            String namespace;
            JSQualifiedName name = level.myNamespace.getQualifiedName();
            String string = namespace = name != null ? name.getQualifiedName() : "";
            if (level.isGlobal() && !visitedNamespaces.add(namespace)) continue;
            PsiFile scopeFile = level.getScopeFile();
            GlobalSearchScope scope = scopeFile != null ? GlobalSearchScope.fileScope((PsiFile)scopeFile) : allScope;
            Collection<JSPsiElementBase> namespaceMembers = JSClassResolver.getInstance().findNamespaceMembers(namespace, scope, scopeFile != null || level.isFromJSDoc());
            for (JSPsiElementBase element : namespaceMembers) {
                if (!processor.acceptsFile(element.getContainingFile()) || processor.doAdd(element, JSTypeWithOuterGenerics.getGenericArguments(level.myNamespace))) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static TIntHashSet filterIds(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull PrefixMatcher matcher, @NotNull PsiElement context) {
        if (project == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(11);
        }
        if (matcher == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(12);
        }
        if (context == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(13);
        }
        if (matcher.getPrefix().isEmpty()) {
            return null;
        }
        HashSet keys = new HashSet();
        StubIndexKey<String, JSElement> indexKey = DialectDetector.isActionScript(context) ? JSSymbolIndex2.KEY : JSNonGlobalSymbolIndex.KEY;
        StubIndex.getInstance().processAllKeys(indexKey, s -> {
            if (matcher.prefixMatches(s)) {
                keys.add(s);
            }
            return true;
        }, scope, null);
        TIntHashSet ids = new TIntHashSet(keys.size());
        for (String key : keys) {
            IdIterator iterator = StubIndex.getInstance().getContainingIds(indexKey, (Object)key, project, scope);
            while (iterator.hasNext()) {
                ids.add(iterator.next());
            }
        }
        return ids;
    }

    private static boolean processAllIndexedSymbols(@NotNull JSCompletionProcessor processor, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull PsiElement context) {
        if (processor == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(14);
        }
        if (project == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(16);
        }
        if (context == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(17);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PrefixMatcher matcher = processor.getPrefixMatcher();
        TIntHashSet ids = JSReferenceCompletionContributor.filterIds(project, scope, matcher, context);
        MyJSRecursiveWalkingElementVisitor visitor = new MyJSRecursiveWalkingElementVisitor(processor);
        PsiFile targetFile = processor.getTargetFile();
        JSReferenceCompletionContributor.processSymbolsInPsiFile(processor, visitor, targetFile);
        if (ids == null) {
            for (FileType fileType : JavaScriptIndex.getFileTypesToIndexJS()) {
                for (VirtualFile vFile : FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)scope)) {
                    ProgressManager.checkCanceled();
                    if (!JavaScriptIndex.isAcceptableFile(vFile)) {
                        return true;
                    }
                    if (!StubUpdatingIndex.canHaveStub((VirtualFile)vFile)) {
                        return true;
                    }
                    if (JSReferenceCompletionContributor.processAllInVirtualFile(processor, psiManager, visitor, targetFile, vFile)) continue;
                    return false;
                }
            }
        } else {
            if (ids.isEmpty()) {
                return true;
            }
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            return ids.forEach(id -> {
                ProgressManager.checkCanceled();
                VirtualFile vFile = virtualFileManager.findFileById(id);
                return vFile == null || !scope.accept(vFile) || JSReferenceCompletionContributor.processAllInVirtualFile(processor, psiManager, visitor, targetFile, vFile);
            });
        }
        return true;
    }

    private static boolean processAllInVirtualFile(@NotNull JSCompletionProcessor processor, @NotNull PsiManager psiManager, @NotNull MyJSRecursiveWalkingElementVisitor visitor, @NotNull PsiFile targetFile, @NotNull VirtualFile vFile) {
        PsiFile psi;
        if (processor == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(18);
        }
        if (psiManager == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(19);
        }
        if (visitor == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(20);
        }
        if (targetFile == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(21);
        }
        if (vFile == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(22);
        }
        if ((psi = psiManager.findFile(vFile)) == null || psi == targetFile) {
            return true;
        }
        if (!processor.acceptsFile(psi)) {
            return true;
        }
        return JSReferenceCompletionContributor.processSymbolsInPsiFile(processor, visitor, psi);
    }

    protected static boolean processSymbolsInPsiFile(@NotNull JSCompletionProcessor processor, MyJSRecursiveWalkingElementVisitor visitor, PsiFile psi) {
        if (processor == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(23);
        }
        List stubbedRoots = StubTreeBuilder.getStubbedRoots((FileViewProvider)psi.getViewProvider());
        for (Pair stubbedRoot : stubbedRoots) {
            PsiFile root = (PsiFile)stubbedRoot.second;
            StubTree tree = ((PsiFileImpl)root).getStubTree();
            if (tree != null) {
                for (StubElement stubElement : tree.getPlainList()) {
                    PsiElement psiElement;
                    ProgressManager.checkCanceled();
                    IStubElementType type = stubElement.getStubType();
                    if (!(type instanceof JSStubElementType) || JSReferenceCompletionContributor.processElement(processor, (JSElement)(psiElement = stubElement.getPsi()), (JSStubElementType)type)) continue;
                    return false;
                }
                continue;
            }
            root.accept((PsiElementVisitor)visitor);
        }
        return true;
    }

    private static <PsiT extends JSElement> boolean processElement(JSCompletionProcessor processor, PsiT element, JSStubElementType<?, PsiT> type) {
        if (element instanceof JSFunctionExpression) {
            return true;
        }
        if (element instanceof JSPsiElementBase && !StringUtil.isEmpty((String)element.getName()) && type.shouldIndexSymbol(element) && !processor.doAdd((JSPsiElementBase)element)) {
            return false;
        }
        if (element instanceof JSImplicitElementProvider) {
            Collection elements;
            JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
            Collection collection = elements = data != null ? data.getImplicitElements() : null;
            if (elements != null) {
                for (JSImplicitElement implicitElement : elements) {
                    if (!(implicitElement instanceof JSIndexableImplicitElement) || JSElementIndexingDataStructureImpl.indexImplicitElement(((JSIndexableImplicitElement)implicitElement).getStructure(), null) || processor.doAdd((JSPsiElementBase)implicitElement)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 7: 
            case 9: 
            case 14: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSReferenceCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "calcPropertyNameReferenceVariants";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getShorthandedPropertyContext";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processIndexedSymbols";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processCompeteMatchedElements";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "filterIds";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllIndexedSymbols";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllInVirtualFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "processSymbolsInPsiFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyJSRecursiveWalkingElementVisitor
    extends JSRecursiveWalkingElementVisitor {
        private final JSCompletionProcessor myProcessor;

        MyJSRecursiveWalkingElementVisitor(JSCompletionProcessor processor) {
            this.myProcessor = processor;
        }

        public void visitElement(@NotNull PsiElement element) {
            ASTNode node;
            IElementType type;
            if (element == null) {
                MyJSRecursiveWalkingElementVisitor.$$$reportNull$$$0(0);
            }
            IElementType iElementType = type = (node = element.getNode()) != null ? node.getElementType() : null;
            if (type instanceof JSStubElementType && ((JSStubElementType)type).shouldCreateStub(node) && !JSReferenceCompletionContributor.processElement(this.myProcessor, (JSElement)element, (JSStubElementType)type)) {
                this.stopWalking();
            }
            super.visitElement(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/completion/JSReferenceCompletionContributor$MyJSRecursiveWalkingElementVisitor", "visitElement"));
        }
    }
}

