/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ArrayUtil;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ScopedImportSet {
    private static final ImportProcessor<JSImportedElementResolveResult> ourFindClassProcessor = new ImportProcessor<JSImportedElementResolveResult>(){

        @Override
        public JSImportedElementResolveResult process(@NotNull String referenceName, @NotNull ImportProcessor.ImportInfo info, @NotNull PsiNamedElement scope) {
            if (referenceName == null) {
                1.$$$reportNull$$$0(0);
            }
            if (info == null) {
                1.$$$reportNull$$$0(1);
            }
            if (scope == null) {
                1.$$$reportNull$$$0(2);
            }
            return ScopedImportSet.resolveImportedClass(referenceName, scope, info);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "referenceName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scope";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/flex/ScopedImportSet$1";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    protected static void appendToMap(Map<String, Object> map, JSImportStatement importStatement) {
        ScopedImportSet.doAppendToMap(map, importStatement);
    }

    protected static void doAppendToMap(Map<String, Object> map, Object stringOrStatement) {
        String s = stringOrStatement instanceof String ? (String)stringOrStatement : ((JSImportStatement)stringOrStatement).getImportText();
        int index = s.lastIndexOf(46);
        if (index == -1) {
            return;
        }
        String key = s.substring(index + 1);
        Object o = map.get(key);
        if (o == null) {
            map.put(key, stringOrStatement);
        } else if (o instanceof Object[]) {
            map.put(key, ArrayUtil.append((Object[])((Object[])o), (Object)stringOrStatement));
        } else {
            map.put(key, new Object[]{stringOrStatement, o});
        }
    }

    public static JSImportedElementResolveResult resolveImportedClass(@NotNull String referenceName, PsiNamedElement file2, ImportProcessor.ImportInfo info) {
        if (referenceName == null) {
            ScopedImportSet.$$$reportNull$$$0(0);
        }
        String nameToTry = info.getQNameToSearch(referenceName);
        PsiElement element = JSDialectSpecificHandlersFactory.forElement((PsiElement)file2).getClassResolver().findClassByQName(nameToTry, (PsiElement)file2);
        if (element != null) {
            return new JSImportedElementResolveResult(nameToTry, element, info.source instanceof JSImportStatement ? (JSImportStatement)info.source : null);
        }
        return null;
    }

    public boolean tryResolveImportedClass(PsiNamedElement scope, final ResolveProcessor resolveProcessor) {
        final String qname = resolveProcessor.getQualifiedNameToImport();
        Object result2 = this.process(resolveProcessor.getName(), qname, scope, new ImportProcessor<Object>(){

            @Override
            public Object process(@NotNull String referenceName, @NotNull ImportProcessor.ImportInfo info, @NotNull PsiNamedElement scope) {
                if (referenceName == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (info == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (scope == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (qname != null && !qname.equals(info.getQNameToSearch(referenceName))) {
                    return null;
                }
                JSImportedElementResolveResult resolveResult = (JSImportedElementResolveResult)ourFindClassProcessor.process(referenceName, info, scope);
                return ScopedImportSet.dispatchResult(resolveResult, resolveProcessor) ? resolveResult : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "referenceName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "info";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "scope";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/flex/ScopedImportSet$2";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return result2 == null;
    }

    private static boolean dispatchResult(JSImportedElementResolveResult expression, PsiScopeProcessor processor) {
        PsiElement element;
        if (expression != null && (element = expression.resolvedElement) != null) {
            ResolveState state = ResolveState.initial();
            if (expression.importStatement != null) {
                state = state.put(JSResolveResult.IMPORT_KEY, (Object)expression.importStatement);
            }
            return !processor.execute(element, state);
        }
        return false;
    }

    public <T> T process(@NotNull String referenceName, final @Nullable String qualifiedName, @NotNull PsiNamedElement scope, final @NotNull ImportProcessor<T> processor) {
        T o;
        block5: {
            ImportProcessor filteringProcessor;
            Object entry;
            Map<String, Object> map;
            if (referenceName == null) {
                ScopedImportSet.$$$reportNull$$$0(1);
            }
            if (scope == null) {
                ScopedImportSet.$$$reportNull$$$0(2);
            }
            if (processor == null) {
                ScopedImportSet.$$$reportNull$$$0(3);
            }
            if ((o = ScopedImportSet.tryEntry((map = this.getUpToDateMap((PsiElement)scope)).get(referenceName), referenceName, scope, processor, false)) == null) {
                o = ScopedImportSet.tryEntry(map.get("*"), referenceName, scope, processor, true);
            }
            if (o != null || qualifiedName == null) break block5;
            Iterator<Object> iterator = map.values().iterator();
            while (iterator.hasNext() && (o = ScopedImportSet.tryEntry(entry = iterator.next(), referenceName, scope, filteringProcessor = new ImportProcessor<T>(){

                @Override
                public T process(@NotNull String referenceName, @NotNull ImportProcessor.ImportInfo info, @NotNull PsiNamedElement scope) {
                    if (referenceName == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (info == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (scope == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    if (!StringUtil.getPackageName((String)qualifiedName).equals(StringUtil.getPackageName((String)info.importString))) {
                        return null;
                    }
                    return processor.process(referenceName, info, scope);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "referenceName";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "info";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "scope";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/flex/ScopedImportSet$3";
                    objectArray[2] = "process";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, true)) == null) {
            }
        }
        return o;
    }

    private static <T> T tryEntry(Object entry, String referenceName, PsiNamedElement scope, ImportProcessor<T> processor, boolean starImport) {
        if (entry == null) {
            return null;
        }
        if (entry instanceof Object[]) {
            for (Object entryItem : (Object[])entry) {
                T result2 = ScopedImportSet.dispatch(referenceName, entryItem, starImport, scope, processor);
                if (result2 == null) continue;
                return result2;
            }
        } else {
            return ScopedImportSet.dispatch(referenceName, entry, starImport, scope, processor);
        }
        return null;
    }

    private static <T> T dispatch(String referenceName, Object entry, boolean starImport, PsiNamedElement scope, ImportProcessor<T> processor) {
        String importString = entry instanceof String ? (String)entry : ((JSImportStatement)entry).getImportText();
        ImportProcessor.ImportInfo importInfo = new ImportProcessor.ImportInfo(importString, starImport, entry);
        return processor.process(referenceName, importInfo, scope);
    }

    @NotNull
    protected abstract Map<String, Object> getUpToDateMap(@NotNull PsiElement var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/flex/ScopedImportSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveImportedClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ImportProcessor<T> {
        public T process(@NotNull String var1, @NotNull ImportInfo var2, @NotNull PsiNamedElement var3);

        public static class ImportInfo {
            public final String importString;
            public final boolean starImport;
            public final Object source;

            public ImportInfo(String _importString, boolean _starImport, Object _source) {
                this.importString = _importString;
                this.starImport = _starImport;
                this.source = _source;
            }

            public String getQNameToSearch(@NotNull String referenceName) {
                if (referenceName == null) {
                    ImportInfo.$$$reportNull$$$0(0);
                }
                return this.starImport ? StringUtil.getQualifiedName((String)StringUtil.getPackageName((String)this.importString), (String)referenceName) : this.importString;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/lang/javascript/flex/ScopedImportSet$ImportProcessor$ImportInfo", "getQNameToSearch"));
            }
        }
    }
}

