/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JSNonStrictModeUsedInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        return new JSElementVisitor(){

            public void visitJSFile(JSFile file2) {
                this.checkHasUseStrict((JSExecutionScope)file2, "File");
            }

            public void visitJSEmbeddedContent(JSEmbeddedContent embeddedContent) {
                this.checkHasUseStrict((JSExecutionScope)embeddedContent, "Script");
            }

            private void checkHasUseStrict(JSExecutionScope executionScope, @NotNull String element) {
                DialectOptionHolder dialect;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((dialect = DialectDetector.dialectOfElement((PsiElement)executionScope)) != null && dialect.isJavaScript() && !dialect.isECMA6 && !JSResolveUtil.hasUseStrictPragma(executionScope.getNode())) {
                    LocalQuickFix fix = JSFixFactory.getInstance().insertUseStrict(executionScope);
                    holder.registerProblem((PsiElement)executionScope, JavaScriptBundle.message((String)"js.strict.mode.inspection.error", (Object[])new Object[]{element}), new LocalQuickFix[]{fix});
                }
            }

            public void visitJSExpressionStatement(JSExpressionStatement node) {
                JSExecutionScope executionScope;
                if (JSPsiImplUtils.isUseStrictStatement((PsiElement)node) && (executionScope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)node, JSExecutionScope.class)) != null && !(executionScope instanceof PsiFile) && JSResolveUtil.isEcmaScript5(executionScope.getParent())) {
                    LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix("js.strict.mode.remove.pragma", (PsiElement)node);
                    holder.registerProblem((PsiElement)node, JavaScriptBundle.message((String)"js.strict.mode.inspection.redundant.pragma", (Object[])new Object[0]), new LocalQuickFix[]{fix});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSNonStrictModeUsedInspection$1", "checkHasUseStrict"));
            }
        };
    }
}

