/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.destructuring;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.destructuring.JSStatementDestructuringIntentionBase;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import gnu.trove.TDoubleArrayList;
import java.util.List;
import java.util.Objects;
import kotlin.Triple;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSubsequentPropertyAccessToDestructuringIntention
extends JSStatementDestructuringIntentionBase {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSSubsequentPropertyAccessToDestructuringIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSSubsequentPropertyAccessToDestructuringIntention.$$$reportNull$$$0(1);
        }
        this.doInvoke((JSExpression)JSSubsequentPropertyAccessToDestructuringIntention.findExpression(element, e -> JSSubsequentPropertyAccessToDestructuringIntention.findReference(e)), project, editor);
    }

    @Override
    protected void appendDestructuringInitializer(TDoubleArrayList indices, List<String> leftHandSides, List<Triple<String, String, String>> propertyData, StringBuilder destructuringString) {
        JSSubsequentPropertyAccessToDestructuringIntention.appendDestructuringObjectInitializer(leftHandSides, propertyData, destructuringString);
    }

    private static void appendDestructuringObjectInitializer(List<String> leftHandSides, List<Triple<String, String, String>> propertyData, StringBuilder builder) {
        int max = leftHandSides.size();
        builder.append("{");
        for (int i = 0; i < max; ++i) {
            String varstring;
            String pname = (String)propertyData.get(i).component1();
            String propAndVarName = Objects.equals(pname, varstring = leftHandSides.get(i)) ? pname : pname + ": " + varstring;
            builder.append(propAndVarName);
            String defaultValue = (String)propertyData.get(i).component2();
            if (defaultValue != null) {
                builder.append(" = ").append(defaultValue);
            }
            builder.append(i == max - 1 ? "" : ",");
        }
        builder.append("}");
    }

    private static boolean isNumericConst(JSExpression expression) {
        JSLiteralExpression literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)JSUtils.unparenthesize(expression), JSLiteralExpression.class);
        return literalExpression != null && literalExpression.getExpressionKind(false).isNumeric();
    }

    @Override
    @Nullable
    protected JSExpression checkValidExpressionInValue(@Nullable JSExpression initializer) {
        if (initializer == null) {
            return null;
        }
        JSConditionalExpression ternaryExpression = (JSConditionalExpression)ObjectUtils.tryCast((Object)initializer, JSConditionalExpression.class);
        if (ternaryExpression == null) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)initializer, JSReferenceExpression.class);
            return referenceExpression == null || referenceExpression.getReferenceName() == null ? null : referenceExpression.getQualifier();
        }
        JSExpression condition = ternaryExpression.getCondition();
        JSBinaryExpression binary = (JSBinaryExpression)ObjectUtils.tryCast((Object)JSUtils.unparenthesize(condition), JSBinaryExpression.class);
        if (binary == null) {
            return null;
        }
        IElementType conditionSignTokenType = binary.getOperationSign();
        if (conditionSignTokenType != JSTokenTypes.EQEQEQ && conditionSignTokenType != JSTokenTypes.NEQEQ && conditionSignTokenType != JSTokenTypes.NE && conditionSignTokenType != JSTokenTypes.EQEQ) {
            return null;
        }
        boolean isNegativeCondition = conditionSignTokenType == JSTokenTypes.NEQEQ || conditionSignTokenType == JSTokenTypes.NE;
        JSExpression rOperand = binary.getROperand();
        JSLiteralExpression rightAsLiteral = (JSLiteralExpression)ObjectUtils.tryCast((Object)rOperand, JSLiteralExpression.class);
        JSReferenceExpression rightAsReference = (JSReferenceExpression)ObjectUtils.tryCast((Object)rOperand, JSReferenceExpression.class);
        JSPrefixExpression rightAsPrefix = (JSPrefixExpression)ObjectUtils.tryCast((Object)rOperand, JSPrefixExpression.class);
        if (!(rightAsLiteral != null || rightAsReference != null && rightAsReference.getQualifier() == null || rightAsPrefix != null && rightAsPrefix.getOperationSign() == JSTokenTypes.VOID_KEYWORD)) {
            return null;
        }
        if (rightAsLiteral != null && !"undefined".equals(rightAsLiteral.getStringValue())) {
            return null;
        }
        if (rightAsReference != null && !"undefined".equals(rightAsReference.getText())) {
            return null;
        }
        if (rightAsPrefix != null && !JSSubsequentPropertyAccessToDestructuringIntention.isNumericConst(rightAsPrefix.getExpression())) {
            return null;
        }
        JSPrefixExpression leftAsTypeOf = (JSPrefixExpression)ObjectUtils.tryCast((Object)binary.getLOperand(), JSPrefixExpression.class);
        JSReferenceExpression leftAsReference = (JSReferenceExpression)ObjectUtils.tryCast((Object)binary.getLOperand(), JSReferenceExpression.class);
        if ((leftAsTypeOf == null || leftAsTypeOf.getOperationSign() != JSTokenTypes.TYPEOF_KEYWORD) && leftAsReference == null) {
            return null;
        }
        JSReferenceExpression expression = null;
        if (leftAsTypeOf != null && rightAsLiteral != null) {
            expression = (JSReferenceExpression)ObjectUtils.tryCast((Object)JSUtils.unparenthesize(leftAsTypeOf.getExpression()), JSReferenceExpression.class);
        }
        if (leftAsReference != null && (rightAsReference != null || rightAsPrefix != null)) {
            expression = leftAsReference;
        }
        if (expression == null) {
            return null;
        }
        JSExpression defaultValueBranch = isNegativeCondition ? ternaryExpression.getElse() : ternaryExpression.getThen();
        JSReferenceExpression assignedValueBranch = (JSReferenceExpression)ObjectUtils.tryCast((Object)(isNegativeCondition ? ternaryExpression.getThen() : ternaryExpression.getElse()), JSReferenceExpression.class);
        if (defaultValueBranch == null || assignedValueBranch == null) {
            return null;
        }
        if (expression.getQualifier() == null || assignedValueBranch.getQualifier() == null) {
            return null;
        }
        if (!JSSubsequentPropertyAccessToDestructuringIntention.areNodesEquivalent(expression, assignedValueBranch)) {
            return null;
        }
        return assignedValueBranch.getQualifier();
    }

    private static boolean areNodesEquivalent(JSReferenceExpression expression, JSReferenceExpression branch) {
        JSReferenceExpression expr1 = expression;
        JSReferenceExpression expr2 = branch;
        do {
            String name2;
            String name1;
            if (!Objects.equals(name1 = expr1.getText(), name2 = expr2.getText())) {
                return false;
            }
            expr1 = expr1 instanceof JSReferenceExpression ? expr1.getQualifier() : null;
            JSExpression jSExpression = expr2 = expr2 instanceof JSReferenceExpression ? expr2.getQualifier() : null;
            if (expr1 != null || expr2 != null) continue;
            return true;
        } while (expr1 != null && expr2 != null);
        return false;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"refactoring.destructuring.vars.intention.replace.object", (Object[])new Object[0]);
        if (string == null) {
            JSSubsequentPropertyAccessToDestructuringIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSSubsequentPropertyAccessToDestructuringIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JSSubsequentPropertyAccessToDestructuringIntention.$$$reportNull$$$0(4);
        }
        return super.isAvailable(project, editor, element) && this.checkAvailable((JSExpression)JSSubsequentPropertyAccessToDestructuringIntention.findExpression(element, e -> JSSubsequentPropertyAccessToDestructuringIntention.findReference(e)), project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/destructuring/JSSubsequentPropertyAccessToDestructuringIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/destructuring/JSSubsequentPropertyAccessToDestructuringIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

