/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsqtProcessOutputViewer {
    private JsqtProcessOutputViewer() {
    }

    public static void show(@NotNull Project project, @NotNull String title, @Nullable Icon icon, @Nullable GeneralCommandLine commandLine, @Nullable ProcessHandler handler, @NotNull ProcessOutput output) {
        if (project == null) {
            JsqtProcessOutputViewer.$$$reportNull$$$0(0);
        }
        if (title == null) {
            JsqtProcessOutputViewer.$$$reportNull$$$0(1);
        }
        if (output == null) {
            JsqtProcessOutputViewer.$$$reportNull$$$0(2);
        }
        RunContentManager runContentManager = RunContentManager.getInstance((Project)project);
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        RunContentDescriptor descriptor2 = JsqtProcessOutputViewer.createDescriptor(project, title, icon, commandLine, handler, output, executor);
        runContentManager.showRunContent(executor, descriptor2);
    }

    @NotNull
    private static RunContentDescriptor createDescriptor(@NotNull Project project, @NotNull String title, @Nullable Icon icon, @Nullable GeneralCommandLine commandLine, @Nullable ProcessHandler handler, @NotNull ProcessOutput output, @NotNull Executor executor) {
        if (project == null) {
            JsqtProcessOutputViewer.$$$reportNull$$$0(3);
        }
        if (title == null) {
            JsqtProcessOutputViewer.$$$reportNull$$$0(4);
        }
        if (output == null) {
            JsqtProcessOutputViewer.$$$reportNull$$$0(5);
        }
        if (executor == null) {
            JsqtProcessOutputViewer.$$$reportNull$$$0(6);
        }
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        if (commandLine != null) {
            consoleBuilder.filters(new Filter[]{new NodeStackTraceFilter(project, commandLine.getWorkDirectory())});
        }
        ConsoleView view = consoleBuilder.getConsole();
        if (handler != null && !handler.isProcessTerminated()) {
            view.attachToProcess(handler);
            ProcessTerminatedListener.attach((ProcessHandler)handler);
        }
        JsqtProcessOutputViewer.fillContents(view, commandLine, handler, output);
        DefaultActionGroup actions = new DefaultActionGroup();
        AnAction stopAction = ActionManager.getInstance().getAction("Stop");
        if (stopAction != null) {
            actions.add(stopAction);
        }
        JPanel result2 = JsqtProcessOutputViewer.createPanel(view, actions);
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)view, handler, (JComponent)result2, title, icon);
        actions.addAll(view.createConsoleActions());
        actions.add((AnAction)new CloseAction(executor, descriptor2, project));
        RunContentDescriptor runContentDescriptor = descriptor2;
        if (runContentDescriptor == null) {
            JsqtProcessOutputViewer.$$$reportNull$$$0(7);
        }
        return runContentDescriptor;
    }

    private static void fillContents(@NotNull ConsoleView view, @Nullable GeneralCommandLine commandLine, @Nullable ProcessHandler handler, @NotNull ProcessOutput output) {
        if (view == null) {
            JsqtProcessOutputViewer.$$$reportNull$$$0(8);
        }
        if (output == null) {
            JsqtProcessOutputViewer.$$$reportNull$$$0(9);
        }
        if (commandLine != null) {
            view.print(commandLine.getCommandLineString(), ConsoleViewContentType.SYSTEM_OUTPUT);
            view.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        String stdout = output.getStdout();
        String stderr = output.getStderr();
        view.print(stdout, ConsoleViewContentType.NORMAL_OUTPUT);
        if (!(stdout.isEmpty() || stderr.isEmpty() || stdout.endsWith("\n"))) {
            view.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        view.print(stderr, ConsoleViewContentType.ERROR_OUTPUT);
        if (handler == null || handler.isProcessTerminated()) {
            view.print("\nProcess finished with exit code " + output.getExitCode() + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    @NotNull
    private static JPanel createPanel(@NotNull ConsoleView view, @NotNull DefaultActionGroup actions) {
        if (view == null) {
            JsqtProcessOutputViewer.$$$reportNull$$$0(10);
        }
        if (actions == null) {
            JsqtProcessOutputViewer.$$$reportNull$$$0(11);
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)view.getComponent(), "Center");
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("JsqtProcessOutputViewer", (ActionGroup)actions, false);
        panel2.add((Component)actionToolbar.getComponent(), "West");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            JsqtProcessOutputViewer.$$$reportNull$$$0(12);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JsqtProcessOutputViewer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 7: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillContents";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

