/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.eslint.EslintError;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintFixSingleErrorAction
extends BaseIntentionAction
implements HighPriorityAction {
    @NotNull
    private final EslintError myError;
    private final long myModificationStamp;
    private final String myToolName;
    private final SmartPsiElementPointer<PsiFile> myPsiFilePointer;

    public EslintFixSingleErrorAction(@NotNull PsiFile file2, @NotNull EslintError error, String toolName, long modificationStamp) {
        if (file2 == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(0);
        }
        if (error == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(1);
        }
        this.myPsiFilePointer = SmartPointerManager.getInstance((Project)file2.getProject()).createSmartPsiElementPointer((PsiElement)file2);
        this.myError = error;
        this.myToolName = toolName;
        this.myModificationStamp = modificationStamp;
    }

    @NotNull
    public String getText() {
        return EslintFixSingleErrorAction.getText(this.myToolName, this.myError.getCode());
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return EslintFixSingleErrorAction.getText(this.myToolName, null);
    }

    @NotNull
    private static String getText(String toolName, @Nullable String errorCode) {
        String errorMessage = StringUtil.isNotEmpty((String)errorCode) ? "'" + errorCode + "'" : "current error";
        String string = JavaScriptBundle.message((String)"eslint.fix.problems.text", (Object[])new Object[]{toolName, errorMessage});
        if (string == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(3);
        }
        return editor != null && editor.getDocument().getModificationStamp() == this.myModificationStamp && this.myError.getFixInfo() != null && file2 == this.myPsiFilePointer.getElement() && !StringUtil.equals((CharSequence)this.myError.getCode(), (CharSequence)"linebreak-style");
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(4);
        }
        if (!this.isAvailable(project, editor, file2)) {
            return;
        }
        EslintError.FixInfo info = this.myError.getFixInfo();
        if (info == null) {
            return;
        }
        Document document2 = editor.getDocument();
        String separator = FileDocumentManager.getInstance().getLineSeparator(file2.getViewProvider().getVirtualFile(), project);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getText(), null, () -> EslintFixSingleErrorAction.applyReplacement(document2, separator, info), (PsiFile[])new PsiFile[0]);
        DaemonCodeAnalyzer.getInstance((Project)project).restart(file2);
    }

    private static void applyReplacement(@NotNull Document document2, @NotNull String separator, @NotNull EslintError.FixInfo fixInfo) {
        String lf;
        if (document2 == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(5);
        }
        if (separator == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(6);
        }
        if (fixInfo == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(7);
        }
        if ((lf = LineSeparator.LF.getSeparatorString()).equals(separator)) {
            document2.replaceString(fixInfo.start, fixInfo.end, (CharSequence)fixInfo.text);
        } else {
            StringBuilder result2 = new StringBuilder(StringUtil.convertLineSeparators((String)document2.getText(), (String)separator));
            result2.replace(fixInfo.start, fixInfo.end, fixInfo.text);
            document2.setText((CharSequence)StringUtilRt.convertLineSeparators((String)result2.toString(), (String)lf));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintFixSingleErrorAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintFixSingleErrorAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyReplacement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

