/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSArrayLiteralExpressionStub;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import java.util.Iterator;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSArrayLiteralExpressionImpl
extends JSStubElementImpl<JSArrayLiteralExpressionStub>
implements JSArrayLiteralExpression,
StubBasedPsiElement<JSArrayLiteralExpressionStub> {
    private static final Key<Integer> INDEX_IN_ARRAY = Key.create((String)"index.array");

    public JSArrayLiteralExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSArrayLiteralExpressionImpl(JSArrayLiteralExpressionStub stub) {
        super(stub, (IStubElementType)JSStubElementTypes.ARRAY_LITERAL_EXPRESSION);
    }

    public JSExpression @NotNull [] getExpressions() {
        JSExpression[] jSExpressionArray = (JSExpression[])this.getExpressionStream().toArray(JSExpression[]::new);
        if (jSExpressionArray == null) {
            JSArrayLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        return jSExpressionArray;
    }

    @NotNull
    public StreamEx<JSExpression> getExpressionStream() {
        return JSArrayLiteralExpressionImpl.getExpressionStream((PsiElement)this, JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
    }

    public final int indexOf(@Nullable JSExpression expression) {
        if (expression == null) {
            return -1;
        }
        if (expression.getParent() != this) {
            return -1;
        }
        Integer data = (Integer)expression.getUserData(INDEX_IN_ARRAY);
        if (data != null) {
            return data;
        }
        return (int)this.getExpressionStream().indexOf((Object)expression).orElse(-1L);
    }

    @NotNull
    public static <T extends PsiElement> StreamEx<T> getExpressionStream(@NotNull PsiElement context, @NotNull TokenSet tokenSet) {
        if (context == null) {
            JSArrayLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        if (tokenSet == null) {
            JSArrayLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        StreamEx streamEx = StreamEx.of(JSArrayLiteralExpressionImpl.getIterator(context, tokenSet));
        if (streamEx == null) {
            JSArrayLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        return streamEx;
    }

    @NotNull
    private static <T extends PsiElement> Iterator<T> getIterator(@NotNull PsiElement context, @NotNull TokenSet tokenSet) {
        if (context == null) {
            JSArrayLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        if (tokenSet == null) {
            JSArrayLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        return new ExpressionsIterator(context, tokenSet);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSArrayLiteralExpressionImpl.$$$reportNull$$$0(6);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSArrayLiteralExpression((JSArrayLiteralExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSArrayLiteralExpressionImpl.$$$reportNull$$$0(7);
        }
        PsiElement elt = super.addBefore(element, anchor);
        this.addCommaIfNeeded(elt);
        return elt;
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSArrayLiteralExpressionImpl.$$$reportNull$$$0(8);
        }
        PsiElement elt = super.addAfter(element, anchor);
        this.addCommaIfNeeded(elt);
        return elt;
    }

    private void addCommaIfNeeded(@Nullable PsiElement elt) {
        if (!(elt instanceof JSExpression)) {
            return;
        }
        JSChangeUtil.addCommaIfNeeded(elt, JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, (x$0, x$1) -> super.addBefore((PsiElement)x$0, (PsiElement)x$1), (x$0, x$1) -> super.addAfter((PsiElement)x$0, (PsiElement)x$1));
    }

    public JSExpression replace(JSExpression other) {
        return JSChangeUtil.replaceExpression((JSExpression)this, other);
    }

    public boolean isEmpty() {
        return !JSArrayLiteralExpressionImpl.getIterator((PsiElement)this, JSExtendedLanguagesTokenSetProvider.EXPRESSIONS).hasNext();
    }

    public static boolean shouldCreateStub(ASTNode node) {
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions(node)) {
            if (!handler.shouldCreateStubForArrayLiteral(node)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSArrayLiteralExpressionImpl";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSArrayLiteralExpressionImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionStream";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionStream";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIterator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ExpressionsIterator<T extends PsiElement>
    implements Iterator<T> {
        private final TokenSet myTokenSet;
        private ASTNode nextResult;
        int index;

        ExpressionsIterator(@NotNull PsiElement context, @NotNull TokenSet tokenSet) {
            if (context == null) {
                ExpressionsIterator.$$$reportNull$$$0(0);
            }
            if (tokenSet == null) {
                ExpressionsIterator.$$$reportNull$$$0(1);
            }
            this.index = 0;
            this.myTokenSet = tokenSet;
            this.nextResult = this.skipElements(context.getNode().getFirstChildNode());
        }

        @Override
        public boolean hasNext() {
            return this.nextResult != null;
        }

        @Override
        public T next() {
            ProgressManager.checkCanceled();
            assert (this.myTokenSet.contains(this.nextResult.getElementType()));
            ASTNode result2 = this.nextResult;
            this.nextResult = this.skipElements(this.nextResult.getTreeNext());
            PsiElement psi = result2.getPsi();
            if (psi != null) {
                psi.putUserData(INDEX_IN_ARRAY, (Object)this.index++);
            }
            return (T)psi;
        }

        @Nullable
        private ASTNode skipElements(@Nullable ASTNode child) {
            while (child != null && !this.isAcceptableToken(child)) {
                child = child.getTreeNext();
            }
            return child;
        }

        private boolean isAcceptableToken(@NotNull ASTNode child) {
            if (child == null) {
                ExpressionsIterator.$$$reportNull$$$0(2);
            }
            return this.myTokenSet.contains(child.getElementType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenSet";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSArrayLiteralExpressionImpl$ExpressionsIterator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAcceptableToken";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

