/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferenceCache;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.amd.JSAmdModulesIndex;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.frameworks.gcl.JSGclModuleReference;
import com.intellij.lang.javascript.frameworks.gcl.JSGclReferenceContributor;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.index.JSLocalTypeEvaluatorBase;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSEmptyExpression;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReferenceItem;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeInfoOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSThisExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSComplexityAwareRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationHelper;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationResultProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextUtil;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyDestructuringPropertyElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyElvisContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessToDestructuringElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessToTypeElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyStaticContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSUnwrapPromiseTypeElement;
import com.intellij.lang.javascript.psi.resolve.context.JSWrapInPromiseTypeElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptMergedTypeImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSForInStringType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionReturnWrapperType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyIndexedAccessType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyNewType;
import com.intellij.lang.javascript.psi.types.evaluable.JSBestChoiceTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSNumericIndexerAccessType;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReturnedExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSStubBasedExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSThisType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.psi.util.SoftlyCachedValue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.ReplaceWith;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeEvaluator {
    protected static final PsiElement EXPLICIT_TYPE_MARKER_ELEMENT = PsiUtilCore.NULL_PSI_ELEMENT;
    private static final ThreadLocal<JSEvaluatorComplexityTracker> ourComplexityTracker = ThreadLocal.withInitial(JSEvaluatorComplexityTracker::new);
    private static final JSComplexityAwareRecursionGuard<JSEvaluationKey> ourRecursionGuard = new JSComplexityAwareRecursionGuard("js.type.evaluator");
    private static final Map<Thread, JSEvaluatorComplexityTracker> ourTestComplexityTracker = new ConcurrentHashMap<Thread, JSEvaluatorComplexityTracker>();
    private static volatile int ourTestMaxComplexity = new JSEvaluatorComplexityTracker().getComplexityLeft();
    public static final int MAX_RESOLVE_RESULT_COUNT_TO_EVALUATE = 20;
    private static final int MAX_MODULES_TO_EVALUATE = JSUtils.getSystemPropertySafely("idea.javascript.max.modules.to.process", 10);
    private static final Key<SoftlyCachedValue<JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<JSTypeEvaluationResult>>> CACHE_KEY_EXPRESSION_TYPE = Key.create((String)"js.evaluator.expression.type");
    private static final Key<SoftlyCachedValue<JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<JSTypeEvaluationResult>>> CACHE_KEY_CONTEXTUAL_EXPRESSION_TYPE = Key.create((String)"js.contextual.evaluator.expression.type");
    private static final Function<PsiElement, JSTypeEvaluationResult> CACHE_PROVIDER_EXPRESSION_TYPE = param -> {
        JSTypeEvaluationResultProcessor typeProcessor = new JSTypeEvaluationResultProcessor();
        PsiFile targetFile = param.getContainingFile();
        JSTypeEvaluator.doEvaluateExpressionOrElementTypes(targetFile, typeProcessor, param);
        return typeProcessor.getResult();
    };
    private static final Function<PsiElement, JSTypeEvaluationResult> CACHE_PROVIDER_CONTEXTUAL_EXPRESSION_TYPE = param -> {
        JSTypeEvaluationResultProcessor typeProcessor = new JSTypeEvaluationResultProcessor();
        JSTypeEvaluator typeEvaluator = JSTypeEvaluator.createEvaluator(param.getContainingFile(), (JSTypeProcessor)typeProcessor, param, true);
        if (param instanceof JSExpression) {
            typeEvaluator.doEvaluateTypes((JSExpression)param);
        }
        return typeProcessor.getResult();
    };
    private static final String JQUERY_NS = "jQuery";
    protected final JSEvaluateContext myContext;
    @NotNull
    protected final JSTypeProcessorWrapper myTypeProcessor;
    protected final JSTypeEvaluationHelper myHelper;
    private static final Predicate<JSInitializerOwner> WITH_TYPE_DECLARATION_PREDICATE = owner -> owner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)owner).getTypeElement() != null;

    @java.lang.Deprecated
    protected JSTypeEvaluator(@NotNull JSEvaluateContext context, @NotNull JSTypeProcessor processor) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(1);
        }
        this(context, processor, JSTypeEvaluationHelper.DEFAULT);
    }

    protected JSTypeEvaluator(@NotNull JSEvaluateContext context, @NotNull JSTypeProcessor processor, @NotNull JSTypeEvaluationHelper helper) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(3);
        }
        if (helper == null) {
            JSTypeEvaluator.$$$reportNull$$$0(4);
        }
        this.myContext = context;
        this.myTypeProcessor = new JSTypeProcessorWrapper(processor);
        this.myHelper = helper;
    }

    @Nullable
    public static JSType forceEvaluateType(@NotNull PsiElement target, @NotNull JSExpression expr, @NotNull PsiFile targetFile) {
        if (target == null) {
            JSTypeEvaluator.$$$reportNull$$$0(5);
        }
        if (expr == null) {
            JSTypeEvaluator.$$$reportNull$$$0(6);
        }
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(7);
        }
        JSSimpleTypeProcessor typeProcessor = new JSSimpleTypeProcessor(target);
        JSTypeEvaluator.processWithEvaluationGuard((PsiElement)expr, () -> {
            JSTypeEvaluator.doEvaluateExpressionOrElementTypes(targetFile, typeProcessor, (PsiElement)expr);
            return null;
        });
        return typeProcessor.getType();
    }

    public static void evaluateTypes(@NotNull JSExpression expr, @NotNull JSTypeProcessor typeProcessor) {
        if (expr == null) {
            JSTypeEvaluator.$$$reportNull$$$0(8);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(9);
        }
        JSTypeEvaluator.evaluateExpressionOrElementTypes(expr.getContainingFile(), typeProcessor, (PsiElement)expr);
    }

    public static void evaluateTypes(@NotNull JSExpression expr, @NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor) {
        if (expr == null) {
            JSTypeEvaluator.$$$reportNull$$$0(10);
        }
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(11);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(12);
        }
        JSTypeEvaluator.evaluateExpressionOrElementTypes(targetFile, typeProcessor, (PsiElement)expr);
    }

    public static void evaluateExpressionOrElementTypes(@NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor, @NotNull PsiElement element) {
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(13);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(14);
        }
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(15);
        }
        JSTypeEvaluator.processWithEvaluationGuard(element, () -> {
            if (element instanceof JSExpression) {
                JSTypeEvaluator typeEvaluator = JSTypeEvaluator.createEvaluator(targetFile, typeProcessor, element, false);
                typeEvaluator.evaluateTypes((JSExpression)element);
            } else {
                JSTypeEvaluator.doEvaluateExpressionOrElementTypes(targetFile, typeProcessor, element);
            }
            return null;
        });
    }

    private static void doEvaluateExpressionOrElementTypes(@NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor, @NotNull PsiElement element) {
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(16);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(17);
        }
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(18);
        }
        JSTypeEvaluator typeEvaluator = JSTypeEvaluator.createEvaluator(targetFile, typeProcessor, element, false);
        if (element instanceof JSExpression) {
            typeEvaluator.doEvaluateTypes((JSExpression)element);
        } else if (element instanceof JSDestructuringContainer) {
            typeEvaluator.evaluateDestructuringContainer((JSDestructuringContainer)element);
        } else {
            typeEvaluator.addTypeFromResolveResult(element);
        }
    }

    private static JSTypeEvaluator createEvaluator(@NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor, @NotNull PsiElement element, boolean contextualOverrideEvaluation) {
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(19);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(20);
        }
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(21);
        }
        JSEvaluateContext context = new JSEvaluateContext(targetFile, contextualOverrideEvaluation);
        return JSTypeEvaluator.createEvaluator(targetFile, typeProcessor, element, context);
    }

    @NotNull
    public static JSTypeEvaluator createEvaluator(@NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor, @NotNull PsiElement element, @NotNull JSEvaluateContext context) {
        Language fileLanguage;
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(22);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(23);
        }
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(24);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(25);
        }
        JSTypeEvaluator jSTypeEvaluator = ((fileLanguage = DialectDetector.languageOfElement((PsiElement)targetFile)) instanceof JSLanguageDialect ? JSDialectSpecificHandlersFactory.forLanguage(fileLanguage) : JSDialectSpecificHandlersFactory.forElement(element)).newTypeEvaluator(context, typeProcessor);
        if (jSTypeEvaluator == null) {
            JSTypeEvaluator.$$$reportNull$$$0(26);
        }
        return jSTypeEvaluator;
    }

    @Nullable
    public static JSTypeEvaluationResult getExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(27);
        }
        return JSTypeEvaluator.getElementType((PsiElement)expression, false);
    }

    @Nullable
    public static JSTypeEvaluationResult getElementType(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(28);
        }
        return JSTypeEvaluator.getElementType(element, false);
    }

    @Nullable
    public static JSTypeEvaluationResult getElementType(@NotNull PsiElement element, boolean isContextual) {
        Function<PsiElement, JSTypeEvaluationResult> provider;
        Key<SoftlyCachedValue<JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<JSTypeEvaluationResult>>> key;
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(29);
        }
        if (isContextual) {
            key = CACHE_KEY_CONTEXTUAL_EXPRESSION_TYPE;
            provider = CACHE_PROVIDER_CONTEXTUAL_EXPRESSION_TYPE;
        } else {
            key = CACHE_KEY_EXPRESSION_TYPE;
            provider = CACHE_PROVIDER_EXPRESSION_TYPE;
        }
        JSEvaluationKey node = new JSEvaluationKey(element, isContextual, provider.getClass());
        Supplier getCachedValue = () -> {
            JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue prevValue;
            SoftlyCachedValue prevCachedValue = (SoftlyCachedValue)element.getUserData(key);
            if (prevCachedValue != null && (prevValue = (JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue)prevCachedValue.getUpToDateOrNull()) != null) {
                return prevValue;
            }
            return null;
        };
        Consumer cacheNewValue = it -> element.putUserData(key, new SoftlyCachedValue<JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue>((JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue)it, (ModificationTracker)PsiModificationTracker.SERVICE.getInstance((Project)element.getProject())));
        return ourRecursionGuard.getCachedValue(node, JSTypeEvaluator.getComplexityTracker(), getCachedValue, cacheNewValue, p -> (JSTypeEvaluationResult)provider.apply(p.myElement));
    }

    @Nullable
    public static JSTypeEvaluationResult getContextualType(@NotNull JSExpression element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(30);
        }
        return JSTypeEvaluator.getElementType((PsiElement)element, true);
    }

    private void addTypeEvaluationResultElement(@NotNull JSTypeEvaluationResult.JSTypeEvaluationResultElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(31);
        }
        JSReferenceExpression originalExpression = this.myContext.getProcessedExpression();
        PsiElement originalSource = this.myContext.getSource();
        this.myContext.withCombinedContext(element.getEvaluationContext(), () -> {
            PsiElement source = element.getSource();
            if (element.getNamespace() != null) {
                JSTypeEvaluator.applyContextAndProcessNamespace(element.getNamespace(), this.myContext, source, this.myTypeProcessor);
                return;
            }
            JSType guardedType = this.myHelper.getGuardedTypeByEvaluateContext(element.getType(), this.myContext, originalSource, originalExpression);
            if (guardedType != null) {
                this.applyContextAndProcess(guardedType, source);
            } else {
                assert (source != null);
                if (element.isForUnknownElement()) {
                    this.myTypeProcessor.setUnknownElement(source);
                } else {
                    this.applyContextAndProcessResolvedElement(source);
                }
            }
        });
    }

    public void addType(@Nullable JSType type, @Nullable PsiElement source) {
        this.addType(type, source, false);
    }

    public void addType(@Nullable JSType type, @Nullable PsiElement source, boolean skipGuard) {
        JSType jSType = type = skipGuard ? type : this.myHelper.getGuardedTypeByEvaluateContext(type, this.myContext, source);
        if (type == null) {
            return;
        }
        this.doAddType(type, source);
    }

    protected void doAddType(@NotNull JSType type, @Nullable PsiElement source) {
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(32);
        }
        this.addAdditionalTypesForType(type);
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            if (handler.processTypeBeforeAdd(type, this.myContext, this.myTypeProcessor)) continue;
            return;
        }
        JSType unwrappedType = JSTypeUtils.unwrapDecorations(type);
        if (this.addEvaluableOnlyType(unwrappedType, source)) {
            return;
        }
        Collection<PsiElement> referencedJSDocModules = CommonJSUtil.resolveJSDocCommentModules(unwrappedType, null);
        for (PsiElement module : referencedJSDocModules) {
            if (!(module instanceof JSFile)) continue;
            JSTypeEvaluator.processWithEvaluationGuard(module, () -> {
                this.addTypeFromExternalModuleReferenceResolveResult(module);
                return null;
            });
        }
        this.applyContextAndProcess(type, source);
    }

    private void applyContextAndProcess(@NotNull JSType type, @Nullable PsiElement source) {
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(33);
        }
        if (type instanceof JSEvaluableType) {
            type = type.substitute();
        }
        if (!this.myContext.isJSElementsToApplyEmpty()) {
            JSApplyContextElement pop = this.myContext.popJSElementToApply();
            JSType resultType = JSApplyContextUtil.applyContextElementToType(type, pop);
            if (resultType != null) {
                resultType = this.myHelper.getGuardedTypeByEvaluateContext(resultType, this.myContext, source);
                this.doAddType(resultType, source);
            }
            this.myContext.pushJSElementToApply(pop);
            return;
        }
        type = this.myHelper.getGenericTypeEvaluator().evaluateGenerics(type, (JSExpression)this.myContext.getProcessedExpression(), null);
        if (!this.myContext.isStrict() && type.getSource().isStrict()) {
            type = JSTypeUtils.copyWithStrictRecursive(type, false);
        }
        if ((type = JSCompositeTypeImpl.optimizeTypeForSubstitute(type, (PsiElement)this.myContext.getProcessedExpression())) instanceof JSFreshObjectLiteralType && this.myContext.getSource() instanceof JSVariable) {
            type = ((JSFreshObjectLiteralType)type).removeFreshness();
        }
        this.myTypeProcessor.process(type, this.myContext, source);
    }

    private boolean addEvaluableOnlyType(@NotNull JSType type, @Nullable PsiElement source) {
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(34);
        }
        if (type instanceof JSRequireCallExpressionType) {
            Collection<PsiElement> elements;
            String referencedModule = ((JSRequireCallExpressionType)type).resolveReferencedModule();
            PsiFile scope = ((JSRequireCallExpressionType)type).getScope();
            if (scope != null && !(elements = JSFileReferenceCache.getInstance(scope.getProject()).resolveModuleReference((PsiElement)scope, referencedModule, false)).isEmpty()) {
                JSTypeEvaluator.getComplexityTracker().runTasks(elements, false, element -> this.processItem((PsiElement)element, () -> this.addTypeFromExternalModuleReferenceResolveResult((PsiElement)element)));
                return true;
            }
        } else {
            if (type instanceof JSApplyNewType) {
                JSType baseType = ((JSApplyNewType)type).getBaseType();
                this.myContext.processWithJSElementToApply(new JSApplyInstanceContextElement((JSCallItem)type), () -> this.addType(baseType, source));
                return true;
            }
            if (type instanceof JSApplyCallType) {
                JSTypeEvaluator.getComplexityTracker().runTask(() -> {
                    JSType baseType = ((JSApplyCallType)type).getBaseType();
                    JSType substitute = baseType instanceof JSEvaluableOnlyType ? baseType.substitute() : baseType;
                    this.addReturnType(substitute, (JSApplyCallType)type, source);
                    return true;
                });
                return true;
            }
            if (type instanceof JSReferenceType) {
                PsiElement sourceElement = type.getSourceElement();
                if (sourceElement != null) {
                    JSReferenceType referenceType = (JSReferenceType)type;
                    Collection<PsiElement> declarations = referenceType.getDeclarations();
                    if (declarations.size() > 1) {
                        this.myTypeProcessor.setUnknownElement(sourceElement);
                        if (declarations.size() > JSReferenceExpressionResolver.MAX_RESULTS_COUNT_TO_KEEP) {
                            return true;
                        }
                    }
                    AtomicBoolean addedFromResolveResult = new AtomicBoolean(false);
                    JSTypeEvaluator.getComplexityTracker().runTasks(declarations, false, resolvedElement -> {
                        JSNamespace namespace;
                        boolean addedFromCurrentElement = false;
                        if (resolvedElement instanceof JSNamedElement || resolvedElement instanceof ES6ImportExportSpecifier) {
                            if (resolvedElement instanceof JSNamedElement) {
                                this.addTypeFromResolveResult((PsiElement)resolvedElement);
                            } else {
                                ResolveResult[] specifierResults;
                                for (ResolveResult specifierResult : specifierResults = (ResolveResult[])ObjectUtils.notNull((Object)ResolveResultSink.resolveImportExportSpecifiers(resolvedElement), (Object)ResolveResult.EMPTY_ARRAY)) {
                                    PsiElement element = specifierResult.getElement();
                                    if (element == null) continue;
                                    this.addTypeFromResolveResult(element);
                                }
                            }
                            addedFromCurrentElement = true;
                        }
                        if (resolvedElement instanceof JSElementBase && (namespace = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)resolvedElement, false)) != null) {
                            addedFromCurrentElement = true;
                            this.addNamespace(namespace, sourceElement);
                        }
                        if (addedFromCurrentElement) {
                            addedFromResolveResult.set(true);
                        }
                    });
                    if (!addedFromResolveResult.get()) {
                        JSQualifiedNameImpl name = JSQualifiedNameImpl.create(referenceType.getReferenceName(), null);
                        JSNamespace namespace = JSNamedTypeFactory.createNamespace(name, JSContext.STATIC, sourceElement, false, true, false);
                        this.addNamespace(namespace, sourceElement);
                    }
                    return true;
                }
            } else {
                if (type instanceof JSQualifiedReferenceType) {
                    JSQualifiedReferenceType qualifiedReferenceType = (JSQualifiedReferenceType)type;
                    JSType qualifierType = qualifiedReferenceType.getQualifierType();
                    this.myContext.processWithJSElementToApply(new JSApplyPropertyElement(qualifiedReferenceType.getReferenceName()), () -> this.addType(qualifierType, source));
                    if (JSSymbolUtil.isGlobalNamedType(qualifierType)) {
                        this.addType(new JSReferenceType(qualifiedReferenceType.getReferenceName(), type.getSource()), source);
                    }
                    return true;
                }
                if (type instanceof JSNumericIndexerAccessType) {
                    JSNumberLiteralTypeImpl literalType = new JSNumberLiteralTypeImpl(((JSNumericIndexerAccessType)type).getIndex(), false, type.getSource(), String.valueOf(((JSNumericIndexerAccessType)type).getIndex()));
                    this.doAddType(JSCompositeTypeFactory.createIndexedAccessType(((JSNumericIndexerAccessType)type).getQualifierType(), literalType, type.getSource()), source);
                    return true;
                }
                if (type instanceof JSApplyIndexedAccessType) {
                    this.myContext.processWithJSElementToApply(new JSApplyIndexedAccessToTypeElement(((JSApplyIndexedAccessType)type).getArgumentType()), () -> this.addType(((JSApplyIndexedAccessType)type).getQualifierType(), source));
                    return true;
                }
                if (type instanceof JSReturnedExpressionType) {
                    JSExpression expression = ((JSReturnedExpressionType)type).findAssociatedExpression();
                    if (expression != null) {
                        this.evaluateTypes(expression);
                    }
                } else if (type instanceof JSStubBasedExpressionType) {
                    JSExpression expression = ((JSStubBasedExpressionType)type).findAssociatedExpression();
                    if (expression != null) {
                        boolean strict = this.myContext.startEvaluationWithStrictness(!JSTypeEvaluator.isEmptyJSObjectLiteral(expression));
                        this.evaluateTypes(expression);
                        this.myContext.finishEvaluationWithStrictness(strict);
                    }
                } else if (type instanceof JSDestructuringTypeImpl) {
                    JSVariable variable = ((JSDestructuringTypeImpl)type).getVariable();
                    this.processItem((PsiElement)variable, () -> this.addTypeFromVariableResolveResult((JSFieldVariable)variable, null));
                } else {
                    if (type instanceof JSUnionOrIntersectionType) {
                        if (((JSUnionOrIntersectionType)type).getTypes().stream().map(JSTypeUtils::unwrapDecorations).anyMatch(JSEvaluableOnlyType.class::isInstance)) {
                            for (JSType typeOption : ((JSUnionOrIntersectionType)type).getTypes()) {
                                this.doAddType(typeOption, source);
                            }
                            return true;
                        }
                    }
                    if (type instanceof JSFunctionReturnWrapperType || type instanceof JSModuleTypeImpl || type instanceof JSBestChoiceTypeImpl) {
                        this.doAddType(type.substitute(), source);
                        return true;
                    }
                    if (type instanceof JSThisType) {
                        JSReferenceExpression processedExpression = this.myContext.getProcessedExpression();
                        if (processedExpression != null && processedExpression.getParent() instanceof JSCallExpression && !(processedExpression.getParent() instanceof JSNewExpression)) {
                            JSExpression qualifier = processedExpression.getQualifier();
                            if (qualifier == null) {
                                this.addType((JSType)JSNamedTypeFactory.createNamespace(null, type.getSource(), JSTypeContext.STATIC, false), source);
                            } else {
                                this.evaluateTypes(qualifier);
                            }
                        } else {
                            PsiElement sourceElement = type.getSourceElement();
                            if (sourceElement != null) {
                                this.processItem(sourceElement, () -> JSTypeEvaluator.getComplexityTracker().runTask(() -> {
                                    this.addType((JSType)JSContextResolver.resolveContext(sourceElement, this.isAstAccessAllowed(sourceElement)), sourceElement);
                                    return true;
                                }));
                            }
                        }
                    }
                }
            }
        }
        return type instanceof JSEvaluableOnlyType;
    }

    private void addAdditionalTypesForType(@Nullable JSType type) {
        PsiElement element;
        JSType referenceType;
        Object object = type instanceof JSReferenceType || type instanceof JSQualifiedReferenceType ? type : (referenceType = type instanceof JSApplyCallType ? ((JSApplyCallType)type).getBaseType() : null);
        if (referenceType instanceof JSReferenceItem && (element = referenceType.getSourceElement()) != null) {
            JSReferenceItem refType = (JSReferenceItem)referenceType;
            this.addAdditionalTypes(element, refType, refType);
        }
    }

    private void addReturnType(@NotNull JSType functionType, @NotNull JSApplyCallType callItem, @Nullable PsiElement source) {
        JSType returnType;
        if (functionType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(35);
        }
        if (callItem == null) {
            JSTypeEvaluator.$$$reportNull$$$0(36);
        }
        if ((returnType = JSTypeUtils.getReturnType(functionType, callItem)) != null) {
            this.addType(returnType, source);
        } else {
            this.myTypeProcessor.setUnknownElement(callItem.getSourceElement());
        }
    }

    public void addNamespace(@NotNull JSNamespace namespace, @Nullable PsiElement source) {
        if (namespace == null) {
            JSTypeEvaluator.$$$reportNull$$$0(37);
        }
        JSTypeEvaluator.applyContextAndProcessNamespace(namespace, this.myContext, source, this.myTypeProcessor);
    }

    static void applyContextAndProcessNamespace(@NotNull JSNamespace namespace, @NotNull JSEvaluateContext context, @Nullable PsiElement source, @NotNull JSTypeProcessor processor) {
        if (namespace == null) {
            JSTypeEvaluator.$$$reportNull$$$0(38);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(39);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(40);
        }
        List elementsToApply = context.isJSElementsToApplyEmpty() ? ContainerUtil.emptyList() : new SmartList();
        JSNamespace actualNamespace = namespace;
        while (!context.isJSElementsToApplyEmpty() && actualNamespace != null) {
            JSApplyContextElement pop = context.popJSElementToApply();
            elementsToApply.add(pop);
            if (pop instanceof JSApplyPropertyElement) {
                source = null;
            }
            actualNamespace = JSApplyContextUtil.applyContextElementToNamespace(actualNamespace, pop);
        }
        if (actualNamespace != null && context.isJSElementsToApplyEmpty()) {
            processor.processNamespace(actualNamespace, context, source);
        }
        for (int i = elementsToApply.size() - 1; i >= 0; --i) {
            context.pushJSElementToApply((JSApplyContextElement)elementsToApply.get(i));
        }
    }

    private void doEvaluateTypes(JSExpression rawqualifier) {
        JSApplyElvisContextElement elvisContext;
        if (rawqualifier != null && (elvisContext = JSApplyElvisContextElement.getElvisContext(rawqualifier)) != null) {
            this.myContext.processWithJSElementToApply(elvisContext, () -> this.doEvaluateTypesImpl(rawqualifier));
            return;
        }
        this.doEvaluateTypesImpl(rawqualifier);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doEvaluateTypesImpl(@Nullable JSExpression rawqualifier) {
        JSType typecast;
        if (rawqualifier != null && this.isAstAccessAllowed((PsiElement)rawqualifier) && (typecast = this.evaluateTypeFromInlineComment(rawqualifier)) != null) {
            this.addType(typecast, null);
            return;
        }
        if (rawqualifier instanceof JSDefinitionExpression) {
            rawqualifier = ((JSDefinitionExpression)rawqualifier).getExpression();
        }
        if (rawqualifier instanceof JSReferenceExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)rawqualifier;
            if (referenceExpression.getQualifier() == null && rawqualifier.getNode().findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                this.addType(new JSUndefinedType(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true)), (PsiElement)rawqualifier);
                return;
            }
            this.processRefExpr(referenceExpression);
            return;
        }
        if (rawqualifier instanceof JSNewExpression) {
            this.evaluateNewExpressionTypes((JSNewExpression)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSCallExpression) {
            this.evaluateCallExpressionTypes((JSCallExpression)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSPrefixExpression) {
            JSPrefixExpression prefixExpression = (JSPrefixExpression)rawqualifier;
            IElementType sign = prefixExpression.getOperationSign();
            String evaluatedType = null;
            JSType evaluatedJsType = null;
            if (JSTokenTypes.EXCL == sign || JSTokenTypes.DELETE_KEYWORD == sign) {
                evaluatedType = "boolean";
            } else if (JSTokenTypes.PLUS == sign || JSTokenTypes.PLUSPLUS == sign || JSTokenTypes.TILDE == sign || JSTokenTypes.MINUSMINUS == sign || JSTokenTypes.MINUS == sign) {
                if (JSSymbolUtil.isLiteralOrLiteralWithSign((JSExpression)prefixExpression)) {
                    this.addTypeFromLiteralExpression((JSExpression)prefixExpression);
                    return;
                }
                if (!DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    this.addNumericOperatorType(prefixExpression.getExpression(), null, (JSExpression)prefixExpression);
                    return;
                }
                JSType type = this.getExpressionTypeInContext(prefixExpression.getExpression());
                if (type != null) {
                    evaluatedType = type.getTypeText();
                }
            } else if (JSTokenTypes.TYPEOF_KEYWORD == sign) {
                if (!DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                    evaluatedJsType = JSCompositeTypeFactory.createUnionType(typeSource, ContainerUtil.map((Object[])JSCommonTypeNames.TYPEOF_VALUES, v -> new JSStringLiteralTypeImpl((String)v, false, typeSource)));
                } else {
                    evaluatedType = "string";
                }
            } else if (JSTokenTypes.AWAIT_KEYWORD == sign) {
                this.myContext.pushJSElementToApply(JSUnwrapPromiseTypeElement.INSTANCE);
                if (prefixExpression.getExpression() == null) return;
                this.evaluateTypes(prefixExpression.getExpression());
                return;
            }
            if (evaluatedJsType != null) {
                this.addType(evaluatedJsType, (PsiElement)rawqualifier);
                return;
            }
            if (evaluatedType != null) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                JSType type = JSNamedTypeFactory.createType(evaluatedType, source, JSContext.INSTANCE);
                this.addType(type, (PsiElement)rawqualifier);
                return;
            }
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSPostfixExpression) {
            JSPostfixExpression postfixExpression = (JSPostfixExpression)rawqualifier;
            IElementType sign = postfixExpression.getOperationSign();
            if (JSTokenTypes.PLUSPLUS != sign) {
                if (JSTokenTypes.MINUSMINUS != sign) return;
            }
            if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                this.simpleEvalType(rawqualifier, postfixExpression.getExpression());
                return;
            }
            this.addNumericOperatorType(postfixExpression.getExpression(), null, rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)rawqualifier;
            IElementType sign = binaryExpression.getOperationSign();
            JSExpression rOperand = binaryExpression.getROperand();
            JSExpression lOperand = binaryExpression.getLOperand();
            if (lOperand == null) return;
            if (rOperand == null) return;
            this.processBinaryOperation(binaryExpression, sign, lOperand, rOperand);
            return;
        }
        if (rawqualifier instanceof JSLiteralExpression) {
            this.addTypeFromLiteralExpression(rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSArrayLiteralExpression) {
            JSType type;
            JSArrayLiteralExpression literal = (JSArrayLiteralExpression)rawqualifier;
            if (!literal.isEmpty()) {
                type = this.getArrayTypeFromExpressions(literal, literal.getExpressionStream());
            } else {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                type = new JSArrayTypeImpl(JSAnyType.get((PsiElement)rawqualifier, true), typeSource);
            }
            this.addType(type, (PsiElement)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSIndexedPropertyAccessExpression) {
            this.addType(this.getIndexedPropertyAccessType((JSIndexedPropertyAccessExpression)rawqualifier), (PsiElement)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)rawqualifier, this.isAstAccessAllowed((PsiElement)rawqualifier));
            return;
        }
        if (rawqualifier instanceof JSParenthesizedExpression) {
            this.evaluateTypes(((JSParenthesizedExpression)rawqualifier).getInnerExpression());
            return;
        }
        if (rawqualifier instanceof JSThisExpression) {
            this.processThisQualifierExpression((JSThisExpression)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSSuperExpression) {
            JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)rawqualifier);
            this.processSuperQualifierExpression((JSSuperExpression)rawqualifier, jsClass);
            return;
        }
        if (rawqualifier instanceof JSFunctionExpression) {
            this.processFunction((JSFunction)((JSFunctionExpression)rawqualifier));
            return;
        }
        if (rawqualifier instanceof JSConditionalExpression) {
            JSConditionalExpression conditionalExpression = (JSConditionalExpression)rawqualifier;
            JSExpression thenPart = conditionalExpression.getThen();
            JSExpression elsePart = conditionalExpression.getElse();
            JSType thenType = this.getConditionalPartTypeOrAny((JSExpression)conditionalExpression, thenPart);
            JSType elseType = this.getConditionalPartTypeOrAny((JSExpression)conditionalExpression, elsePart);
            if (thenType == null) {
                if (elseType == null) return;
            }
            JSType common = TypeScriptTypeRelations.getBestChoiceType(thenType, elseType, (PsiElement)conditionalExpression);
            this.addType(common, (PsiElement)conditionalExpression);
            return;
        }
        if (rawqualifier instanceof JSEmptyExpression) {
            this.addType(new JSUndefinedType(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, false)), (PsiElement)rawqualifier);
            return;
        }
        if (this.evaluateDialectSpecificTypes(rawqualifier)) return;
        if (rawqualifier == null) return;
        this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
    }

    private void processBinaryOperation(@NotNull JSBinaryExpression binaryExpression, @Nullable IElementType sign, @Nullable JSExpression lOperand, @Nullable JSExpression rOperand) {
        if (binaryExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(41);
        }
        if (sign == JSTokenTypes.AS_KEYWORD) {
            this.resolveAsBinaryOperationExpression((JSExpression)binaryExpression, rOperand);
        } else if (JSTokenTypes.BOOLEAN_RESULT_OPERATIONS.contains(sign)) {
            this.addType(new JSBooleanType(true, JSTypeSourceFactory.createTypeSource((PsiElement)binaryExpression, true), JSTypeContext.INSTANCE), null);
        } else if (JSTokenTypes.ADDITIVE_OPERATIONS.contains(sign) || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign) || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.OROR || sign == JSTokenTypes.QUEST_QUEST || sign == JSTokenTypes.MULTMULT) {
            if (sign == JSTokenTypes.DIV || (sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.MINUS || sign == JSTokenTypes.MULTMULT || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign)) && !DialectDetector.isActionScript((PsiElement)binaryExpression)) {
                this.addNumericOperatorType(lOperand, rOperand, (JSExpression)binaryExpression);
            } else {
                JSType lProcType = JSTypeUtils.getValuableType(this.getExpressionTypeInContext(lOperand));
                JSType rProcType = JSTypeUtils.getValuableType(this.getExpressionTypeInContext(rOperand));
                if (sign == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.QUEST_QUEST) {
                    this.evaluateAndOrOrType((JSExpression)binaryExpression, sign, lProcType, rProcType);
                } else {
                    this.evaluatePlusType(binaryExpression, lProcType, rProcType);
                }
            }
        } else if (JSExtendedLanguagesTokenSetProvider.ASSIGNMENT_OPERATIONS.contains(sign)) {
            JSTypeEvaluationResult result2 = null;
            if (DialectDetector.isActionScript((PsiElement)binaryExpression)) {
                result2 = this.getTypeEvaluationResultInContext(lOperand);
            }
            if (result2 == null) {
                result2 = this.getTypeEvaluationResultInContext(rOperand);
            }
            if (result2 != null) {
                for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : result2.getResults()) {
                    this.addTypeEvaluationResultElement(element);
                }
            } else {
                this.myTypeProcessor.setUnknownElement((PsiElement)binaryExpression);
            }
        } else if (JSTokenTypes.SHIFT_OPERATIONS.contains(sign)) {
            this.simpleEvalType((JSExpression)binaryExpression, lOperand);
        }
    }

    protected JSType evaluateTypeFromInlineComment(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(42);
        }
        return JSDocumentationUtils.findTypeFromInlineComment((PsiElement)rawqualifier);
    }

    private void addNumericOperatorType(@Nullable JSExpression firstOperand, @Nullable JSExpression secondOperand, @NotNull JSExpression evaluatedExpression) {
        if (evaluatedExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(43);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)evaluatedExpression, true);
        JSType expressionType = this.getExpressionTypeInContext(firstOperand);
        if (expressionType instanceof JSBigIntType) {
            this.addType(new JSBigIntType(true, typeSource, JSTypeContext.INSTANCE), null);
        } else {
            JSType otherExpressionType = this.getExpressionTypeInContext(secondOperand);
            if (otherExpressionType instanceof JSBigIntType) {
                this.addType(new JSBigIntType(true, typeSource, JSTypeContext.INSTANCE), null);
            } else {
                this.addType(new JSNumberType(true, typeSource, JSTypeContext.INSTANCE), null);
            }
        }
    }

    protected void evaluatePlusType(@NotNull JSBinaryExpression binaryExpression, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        JSType evaluatedType;
        if (binaryExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(44);
        }
        if ((evaluatedType = JSLocalTypeEvaluatorBase.evaluatePlusForExpandedTypes((PsiElement)binaryExpression, lProcType, rProcType)) != null) {
            this.addType(evaluatedType, (PsiElement)binaryExpression);
        } else {
            this.myTypeProcessor.setUnknownElement((PsiElement)binaryExpression);
        }
    }

    protected void evaluateAndOrOrType(@NotNull JSExpression rawqualifier, @NotNull IElementType sign, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(45);
        }
        if (sign == null) {
            JSTypeEvaluator.$$$reportNull$$$0(46);
        }
        if (lProcType != null) {
            this.addType(lProcType, (PsiElement)rawqualifier);
        }
        if (rProcType != null) {
            this.addType(rProcType, (PsiElement)rawqualifier);
        }
        if (lProcType == null && rProcType == null) {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    @Nullable
    protected JSType getIndexedPropertyAccessType(@NotNull JSIndexedPropertyAccessExpression rawqualifier) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(47);
        }
        return this.addComponentTypeFromArrayExpression((JSExpression)rawqualifier, rawqualifier.getQualifier());
    }

    private void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier) {
        JSClass jsClass;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(48);
        }
        JSClass jSClass = jsClass = JSResolveUtil.ownerHasExplicitThisParameter((JSExpression)rawqualifier) ? null : (JSClass)ObjectUtils.tryCast((Object)JSThisExpressionImpl.resolveThisContext((PsiElement)rawqualifier), JSClass.class);
        if (jsClass != null) {
            JSContext staticOrInstance = JSResolveUtil.calculateStaticFromContext((PsiElement)rawqualifier) ? JSContext.STATIC : JSContext.INSTANCE;
            this.processThisQualifierExpression(rawqualifier, jsClass, staticOrInstance);
        } else {
            PsiElement thisScope = JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)rawqualifier);
            this.processThisQualifierInExecutionScope(rawqualifier, thisScope);
        }
    }

    protected void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier, @NotNull JSClass jsClass, @NotNull JSContext staticOrInstance) {
        String name;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(49);
        }
        if (jsClass == null) {
            JSTypeEvaluator.$$$reportNull$$$0(50);
        }
        if (staticOrInstance == null) {
            JSTypeEvaluator.$$$reportNull$$$0(51);
        }
        if ((name = jsClass.getQualifiedName()) != null) {
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
            this.addType(this.createTypeForThisExpression(staticOrInstance, jsClass, typeSource), (PsiElement)jsClass);
        }
    }

    @NotNull
    protected JSType createTypeForThisExpression(@NotNull JSContext staticOrInstance, @NotNull JSClass jsClass, @NotNull JSTypeSource typeSource) {
        if (staticOrInstance == null) {
            JSTypeEvaluator.$$$reportNull$$$0(52);
        }
        if (jsClass == null) {
            JSTypeEvaluator.$$$reportNull$$$0(53);
        }
        if (typeSource == null) {
            JSTypeEvaluator.$$$reportNull$$$0(54);
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.copyWithJSContext(this.getNamespaceFromQualifiedNamedElement((JSQualifiedNamedElement)jsClass, typeSource.isStrict()), staticOrInstance);
        if (jSNamespace == null) {
            JSTypeEvaluator.$$$reportNull$$$0(55);
        }
        return jSNamespace;
    }

    protected void processThisQualifierInExecutionScope(@NotNull JSThisExpression thisQualifier, PsiElement thisScope) {
        JSType type;
        if (thisQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(56);
        }
        if ((type = JSDocumentationUtils.findContextType(thisScope)) != null) {
            this.addType(type, null);
        } else {
            JSNamespace thisType = JSContextResolver.resolveContext((PsiElement)thisQualifier, this.isAstAccessAllowed((PsiElement)thisQualifier));
            if (thisType != null) {
                this.addType((JSType)thisType, (PsiElement)thisQualifier);
            } else if (thisScope instanceof JSFunctionExpression && thisScope.getParent() instanceof JSArgumentList) {
                JSType funcType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSFunctionExpression)thisScope), this.getContextualExpectedTypeKind());
                if ((funcType = JSTypeUtils.getValuableType(funcType)) instanceof JSFunctionTypeImpl && (thisType = ((JSFunctionTypeImpl)funcType).getThisType()) != null) {
                    this.addType((JSType)thisType, (PsiElement)thisQualifier);
                }
            }
            if (thisType == null) {
                this.myTypeProcessor.setUnknownElement((PsiElement)thisQualifier);
            }
        }
    }

    private void resolveAsBinaryOperationExpression(JSExpression rawqualifier, JSExpression rOperand) {
        JSType type;
        PsiElement resolve;
        boolean isClassCast = false;
        if (rOperand instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)rOperand).resolve()) instanceof JSVariable && (type = ((JSVariable)resolve).getJSType()) instanceof JSNamedType && "Class".equals(type.getTypeText(JSType.TypeTextFormat.SIMPLE))) {
            isClassCast = true;
        }
        if (isClassCast) {
            this.addType(JSAnyType.get((PsiElement)rawqualifier, false), (PsiElement)rawqualifier);
        } else {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rOperand, false);
            this.addType(JSTypeUtils.createType(rOperand.getText(), source), null);
        }
    }

    protected void processSuperQualifierExpression(JSSuperExpression rawqualifier, @Nullable JSClass jsClass) {
        JSClass aClass;
        String name;
        JSClass[] classes;
        if (jsClass != null && (classes = jsClass.getSuperClasses()).length > 0 && (name = (aClass = classes[0]).getQualifiedName()) != null) {
            this.addType(JSNamedTypeFactory.createType(name, JSTypeSourceFactory.createTypeSource((PsiElement)aClass, false), JSContext.UNKNOWN), (PsiElement)aClass);
        }
    }

    @Nullable
    private JSType getConditionalPartTypeOrAny(JSExpression conditionalExpression, JSExpression part) {
        JSType partType = null;
        if (part != null && (partType = this.getExpressionTypeInContext(part)) == null) {
            partType = JSAnyType.get((PsiElement)conditionalExpression, false);
        }
        return partType;
    }

    protected boolean isContextualOverloadEvaluation() {
        return this.myContext.isContextualOverloadEvaluation();
    }

    @Nullable
    protected JSType getExpressionTypeInContext(@Nullable JSExpression toEvaluate) {
        return JSResolveUtil.getElementJSType((PsiElement)toEvaluate, this.isContextualOverloadEvaluation());
    }

    @Nullable
    protected JSType getLazyExpressionTypeInContext(@Nullable JSExpression toEvaluate) {
        if (toEvaluate == null) {
            return null;
        }
        return new JSPsiBasedTypeOfType((PsiElement)toEvaluate, this.isContextualOverloadEvaluation());
    }

    @Nullable
    protected JSTypeEvaluationResult getTypeEvaluationResultInContext(@Nullable JSExpression toEvaluate) {
        return toEvaluate == null ? null : JSTypeEvaluator.getElementType((PsiElement)toEvaluate, this.isContextualOverloadEvaluation());
    }

    @NotNull
    protected JSType getArrayTypeFromExpressions(@NotNull JSArrayLiteralExpression rawQualifier, @NotNull Stream<JSExpression> expressions) {
        if (rawQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(57);
        }
        if (expressions == null) {
            JSTypeEvaluator.$$$reportNull$$$0(58);
        }
        List providers = expressions.map(el -> () -> JSTypeEvaluator.getTypeOrSpread(el, this.getExpressionTypeForArrayLiteral((JSExpression)rawQualifier, (JSExpression)el, null))).collect(Collectors.toList());
        JSType commonType = JSTypeUtils.getCommonType(providers, (PsiElement)rawQualifier, true);
        return new JSArrayTypeImpl(commonType, JSTypeSourceFactory.createTypeSource((PsiElement)rawQualifier, true));
    }

    @Nullable
    protected static JSType getTypeOrSpread(@NotNull JSExpression el, @Nullable JSType type) {
        if (el == null) {
            JSTypeEvaluator.$$$reportNull$$$0(59);
        }
        if (el instanceof JSSpreadExpression) {
            return new JSSpreadTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)el, true), type == null ? JSAnyType.get((PsiElement)el, true) : type);
        }
        return type;
    }

    @Nullable
    protected JSType getExpressionTypeForArrayLiteral(@Nullable JSExpression arrayLiteralExpression, @Nullable JSExpression expression, @Nullable AtomicInteger typesToEvaluateLimit) {
        JSType exprType;
        JSType jSType = expression instanceof JSSpreadExpression ? this.getArrayElementTypeFromSpread((JSSpreadExpression)expression) : (exprType = expression != null ? JSTypeEvaluator.getTypeFromConstant(expression) : this.createNullType(arrayLiteralExpression));
        if (exprType == null && (typesToEvaluateLimit == null || typesToEvaluateLimit.decrementAndGet() >= 0)) {
            exprType = this.getLazyExpressionTypeInContext(expression);
        }
        return exprType;
    }

    @Nullable
    private JSType getArrayElementTypeFromSpread(@NotNull JSSpreadExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(60);
        }
        return this.getExpressionTypeInContext(expression.getExpression());
    }

    @NotNull
    protected JSType createNullType(@Nullable JSExpression rawqualifier) {
        JSType jSType = JSNamedTypeFactory.createType("null", JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true), JSContext.INSTANCE);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(61);
        }
        return jSType;
    }

    protected void addTypeFromLocalName(PsiNamedElement resolveResult) {
        String name = resolveResult.getName();
        if (name != null && DialectDetector.isJavaScript((PsiElement)resolveResult)) {
            JSNamespace ns = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(name, null), JSContext.STATIC, (PsiElement)resolveResult, false, true, true);
            this.addNamespace(ns, (PsiElement)resolveResult);
        }
    }

    protected boolean evaluateDialectSpecificTypes(JSExpression rawqualifier) {
        return false;
    }

    protected void evaluateNewExpressionTypes(JSNewExpression newExpression) {
        JSExpression methodExpr = newExpression.getMethodExpression();
        this.myContext.processWithJSElementToApply(new JSApplyInstanceContextElement((JSCallItem)newExpression), () -> this.evaluateTypes(methodExpr));
    }

    @java.lang.Deprecated
    @Deprecated(message="JSEvaluateContext.JSEvaluationPlace is deprecated", replaceWith=@ReplaceWith(expression="evaluateCallExpressionTypes(callExpression)", imports={}))
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    protected void evaluateCallExpressionTypes(@NotNull JSCallExpression callExpression, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(62);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(63);
        }
        this.evaluateCallExpressionTypes(callExpression);
    }

    protected void evaluateCallExpressionTypes(@NotNull JSCallExpression callExpression) {
        JSClass jsClass;
        JSFunction parentFunction;
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(64);
        }
        if (!this.isAstAccessAllowed((PsiElement)callExpression)) {
            JSExpression methodExpression = callExpression.getStubSafeMethodExpression();
            if (methodExpression != null) {
                JSApplyContextElement applyContextElement = callExpression instanceof JSNewExpression ? new JSApplyInstanceContextElement((JSCallItem)callExpression) : JSApplyCallElement.fromMethodExpressionStubSafe(methodExpression);
                this.getEvaluationContext().processWithJSElementToApply(applyContextElement, () -> this.evaluateTypes(methodExpression));
            }
            return;
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            boolean isTypeScript;
            JSReferenceExpression invoked = (JSReferenceExpression)methodExpression;
            String referencedName = invoked.getReferenceName();
            DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)callExpression);
            boolean bl = isTypeScript = dialect != null && dialect.isTypeScript;
            if ("create".equals(referencedName) && dialect != null && dialect.isJavaScript()) {
                boolean processed = this.processCreateMethodCall(callExpression, invoked);
                if (processed) {
                    return;
                }
            } else if (!isTypeScript && ("apply".equals(referencedName) || "call".equals(referencedName))) {
                methodExpression = this.processApplyOrCallMethodCall(methodExpression, invoked);
            } else if (!isTypeScript && ("reduce".equals(referencedName) || "reduceRight".equals(referencedName))) {
                methodExpression = JSTypeEvaluator.processReduceMethodCall(methodExpression, invoked);
            } else {
                if (this.processRequireMethodCall(callExpression, invoked, isTypeScript)) {
                    return;
                }
                if (JSGclReferenceContributor.isGoogRequireCall(methodExpression)) {
                    this.addTypeFromGclRequireCall(callExpression);
                    return;
                }
            }
        }
        if (methodExpression instanceof JSSuperExpression && !DialectDetector.isTypeScript((PsiElement)callExpression) && (parentFunction = JSPsiImplUtils.getParentFunctionThroughLambdas((PsiElement)methodExpression)) != null && parentFunction.isConstructor() && (jsClass = JSResolveUtil.getClassOfContext((PsiElement)parentFunction)) != null) {
            this.addType(jsClass.getJSType(), (PsiElement)callExpression, true);
        }
        JSApplyContextElement elementToApply = JSApplyContextUtil.fromCallExpression(callExpression, methodExpression);
        JSExpression finalMethodExpression = methodExpression;
        this.myContext.processWithJSElementToApply(elementToApply, () -> this.evaluateTypes(finalMethodExpression));
    }

    private void addTypeFromGclRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(65);
        }
        boolean wasStrict = this.myContext.startEvaluationWithStrictness(DialectDetector.isTypeScript((PsiElement)callExpression));
        boolean resolvedToModule = false;
        JSGclModuleReference reference = JSGclReferenceContributor.getGclModuleReference(callExpression);
        if (reference != null) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = reference.multiResolve(false)) {
                PsiFile file2;
                PsiElement element = result2.getElement();
                if (!(element instanceof JSImplicitElement) || !"gcl".equals(((JSImplicitElement)element).getUserString()) || !((file2 = element.getContainingFile()) instanceof JSFile)) continue;
                resolvedToModule = true;
                this.addTypeFromExternalModuleReferenceResolveResult((PsiElement)file2);
                Collection<JSPsiElementBase> exportsList = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit("exports", file2);
                if (exportsList.size() != 1) continue;
                JSPsiElementBase exportElement = exportsList.iterator().next();
                JSTypeEvaluator.processWithEvaluationGuard((PsiElement)exportElement, () -> {
                    this.addTypeFromResolveResult((PsiElement)exportElement);
                    return null;
                });
            }
            if (!resolvedToModule) {
                JSQualifiedName qName = reference.getQualifiedName();
                JSNamespace namespace = JSNamedTypeFactory.createNamespace(qName, JSContext.STATIC, reference.getElement(), true);
                this.addNamespace(namespace, reference.getElement());
            }
        }
        this.myContext.finishEvaluationWithStrictness(wasStrict);
    }

    protected boolean processRequireMethodCall(@NotNull JSCallExpression callExpression, @NotNull JSReferenceExpression invoked, boolean isTypeScript) {
        Collection<PsiElement> modules;
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(66);
        }
        if (invoked == null) {
            JSTypeEvaluator.$$$reportNull$$$0(67);
        }
        if ((modules = CommonJSUtil.findReferencedModulesIfRequireCall(callExpression)).size() > MAX_MODULES_TO_EVALUATE) {
            Logger.getInstance(JSTypeEvaluator.class).warn("Too many resolved modules (" + modules.size() + ") for " + callExpression.getText());
            this.myTypeProcessor.setUnknownElement((PsiElement)callExpression);
            return false;
        }
        if (!modules.isEmpty()) {
            if (JSAmdPsiUtil.isWithinAmdModule((PsiElement)callExpression)) {
                JSLiteralExpression amdModuleReference = (JSLiteralExpression)callExpression.getArguments()[0];
                boolean result2 = false;
                for (PsiElement module : modules) {
                    result2 |= this.addTypeFromAmdModule(amdModuleReference, module);
                }
                return result2;
            }
            boolean wasStrict = this.myContext.startEvaluationWithStrictness(!isTypeScript);
            this.myContext.processExpression(invoked, JSTypeEvaluator.getComplexityTracker(), modules, this::addModuleFromRequire);
            this.myContext.finishEvaluationWithStrictness(wasStrict);
            return true;
        }
        return false;
    }

    private static JSExpression processReduceMethodCall(JSExpression methodExpression, JSReferenceExpression invoked) {
        Optional first;
        JSExpression qualifier = invoked.getQualifier();
        if (qualifier instanceof JSArrayLiteralExpression && (first = ((JSArrayLiteralExpression)qualifier).getExpressionStream().findFirst()).isPresent()) {
            return (JSExpression)first.get();
        }
        return methodExpression;
    }

    private JSExpression processApplyOrCallMethodCall(@NotNull JSExpression methodExpression, @NotNull JSReferenceExpression invoked) {
        JSExpression qualifier;
        if (methodExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(68);
        }
        if (invoked == null) {
            JSTypeEvaluator.$$$reportNull$$$0(69);
        }
        if ((qualifier = invoked.getQualifier()) != null) {
            Ref referencesLib = Ref.create((Object)false);
            this.processItem((PsiElement)qualifier, () -> {
                ResolveResult[] results;
                for (ResolveResult result2 : results = invoked.multiResolve(false)) {
                    String fileName;
                    PsiElement element = result2.getElement();
                    if (element == null || !"ECMAScript.js2".equals(fileName = element.getContainingFile().getName()) && !JSCorePredefinedLibrariesProvider.isECMAScriptLibraryFileName(fileName)) continue;
                    referencesLib.set((Object)true);
                    break;
                }
            });
            if (((Boolean)referencesLib.get()).booleanValue()) {
                return qualifier;
            }
        }
        return methodExpression;
    }

    private boolean processCreateMethodCall(@NotNull JSCallExpression callExpression, @NotNull JSReferenceExpression invoked) {
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(70);
        }
        if (invoked == null) {
            JSTypeEvaluator.$$$reportNull$$$0(71);
        }
        Ref processed = Ref.create((Object)false);
        this.processItem((PsiElement)invoked, () -> {
            JSType type;
            JSFunctionItem functionItem;
            JSExpression firstArgument;
            JSExpression[] arguments = callExpression.getArguments();
            JSExpression jSExpression = firstArgument = arguments.length > 0 ? arguments[0] : null;
            if (JSSymbolUtil.isAccurateReferenceExpressionName(invoked, "Object", "create")) {
                boolean wasStrict = this.myContext.startEvaluationWithStrictness(false);
                this.evaluateTypes(firstArgument);
                this.myContext.finishEvaluationWithStrictness(wasStrict);
                processed.set((Object)true);
                return;
            }
            boolean hasExplicitReturnType = false;
            PsiElement resolve = invoked.resolve();
            if (resolve != null && (functionItem = JSPsiImplUtils.calculatePossibleFunction(resolve, (PsiElement)invoked, true)) != null && JSTypeUtils.isStrictType(type = functionItem.getReturnType())) {
                hasExplicitReturnType = true;
            }
            if (!hasExplicitReturnType && (firstArgument instanceof JSLiteralExpression && ((JSLiteralExpression)firstArgument).isQuotedLiteral() || firstArgument instanceof JSReferenceExpression)) {
                String typeString;
                String string = typeString = firstArgument instanceof JSReferenceExpression ? JSQualifiedNameImpl.toString(JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)firstArgument))) : ((JSLiteralExpression)firstArgument).getStringValue();
                if (typeString != null) {
                    type = JSNamedTypeFactory.createType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)firstArgument, false), JSTypeContext.UNKNOWN);
                    this.addType(type, (PsiElement)firstArgument);
                }
                processed.set((Object)true);
            }
        });
        return Boolean.TRUE.equals(processed.get());
    }

    private void addModuleFromRequire(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(72);
        }
        JSTypeEvaluator.processWithEvaluationGuard(element, () -> {
            this.addTypeFromExternalModuleReferenceResolveResult(element, true);
            return null;
        });
    }

    protected final void addTypeFromExternalModuleReferenceResolveResult(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        this.addTypeFromExternalModuleReferenceResolveResult(element, false);
    }

    public void addTypeFromExternalModuleReferenceResolveResult(@NotNull PsiElement resolve, boolean fromRequire) {
        if (resolve == null) {
            JSTypeEvaluator.$$$reportNull$$$0(73);
        }
        if (resolve instanceof JSFile) {
            JSReferenceExpression place = this.myContext.getProcessedExpression();
            PsiFile placeFile = place != null ? place.getContainingFile() : null;
            boolean isEs6Module = placeFile instanceof JSFile && !((JSFile)placeFile).hasES6Syntax();
            this.addTypeFromModuleFile((JSFile)resolve, isEs6Module && (DialectDetector.isJavaScript((PsiElement)place) || fromRequire));
        } else if (resolve instanceof JsonFile) {
            this.applyContextAndProcessResolvedElement(resolve);
        } else if (resolve instanceof StylesheetFile) {
            this.myTypeProcessor.processResolvedElement(resolve, this.myContext);
        } else {
            this.addTypeFromResolveResult(resolve);
        }
    }

    protected void addTypeFromModuleFile(@NotNull JSFile jsFile, boolean contextAllowsProcessingDefaultExport) {
        if (jsFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(74);
        }
        boolean processDefaultExportForLegacyCompatibility = contextAllowsProcessingDefaultExport;
        if (contextAllowsProcessingDefaultExport) {
            processDefaultExportForLegacyCompatibility = jsFile.hasES6Syntax();
        }
        this.applyContextAndProcessResolvedElement((PsiElement)jsFile);
        Collection<? extends PsiElement> exportedElements = Collections.unmodifiableCollection(JSResolveUtil.getExportedElements(jsFile));
        if (exportedElements.isEmpty() && processDefaultExportForLegacyCompatibility) {
            JSElement defaultExport = ES6PsiUtil.findDefaultExport((PsiElement)jsFile);
            if (defaultExport instanceof ES6ExportDefaultAssignment) {
                PsiElement resolvedExportAssignment = JSTypeEvaluator.resolveExportAssignmentLocally((JSExportAssignment)defaultExport);
                if (resolvedExportAssignment != null) {
                    exportedElements = Collections.singleton(resolvedExportAssignment);
                }
            } else if (defaultExport != null) {
                exportedElements = Collections.singleton(defaultExport);
            }
        }
        JSTypeEvaluator.getComplexityTracker().runTasks(exportedElements, false, exportedElement -> JSTypeEvaluator.processWithEvaluationGuard(exportedElement, () -> {
            this.addTypeFromResolveResult((PsiElement)exportedElement);
            return null;
        }));
    }

    @Nullable
    private static PsiElement resolveExportAssignmentLocally(JSExportAssignment defaultExport) {
        String reference = defaultExport.getInitializerReference();
        if (reference != null) {
            PsiElement localResolve = JSStubBasedPsiTreeUtil.resolveLocally(reference, (PsiElement)defaultExport);
            if (localResolve != null) {
                return localResolve;
            }
        } else {
            JSElement element = defaultExport.getStubSafeElement();
            if (element != null) {
                return element;
            }
        }
        return null;
    }

    private static void addDefaultExportNamespaces(@NotNull PsiElement source, @NotNull JSEvaluateContext context, @NotNull JSTypeProcessor processor) {
        if (source == null) {
            JSTypeEvaluator.$$$reportNull$$$0(75);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(76);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(77);
        }
        PsiFile file2 = source.getContainingFile();
        JSNamespace moduleExports = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromComponents("module", "exports"), JSContext.STATIC, (PsiElement)file2, true, true, true);
        JSTypeEvaluator.applyContextAndProcessNamespace(moduleExports, context, source, processor);
        JSNamespace exports = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create("exports", null), JSContext.STATIC, (PsiElement)file2, true, true, true);
        JSTypeEvaluator.applyContextAndProcessNamespace(exports, context, source, processor);
    }

    @NotNull
    protected JSEvaluateContext getEvaluationContext() {
        JSEvaluateContext jSEvaluateContext = this.myContext;
        if (jSEvaluateContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(78);
        }
        return jSEvaluateContext;
    }

    protected boolean processFunction(@NotNull JSFunction function2) {
        boolean inCall;
        if (function2 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(79);
        }
        if (!this.isAstAccessAllowed((PsiElement)function2, true)) {
            JSApplyContextElement peek = this.getEvaluationContext().peekJSElementToApply();
            if (peek instanceof JSApplyCallElement) {
                JSType type = JSFunctionImpl.evaluateReturnTypeFromHierarchy((JSFunctionItem)function2);
                if (type != null) {
                    this.getEvaluationContext().processWithoutTopJSElementToApply(() -> this.addType(type, (PsiElement)function2, true));
                }
            } else if (peek instanceof JSApplyInstanceContextElement) {
                JSType type = JSTypeEvaluator.getTypeFromConstructorName(function2);
                if (type != null) {
                    this.getEvaluationContext().processWithoutTopJSElementToApply(() -> this.addType(type, (PsiElement)function2, true));
                }
            } else {
                this.addType((JSType)TypeScriptTypeParser.buildFunctionType((JSFunctionItem)function2), (PsiElement)function2);
                this.addTypeFromLocalName((PsiNamedElement)function2);
            }
            return true;
        }
        JSApplyContextElement elementToApply = this.myContext.peekJSElementToApply();
        boolean bl = inCall = elementToApply instanceof JSApplyCallElement || elementToApply instanceof JSApplyInstanceContextElement;
        if (function2.isGetProperty()) {
            JSType returnType = JSFunctionImpl.getReturnTypeInContext((JSFunctionItem)function2, (PsiElement)this.myContext.getProcessedExpression(), this.getContextualExpectedTypeKind());
            if (returnType != null) {
                this.addType(returnType, null);
            }
        } else if (function2.isSetProperty()) {
            JSType parameterType = JSResolveUtil.getTypeFromSetAccessor((JSFunctionItem)function2);
            if (parameterType != null) {
                this.addType(parameterType, null);
            }
        } else if (!inCall) {
            JSExpression returned;
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)function2, false);
            if (source.isTypeScript()) {
                JSFunctionType type = TypeScriptTypeParser.buildFunctionType((JSFunctionItem)function2);
                if (function2 instanceof JSOptionalOwner && ((JSOptionalOwner)function2).isOptional()) {
                    type = TypeScriptTypeGuard.wrapWithUndefined((JSType)type, type.getSource());
                }
                this.addType((JSType)type, (PsiElement)function2);
            } else if (this.isFromCurrentFile((PsiElement)function2) && (returned = (JSExpression)JSStubBasedPsiTreeUtil.forceAllowTreeLoading(function2.getContainingFile(), () -> JSPsiImplUtils.getReturnedExpressionIfSingle(function2))) != null) {
                SmartList parameterTypes = new SmartList();
                for (JSParameterListElement parameter : function2.getParameters()) {
                    parameterTypes.add(parameter.getTypeDecorator());
                }
                JSTypeSource explicitlyDeclaredSource = JSTypeSourceFactory.createTypeSource((PsiElement)function2, true);
                JSFunctionTypeImpl type = new JSFunctionTypeImpl(explicitlyDeclaredSource, (List<? extends JSParameterTypeDecorator>)parameterTypes, new JSPsiBasedTypeOfType((PsiElement)returned, this.isContextualOverloadEvaluation()));
                this.addType(type, (PsiElement)function2);
            } else {
                String name;
                JSType functionType = source.getLanguage() == JSTypeSource.SourceLanguage.JS ? ((name = function2.getQualifiedName()) != null ? JSNamedTypeFactory.createType(name, source, JSContext.STATIC) : JSNamedTypeFactory.createFunctionType(source)) : JSNamedTypeFactory.createFunctionType(source);
                this.addType(functionType, (PsiElement)function2);
            }
        } else {
            this.myContext.processWithoutTopJSElementToApply(pop -> {
                JSQualifiedName namespace;
                JSExpression methodExpression = null;
                boolean isNewCall = pop instanceof JSApplyInstanceContextElement;
                if (pop instanceof JSApplyCallElement) {
                    methodExpression = ((JSApplyCallElement)pop).getMethodExpression();
                } else if (pop instanceof JSApplyInstanceContextElement) {
                    JSNewExpression newExpression = ((JSApplyInstanceContextElement)pop).getNewExpression();
                    methodExpression = newExpression != null ? newExpression.getMethodExpression() : null;
                }
                JSType jsType = JSFunctionImpl.getReturnTypeInContext((JSFunctionItem)function2, (PsiElement)this.myContext.getProcessedExpression(), this.getContextualExpectedTypeKind());
                if (isNewCall) {
                    List<JSType> types2;
                    List newTypes;
                    JSType typeFromConstructorName = JSTypeEvaluator.getTypeFromConstructorName(function2);
                    if (typeFromConstructorName == null) {
                        typeFromConstructorName = JSAnyType.get((PsiElement)function2, false);
                    }
                    if ((newTypes = ContainerUtil.filter(types2 = jsType instanceof JSUnionType ? ((JSUnionType)jsType).getTypes() : Collections.singletonList(jsType != null ? jsType : typeFromConstructorName), type -> !(type instanceof JSVoidType) && !(type instanceof JSUndefinedType) && (!(type instanceof JSPrimitiveType) || !((JSPrimitiveType)type).isPrimitive()))).size() < types2.size()) {
                        newTypes.add(0, typeFromConstructorName);
                    }
                    jsType = JSCompositeTypeImpl.getCommonType(newTypes, typeFromConstructorName.getSource(), false);
                }
                if (!isNewCall && (namespace = function2.getJSNamespace().getQualifiedName()) instanceof JSQualifiedNameImpl && ((JSQualifiedNameImpl)namespace).matches(JQUERY_NS)) {
                    this.addJQueryType((PsiElement)function2);
                }
                if (jsType != null) {
                    jsType = this.myHelper.getGenericTypeEvaluator().evaluateGenerics(jsType, methodExpression, (PsiElement)function2);
                    this.addType(jsType, null, true);
                }
            });
        }
        return true;
    }

    @Nullable
    private static JSType getTypeFromConstructorName(@NotNull JSFunction function2) {
        JSClass parentClass;
        if (function2 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(80);
        }
        if (function2.isConstructor() && (parentClass = JSUtils.getMemberContainingClass((PsiElement)function2)) != null) {
            String qName = parentClass.getQualifiedName();
            if (qName != null) {
                return JSNamedTypeFactory.createType(qName, JSTypeSourceFactory.createTypeSource((PsiElement)parentClass, false), JSContext.INSTANCE);
            }
        } else {
            if (function2 instanceof JSFunctionExpression && function2.getName() == null && function2.getContext() instanceof ES6ExportDefaultAssignment) {
                return JSNamedTypeFactory.createExplicitlyDeclaredType("\"default\"", (PsiElement)function2);
            }
            String name = JSTypeEvaluator.getElementQName((JSNamedElement)function2);
            if (name != null) {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)function2, true);
                return JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName(name), typeSource, JSTypeContext.INSTANCE, true);
            }
        }
        return null;
    }

    private void processRefExpr(@NotNull JSReferenceExpression expression) {
        JSReferenceExpression localQualifier;
        JSExpression qualifier;
        JSExpression exprQualifier;
        String referenceName;
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(81);
        }
        if ("prototype".equals(referenceName = expression.getReferenceName()) && !DialectDetector.isTypeScript((PsiElement)expression) && (exprQualifier = expression.getQualifier()) instanceof JSReferenceExpression) {
            this.myContext.processWithJSElementToApply(JSApplyInstanceContextElement.INSTANCE, () -> this.processRefExpr((JSReferenceExpression)exprQualifier));
            return;
        }
        if ("constructor".equals(referenceName) && DialectDetector.isJavaScript((PsiElement)expression) && (qualifier = expression.getQualifier()) != null) {
            this.myContext.processWithJSElementToApply(JSApplyStaticContextElement.INSTANCE, () -> this.evaluateTypes(qualifier));
            return;
        }
        if (JSSymbolUtil.isExplicitExportReference(expression) && DialectDetector.isJavaScript((PsiElement)expression)) {
            JSTypeEvaluator.addDefaultExportNamespaces((PsiElement)expression, this.myContext, this.myTypeProcessor);
            return;
        }
        AtomicBoolean hasProcessedResult = new AtomicBoolean(false);
        ResolveResult[] resolveResults = this.getResolveResultsFromQualifier(expression);
        if (resolveResults.length > 0 && !JSTypeEvaluator.shouldSkipProcessing(resolveResults)) {
            hasProcessedResult.set(true);
            boolean wasStrict = this.myContext.startEvaluationWithStrictness(JSResolveUtil.isResolveStrict((PsiReference)expression, resolveResults));
            this.myContext.processExpression(expression, JSTypeEvaluator.getComplexityTracker(), Arrays.asList(resolveResults), r -> {
                this.myTypeProcessor.mySomeResultAddedForCurrentResolveResult = false;
                this.addTypeFromResolveResult(referenceName, (ResolveResult)r);
                if (!this.myTypeProcessor.mySomeResultAddedForCurrentResolveResult) {
                    PsiElement resolvedElement = r.getElement();
                    this.myTypeProcessor.setUnknownElement((PsiElement)(resolvedElement != null ? resolvedElement : expression));
                }
            });
            this.myContext.finishEvaluationWithStrictness(wasStrict);
        }
        if (!DialectDetector.isActionScript((PsiElement)expression) && this.addAdditionalTypes(localQualifier = JSUtils.findRefExprThatStartCallChaining(expression), expression)) {
            hasProcessedResult.set(true);
        }
        if (!hasProcessedResult.get()) {
            JSType typeFromReferenceExpression = JSSymbolUtil.createTypeFromReferenceExpression(expression, JSTypeContext.STATIC);
            if (typeFromReferenceExpression != null && this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement) {
                this.addType(typeFromReferenceExpression, (PsiElement)expression);
            } else {
                this.myTypeProcessor.setUnknownElement((PsiElement)expression);
            }
        }
    }

    protected boolean addTypeFromResolveResult(String referenceName, ResolveResult resolveResult) {
        PsiElement element = resolveResult.getElement();
        if (element == null) {
            return true;
        }
        this.addLocalNamespaceFromImport(referenceName, resolveResult);
        this.addTypeFromResolveResult(element);
        return true;
    }

    protected void addLocalNamespaceFromImport(String referenceName, ResolveResult r) {
        ES6ImportExportDeclarationPart anImport;
        if (r instanceof JSResolveResult && (anImport = ((JSResolveResult)r).getES6Import()) instanceof ES6ImportExportSpecifier && Objects.equals(referenceName, anImport.getDeclaredName())) {
            JSNamespace nsFromImport = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(referenceName, null), JSContext.STATIC, (PsiElement)anImport, true, true, true);
            this.addNamespace(nsFromImport, (PsiElement)anImport);
        }
    }

    protected ResolveResult @NotNull [] getResolveResultsFromQualifier(@NotNull JSReferenceExpression qualifier) {
        if (qualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(82);
        }
        ResolveResult[] resolveResultArray = qualifier.multiResolve(false);
        if (resolveResultArray == null) {
            JSTypeEvaluator.$$$reportNull$$$0(83);
        }
        return resolveResultArray;
    }

    private static boolean shouldSkipProcessing(ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            JSTypeEvaluator.$$$reportNull$$$0(84);
        }
        if (resolveResults.length < 20) {
            return false;
        }
        return !JSResolveUtil.isTypeScriptDeclarationMerging(resolveResults);
    }

    protected final void addTypeFromResolveResult(@NotNull PsiElement resolveResult) {
        String alias;
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(85);
        }
        this.myContext.setSource(resolveResult);
        if (resolveResult instanceof TypeScriptProxyImplicitElementWithBackingItem) {
            resolveResult = ((TypeScriptProxyImplicitElementWithBackingItem)resolveResult).getBackingElement();
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            if (!(handler.addTypeFromResolveResult(this, this.myContext, resolveResult) | handler.addTypeFromResolveResult(this, resolveResult, false))) continue;
            return;
        }
        JSDocComment docComment = JSStubBasedPsiTreeUtil.findOwnDocComment(resolveResult);
        if (docComment != null && (alias = docComment.getAlias()) != null) {
            this.addType((JSType)JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromQualifiedName(alias), JSContext.STATIC, (PsiElement)docComment), (PsiElement)docComment);
        }
        if (resolveResult instanceof JSFieldVariable) {
            this.addTypeFromVariableResolveResult((JSFieldVariable)resolveResult);
        } else {
            this.addTypeFromElementResolveResult(resolveResult);
        }
    }

    protected void addTypeFromVariableResolveResult(@NotNull JSFieldVariable jsVariable) {
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(86);
        }
        this.addTypeFromVariableResolveResult(jsVariable, jsVariable.getJSType());
    }

    private void addTypeFromVariableResolveResult(@NotNull JSFieldVariable jsVariable, @Nullable JSType variableType) {
        boolean useVariableType;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(87);
        }
        boolean wasStrict = this.myContext.isStrict();
        int jsElementsToApplySize = this.myContext.getJSElementsToApply().size();
        if (jsVariable instanceof JSParameter) {
            if (variableType == null && this.isAstAccessAllowed((PsiElement)jsVariable) && this.addTypeFromAmdModuleReference((JSParameter)jsVariable)) {
                return;
            }
            variableType = this.processParameterType((JSParameter)jsVariable, variableType);
        }
        if ((useVariableType = this.useVariableType(variableType)) && variableType.isJavaScript() && !JSTypeEvaluator.isAcceptableInitializerType(variableType) && this.isAstAccessAllowed((PsiElement)jsVariable)) {
            useVariableType = false;
        }
        if (useVariableType) {
            this.addType(variableType, EXPLICIT_TYPE_MARKER_ELEMENT);
        } else if (this.isAstAccessAllowed((PsiElement)jsVariable)) {
            variableType = this.addTypeFromVariableInitializer(jsVariable, variableType);
        } else {
            JSExpression initializer = jsVariable.getInitializerOrStub();
            if (initializer != null) {
                this.getEvaluationContext().withAstAccessForbidden(() -> this.evaluateTypes(initializer));
            }
        }
        if (!useVariableType || variableType instanceof JSCodeBasedType && variableType.isJavaScript() || JSTypeUtils.isNewPropertiesDefinitionAllowed(variableType, false) || this.definesConstructor(jsVariable, variableType)) {
            JSNamespace namespace = this.getNamespaceFromQualifiedNamedElement((JSQualifiedNamedElement)jsVariable, false);
            this.addNamespace(namespace, (PsiElement)jsVariable);
        }
        this.restoreEvaluationContextApplingElementsSize(jsElementsToApplySize);
        this.myContext.finishEvaluationWithStrictness(wasStrict);
    }

    private boolean definesConstructor(@NotNull JSFieldVariable jsVariable, @Nullable JSType variableType) {
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(88);
        }
        if (variableType == null || !variableType.isSourceStrict()) {
            return false;
        }
        JSReferenceExpression processedExpression = this.myContext.getProcessedExpression();
        return processedExpression != null && DialectDetector.isJavaScript((PsiElement)processedExpression) && JSTypeUtils.hasFunctionType(variableType, true, (PsiElement)jsVariable);
    }

    @Nullable
    private JSType addTypeFromVariableInitializer(@NotNull JSFieldVariable jsVariable, @Nullable JSType variableType) {
        JSInitializerOwner initializerOwner;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(89);
        }
        JSExpression initializer = (initializerOwner = this.pushDestructuringContext(jsVariable)) != null ? (JSExpression)JSStubBasedPsiTreeUtil.forceAllowTreeLoading(initializerOwner.getContainingFile(), () -> initializerOwner.getInitializer()) : null;
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)jsVariable);
        if (isTypeScript && initializerOwner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)initializerOwner).getTypeElement() != null) {
            this.addType(((JSTypeDeclarationOwner)initializerOwner).getJSType(), (PsiElement)initializerOwner);
        } else if (initializer != null) {
            if (jsVariable instanceof JSVariable && !JSVariableBaseImpl.isStrictVariableInitializer((JSVariable)jsVariable)) {
                this.myContext.startEvaluationWithStrictness(false);
            }
            this.addTypeFromInitializer(initializer);
        } else if (variableType == null && jsVariable instanceof JSVariable && JSTypeEvaluator.isForStatementDeclaration((JSVariable)jsVariable)) {
            PsiElement forOf = JSResolveUtil.findParent((PsiElement)jsVariable);
            variableType = this.addLoopVariable(expression, (PsiElement)jsVariable, (JSForInStatement)forOf);
        } else if (expression != null && variableType == null) {
            variableType = this.myHelper.getGuardedTypeByEvaluateContext(null, this.myContext, EXPLICIT_TYPE_MARKER_ELEMENT);
            if (variableType != null) {
                this.myContext.startEvaluationWithStrictness(!JSTypeUtils.isStrictType(variableType));
                this.doAddType(variableType, EXPLICIT_TYPE_MARKER_ELEMENT);
            } else {
                this.myTypeProcessor.setUnknownElement((PsiElement)jsVariable);
            }
        }
        return variableType;
    }

    @Nullable
    private JSType processParameterType(@NotNull JSParameter jsVariable, JSType variableType) {
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(90);
        }
        if (variableType == null && this.isAstAccessAllowed((PsiElement)jsVariable)) {
            variableType = JSContextTypeEvaluator.getParameterType((JSParameterListElement)jsVariable, this.myContext, this.getContextualExpectedTypeKind());
        }
        if (jsVariable.isRest()) {
            if (!(variableType instanceof JSRestTypeImpl)) {
                JSTypeSource typeSource = variableType != null && variableType.getSourceElement() != null ? variableType.getSource() : JSTypeSourceFactory.createTypeSource((PsiElement)jsVariable, jsVariable.getTypeDecorator().isExplicitlyDeclared());
                variableType = new JSArrayTypeImpl(variableType, typeSource);
            } else {
                variableType = ((JSRestTypeImpl)variableType).getIterableType();
            }
        }
        return this.substituteThisType(variableType, (JSFieldVariable)jsVariable);
    }

    private static boolean isAcceptableInitializerType(@Nullable JSType variableType) {
        return variableType != null && (!(variableType instanceof JSCodeBasedType) || variableType instanceof JSRequireCallExpressionType || variableType instanceof JSStubBasedExpressionType || variableType instanceof JSApplyIndexedAccessType || variableType instanceof JSReferenceType);
    }

    @Nullable
    protected JSInitializerOwner pushDestructuringContext(@NotNull JSFieldVariable jsVariable) {
        JSEvaluateContext context;
        JSInitializerOwner parent;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(91);
        }
        JSInitializerOwner initializerOwner = null;
        if (DialectDetector.isTypeScript((PsiElement)jsVariable) && WITH_TYPE_DECLARATION_PREDICATE.test(parent = JSDestructuringUtil.findDestructuringParent((JSElement)jsVariable, context = new JSEvaluateContext(this.myContext.targetFile), WITH_TYPE_DECLARATION_PREDICATE))) {
            initializerOwner = parent;
            Iterator iterator = context.getJSElementsToApply().descendingIterator();
            while (iterator.hasNext()) {
                JSApplyContextElement next = (JSApplyContextElement)iterator.next();
                JSApplyContextElement element = this.myContext.peekJSElementToApply();
                if (element instanceof JSApplyDestructuringPropertyElement && next instanceof JSApplyDestructuringPropertyElement && ((JSApplyDestructuringPropertyElement)element).getProperty() == ((JSApplyDestructuringPropertyElement)next).getProperty() || element instanceof JSApplyIndexedAccessToDestructuringElement && next instanceof JSApplyIndexedAccessToDestructuringElement && ((JSApplyIndexedAccessToDestructuringElement)element).getArrayElement() == ((JSApplyIndexedAccessToDestructuringElement)next).getArrayElement()) break;
                this.myContext.pushJSElementToApply(next);
            }
        }
        if (initializerOwner != null) {
            return initializerOwner;
        }
        return JSDestructuringUtil.findDestructuringParent((JSElement)jsVariable, this.myContext, JSInitializerOwner::hasOwnInitializer);
    }

    private static boolean isForStatementDeclaration(@NotNull JSVariable jsVariable) {
        PsiElement forOfCandidate;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(92);
        }
        return (forOfCandidate = JSResolveUtil.findParent((PsiElement)jsVariable)) instanceof JSForInStatement && PsiTreeUtil.isAncestor((PsiElement)((JSForInStatement)forOfCandidate).getVarDeclaration(), (PsiElement)jsVariable, (boolean)true);
    }

    protected void restoreEvaluationContextApplingElementsSize(int sizeBefore) {
        while (this.myContext.getJSElementsToApply().size() > sizeBefore) {
            this.myContext.popJSElementToApply();
        }
    }

    @Nullable
    public static JSType getTypeFromTypeGuard(@NotNull PsiElement namedElement, @Nullable JSReferenceExpression expression, @Nullable JSType preprocessedType, @Nullable PsiElement resolvedElement) {
        if (namedElement == null) {
            JSTypeEvaluator.$$$reportNull$$$0(93);
        }
        return JSDialectSpecificHandlersFactory.forElement(namedElement).getTypeEvaluationHelper().getTypeFromTypeGuard(namedElement, expression, preprocessedType, resolvedElement);
    }

    private void addTypeFromInitializer(@Nullable JSExpression initializer) {
        if (initializer == null) {
            return;
        }
        if (DialectDetector.isTypeScript((PsiElement)initializer)) {
            JSType contextType = this.getExpressionTypeInContext(initializer);
            if (contextType != null) {
                this.addType(contextType, EXPLICIT_TYPE_MARKER_ELEMENT);
            }
            return;
        }
        boolean strict = this.myContext.startEvaluationWithStrictness(!JSTypeEvaluator.isEmptyJSObjectLiteral(initializer));
        this.evaluateTypesFromCache(initializer);
        this.myContext.finishEvaluationWithStrictness(strict);
    }

    private static boolean isEmptyJSObjectLiteral(@NotNull JSExpression initializer) {
        if (initializer == null) {
            JSTypeEvaluator.$$$reportNull$$$0(94);
        }
        return DialectDetector.isJavaScript((PsiElement)initializer) && initializer instanceof JSObjectLiteralExpression && ((JSObjectLiteralExpression)initializer).isEmpty();
    }

    private void evaluateDestructuringContainer(@NotNull JSDestructuringContainer destructuringContainer) {
        JSInitializerOwner owner;
        if (destructuringContainer == null) {
            JSTypeEvaluator.$$$reportNull$$$0(95);
        }
        if ((owner = JSDestructuringUtil.findDestructuringParent((JSElement)destructuringContainer, this.myContext, e -> e.hasOwnInitializer() || JSTypeEvaluator.isApplicableTypeDeclaration(e) || e instanceof JSParameterListElement)) == null) {
            return;
        }
        if (this.evaluateDestructuringInLoop(owner)) {
            return;
        }
        if (WITH_TYPE_DECLARATION_PREDICATE.test(owner)) {
            this.addType(((JSTypeDeclarationOwner)owner).getJSType(), (PsiElement)owner);
        }
        if (owner.hasOwnInitializer()) {
            boolean wasStrict = this.myContext.startEvaluationWithStrictness(owner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)owner).getJSType() instanceof JSDestructuringTypeImpl);
            this.addTypeFromInitializer((JSExpression)JSStubBasedPsiTreeUtil.forceAllowTreeLoading(owner.getContainingFile(), () -> owner.getInitializer()));
            this.myContext.finishEvaluationWithStrictness(wasStrict);
        }
        if (owner instanceof JSParameterListElement) {
            this.addType(JSContextTypeEvaluator.getParameterType((JSParameterListElement)owner, this.myContext, JSExpectedTypeKind.EXPECTED), (PsiElement)owner);
        }
    }

    private boolean evaluateDestructuringInLoop(JSInitializerOwner owner) {
        PsiElement parent = owner.getParent();
        if (!(parent instanceof JSVarStatement)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof JSForInStatement) || !((JSForInStatement)grandParent).isForEach()) {
            return false;
        }
        JSExpression expression = ((JSForInStatement)grandParent).getCollectionExpression();
        if (expression == null) {
            return false;
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)owner, true);
        this.addType(new JSIterableComponentTypeImpl(new JSPsiBasedTypeOfType((PsiElement)expression, false), source), (PsiElement)owner);
        return true;
    }

    private static boolean isApplicableTypeDeclaration(JSInitializerOwner e) {
        if (!(e instanceof JSTypeDeclarationOwner)) {
            return false;
        }
        if (((JSTypeDeclarationOwner)e).getTypeElement() != null) {
            return true;
        }
        PsiElement parent = e.getParent();
        if (!(parent instanceof JSVarStatement)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        return grandParent instanceof JSForInStatement && ((JSForInStatement)grandParent).isForEach();
    }

    protected JSType substituteThisType(@Nullable JSType type, @NotNull JSFieldVariable jsVariable) {
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(96);
        }
        return type;
    }

    protected boolean addTypeFromAmdModuleReference(@NotNull JSParameter parameter) {
        if (parameter == null) {
            JSTypeEvaluator.$$$reportNull$$$0(97);
        }
        boolean result2 = false;
        if (!this.myContext.isAstAccessAllowed()) {
            return false;
        }
        JSLiteralExpression amdModuleReference = JSSymbolUtil.getParameterInitializationIfRequireArgument(parameter);
        if (amdModuleReference != null) {
            PsiReference[] references = amdModuleReference.getReferences();
            Collection<PsiElement> modules = JSFileReferencesUtil.getMostPriorityModules((PsiElement)parameter, references);
            for (PsiElement resolve : modules) {
                result2 |= this.addTypeFromAmdModule(amdModuleReference, resolve);
            }
        }
        return result2;
    }

    private boolean addTypeFromAmdModule(@NotNull JSLiteralExpression amdModuleReference, @NotNull PsiElement resolve) {
        if (amdModuleReference == null) {
            JSTypeEvaluator.$$$reportNull$$$0(98);
        }
        if (resolve == null) {
            JSTypeEvaluator.$$$reportNull$$$0(99);
        }
        boolean result2 = false;
        JSFunctionExpression moduleInitializer = null;
        if (resolve instanceof JSFile) {
            JSFunctionExpression amdModule = JSAmdModulesIndex.findDefaultAmdModule((JSFile)resolve);
            if (amdModule != null) {
                moduleInitializer = amdModule;
            } else {
                this.addTypeFromExternalModuleReferenceResolveResult(resolve);
            }
            result2 = true;
        } else if (resolve instanceof JSFunctionExpression) {
            moduleInitializer = (JSFunctionExpression)resolve;
            JSType type = JSNamedTypeFactory.createType(JSAmdPsiUtil.unifyModuleName(amdModuleReference), JSTypeSourceFactory.createTypeSource(resolve, true), JSContext.STATIC);
            this.addType(type, EXPLICIT_TYPE_MARKER_ELEMENT);
            result2 = true;
        }
        if (moduleInitializer != null) {
            JSFunctionExpression finalModuleInitializer = moduleInitializer;
            this.myContext.processWithJSElementToApply(JSApplyCallElement.fromContextStubSafe((PsiElement)moduleInitializer), () -> this.addTypeFromResolveResult((PsiElement)finalModuleInitializer));
            JSNamespace exportsNamespace = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create("exports", null), JSContext.STATIC, (PsiElement)moduleInitializer, true, false, true);
            this.addType((JSType)exportsNamespace, (PsiElement)moduleInitializer);
        }
        return result2;
    }

    @Contract(value="null->false")
    protected boolean useVariableType(JSType type) {
        return type != null;
    }

    public boolean isFromCurrentFile(@NotNull PsiElement element) {
        JSReferenceExpression context;
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(100);
        }
        if ((context = this.myContext.getProcessedExpression()) == null) {
            context = this.myContext.targetFile;
        }
        return context != null && context.getContainingFile().getOriginalFile().isEquivalentTo((PsiElement)element.getContainingFile().getOriginalFile());
    }

    public void evaluateTypes(@Nullable JSExpression expression) {
        if (expression == null) {
            return;
        }
        if (!this.isAstAccessAllowed((PsiElement)expression) && expression instanceof StubBasedPsiElementBase && ((StubBasedPsiElementBase)expression).getStub() != null) {
            this.doEvaluateTypesStubSafely(expression);
            return;
        }
        if (!this.myContext.isJSElementsToApplyEmpty() || !this.isAstAccessAllowed((PsiElement)expression, true)) {
            this.processItem((PsiElement)expression, () -> this.doEvaluateTypes(expression));
            return;
        }
        this.evaluateTypesFromCache(expression);
    }

    private void evaluateTypesFromCache(@NotNull JSExpression expression) {
        JSTypeEvaluationResult result2;
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(101);
        }
        if ((result2 = this.getTypeEvaluationResultInContext(expression)) != null) {
            List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result2.getResults();
            for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
                this.addTypeEvaluationResultElement(element);
            }
        }
    }

    private void doEvaluateTypesStubSafely(JSExpression expression) {
        if (expression instanceof JSFunction) {
            this.processFunction((JSFunction)expression);
        } else if (expression instanceof JSCallExpression) {
            this.evaluateCallExpressionTypes((JSCallExpression)expression);
        } else if (expression instanceof JSClassExpression) {
            this.addTypeFromClassExpression((JSClassExpression)expression);
        } else if (expression instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)expression, false);
        }
    }

    public void addTypeFromClassExpression(JSClassExpression classExpression) {
    }

    protected void processInstanceContextForClass(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            JSTypeEvaluator.$$$reportNull$$$0(102);
        }
        JSApplyContextElement peek = this.myContext.peekJSElementToApply();
        assert (peek instanceof JSApplyInstanceContextElement);
        this.addTypeFromClassCandidate(jsClass);
    }

    protected void addTypeFromElementResolveResult(@Nullable PsiElement resolveResult) {
        if (resolveResult instanceof TypeScriptMergedTypeImplicitElement) {
            this.addTypeFromMergedElementResolveResult((TypeScriptMergedTypeImplicitElement)resolveResult);
        } else if (resolveResult instanceof JSImplicitElement) {
            JSImplicitElement implicitElement = (JSImplicitElement)resolveResult;
            this.addTypeFromImplicitElementResolveResult(implicitElement);
        } else if (resolveResult instanceof JSProperty) {
            this.addTypeFromProperty((JSProperty)resolveResult);
        } else if (resolveResult instanceof JSClass && this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement) {
            this.processInstanceContextForClass((JSClass)resolveResult);
        } else if (resolveResult instanceof JSClass) {
            this.addTypeFromClassCandidate((JSClass)resolveResult);
        } else if (resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor() && resolveResult.getContext() instanceof JSClass) {
            this.addTypeFromClassCandidate((JSClass)resolveResult.getContext());
        } else if (resolveResult instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)resolveResult, false);
        } else if (resolveResult instanceof JSDefinitionExpression) {
            JSType parameterType = null;
            PsiElement resolveResultParent = resolveResult.getContext();
            if (resolveResultParent instanceof JSForInStatement && resolveResult == ((JSForInStatement)resolveResultParent).getVariableExpression()) {
                parameterType = this.addLoopVariable(this.myContext.getProcessedExpression(), resolveResult, (JSForInStatement)resolveResultParent);
            }
            if (parameterType == null) {
                this.addTypeFromDefExpr((JSDefinitionExpression)resolveResult);
            }
        } else if (!this.addTypeFromDialectSpecificElements(resolveResult)) {
            if (resolveResult instanceof JSFunction) {
                this.processFunction((JSFunction)resolveResult);
            } else if (resolveResult instanceof JSNamedElement) {
                String name = JSTypeEvaluator.getElementQName((JSNamedElement)resolveResult);
                if (name != null) {
                    JSType jsType = JSNamedTypeFactory.createType(name, JSTypeSourceFactory.createTypeSource(resolveResult, false), JSContext.STATIC);
                    this.addType(jsType, resolveResult);
                }
            } else if (resolveResult instanceof JSLiteralExpression) {
                this.addTypeFromLiteralExpression((JSExpression)resolveResult);
            } else if (resolveResult instanceof JsonElement) {
                this.applyContextAndProcessResolvedElement(resolveResult);
            } else if (resolveResult instanceof JSFile) {
                this.addTypeFromExternalModuleReferenceResolveResult(resolveResult);
            }
        }
    }

    private void addTypeFromImplicitElementResolveResult(@NotNull JSImplicitElement resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(103);
        }
        boolean typeAdded = false;
        if (resolveResult instanceof JSLocalImplicitElementImpl) {
            PsiElement owner = resolveResult.getParent();
            JSType jsType = ((JSTypeInfoOwner)resolveResult).getJSType();
            this.addType(jsType, owner);
            return;
        }
        String typeString = resolveResult.getTypeString();
        if (typeString != null) {
            JSType type = JSTypeUtils.createType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)resolveResult, true));
            this.addType(type, (PsiElement)resolveResult);
            typeAdded = true;
        }
        if (!typeAdded && resolveResult.getType().providesNamespace()) {
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)resolveResult, resolveResult.isNamespaceExplicitlyDeclared());
            JSType jsType = JSNamedTypeFactory.createType(resolveResult.getQualifiedName(), typeSource, JSContext.STATIC);
            this.addType(jsType, (PsiElement)resolveResult);
        } else {
            JSNamespace namespace = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)resolveResult), JSContext.STATIC, (PsiElement)resolveResult, resolveResult.isNamespaceExplicitlyDeclared());
            this.addNamespace(namespace, (PsiElement)resolveResult);
        }
    }

    private void addTypeFromMergedElementResolveResult(TypeScriptMergedTypeImplicitElement resolveResult) {
        JSApplyContextElement elementToApply;
        boolean inCall;
        PsiElement explicitElement = resolveResult.getExplicitElement();
        JSType jsType = resolveResult.getJSType();
        if (resolveResult.isOptional() && jsType != null) {
            jsType = TypeScriptTypeGuard.wrapWithUndefined(jsType, jsType.getSource());
        }
        boolean bl = inCall = (elementToApply = this.myContext.peekJSElementToApply()) instanceof JSApplyCallElement || elementToApply instanceof JSApplyInstanceContextElement && ((JSApplyInstanceContextElement)elementToApply).getNewExpression() != null;
        if (inCall && explicitElement instanceof JSFunction) {
            JSExpression methodExpression = elementToApply instanceof JSApplyCallElement ? ((JSApplyCallElement)elementToApply).getMethodExpression() : ((JSApplyInstanceContextElement)elementToApply).getNewExpression();
            jsType = this.myHelper.getGenericTypeEvaluator().evaluateGenerics(jsType, methodExpression, explicitElement);
        }
        PsiElement source = explicitElement == null ? null : explicitElement.getParent();
        this.addType(jsType, source);
    }

    private void addTypeFromProperty(@NotNull JSProperty property) {
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(104);
        }
        boolean skipEvaluatingProps = false;
        boolean hasType = false;
        JSType jsType = property.getJSType();
        if (jsType != null) {
            this.addType(jsType, (PsiElement)property);
            hasType = true;
            boolean bl = skipEvaluatingProps = !JSTypeUtils.isNewPropertiesDefinitionAllowed(jsType, false);
        }
        if (!skipEvaluatingProps) {
            JSDocComment docComment;
            JSNamespace type;
            JSFunction functionInitializer = property.tryGetFunctionInitializer();
            JSObjectLiteralExpression objectLiteralExpression = property.getObjectLiteralExpressionInitializer();
            boolean providesNamespace = functionInitializer != null && !functionInitializer.isGetProperty() && !functionInitializer.isSetProperty() || objectLiteralExpression != null;
            boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)property);
            if (!isTypeScript && providesNamespace && (type = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)property, (docComment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)property)) != null && docComment.isClassExplicitly())) != null) {
                this.addNamespace(type, (PsiElement)property);
            }
            if (!hasType) {
                JSExpression value;
                if (functionInitializer != null || objectLiteralExpression != null) {
                    if (functionInitializer != null) {
                        this.processFunction(functionInitializer);
                    } else {
                        this.addTypeFromObjectLiteralExpression(objectLiteralExpression, false);
                    }
                } else if (this.isFromCurrentFile((PsiElement)property) && (value = property.getValue()) != null) {
                    this.evaluateTypes(value);
                }
            }
        }
    }

    @NotNull
    protected JSNamespace getNamespaceFromQualifiedNamedElement(@NotNull JSQualifiedNamedElement element, boolean isStrict) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(105);
        }
        boolean isLocal = JSUseScopeProvider.getLexicalScope((PsiElement)element) != null;
        JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)element);
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(qualifiedName, JSContext.STATIC, (PsiElement)element, isStrict, true, isLocal);
        if (jSNamespace == null) {
            JSTypeEvaluator.$$$reportNull$$$0(106);
        }
        return jSNamespace;
    }

    protected void addTypeFromClassCandidate(@NotNull JSClass resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(107);
        }
    }

    @Nullable
    private JSType addLoopVariable(@Nullable JSReferenceExpression expression, @NotNull PsiElement element, @Nullable JSForInStatement forInStatement) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(108);
        }
        if (forInStatement == null) {
            return null;
        }
        if (forInStatement.isForEach()) {
            List<JSType> types2 = this.getComponentTypeFromArrayExpression((JSExpression)expression, forInStatement.getCollectionExpression());
            for (JSType type : types2) {
                this.addType(type, (PsiElement)expression);
            }
            return (JSType)ContainerUtil.getFirstItem(types2);
        }
        JSForInStringType parameterType = new JSForInStringType(JSTypeSourceFactory.createTypeSource(element, true), JSTypeContext.INSTANCE);
        this.addType(parameterType, element);
        return parameterType;
    }

    protected boolean addTypeFromDialectSpecificElements(PsiElement resolveResult) {
        return false;
    }

    @Nullable
    public final JSType addComponentTypeFromArrayExpression(@Nullable JSExpression rawqualifier, @Nullable JSExpression collectionExpression) {
        List<JSType> types2 = this.getComponentTypeFromArrayExpression(rawqualifier, collectionExpression);
        for (JSType type : types2) {
            this.addType(type, (PsiElement)rawqualifier);
        }
        return types2.size() == 1 ? (JSType)ContainerUtil.getFirstItem(types2) : null;
    }

    @NotNull
    protected List<JSType> getComponentTypeFromArrayExpression(@Nullable JSExpression rawqualifier, @Nullable JSExpression collectionExpression) {
        if (collectionExpression == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(109);
            }
            return list2;
        }
        JSTypeEvaluationResult result2 = this.getTypeEvaluationResultInContext(collectionExpression);
        if (result2 == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(110);
            }
            return list3;
        }
        List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result2.getResults();
        JSSimpleTypeProcessor processor = new JSSimpleTypeProcessor();
        result2.applyToProcessor(processor);
        JSType type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(processor.getType());
        int index = -1;
        JSExpression indexExpression = null;
        if (rawqualifier instanceof JSIndexedPropertyAccessExpression && (indexExpression = ((JSIndexedPropertyAccessExpression)rawqualifier).getIndexExpression()) instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isNumericLiteral()) {
            Object value = ((JSLiteralExpression)indexExpression).getValue();
            assert (value instanceof Double || value instanceof Long || value instanceof BigInteger) : indexExpression.getText();
            if (value instanceof Long && (Long)value >= 0L && (Long)value <= Integer.MAX_VALUE) {
                index = Math.toIntExact((Long)value);
            } else if (value instanceof BigInteger && ((BigInteger)value).compareTo(BigInteger.ZERO) >= 0 && ((BigInteger)value).compareTo(JSLiteralExpressionImpl.INT_MAX_VALUE_AS_BIGINT) <= 0) {
                index = ((BigInteger)value).intValueExact();
            }
        }
        boolean processed = false;
        for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
            JsonProperty property;
            String propertyName;
            PsiElement source = element.getSource();
            if (source instanceof JsonFile) {
                JsonFile jsonFile = (JsonFile)source;
                source = (PsiElement)AstLoadingFilter.forceAllowTreeLoading((PsiFile)jsonFile, () -> ((JsonFile)jsonFile).getTopLevelValue());
            }
            if (source instanceof JSArrayLiteralExpression) {
                JSExpression[] expressions = ((JSArrayLiteralExpression)source).getExpressions();
                if (index >= 0 && index < expressions.length) {
                    this.addTypeFromElementResolveResult((PsiElement)expressions[index]);
                    processed = true;
                    continue;
                }
                for (JSExpression expr : expressions) {
                    if (!(expr instanceof JSObjectLiteralExpression)) continue;
                    this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)expr, false);
                    processed = true;
                }
                continue;
            }
            if (source instanceof JsonArray) {
                List values = ((JsonArray)source).getValueList();
                if (index < 0 || index >= values.size()) continue;
                this.applyContextAndProcessResolvedElement((PsiElement)values.get(index));
                processed = true;
                continue;
            }
            if (!(source instanceof JsonObject) || !(indexExpression instanceof JSLiteralExpression) || (propertyName = ((JSLiteralExpression)indexExpression).getValueAsPropertyName()) == null || (property = ((JsonObject)source).findProperty(propertyName)) == null) continue;
            this.applyContextAndProcessResolvedElement((PsiElement)property);
            processed = true;
        }
        if (!processed && type instanceof JSTupleType && ((JSTupleType)type).hasTypeByIndex(index)) {
            List<JSType> list4 = Collections.singletonList(((JSTupleType)type).getTypeByIndex(index));
            if (list4 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(111);
            }
            return list4;
        }
        List<JSType> list5 = this.getComponentTypeFromProcessor(rawqualifier, type);
        if (list5 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(112);
        }
        return list5;
    }

    @Nullable
    public final JSType addComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        List<JSType> types2 = this.getComponentTypeFromProcessor(rawqualifier, type);
        for (JSType jsType : types2) {
            if (type == null) continue;
            this.addType(jsType, (PsiElement)rawqualifier);
        }
        return types2.size() == 1 ? (JSType)ContainerUtil.getFirstItem(types2) : null;
    }

    @NotNull
    protected List<JSType> getComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        SmartList result2 = this.getComponentTypeWithExpandingComposite(rawqualifier, type);
        SmartList smartList = result2.isEmpty() ? new SmartList((Object)JSAnyType.get((PsiElement)rawqualifier, false)) : result2;
        if (smartList == null) {
            JSTypeEvaluator.$$$reportNull$$$0(113);
        }
        return smartList;
    }

    @NotNull
    protected final List<JSType> getComponentTypeWithExpandingComposite(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(114);
            }
            return list2;
        }
        if (type instanceof JSUnionType) {
            ArrayList<JSType> result2 = new ArrayList<JSType>();
            for (JSType typeOption : ((JSUnionType)type).getTypes()) {
                result2.addAll(this.getComponentTypeFromProcessor(rawqualifier, typeOption));
            }
            ArrayList<JSType> arrayList = result2;
            if (arrayList == null) {
                JSTypeEvaluator.$$$reportNull$$$0(115);
            }
            return arrayList;
        }
        JSTypeSource prevSource = type.getSource();
        if ((type = JSTypeUtils.getIndexableComponentType(type)) == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(116);
            }
            return list3;
        }
        type = JSTypeUtils.copyWithStrict(type, prevSource.isStrict() && type.isSourceStrict());
        List<JSType> list4 = Collections.singletonList(type);
        if (list4 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(117);
        }
        return list4;
    }

    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawqualifier) {
        JSType type;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(118);
        }
        if ((type = JSTypeEvaluator.getTypeFromConstant(rawqualifier)) != null) {
            this.addType(type, (PsiElement)rawqualifier);
        } else {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    @Nullable
    public static JSType getTypeFromConstant(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(119);
        }
        if (rawqualifier instanceof JSEmptyExpression) {
            return JSTypeEvaluator.createConstantNamedType("undefined", rawqualifier);
        }
        String type = JSTypeEvaluator.detectTypeByExpression(rawqualifier);
        if (type == "null" && DialectDetector.isActionScript((PsiElement)rawqualifier)) {
            return JSAnyType.get((PsiElement)rawqualifier, false);
        }
        if (type == "number" && DialectDetector.isActionScript((PsiElement)rawqualifier)) {
            String text = JSTypeEvaluator.getConstantLiteralText(rawqualifier);
            if (text != null && text.indexOf(46) == -1) {
                return JSTypeEvaluator.createConstantNamedType("int", rawqualifier);
            }
            return JSTypeEvaluator.createConstantNamedType(type, rawqualifier);
        }
        if (type == "number" && JSTypeEvaluator.isBigIntLiteral(rawqualifier)) {
            type = "bigint";
        }
        if ((type == "XMLList" || type == "XML") && (DialectDetector.isTypeScript((PsiElement)rawqualifier) || DialectDetector.isJSX((PsiElement)rawqualifier))) {
            return null;
        }
        if (type == "string" || DialectDetector.isTypeScript((PsiElement)rawqualifier) && (type == "number" || type == "boolean" || type == "bigint")) {
            Number literal;
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
            if (type == "string" && !DialectDetector.isTypeScript((PsiElement)rawqualifier) && rawqualifier.getTextLength() > 4096) {
                return new JSStringType(true, typeSource, JSTypeContext.INSTANCE);
            }
            String literalText = JSTypeEvaluator.getConstantLiteralText(rawqualifier);
            if (type == "string" && literalText != null) {
                return new JSStringLiteralTypeImpl(literalText, true, typeSource);
            }
            if (literalText == null) {
                literalText = "";
            }
            if (type == "boolean" && ("true".equals(literalText) || "false".equals(literalText))) {
                return new JSBooleanLiteralTypeImpl("true".equals(literalText), true, typeSource);
            }
            if (type == "number" && literalText.length() > 0 && (literal = JSNumberParser.tryParseNumericValue(literalText, true)) != null) {
                return new JSNumberLiteralTypeImpl((Double)literal, true, typeSource, literalText);
            }
            if (type == "bigint" && literalText.length() > 0 && (literal = JSNumberParser.tryParseBigInt(literalText)) != null) {
                return new JSBigIntLiteralTypeImpl((BigInteger)literal, true, typeSource, literalText);
            }
        }
        return type != null ? JSTypeEvaluator.createConstantNamedType(type, rawqualifier) : null;
    }

    private static boolean isBigIntLiteral(@NotNull JSExpression rawqualifier) {
        IElementType sign;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(120);
        }
        if (rawqualifier instanceof JSPrefixExpression && ((sign = ((JSPrefixExpression)rawqualifier).getOperationSign()) == JSTokenTypes.PLUS || sign == JSTokenTypes.MINUS)) {
            rawqualifier = ((JSPrefixExpression)rawqualifier).getExpression();
        }
        return rawqualifier instanceof JSLiteralExpression && ((JSLiteralExpression)rawqualifier).isBigInteger() && DialectDetector.hasFeature((PsiElement)rawqualifier, JSLanguageFeature.BIG_INT);
    }

    @NotNull
    private static JSType createConstantNamedType(@NotNull String name, @NotNull JSExpression rawqualifier) {
        if (name == null) {
            JSTypeEvaluator.$$$reportNull$$$0(121);
        }
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(122);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
        JSType jSType = JSNamedTypeFactory.createType(name, typeSource, JSContext.INSTANCE);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(123);
        }
        return jSType;
    }

    @Nullable
    private static String detectTypeByExpression(@NotNull JSExpression rawqualifier) {
        ASTNode childNode;
        IElementType constantType;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(124);
        }
        if (rawqualifier instanceof JSPrefixExpression && JSSymbolUtil.isLiteralOrLiteralWithSign(rawqualifier)) {
            return "number";
        }
        if (rawqualifier instanceof JSLiteralExpression) {
            JSLiteralExpressionKind kind = ((JSLiteralExpression)rawqualifier).getExpressionKind(false);
            switch (kind) {
                case QUOTED: 
                case TEMPLATE_NO_ARGS: 
                case TEMPLATE_WITH_ARGS: {
                    return "string";
                }
                case REGEXP: {
                    return "RegExp";
                }
                case TRUE: 
                case FALSE: {
                    return "boolean";
                }
                case NULL: {
                    return "null";
                }
            }
            if (kind.isNumeric()) {
                return "number";
            }
            if (kind != JSLiteralExpressionKind.XML) {
                return null;
            }
        }
        IElementType iElementType = constantType = (childNode = rawqualifier.getNode().getFirstChildNode()) != null ? childNode.getElementType() : null;
        return constantType == JSTokenTypes.XML_START_TAG_START ? "XML" : (constantType == JSTokenTypes.XML_START_TAG_LIST ? "XMLList" : (constantType == JSTokenTypes.UNDEFINED_KEYWORD && !DialectDetector.isActionScript((PsiElement)rawqualifier) ? "undefined" : null));
    }

    @Nullable
    private static String getConstantLiteralText(@NotNull JSExpression jsExpression) {
        String value;
        if (jsExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(125);
        }
        String prefix = null;
        if (jsExpression instanceof JSPrefixExpression) {
            IElementType sign = ((JSPrefixExpression)jsExpression).getOperationSign();
            if (sign == JSTokenTypes.MINUS) {
                prefix = "-";
            }
            jsExpression = ((JSPrefixExpression)jsExpression).getExpression();
        }
        if (jsExpression == null) {
            return null;
        }
        if (jsExpression instanceof JSLiteralExpression && (value = ((JSLiteralExpression)jsExpression).getStringValue()) != null) {
            return value;
        }
        if (jsExpression instanceof JSStringTemplateExpression && ((JSStringTemplateExpression)jsExpression).getArguments().length > 0) {
            return null;
        }
        ASTNode node = jsExpression.getNode();
        ASTNode childNode = node.getFirstChildNode();
        String text = childNode.getText();
        if (prefix != null && text.length() > 0) {
            return prefix + text;
        }
        return text;
    }

    private boolean addAdditionalTypes(@NotNull JSReferenceExpression localQualifier, @NotNull JSReferenceExpression qualifier) {
        if (localQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(126);
        }
        if (qualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(127);
        }
        if (DialectDetector.isTypeScript((PsiElement)localQualifier)) {
            return false;
        }
        boolean hasSomeType = false;
        if (this.myContext.peekJSElementToApply() instanceof JSApplyCallElement) {
            Ref result2 = Ref.create((Object)false);
            this.myContext.processWithoutTopJSElementToApply(() -> {
                boolean value = this.addAdditionalTypes((PsiElement)qualifier, (JSReferenceItem)localQualifier, (JSReferenceItem)qualifier);
                result2.set((Object)value);
            });
            hasSomeType = (Boolean)result2.get();
        } else {
            hasSomeType = this.addAdditionalTypes((PsiElement)qualifier, (JSReferenceItem)localQualifier, (JSReferenceItem)qualifier);
        }
        if ("getComponentById".equals(qualifier.getReferenceName())) {
            hasSomeType |= this.tryAddBindowsType(qualifier);
        }
        return hasSomeType;
    }

    private boolean addAdditionalTypes(@NotNull PsiElement context, @NotNull JSReferenceItem localQualifier, @NotNull JSReferenceItem qualifier) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(128);
        }
        if (localQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(129);
        }
        if (qualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(130);
        }
        if (DialectDetector.isTypeScript(context)) {
            return false;
        }
        boolean hasSomeType = false;
        if (JSSymbolUtil.isAccurateReferenceExpressionName(localQualifier, "$") || JSSymbolUtil.isAccurateReferenceExpressionName(localQualifier, JQUERY_NS) || JSSymbolUtil.isAccurateReferenceExpressionName(localQualifier, JQUERY_NS, "$")) {
            this.addJQueryType(context);
            hasSomeType = true;
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName(qualifier, "$") || JSSymbolUtil.isAccurateReferenceExpressionName(qualifier, JQUERY_NS)) {
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(context, false);
            this.addType(JSNamedTypeFactory.createType("HTMLElement", typeSource, JSContext.UNKNOWN), context);
            hasSomeType = true;
        }
        return hasSomeType;
    }

    private void addJQueryType(@NotNull PsiElement source) {
        if (source == null) {
            JSTypeEvaluator.$$$reportNull$$$0(131);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(source, false);
        this.addType(JSNamedTypeFactory.createType(JQUERY_NS, typeSource, JSContext.UNKNOWN), source, true);
    }

    private boolean tryAddBindowsType(JSReferenceExpression qualifier) {
        JSIndexContent content;
        Collection<JSImplicitElementsIndex.JSElementProxy> proxies;
        PsiFile containingFile;
        PsiElement element = qualifier.getParent();
        if (!(element instanceof JSCallExpression)) {
            return false;
        }
        JSArgumentList argumentList = ((JSCallExpression)element).getArgumentList();
        if (argumentList == null) {
            return false;
        }
        JSExpression[] expressions = argumentList.getArguments();
        if (expressions.length == 0 || !(expressions[0] instanceof JSLiteralExpression)) {
            return false;
        }
        String val = StringUtil.unquoteString((String)expressions[0].getText());
        PsiElement contextElement = qualifier.getContainingFile().getContext();
        if (contextElement != null && JSTagContextBuilder.isBindowsXml(containingFile = contextElement.getContainingFile()) && (proxies = (content = JSIndexContent.get(containingFile)).getImplicitElements().get(val)) != null) {
            for (JSImplicitElementsIndex.JSElementProxy proxy : proxies) {
                XmlTag tag;
                PsiElement elementAtOffset = proxy.toOffsetBasedImplicitElement(containingFile).getElementAtOffset();
                if (elementAtOffset == null || (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, XmlTag.class)) == null) continue;
                JSType type = JSNamedTypeFactory.createType(JSTagContextBuilder.getTypeName(tag), JSTypeSourceFactory.createTypeSource(elementAtOffset, false), JSContext.UNKNOWN);
                this.myTypeProcessor.process(type, this.myContext, elementAtOffset);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static String getElementQName(JSNamedElement psiElement) {
        String name = null;
        if (psiElement instanceof JSQualifiedNamedElement) {
            name = ((JSQualifiedNamedElement)psiElement).getQualifiedName();
        }
        if (name == null) {
            name = psiElement.getName();
        }
        return name;
    }

    protected void addTypeFromObjectLiteralExpression(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        JSApplyContextElement peek = this.myContext.peekJSElementToApply();
        if (peek instanceof JSApplyPropertyElement) {
            this.myContext.processWithoutTopJSElementToApply(() -> {
                if (peek instanceof JSApplyDestructuringPropertyElement && ((JSApplyDestructuringPropertyElement)peek).getProperty().isRest()) {
                    JSType recordType = this.getObjectLiteralType(expression, evaluatePropertyTypes);
                    JSApplyContextUtil.processProperty((JSApplyPropertyElement)peek, recordType, (newType, newElement) -> this.addType((JSType)newType, (PsiElement)newElement));
                } else {
                    JSProperty property = expression.findProperty(((JSApplyPropertyElement)peek).getName());
                    if (property != null) {
                        this.addTypeFromProperty(property);
                    }
                }
            });
        } else {
            JSType recordType = this.getObjectLiteralType(expression, evaluatePropertyTypes);
            this.addType(recordType, (PsiElement)expression);
        }
    }

    @NotNull
    protected JSType getObjectLiteralType(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            return new JSObjectType(JSTypeSourceFactory.createTypeSource((PsiElement)expression, false), JSTypeContext.UNKNOWN);
        }
        if (DialectDetector.isTypeScript((PsiElement)expression)) {
            evaluatePropertyTypes = true;
        }
        JSElement[] properties = expression.getPropertiesIncludingSpreads();
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)expression, true);
        HashMap<String, JSRecordType.PropertySignature> propertyMembers = new HashMap<String, JSRecordType.PropertySignature>();
        ArrayList<JSRecordType.TypeMember> nonPropertyMembers = new ArrayList<JSRecordType.TypeMember>();
        SmartList syntheticStringIndexerTypes = new SmartList();
        SmartList syntheticNumericIndexerTypes = new SmartList();
        ArrayList<JSType> unexpandedTypes = new ArrayList<JSType>();
        boolean hasComputedProps = false;
        for (JSElement property : properties) {
            JSType spreadType;
            if (property instanceof JSProperty) {
                ES6ComputedName computedPropertyName;
                JSRecordType.PropertySignature member = this.getTypeMemberFromSimplePropertyValue((JSProperty)property, evaluatePropertyTypes);
                if (member != null && member.hasValidName()) {
                    propertyMembers.put(member.getMemberName(), member);
                }
                boolean hasComputedName = false;
                if (property instanceof JSComputedPropertyNameOwner && (computedPropertyName = ((JSComputedPropertyNameOwner)property).getComputedPropertyName()) != null) {
                    hasComputedName = true;
                    hasComputedProps = true;
                    if (evaluatePropertyTypes) {
                        JSExpression jsExpression = computedPropertyName.getExpression();
                        JSType propNameType = this.getExpressionTypeInContext(jsExpression);
                        JSType propNameValuableType = JSTypeUtils.getValuableType(propNameType);
                        if (propNameValuableType instanceof JSStringType) {
                            ContainerUtil.addIfNotNull((Collection)syntheticStringIndexerTypes, (Object)this.getWidenedPropertyType((JSProperty)property));
                        }
                        if (propNameValuableType instanceof JSNumberType) {
                            JSType widenedPropertyType = this.getWidenedPropertyType((JSProperty)property);
                            ContainerUtil.addIfNotNull((Collection)syntheticNumericIndexerTypes, (Object)widenedPropertyType);
                            ContainerUtil.addIfNotNull((Collection)syntheticStringIndexerTypes, (Object)widenedPropertyType);
                        }
                    }
                }
                if (hasComputedName) continue;
                ContainerUtil.addIfNotNull((Collection)syntheticStringIndexerTypes, (Object)this.getWidenedPropertyType((JSProperty)property));
                continue;
            }
            if (!(property instanceof JSSpreadExpression) || (spreadType = JSTypeUtils.getValuableType(((JSSpreadExpression)property).getInnerExpressionType())) == null) continue;
            if (spreadType instanceof JSAnyType) {
                JSTypeSource source = spreadType.getSource();
                if (spreadType.isTypeScript()) {
                    JSType jSType = spreadType;
                    if (jSType == null) {
                        JSTypeEvaluator.$$$reportNull$$$0(132);
                    }
                    return jSType;
                }
                PsiElement sourceElement = spreadType.getSourceElement();
                if (sourceElement == null) {
                    sourceElement = property;
                }
                return new JSRecordTypeImpl(source, Collections.singletonList(new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSStringType(true, source, JSTypeContext.INSTANCE), spreadType, JSRecordMemberSourceFactory.createSource(sourceElement), false)));
            }
            if (JSTypeUtils.hasForeignGenericParameter(spreadType) || spreadType instanceof JSEvaluableOnlyType && spreadType.isJavaScript()) {
                unexpandedTypes.add(spreadType);
                continue;
            }
            for (JSRecordType.TypeMember member : spreadType.asRecordType().getTypeMembers()) {
                if (member instanceof JSRecordType.PropertySignature) {
                    if (member instanceof PsiElement && JSUtils.isPrivateSharpItem((PsiElement)member)) continue;
                    propertyMembers.put(((JSRecordType.PropertySignature)member).getMemberName(), JSTypeEvaluator.mergeIfOptional(typeSource, propertyMembers, (JSRecordType.PropertySignature)member));
                    continue;
                }
                if (spreadType.getSourceElement() instanceof TypeScriptEnum && member instanceof JSRecordType.IndexSignature) continue;
                JSTypeEvaluator.addMember(nonPropertyMembers, member);
            }
        }
        if (hasComputedProps && syntheticStringIndexerTypes.size() > 0) {
            JSTypeEvaluator.addMember(nonPropertyMembers, (JSRecordType.TypeMember)new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSStringType(true, typeSource, JSTypeContext.INSTANCE), JSCompositeTypeImpl.optimizeTypeIfComposite(JSCompositeTypeFactory.createUnionType(typeSource, (Collection<? extends JSType>)syntheticStringIndexerTypes)), (PsiElement)null, true));
        }
        if (hasComputedProps && syntheticNumericIndexerTypes.size() > 0) {
            JSTypeEvaluator.addMember(nonPropertyMembers, (JSRecordType.TypeMember)new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSNumberType(true, typeSource, JSTypeContext.INSTANCE), JSCompositeTypeImpl.optimizeTypeIfComposite(JSCompositeTypeFactory.createUnionType(typeSource, (Collection<? extends JSType>)syntheticNumericIndexerTypes)), (PsiElement)null, true));
        }
        JSFreshObjectLiteralTypeImpl literalType = new JSFreshObjectLiteralTypeImpl(typeSource, ContainerUtil.concat(nonPropertyMembers, new ArrayList(propertyMembers.values())));
        if (unexpandedTypes.size() == 0) {
            JSFreshObjectLiteralTypeImpl jSFreshObjectLiteralTypeImpl = literalType;
            if (jSFreshObjectLiteralTypeImpl == null) {
                JSTypeEvaluator.$$$reportNull$$$0(133);
            }
            return jSFreshObjectLiteralTypeImpl;
        }
        if (literalType.hasMembers()) {
            unexpandedTypes.add(literalType);
        }
        JSType jSType = JSCompositeTypeFactory.createIntersectionType(unexpandedTypes, typeSource, true);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(134);
        }
        return jSType;
    }

    @NotNull
    private static JSRecordType.PropertySignature mergeIfOptional(@NotNull JSTypeSource typeSource, @NotNull Map<String, JSRecordType.PropertySignature> propertyMembers, @NotNull JSRecordType.PropertySignature member) {
        String memberName;
        if (typeSource == null) {
            JSTypeEvaluator.$$$reportNull$$$0(135);
        }
        if (propertyMembers == null) {
            JSTypeEvaluator.$$$reportNull$$$0(136);
        }
        if (member == null) {
            JSTypeEvaluator.$$$reportNull$$$0(137);
        }
        if (propertyMembers.containsKey(memberName = member.getMemberName()) && member.isOptional()) {
            JSRecordType.PropertySignature oldMember = propertyMembers.get(memberName);
            member = new JSRecordTypeImpl.PropertySignatureImpl(memberName, JSCompositeTypeImpl.getCommonType((JSType)ObjectUtils.coalesce((Object)oldMember.getJSType(), (Object)JSAnyType.get(typeSource)), (JSType)ObjectUtils.coalesce((Object)member.getJSType(), (Object)JSAnyType.get(typeSource)), typeSource, true), oldMember.isOptional() && member.isOptional(), oldMember.isConst() || member.isConst());
        }
        JSRecordType.PropertySignature propertySignature = member;
        if (propertySignature == null) {
            JSTypeEvaluator.$$$reportNull$$$0(138);
        }
        return propertySignature;
    }

    private static void addMember(ArrayList<JSRecordType.TypeMember> nonPropertyMembers, JSRecordType.TypeMember member) {
        boolean memberSet = false;
        if (member instanceof JSRecordType.IndexSignature) {
            for (int i = 0; i < nonPropertyMembers.size(); ++i) {
                JSRecordType.TypeMember propertyMember = nonPropertyMembers.get(i);
                if (!(propertyMember instanceof JSRecordType.IndexSignature) || ((JSRecordType.IndexSignature)propertyMember).getIndexSignatureKind() != ((JSRecordType.IndexSignature)member).getIndexSignatureKind()) continue;
                nonPropertyMembers.set(i, member);
                memberSet = true;
            }
        }
        if (!memberSet) {
            nonPropertyMembers.add(member);
        }
    }

    @Nullable
    protected JSType getWidenedPropertyType(@NotNull JSProperty property) {
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(139);
        }
        return JSTypeUtils.widenLiteralTypes(property.getJSType());
    }

    @Nullable
    private JSRecordType.PropertySignature getTypeMemberFromSimplePropertyValue(@NotNull JSProperty property, boolean evaluatePropertyTypes) {
        JSFunctionType type;
        String name;
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(140);
        }
        if ((name = property.getName()) == null && property instanceof JSComputedPropertyNameOwner) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)property);
        }
        if (name == null && !(property instanceof JSComputedPropertyNameOwner)) {
            return null;
        }
        if (property instanceof ES6FunctionProperty) {
            type = TypeScriptTypeParser.buildFunctionType((JSFunctionItem)((JSFunction)property));
        } else {
            type = this.getWidenedPropertyType(property);
            if (!(DialectDetector.isTypeScript((PsiElement)property) || type != null && JSTypeEvaluator.isAcceptableInitializerType((JSType)type) || !evaluatePropertyTypes)) {
                type = this.getExpressionTypeInContext(property.getValue());
            }
        }
        type = JSTypeEvaluator.modifyTypeIfAccessor(property, (JSType)type);
        if (name == null) {
            String referenceName;
            ES6ComputedName propertyName = ((JSComputedPropertyNameOwner)property).getComputedPropertyName();
            String string = referenceName = propertyName == null ? null : propertyName.getExpressionAsReferenceName();
            if (referenceName != null) {
                return new JSRecordTypeImpl.ComputedPropertySignatureImpl(referenceName, (JSType)type, false, property instanceof JSConstStatusOwner && ((JSConstStatusOwner)property).isConst(), JSRecordMemberSourceFactory.createSource((PsiElement)property));
            }
            return null;
        }
        return new JSRecordTypeImpl.PropertySignatureImpl(name, (JSType)type, false, property instanceof JSConstStatusOwner && ((JSConstStatusOwner)property).isConst(), (PsiElement)property);
    }

    @Nullable
    private static JSType modifyTypeIfAccessor(@NotNull JSProperty property, @Nullable JSType type) {
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(141);
        }
        boolean isGetter = property.isGetProperty();
        boolean isSetter = property.isSetProperty();
        if (!isGetter && !isSetter) {
            return type;
        }
        if (type instanceof JSFunctionTypeImpl) {
            if (isGetter) {
                return ((JSFunctionTypeImpl)type).getReturnType();
            }
            List<JSParameterTypeDecorator> parameters = ((JSFunctionTypeImpl)type).getParameters();
            if (parameters.size() >= 1) {
                return parameters.get(0).getSimpleType();
            }
        }
        return JSAnyType.get(JSTypeSourceFactory.createTypeSource((PsiElement)property, false));
    }

    protected void addTypeFromDefExpr(@NotNull JSDefinitionExpression psiElement) {
        JSDocComment comment;
        JSNamespace providedNs;
        JSType jsType;
        if (psiElement == null) {
            JSTypeEvaluator.$$$reportNull$$$0(142);
        }
        if ((jsType = psiElement.getJSType()) instanceof JSStubBasedExpressionType) {
            jsType = null;
        }
        boolean hasType = false;
        if (jsType != null) {
            this.addType(jsType, (PsiElement)psiElement);
            hasType = true;
            if (jsType instanceof JSReferenceType && CommonJSUtil.isExportNamespace(JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)psiElement))) {
                String referencedName = ((JSReferenceType)jsType).getReferenceName();
                JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.create(referencedName, null);
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)psiElement, true);
                for (FrameworkIndexingHandler indexingHandler : FrameworkIndexingHandler.getExtensions((PsiElement)psiElement)) {
                    JSType type = indexingHandler.getExportsInnerAliasType(qualifiedName, typeSource);
                    if (type == null) continue;
                    this.addType(type, (PsiElement)psiElement);
                }
            }
            if (jsType.getSource().isStrict()) {
                return;
            }
        }
        if (!hasType) {
            boolean evaluateInitializer;
            JSFunctionExpression functionExpression;
            JSExpression initializer = psiElement.getInitializerOrStub();
            JSFunctionExpression jSFunctionExpression = functionExpression = initializer instanceof JSFunctionExpression ? (JSFunctionExpression)initializer : null;
            if (functionExpression != null && !this.myContext.isJSElementsToApplyEmpty()) {
                this.processFunction((JSFunction)functionExpression);
                return;
            }
            boolean bl = evaluateInitializer = this.myContext.isStrict() || CommonJSUtil.isExportNamespace(JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)psiElement));
            if (evaluateInitializer) {
                if (this.isAstAccessAllowed((PsiElement)psiElement)) {
                    JSExpression expr = JSPsiImplUtils.getRightmostOperand(psiElement);
                    if (expr != null) {
                        this.evaluateTypes(expr);
                    }
                } else if (initializer != null) {
                    this.getEvaluationContext().withAstAccessForbidden(() -> this.evaluateTypes(initializer));
                }
            }
        }
        boolean explicitType = false;
        if (psiElement.isNamespaceExplicitlyDeclared() && (providedNs = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)psiElement, explicitType = (comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)psiElement)) != null && comment.hasNamespaceTag())) != null) {
            if (explicitType) {
                this.addType((JSType)providedNs, EXPLICIT_TYPE_MARKER_ELEMENT);
            } else {
                this.addNamespace(providedNs, (PsiElement)psiElement);
            }
        }
        if (jsType == null && !explicitType && !CommonJSUtil.isModuleExportsElement((JSElementBase)psiElement)) {
            this.myTypeProcessor.setUnknownElement((PsiElement)psiElement);
        }
    }

    @NotNull
    protected JSExpectedTypeKind getContextualExpectedTypeKind() {
        JSExpectedTypeKind jSExpectedTypeKind = this.isContextualOverloadEvaluation() ? JSExpectedTypeKind.CONTEXTUAL_WITH_OVERLOADS : JSExpectedTypeKind.CONTEXTUAL;
        if (jSExpectedTypeKind == null) {
            JSTypeEvaluator.$$$reportNull$$$0(143);
        }
        return jSExpectedTypeKind;
    }

    private void simpleEvalType(JSExpression rawqualifier, JSExpression lOperand) {
        JSType evaluatedType = this.getExpressionTypeInContext(lOperand);
        if (evaluatedType != null) {
            this.addType(evaluatedType, (PsiElement)rawqualifier);
        } else {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    protected void processItem(@NotNull PsiElement element, @NotNull Runnable runnable) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(144);
        }
        if (runnable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(145);
        }
        JSEvaluationKey node = new JSEvaluationKey(element, this.isContextualOverloadEvaluation(), runnable.getClass());
        ourRecursionGuard.doPreventingRecursion(node, false, () -> {
            runnable.run();
            return null;
        });
    }

    public static void processWithEvaluationGuard(@NotNull PsiElement element, @NotNull Computable<?> runnable) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(146);
        }
        if (runnable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(147);
        }
        JSEvaluationKey node = new JSEvaluationKey(element, false, runnable.getClass());
        ourRecursionGuard.doPreventingRecursion(node, false, runnable);
    }

    protected void applyContextAndProcessResolvedElement(@NotNull PsiElement resolve) {
        if (resolve == null) {
            JSTypeEvaluator.$$$reportNull$$$0(148);
        }
        if (this.myContext.peekJSElementToApply() instanceof JSApplyPropertyElement) {
            this.myContext.processWithoutTopJSElementToApply(peek -> this.applyDestructuringPropertyAndProcessResolvedElement(resolve, (JSApplyPropertyElement)peek));
            return;
        }
        if (resolve instanceof JSFile && this.myContext.peekJSElementToApply() instanceof JSWrapInPromiseTypeElement) {
            this.addType(JSModuleTypeImpl.createTypeForFile((JSFile)resolve), resolve);
            return;
        }
        this.myTypeProcessor.processResolvedElement(resolve, this.myContext);
    }

    private void applyDestructuringPropertyAndProcessResolvedElement(@NotNull PsiElement resolve, @NotNull JSApplyPropertyElement property) {
        if (resolve == null) {
            JSTypeEvaluator.$$$reportNull$$$0(149);
        }
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(150);
        }
        final String name = property.getName();
        JSResolveProcessorBase processor = new JSResolveProcessorBase(name){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(element instanceof JSPsiNamedElementBase) || name.equals(((JSPsiNamedElementBase)element).getName())) {
                    JSTypeEvaluator.processWithEvaluationGuard(element, () -> {
                        JSTypeEvaluator.this.addTypeFromResolveResult(element);
                        return null;
                    });
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JSReferenceExpression place = this.myContext.getProcessedExpression();
        if (place == null) {
            place = resolve;
        }
        QualifiedItemProcessor.processResolvedElement(resolve, new JSEvaluateContext(this.myContext.targetFile), processor, (PsiElement)place);
    }

    @NotNull
    public static JSEvaluatorComplexityTracker getComplexityTracker() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            JSEvaluatorComplexityTracker jSEvaluatorComplexityTracker = ourComplexityTracker.get();
            if (jSEvaluatorComplexityTracker == null) {
                JSTypeEvaluator.$$$reportNull$$$0(151);
            }
            return jSEvaluatorComplexityTracker;
        }
        Thread currentThread = Thread.currentThread();
        JSEvaluatorComplexityTracker complexityTracker = ourTestComplexityTracker.get(currentThread);
        if (complexityTracker != null) {
            JSEvaluatorComplexityTracker jSEvaluatorComplexityTracker = complexityTracker;
            if (jSEvaluatorComplexityTracker == null) {
                JSTypeEvaluator.$$$reportNull$$$0(152);
            }
            return jSEvaluatorComplexityTracker;
        }
        complexityTracker = new JSEvaluatorComplexityTracker(ourTestMaxComplexity);
        ourTestComplexityTracker.put(currentThread, complexityTracker);
        JSEvaluatorComplexityTracker jSEvaluatorComplexityTracker = complexityTracker;
        if (jSEvaluatorComplexityTracker == null) {
            JSTypeEvaluator.$$$reportNull$$$0(153);
        }
        return jSEvaluatorComplexityTracker;
    }

    public static void setMaxComplexity(int maxComplexity, @NotNull Disposable testRootDisposable) {
        if (testRootDisposable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(154);
        }
        final int defaultMaxComplexity = ourTestMaxComplexity;
        ourTestMaxComplexity = maxComplexity;
        ourTestComplexityTracker.clear();
        Disposer.register((Disposable)testRootDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ourTestMaxComplexity = defaultMaxComplexity;
                ourTestComplexityTracker.clear();
            }
        });
    }

    protected boolean isAstAccessAllowed(@NotNull PsiElement context) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(155);
        }
        return this.isAstAccessAllowed(context, false);
    }

    protected boolean isAstAccessAllowed(@NotNull PsiElement context, boolean allowAccessInNonTargetFile) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(156);
        }
        return this.myContext.isAstAccessAllowed() && (allowAccessInNonTargetFile || this.isFromCurrentFile(context));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 26: 
            case 55: 
            case 61: 
            case 78: 
            case 83: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 123: 
            case 132: 
            case 133: 
            case 134: 
            case 138: 
            case 143: 
            case 151: 
            case 152: 
            case 153: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 26: 
            case 55: 
            case 61: 
            case 78: 
            case 83: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 123: 
            case 132: 
            case 133: 
            case 134: 
            case 138: 
            case 143: 
            case 151: 
            case 152: 
            case 153: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 40: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProcessor";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 72: 
            case 100: 
            case 105: 
            case 108: 
            case 144: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: 
            case 55: 
            case 61: 
            case 78: 
            case 83: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 123: 
            case 132: 
            case 133: 
            case 134: 
            case 138: 
            case 143: 
            case 151: 
            case 152: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator";
                break;
            }
            case 27: 
            case 60: 
            case 81: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callItem";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 42: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawqualifier";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluatedExpression";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 50: 
            case 53: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 54: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisQualifier";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawQualifier";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 67: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoked";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 73: 
            case 99: 
            case 148: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 75: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 82: 
            case 127: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 85: 
            case 103: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsVariable";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringContainer";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "amdModuleReference";
                break;
            }
            case 104: 
            case 139: 
            case 140: 
            case 141: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsExpression";
                break;
            }
            case 126: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localQualifier";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyMembers";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 145: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRootDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvaluator";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeForThisExpression";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createNullType";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationContext";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResultsFromQualifier";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceFromQualifiedNamedElement";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromArrayExpression";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromProcessor";
                break;
            }
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeWithExpandingComposite";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstantNamedType";
                break;
            }
            case 132: 
            case 133: 
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectLiteralType";
                break;
            }
            case 138: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeIfOptional";
                break;
            }
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextualExpectedTypeKind";
                break;
            }
            case 151: 
            case 152: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "getComplexityTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forceEvaluateType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypes";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpressionOrElementTypes";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateExpressionOrElementTypes";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluator";
                break;
            }
            case 26: 
            case 55: 
            case 61: 
            case 78: 
            case 83: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 123: 
            case 132: 
            case 133: 
            case 134: 
            case 138: 
            case 143: 
            case 151: 
            case 152: 
            case 153: {
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionType";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getElementType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getContextualType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addTypeEvaluationResultElement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "doAddType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "applyContextAndProcess";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addEvaluableOnlyType";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addReturnType";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addNamespace";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "applyContextAndProcessNamespace";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processBinaryOperation";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypeFromInlineComment";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addNumericOperatorType";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePlusType";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "evaluateAndOrOrType";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyAccessType";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierExpression";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createTypeForThisExpression";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierInExecutionScope";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getArrayTypeFromExpressions";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOrSpread";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElementTypeFromSpread";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCallExpressionTypes";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromGclRequireCall";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "processRequireMethodCall";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "processApplyOrCallMethodCall";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "processCreateMethodCall";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "addModuleFromRequire";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromExternalModuleReferenceResolveResult";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromModuleFile";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultExportNamespaces";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "processFunction";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromConstructorName";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "processRefExpr";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getResolveResultsFromQualifier";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipProcessing";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromResolveResult";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromVariableResolveResult";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "definesConstructor";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromVariableInitializer";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "processParameterType";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "pushDestructuringContext";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "isForStatementDeclaration";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTypeGuard";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyJSObjectLiteral";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "evaluateDestructuringContainer";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "substituteThisType";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromAmdModuleReference";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromAmdModule";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "isFromCurrentFile";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypesFromCache";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "processInstanceContextForClass";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromImplicitElementResolveResult";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromProperty";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFromQualifiedNamedElement";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassCandidate";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "addLoopVariable";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromLiteralExpression";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromConstant";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "isBigIntLiteral";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "createConstantNamedType";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "detectTypeByExpression";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getConstantLiteralText";
                break;
            }
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalTypes";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "addJQueryType";
                break;
            }
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "mergeIfOptional";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "getWidenedPropertyType";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMemberFromSimplePropertyValue";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "modifyTypeIfAccessor";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromDefExpr";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "processItem";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "processWithEvaluationGuard";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "applyContextAndProcessResolvedElement";
                break;
            }
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "applyDestructuringPropertyAndProcessResolvedElement";
                break;
            }
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "setMaxComplexity";
                break;
            }
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "isAstAccessAllowed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 26: 
            case 55: 
            case 61: 
            case 78: 
            case 83: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 123: 
            case 132: 
            case 133: 
            case 134: 
            case 138: 
            case 143: 
            case 151: 
            case 152: 
            case 153: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class JSTypeProcessorWrapper
    implements JSTypeProcessor {
        @NotNull
        private final JSTypeProcessor myDelegate;
        private boolean mySomeResultAddedForCurrentResolveResult;

        public JSTypeProcessorWrapper(@NotNull JSTypeProcessor delegate) {
            if (delegate == null) {
                JSTypeProcessorWrapper.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
            if (type == null) {
                JSTypeProcessorWrapper.$$$reportNull$$$0(1);
            }
            if (evaluateContext == null) {
                JSTypeProcessorWrapper.$$$reportNull$$$0(2);
            }
            this.mySomeResultAddedForCurrentResolveResult = true;
            this.myDelegate.process(type, evaluateContext, source);
        }

        @Override
        public void processNamespace(@NotNull JSNamespace namespace, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
            if (namespace == null) {
                JSTypeProcessorWrapper.$$$reportNull$$$0(3);
            }
            if (evaluateContext == null) {
                JSTypeProcessorWrapper.$$$reportNull$$$0(4);
            }
            this.mySomeResultAddedForCurrentResolveResult = true;
            this.myDelegate.processNamespace(namespace, evaluateContext, source);
        }

        @Override
        public void processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext) {
            if (element == null) {
                JSTypeProcessorWrapper.$$$reportNull$$$0(5);
            }
            if (evaluateContext == null) {
                JSTypeProcessorWrapper.$$$reportNull$$$0(6);
            }
            this.mySomeResultAddedForCurrentResolveResult = true;
            this.myDelegate.processResolvedElement(element, evaluateContext);
        }

        @Override
        public void setUnknownElement(@NotNull PsiElement element) {
            if (element == null) {
                JSTypeProcessorWrapper.$$$reportNull$$$0(7);
            }
            this.mySomeResultAddedForCurrentResolveResult = true;
            this.myDelegate.setUnknownElement(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluateContext";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator$JSTypeProcessorWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processNamespace";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processResolvedElement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setUnknownElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class JSEvaluationKey {
        public final PsiElement myElement;
        public final boolean myIsContextualOverloadEvaluation;
        public final Class myProviderClass;

        public JSEvaluationKey(@NotNull PsiElement element, boolean isContextualOverloadEvaluation, @NotNull Class providerClass) {
            if (element == null) {
                JSEvaluationKey.$$$reportNull$$$0(0);
            }
            if (providerClass == null) {
                JSEvaluationKey.$$$reportNull$$$0(1);
            }
            this.myElement = element;
            this.myIsContextualOverloadEvaluation = isContextualOverloadEvaluation;
            this.myProviderClass = providerClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JSEvaluationKey key = (JSEvaluationKey)o;
            return this.myElement.equals(key.myElement) && this.myIsContextualOverloadEvaluation == key.myIsContextualOverloadEvaluation && this.myProviderClass.equals(key.myProviderClass);
        }

        public int hashCode() {
            return Objects.hash(this.myElement, this.myIsContextualOverloadEvaluation, this.myProviderClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "providerClass";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator$JSEvaluationKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

