/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeResolvedHashCodeUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeAssignableErrorMessage;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeMemberParser;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.recordImpl.CallSignatureCommonImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.IndexSignatureCommonImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureCommonImpl;
import com.intellij.lang.javascript.settings.JSSymbolPresentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRecordTypeImpl
extends JSTypeBaseImpl
implements JSRecordType,
JSType.CompositeStructure {
    @NotNull
    protected final List<JSRecordType.TypeMember> myAllTypeMembers;
    @NotNull
    protected final List<JSRecordType.CallSignature> myCallSignatures;
    @Nullable
    protected final JSRecordType.IndexSignature myStringIndexer;
    @Nullable
    protected final JSRecordType.IndexSignature myNumericIndexer;
    @NotNull
    protected final Map<String, JSRecordType.PropertySignature> myProperties;
    protected final boolean myIsWeakType;
    protected final List<JSRecordType.PropertySignature> myComputedProperties;

    public JSRecordTypeImpl(@NotNull JSTypeSource source, @NotNull List<? extends JSRecordType.TypeMember> typeMembers) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(0);
        }
        if (typeMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(1);
        }
        this(source, typeMembers, true);
    }

    protected JSRecordTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(3);
        }
        this(source, JSTypeSerializer.TYPE_MEMBERS_SERIALIZER.read(source, inputStream));
    }

    /*
     * WARNING - void declaration
     */
    public JSRecordTypeImpl(@NotNull JSTypeSource source, @NotNull List<? extends JSRecordType.TypeMember> typeMembers, boolean removeFreshness) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(4);
        }
        if (typeMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(5);
        }
        super(source);
        THashMap nameToPropertySignature = new THashMap();
        ArrayList<Object> allMembers = new ArrayList<Object>(typeMembers.size());
        JSRecordType.IndexSignature stringIndex = null;
        JSRecordType.IndexSignature numericIndex = null;
        ArrayList<JSRecordType.CallSignature> callSignatures = null;
        ArrayList<ComputedPropertySignatureImpl> computedProperties = null;
        TObjectIntHashMap propertyIndices = new TObjectIntHashMap();
        boolean isPossiblyWeak = true;
        int positionInAllMembers = -1;
        for (JSRecordType.TypeMember typeMember : typeMembers) {
            void var14_14;
            if (typeMember instanceof JSRecordType.PropertySignature) {
                JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)typeMember;
                if (removeFreshness) {
                    JSRecordType.PropertySignature propertySignature2 = propertySignature = JSRecordTypeImpl.removePropertyTypeFreshness(propertySignature);
                }
                if (!propertySignature.isOptional()) {
                    isPossiblyWeak = false;
                }
                if (propertySignature instanceof ComputedPropertySignatureImpl) {
                    if (computedProperties == null) {
                        computedProperties = new ArrayList<ComputedPropertySignatureImpl>();
                    }
                    computedProperties.add((ComputedPropertySignatureImpl)propertySignature);
                    ++positionInAllMembers;
                    allMembers.add(propertySignature);
                    continue;
                }
                String name = propertySignature.getMemberName();
                JSRecordType.PropertySignature storedSignature = (JSRecordType.PropertySignature)nameToPropertySignature.get(name);
                if (storedSignature != null) {
                    JSRecordType.PropertySignature mergedSignature = JSRecordTypeImpl.mergeSignatures(name, propertySignature, storedSignature, source);
                    int index = propertyIndices.get((Object)name);
                    allMembers.set(index, mergedSignature);
                    nameToPropertySignature.put(name, mergedSignature);
                    continue;
                }
                nameToPropertySignature.put(name, propertySignature);
                propertyIndices.put((Object)name, positionInAllMembers + 1);
            } else {
                if (typeMember instanceof JSRecordType.IndexSignature) {
                    JSRecordType.IndexSignatureKind kind = ((JSRecordType.IndexSignature)typeMember).getIndexSignatureKind();
                    switch (kind) {
                        case NUMERIC: {
                            numericIndex = numericIndex == null ? (JSRecordType.IndexSignature)typeMember : numericIndex;
                            break;
                        }
                        case STRING: {
                            stringIndex = stringIndex == null ? (JSRecordType.IndexSignature)typeMember : stringIndex;
                            break;
                        }
                    }
                } else if (typeMember instanceof JSRecordType.CallSignature) {
                    if (callSignatures == null) {
                        callSignatures = new ArrayList<JSRecordType.CallSignature>();
                    }
                    callSignatures.add((JSRecordType.CallSignature)typeMember);
                }
                isPossiblyWeak = false;
            }
            ++positionInAllMembers;
            allMembers.add(var14_14);
        }
        this.myIsWeakType = isPossiblyWeak && !allMembers.isEmpty();
        this.myStringIndexer = stringIndex;
        this.myNumericIndexer = numericIndex;
        this.myCallSignatures = callSignatures == null ? ContainerUtil.emptyList() : Collections.unmodifiableList(callSignatures);
        this.myAllTypeMembers = Collections.unmodifiableList(allMembers);
        this.myProperties = Collections.unmodifiableMap(nameToPropertySignature);
        this.myComputedProperties = computedProperties == null ? ContainerUtil.emptyList() : Collections.unmodifiableList(computedProperties);
    }

    protected JSRecordTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSRecordType.TypeMember> allTypeMembers, @NotNull List<JSRecordType.CallSignature> callSignatures, @Nullable JSRecordType.IndexSignature stringIndexer, @Nullable JSRecordType.IndexSignature numericIndexer, @NotNull Map<String, JSRecordType.PropertySignature> properties, @NotNull List<JSRecordType.PropertySignature> computedProperties, boolean isWeakType) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(6);
        }
        if (allTypeMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(7);
        }
        if (callSignatures == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(8);
        }
        if (properties == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(9);
        }
        if (computedProperties == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(10);
        }
        super(source);
        this.myAllTypeMembers = allTypeMembers;
        this.myCallSignatures = callSignatures;
        this.myStringIndexer = stringIndexer;
        this.myNumericIndexer = numericIndexer;
        this.myProperties = properties;
        this.myComputedProperties = computedProperties;
        this.myIsWeakType = isWeakType;
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(11);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_MEMBERS_SERIALIZER.write(this.myAllTypeMembers, outputStream);
    }

    @NotNull
    private static JSRecordType.PropertySignature mergeSignatures(@NotNull String name, @NotNull JSRecordType.PropertySignature newSignature, @NotNull JSRecordType.PropertySignature stored, @NotNull JSTypeSource source) {
        boolean isReadonly;
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(12);
        }
        if (newSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(13);
        }
        if (stored == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(14);
        }
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(15);
        }
        boolean isOptional = newSignature.isOptional() && stored.isOptional();
        boolean bl = isReadonly = newSignature.isConst() && stored.isConst();
        if (stored instanceof JSCompositeFunctionPropertySignatureImpl) {
            return JSRecordTypeImpl.addPropertyToCompositeFunctions(name, (JSCompositeFunctionPropertySignatureImpl)stored, newSignature, source, isOptional, isReadonly);
        }
        if (newSignature instanceof JSCompositeFunctionPropertySignatureImpl) {
            return JSRecordTypeImpl.addPropertyToCompositeFunctions(name, (JSCompositeFunctionPropertySignatureImpl)newSignature, stored, source, isOptional, isReadonly);
        }
        if (stored instanceof JSFunctionItem && newSignature instanceof JSFunctionItem && (((JSFunctionItem)stored).isGetProperty() && ((JSFunctionItem)newSignature).isSetProperty() || ((JSFunctionItem)stored).isSetProperty() && ((JSFunctionItem)newSignature).isGetProperty())) {
            return JSRecordTypeImpl.mergeAccessors(name, stored, newSignature);
        }
        if (!(stored.getJSType() instanceof JSFunctionTypeImpl)) {
            JSRecordType.PropertySignature propertySignature = stored;
            if (propertySignature == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(16);
            }
            return propertySignature;
        }
        return new JSCompositeFunctionPropertySignatureImpl(name, ContainerUtil.newArrayList((Object[])new JSRecordType.PropertySignature[]{stored, newSignature}), isOptional, isReadonly, source);
    }

    @NotNull
    private static JSRecordType.PropertySignature mergeAccessors(String name, JSRecordType.PropertySignature getter, JSRecordType.PropertySignature setter) {
        return new PropertySignatureImpl(name, getter.getJSType(), getter.isOptional() && setter.isOptional(), false, JSRecordMemberSourceFactory.createSource(ContainerUtil.concat((List)getter.getMemberSource().getAllSourceElements(), (List)setter.getMemberSource().getAllSourceElements()), JSRecordType.MemberSourceKind.MergedAccessor));
    }

    @NotNull
    private static JSRecordType.PropertySignature addPropertyToCompositeFunctions(@NotNull String name, @NotNull JSCompositeFunctionPropertySignatureImpl composite, @NotNull JSRecordType.PropertySignature newProperty, @NotNull JSTypeSource source, boolean isOptional, boolean isReadonly) {
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(17);
        }
        if (composite == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(18);
        }
        if (newProperty == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(19);
        }
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(20);
        }
        List<JSRecordType.PropertySignature> members = composite.getMembers();
        ArrayList<JSRecordType.PropertySignature> list2 = new ArrayList<JSRecordType.PropertySignature>(members.size() + 1);
        list2.addAll(members);
        if (newProperty instanceof JSCompositeFunctionPropertySignatureImpl) {
            list2.addAll(((JSCompositeFunctionPropertySignatureImpl)newProperty).getMembers());
        } else {
            list2.add(newProperty);
        }
        return new JSCompositeFunctionPropertySignatureImpl(name, list2, isOptional, isReadonly, source);
    }

    @NotNull
    private static JSRecordType.PropertySignature removePropertyTypeFreshness(@NotNull JSRecordType.PropertySignature propertySignature) {
        JSType type;
        if (propertySignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(21);
        }
        if (!((type = propertySignature.getJSType()) instanceof JSFreshObjectLiteralType)) {
            JSRecordType.PropertySignature propertySignature2 = propertySignature;
            if (propertySignature2 == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(22);
            }
            return propertySignature2;
        }
        return new PropertySignatureImpl(propertySignature.getMemberName(), (JSType)((JSFreshObjectLiteralType)type).removeFreshness(), propertySignature.isOptional(), propertySignature.isConst(), propertySignature.getMemberSource());
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(23);
        }
        if (builder == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(24);
        }
        builder.append("{");
        boolean useTypeScriptRecordTypeFormat = format == JSType.TypeTextFormat.CODE && this.isTypeScript();
        String prefix = "";
        String nextPrefix = useTypeScriptRecordTypeFormat ? "; " : ", ";
        String separator = this.getTypeSeparator();
        char quote = this.getQuote();
        for (int i = 0; i < this.myAllTypeMembers.size(); ++i) {
            JSRecordType.TypeMember typeMember = this.myAllTypeMembers.get(i);
            builder.append(prefix);
            if (i > 10 && format == JSType.TypeTextFormat.PRESENTABLE) {
                builder.append("...");
                builder.append("}");
                return;
            }
            typeMember.appendMemberPresentation(format, builder, separator, quote);
            prefix = nextPrefix;
        }
        builder.append("}");
    }

    protected char getQuote() {
        String quote = JSSymbolPresentationProvider.getDefaultQuote(this.getSource().getSourceElement());
        return quote.charAt(0);
    }

    @Override
    protected final boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(25);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(26);
        }
        if (this.isTypeScript() && this.hasIndexers() && elementType instanceof JSPrimitiveType && ((JSPrimitiveType)elementType).isPrimitive()) {
            return false;
        }
        if (JSRecordTypeImpl.canSubstitute(elementType)) {
            JSType substitute = elementType.substitute();
            if (elementType != substitute) {
                return this.isDirectlyAssignableType(substitute, processingContext);
            }
            elementType = JSRecordTypeImpl.convertToRecordTypeIfPossible(elementType);
        }
        if (elementType instanceof JSArrayType) {
            elementType = JSRecordTypeImpl.convertToRecordTypeIfPossible(((JSArrayType)elementType).asGenericType());
        }
        if (elementType instanceof JSRecordType) {
            return this.isDirectlyAssignableRecordType((JSRecordType)elementType, processingContext);
        }
        if (elementType instanceof JSObjectType) {
            return true;
        }
        if (!this.hasMembers() && elementType.isJavaScript()) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @NotNull
    private static JSType convertToRecordTypeIfPossible(@NotNull JSType elementType) {
        JSRecordType recordTypeCandidate;
        if (elementType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(27);
        }
        Object object = (recordTypeCandidate = elementType.asRecordType()) == JSTypeCastUtil.NO_RECORD_TYPE ? elementType : recordTypeCandidate;
        if (object == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(28);
        }
        return object;
    }

    protected static boolean canSubstitute(@NotNull JSType elementType) {
        if (elementType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(29);
        }
        if (elementType instanceof JSFunctionTypeImpl) {
            return true;
        }
        return elementType instanceof JSNamedType || elementType instanceof JSGenericTypeImpl || elementType instanceof JSAliasTypeImpl || elementType instanceof JSUnionOrIntersectionType;
    }

    private static boolean isObject(@NotNull JSRecordType recordType) {
        PsiElement sourceElement;
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(30);
        }
        return (sourceElement = recordType.getSource().getSourceElement()) instanceof TypeScriptInterface && "Object".equals(((TypeScriptInterface)sourceElement).getQualifiedName());
    }

    private boolean isDirectlyAssignableRecordType(@NotNull JSRecordType sourceType, @NotNull ProcessingContext processingContext) {
        boolean rTypeWithCallSignatures;
        if (sourceType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(31);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(32);
        }
        List rTypeCallSignatures = sourceType.getCallSignatures();
        boolean hasMembers = sourceType.hasMembers();
        boolean bl = rTypeWithCallSignatures = !rTypeCallSignatures.isEmpty();
        if (!this.checkWeakTypeCondition(sourceType, hasMembers)) {
            return false;
        }
        if (!this.checkCallSignatureExistence(rTypeWithCallSignatures, processingContext)) {
            return false;
        }
        if (!this.checkStringIndexerTypes(sourceType, processingContext)) {
            return false;
        }
        if (!this.checkNumericIndexerTypes(sourceType, processingContext)) {
            return false;
        }
        if (!this.checkPropertyTypes(sourceType, rTypeWithCallSignatures, processingContext)) {
            return false;
        }
        if (!this.checkCallSignatureTypes(processingContext, rTypeCallSignatures)) {
            return false;
        }
        return this.checkObjectLiteralProperties(sourceType, processingContext);
    }

    private boolean checkObjectLiteralProperties(@NotNull JSRecordType sourceType, @NotNull ProcessingContext processingContext) {
        if (sourceType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(33);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(34);
        }
        if (!JSRecordTypeImpl.isObjectLiteralType(this) || !JSRecordTypeImpl.isObjectType(sourceType) || processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) == null) {
            return true;
        }
        for (JSRecordType.PropertySignature property : sourceType.getProperties()) {
            JSType type;
            if (this.hasProperty(property.getMemberName()) || (type = property.getJSType()) instanceof JSUndefinedType) continue;
            return false;
        }
        return true;
    }

    private boolean checkWeakTypeCondition(@NotNull JSRecordType recordType, boolean hasMembers) {
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(35);
        }
        if (this.myIsWeakType && hasMembers && !JSRecordTypeImpl.isObject(recordType)) {
            Set rNames = recordType.getPropertyNames();
            HashSet<String> lNames = new HashSet<String>(this.getPropertyNames());
            lNames.retainAll(rNames);
            if (lNames.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    private boolean checkCallSignatureExistence(boolean rTypeWithCallSignatures, @NotNull ProcessingContext processingContext) {
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(36);
        }
        if (!this.myCallSignatures.isEmpty() && !rTypeWithCallSignatures) {
            JSTypeAssignableErrorMessage.addMessageToContext((ProcessingContext)processingContext, (String)"javascript.no.call.signatures", (String[])new String[0]);
            return false;
        }
        return true;
    }

    private boolean checkPropertyTypes(@NotNull JSRecordType sourceType, boolean hasCallSignatures, @NotNull ProcessingContext processingContext) {
        if (sourceType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(37);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(38);
        }
        boolean subtyping = processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) != null && !JSRecordTypeImpl.isExpressionBasedType(sourceType);
        JSUndefinedType undefinedType = null;
        JSRecordType additionalMembers = null;
        ArrayList<PropertyTypeChecker> toCheck = null;
        for (JSRecordType.PropertySignature lProperty : this.getProperties()) {
            String lPropName = lProperty.getMemberName();
            JSRecordType.PropertySignature rProperty = sourceType.findPropertySignature(lPropName);
            if (rProperty != null && rProperty.isOptional() && !lProperty.isOptional() && this.isTypeScript()) {
                return false;
            }
            if (rProperty == null && (!lProperty.isOptional() || subtyping)) {
                if (this.isJavaScript() && sourceType.isJavaScript()) {
                    if (undefinedType == null) {
                        undefinedType = new JSUndefinedType(sourceType.getSource());
                    }
                    if (JSRecordTypeImpl.isUndefinedProperty(lProperty, undefinedType, processingContext)) continue;
                }
                if (hasCallSignatures) {
                    if (additionalMembers == null) {
                        additionalMembers = TypeScriptUtil.getFunctionTypeMembers(this.getSource().getSourceElement());
                    }
                    if (additionalMembers != null && this.checkFunctionInterfaceProperties(processingContext, additionalMembers, lProperty)) continue;
                }
                return false;
            }
            if (rProperty == null) continue;
            if (toCheck == null) {
                toCheck = new ArrayList<PropertyTypeChecker>();
            }
            toCheck.add(context -> this.checkPropertySignatureAssignable(lProperty, rProperty, context));
        }
        if (toCheck != null) {
            for (PropertyTypeChecker checker : toCheck) {
                if (checker.check(processingContext)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkCallSignatureTypes(@NotNull ProcessingContext processingContext, @NotNull List<JSRecordType.CallSignature> callSignatures) {
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(39);
        }
        if (callSignatures == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(40);
        }
        for (JSRecordType.CallSignature lCallSignature : this.myCallSignatures) {
            if (JSRecordTypeImpl.checkCallSignaturesAssignable(lCallSignature, callSignatures, processingContext)) continue;
            return false;
        }
        return true;
    }

    private boolean checkStringIndexerTypes(@NotNull JSRecordType recordType, @NotNull ProcessingContext processingContext) {
        JSRecordType.IndexSignature numericIndexSignature;
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(41);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(42);
        }
        if (this.myStringIndexer == null) {
            return true;
        }
        JSType memberType = this.myStringIndexer.getMemberType();
        JSRecordType.IndexSignature stringIndexSignature = recordType.findIndexer(JSRecordType.IndexSignatureKind.STRING);
        if (stringIndexSignature != null) {
            return memberType.isDirectlyAssignableType(stringIndexSignature.getMemberType(), processingContext);
        }
        if (JSTypeComparingContextService.isSubtyping(processingContext) && (numericIndexSignature = recordType.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC)) != null && numericIndexSignature.getMemberType().isDirectlyAssignableType(memberType, processingContext)) {
            return true;
        }
        return (JSRecordTypeImpl.isObjectType(recordType) || memberType instanceof JSAnyType || memberType instanceof JSGenericParameterType) && !this.hasPropertyNotAssignableToIndexer(recordType, p -> true, this.myStringIndexer, processingContext);
    }

    private boolean checkNumericIndexerTypes(@NotNull JSRecordType recordType, @NotNull ProcessingContext processingContext) {
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(43);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(44);
        }
        if (this.myNumericIndexer == null) {
            return true;
        }
        JSRecordType.IndexSignature stringIndexSignature = recordType.findIndexer(JSRecordType.IndexSignatureKind.STRING);
        JSRecordType.IndexSignature numericIndexSignature = recordType.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC);
        JSType memType = this.myNumericIndexer.getMemberType();
        if (numericIndexSignature != null) {
            return memType.isDirectlyAssignableType(numericIndexSignature.getMemberType(), processingContext);
        }
        if (stringIndexSignature != null) {
            if (!memType.isDirectlyAssignableType(stringIndexSignature.getMemberType(), processingContext)) {
                return false;
            }
            if (JSRecordTypeImpl.isObjectType(recordType) && this.hasPropertyNotAssignableToIndexer(recordType, p -> true, this.myNumericIndexer, processingContext)) {
                return false;
            }
        } else if (!JSRecordTypeImpl.isObjectType(recordType) && !(memType instanceof JSAnyType) && !(memType instanceof JSGenericParameterType) || this.hasPropertyNotAssignableToIndexer(recordType, JSRecordTypeImpl::isNumericallyNamedProperty, this.myNumericIndexer, processingContext)) {
            return false;
        }
        return true;
    }

    private static boolean isNumericallyNamedProperty(@NotNull JSRecordType.PropertySignature p) {
        if (p == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(45);
        }
        if (p instanceof TypeScriptEnumField) {
            return true;
        }
        String memberName = p.getMemberName();
        return JSStringUtil.isNumericValueStart(memberName, false) && JSNumberParser.tryParseNumericValue(memberName, false) != null;
    }

    private static boolean isExpressionBasedType(@NotNull JSRecordType type) {
        PsiElement sourceElement;
        if (type == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(46);
        }
        return (sourceElement = type.getSourceElement()) instanceof JSObjectLiteralExpression || sourceElement instanceof JSArrayLiteralExpression;
    }

    private static boolean isObjectType(@NotNull JSRecordType type) {
        PsiElement sourceElement;
        if (type == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(47);
        }
        return (sourceElement = type.getSourceElement()) instanceof JSObjectLiteralExpression || sourceElement instanceof TypeScriptObjectType || sourceElement instanceof TypeScriptEnum || sourceElement instanceof TypeScriptMappedType;
    }

    private static boolean isObjectLiteralType(@NotNull JSRecordType type) {
        if (type == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(48);
        }
        return type.getSourceElement() instanceof JSObjectLiteralExpression;
    }

    private boolean hasPropertyNotAssignableToIndexer(@NotNull JSRecordType recordType, @NotNull Predicate<JSRecordType.PropertySignature> propertyFilter, @NotNull JSRecordType.IndexSignature typeMember, @NotNull ProcessingContext oldProcessingContext) {
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(49);
        }
        if (propertyFilter == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(50);
        }
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(51);
        }
        if (oldProcessingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(52);
        }
        return JSTypeCastUtil.executeJoinInferredGenerics((Processor<? super ProcessingContext>)((Processor)processingContext -> {
            JSType memberType = typeMember.getMemberType();
            return recordType.getProperties().stream().filter(propertyFilter).map(v -> v.getJSType()).anyMatch(t -> t != null && !memberType.isDirectlyAssignableType(t, processingContext));
        }), oldProcessingContext, this.getSource());
    }

    private static boolean isUndefinedProperty(@NotNull JSRecordType.PropertySignature typeMember, @NotNull JSType undefinedType, @Nullable ProcessingContext processingContext) {
        JSType propertyType;
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(53);
        }
        if (undefinedType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(54);
        }
        return (propertyType = typeMember.getJSType()) == null || undefinedType.isDirectlyAssignableType(propertyType, processingContext);
    }

    private boolean checkPropertySignatureAssignable(@NotNull JSRecordType.PropertySignature signature, @NotNull JSRecordType.PropertySignature otherSignature, @Nullable ProcessingContext processingContext) {
        if (signature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(55);
        }
        if (otherSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(56);
        }
        if (signature.isEquivalentTo((JSRecordType.TypeMember)otherSignature, processingContext, true)) {
            return true;
        }
        JSType type = signature.getJSTypeWithOptionality();
        JSType otherType = otherSignature.getJSTypeWithOptionality();
        return this.skipTypeChecking(type) || this.skipTypeChecking(otherType) || type.isDirectlyAssignableType(otherType, processingContext);
    }

    private static boolean checkCallSignaturesAssignable(@NotNull JSRecordType.CallSignature currentSignature, @NotNull List<JSRecordType.CallSignature> callSignatures, @Nullable ProcessingContext processingContext) {
        if (currentSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(57);
        }
        if (callSignatures == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(58);
        }
        for (JSRecordType.CallSignature callSignature : callSignatures) {
            if (!currentSignature.isEquivalentTo((JSRecordType.TypeMember)callSignature, processingContext, true)) continue;
            return true;
        }
        if (JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext) || callSignatures.size() == 1) {
            return JSRecordTypeImpl.simpleCheckCallSignatureAssignable(currentSignature, callSignatures, processingContext);
        }
        int size = currentSignature.getParameterTypeDecorators().size();
        SmartList rest = new SmartList();
        for (JSRecordType.CallSignature signature : callSignatures) {
            List params = signature.getParameterTypeDecorators();
            if (params.size() != size) {
                rest.add(signature);
                continue;
            }
            if (!JSRecordTypeImpl.checkAssignableForCallSignatures(currentSignature, processingContext, signature)) continue;
            return true;
        }
        return JSRecordTypeImpl.simpleCheckCallSignatureAssignable(currentSignature, (List<JSRecordType.CallSignature>)rest, processingContext);
    }

    private static boolean simpleCheckCallSignatureAssignable(@NotNull JSRecordType.CallSignature currentSignature, @NotNull List<JSRecordType.CallSignature> rest, @Nullable ProcessingContext processingContext) {
        if (currentSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(59);
        }
        if (rest == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(60);
        }
        for (JSRecordType.CallSignature callSignature : rest) {
            if (!JSRecordTypeImpl.checkAssignableForCallSignatures(currentSignature, processingContext, callSignature)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkAssignableForCallSignatures(@NotNull JSRecordType.CallSignature typeMember, @Nullable ProcessingContext processingContext, @NotNull JSRecordType.CallSignature callSignature) {
        JSFunctionType otherFunctionType;
        JSFunctionType functionType;
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(61);
        }
        if (callSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(62);
        }
        return typeMember.hasNew() == callSignature.hasNew() && JSRecordTypeImpl.checkFunctionsArgumentsAndReturnType(functionType = typeMember.getFunctionType(), otherFunctionType = callSignature.getFunctionType(), processingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkFunctionsArgumentsAndReturnType(@NotNull JSFunctionType functionType, @NotNull JSFunctionType otherFunctionType, @Nullable ProcessingContext processingContext) {
        if (functionType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(63);
        }
        if (otherFunctionType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(64);
        }
        boolean oldCallEnv = false;
        if (processingContext != null) {
            oldCallEnv = processingContext.get(JSTypeBaseImpl.CALL_ENV_KEY) == Boolean.TRUE;
            JSTypeComparingContextService.setCallEnvironment(processingContext, true);
        }
        try {
            if (!JSTypeUtils.areArgumentsAssignable(functionType.getParameters(), otherFunctionType.getParameters(), processingContext, true, !functionType.isTypeScript(), functionType.isTypeScript())) {
                boolean bl = false;
                return bl;
            }
            JSType returnType = functionType.getReturnType();
            JSType otherReturnType = otherFunctionType.getReturnType();
            if (returnType == null || returnType instanceof JSVoidType) {
                boolean bl = true;
                return bl;
            }
            boolean bl = returnType.isDirectlyAssignableType(otherReturnType, processingContext);
            return bl;
        }
        finally {
            if (processingContext != null) {
                JSTypeComparingContextService.setCallEnvironment(processingContext, oldCallEnv);
            }
        }
    }

    private boolean checkFunctionInterfaceProperties(@NotNull ProcessingContext processingContext, @NotNull JSRecordType functionRecord, @NotNull JSRecordType.PropertySignature typeMember) {
        JSRecordType.PropertySignature signature;
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(65);
        }
        if (functionRecord == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(66);
        }
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(67);
        }
        if ((signature = functionRecord.findPropertySignature(typeMember.getMemberName())) == null) {
            return false;
        }
        if (JSRecordTypeImpl.checkSources(typeMember, (JSRecordType.TypeMember)signature, processingContext)) {
            return true;
        }
        return this.checkPropertySignatureAssignable(typeMember, signature, processingContext);
    }

    private static boolean checkSources(@NotNull JSRecordType.PropertySignature typeMember, @NotNull JSRecordType.TypeMember member, @NotNull ProcessingContext processingContext) {
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(68);
        }
        if (member == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(69);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(70);
        }
        JSRecordType.MemberSource source = member.getMemberSource();
        PsiElement memberSource = source.getSingleElement();
        JSRecordType.MemberSource typeMemberSource = typeMember.getMemberSource();
        return memberSource != null && memberSource.isEquivalentTo(typeMemberSource.getSingleElement()) || typeMember.isEquivalentTo(member, processingContext, true);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(71);
        }
        JSRecordType otherType = (JSRecordType)type;
        List otherMembers = otherType.getTypeMembers();
        List<JSRecordType.TypeMember> members = this.getTypeMembers();
        return JSRecordTypeImpl.areMembersEqual(otherMembers, members, processingContext, allowResolve);
    }

    protected static boolean areMembersEqual(@NotNull List<? extends JSRecordType.TypeMember> otherMembers, @NotNull List<? extends JSRecordType.TypeMember> members, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (otherMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(72);
        }
        if (members == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(73);
        }
        if (otherMembers.size() != members.size()) {
            return false;
        }
        for (int i = 0; i < members.size(); ++i) {
            JSRecordType.TypeMember member;
            JSRecordType.TypeMember otherMember = otherMembers.get(i);
            if (otherMember.isEquivalentTo(member = members.get(i), processingContext, allowResolve)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<JSRecordType.TypeMember> getTypeMembers() {
        List<JSRecordType.TypeMember> list2 = this.myAllTypeMembers;
        if (list2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(74);
        }
        return list2;
    }

    public final boolean hasProperty(@NotNull String name) {
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(75);
        }
        if (this.myProperties.containsKey(name)) {
            return true;
        }
        return this.myComputedProperties.stream().anyMatch(p -> name.equals(p.getMemberName()));
    }

    public final boolean hasIndexers() {
        return this.myStringIndexer != null || this.myNumericIndexer != null;
    }

    @NotNull
    public final List<JSRecordType.CallSignature> getCallSignatures() {
        List<JSRecordType.CallSignature> list2 = this.myCallSignatures;
        if (list2 == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(76);
        }
        return list2;
    }

    @NotNull
    public final Set<String> getPropertyNames() {
        Set<String> keys = this.myProperties.keySet();
        if (this.myComputedProperties.isEmpty()) {
            Set<String> set = keys;
            if (set == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(77);
            }
            return set;
        }
        Set strings = ContainerUtil.map2Set(this.myComputedProperties, p -> p.getMemberName());
        strings.addAll(keys);
        Set set = strings;
        if (set == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(78);
        }
        return set;
    }

    @NotNull
    public final Collection<JSRecordType.PropertySignature> getProperties() {
        Collection<JSRecordType.PropertySignature> props = this.myProperties.values();
        if (this.myComputedProperties.isEmpty()) {
            Collection<JSRecordType.PropertySignature> collection = props;
            if (collection == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(79);
            }
            return collection;
        }
        ArrayList<JSRecordType.PropertySignature> result2 = new ArrayList<JSRecordType.PropertySignature>(props.size() + this.myComputedProperties.size());
        result2.addAll(props);
        result2.addAll(this.myComputedProperties);
        ArrayList<JSRecordType.PropertySignature> arrayList = result2;
        if (arrayList == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(80);
        }
        return arrayList;
    }

    public final boolean hasMembers() {
        return !this.myAllTypeMembers.isEmpty();
    }

    public final boolean hasProperties() {
        return !this.myProperties.isEmpty() || !this.myComputedProperties.isEmpty();
    }

    @Nullable
    public final JSRecordType.PropertySignature findPropertySignature(@NotNull String name) {
        JSRecordType.PropertySignature signature;
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(81);
        }
        if ((signature = this.myProperties.get(name)) != null || this.myComputedProperties.isEmpty()) {
            return signature;
        }
        for (JSRecordType.PropertySignature property : this.myComputedProperties) {
            if (!name.equals(property.getMemberName())) continue;
            return property;
        }
        return null;
    }

    @Override
    public final void accept(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(82);
        }
        visitor.visitJSRecordType((JSType)this);
    }

    private boolean skipTypeChecking(@Nullable JSType type) {
        return type == null || this.isTypeScript() && !type.getSource().isStrict();
    }

    @Override
    public final void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(83);
        }
        for (JSRecordType.TypeMember typeMember : this.myAllTypeMembers) {
            typeMember.acceptChildren(visitor);
        }
    }

    @Override
    @NotNull
    protected final JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(84);
        }
        List<JSRecordType.TypeMember> oldMembers = this.getTypeMembers();
        ArrayList<JSRecordType.TypeMember> newMembers = new ArrayList<JSRecordType.TypeMember>(oldMembers.size());
        for (JSRecordType.TypeMember member : oldMembers) {
            newMembers.add(member.copyTypeHierarchy(childTransform));
        }
        if (ContainerUtil.equalsIdentity(oldMembers, newMembers)) {
            JSRecordTypeImpl jSRecordTypeImpl = this;
            if (jSRecordTypeImpl == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(85);
            }
            return jSRecordTypeImpl;
        }
        JSRecordTypeImpl jSRecordTypeImpl = this.createInstance(this.getSource(), newMembers, true);
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(86);
        }
        return jSRecordTypeImpl;
    }

    @NotNull
    protected JSRecordTypeImpl createInstance(@NotNull JSTypeSource source, @NotNull List<JSRecordType.TypeMember> newMembers, boolean membersChanged) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(87);
        }
        if (newMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(88);
        }
        return membersChanged ? new JSRecordTypeImpl(source, newMembers) : new JSRecordTypeImpl(source, this.myAllTypeMembers, this.myCallSignatures, this.myStringIndexer, this.myNumericIndexer, this.myProperties, this.myComputedProperties, this.myIsWeakType);
    }

    @Override
    @NotNull
    protected final JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(89);
        }
        JSRecordTypeImpl jSRecordTypeImpl = this.createInstance(source, this.myAllTypeMembers, false);
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(90);
        }
        return jSRecordTypeImpl;
    }

    @Nullable
    public final JSRecordType.IndexSignature findIndexer(@NotNull JSRecordType.IndexSignatureKind kind) {
        if (kind == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(91);
        }
        switch (kind) {
            case STRING: {
                return this.myStringIndexer;
            }
            case NUMERIC: {
                return this.myNumericIndexer;
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordTypeImpl jSRecordTypeImpl = this;
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(92);
        }
        return jSRecordTypeImpl;
    }

    @Override
    @NotNull
    protected Stream<JSType> getFunctionTypesImpl(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(93);
        }
        Stream<JSType> stream = this.getCallSignatures().stream().filter(typeMember -> typeMember.hasNew() == newCallSignatures).map(typeMember -> typeMember.getFunctionType());
        if (stream == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(94);
        }
        return stream;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return JSTypeResolvedHashCodeUtil.getResolvedHashCodeForMembers(this.getTypeMembers());
    }

    public final boolean isWeak() {
        return this.myIsWeakType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 22: 
            case 28: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 90: 
            case 92: 
            case 94: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 22: 
            case 28: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 90: 
            case 92: 
            case 94: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMembers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allTypeMembers";
                break;
            }
            case 8: 
            case 40: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSignatures";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computedProperties";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 12: 
            case 17: 
            case 75: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSignature";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stored";
                break;
            }
            case 16: 
            case 22: 
            case 28: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 90: 
            case 92: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composite";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProperty";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySignature";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 25: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 26: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 65: 
            case 70: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 30: 
            case 35: 
            case 41: 
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 31: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyFilter";
                break;
            }
            case 51: 
            case 53: 
            case 61: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldProcessingContext";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undefinedType";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherSignature";
                break;
            }
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSignature";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rest";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSignature";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherFunctionType";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionRecord";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherMembers";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMembers";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSignatures";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "removePropertyTypeFreshness";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRecordTypeIfPossible";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeMembers";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallSignatures";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypesImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mergeSignatures";
                break;
            }
            case 16: 
            case 22: 
            case 28: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 90: 
            case 92: 
            case 94: {
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyToCompositeFunctions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyTypeFreshness";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "convertToRecordTypeIfPossible";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "canSubstitute";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isObject";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableRecordType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "checkObjectLiteralProperties";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkWeakTypeCondition";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkCallSignatureExistence";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertyTypes";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkCallSignatureTypes";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkStringIndexerTypes";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "checkNumericIndexerTypes";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isNumericallyNamedProperty";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isExpressionBasedType";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isObjectType";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isObjectLiteralType";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "hasPropertyNotAssignableToIndexer";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isUndefinedProperty";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertySignatureAssignable";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkCallSignaturesAssignable";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "simpleCheckCallSignatureAssignable";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignableForCallSignatures";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionsArgumentsAndReturnType";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionInterfaceProperties";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "checkSources";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "areMembersEqual";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "hasProperty";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "findPropertySignature";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "findIndexer";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypesImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 22: 
            case 28: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 85: 
            case 86: 
            case 90: 
            case 92: 
            case 94: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class PropertySignatureImpl
    implements PropertySignatureCommonImpl {
        @NotNull
        private final String name;
        @Nullable
        private final JSType type;
        private final boolean optional;
        private final boolean isReadonly;
        @NotNull
        private final JSRecordType.MemberSource mySource;

        @Deprecated
        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, @Nullable PsiElement singleSource) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(0);
            }
            this(name, type, optional, false, singleSource);
        }

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, boolean isReadonly, @Nullable PsiElement singleSource) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(1);
            }
            this(name, type, optional, isReadonly, JSRecordMemberSourceFactory.createSource(singleSource));
        }

        @Deprecated
        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, @NotNull JSRecordType.MemberSource source) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(2);
            }
            if (source == null) {
                PropertySignatureImpl.$$$reportNull$$$0(3);
            }
            this(name, type, optional, false, source);
        }

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, boolean isReadonly, @NotNull JSRecordType.MemberSource source) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(4);
            }
            if (source == null) {
                PropertySignatureImpl.$$$reportNull$$$0(5);
            }
            this.name = name;
            this.type = type;
            this.optional = optional;
            this.mySource = source;
            this.isReadonly = isReadonly;
        }

        @Deprecated
        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(6);
            }
            this(name, type, optional, false);
        }

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, boolean isReadonly) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(7);
            }
            this(name, type, optional, isReadonly, JSRecordMemberSourceFactory.createEmptySource());
        }

        @NotNull
        public String getMemberName() {
            String string = this.name;
            if (string == null) {
                PropertySignatureImpl.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Nullable
        public JSType getJSType() {
            return this.type;
        }

        @Override
        @Nullable
        public JSType getJSTypeWithOptionality() {
            JSType type = this.getJSType();
            if (this.isOptional() && type != null) {
                return TypeScriptTypeGuard.wrapWithUndefined(type, type.getSource());
            }
            return type;
        }

        public boolean isOptional() {
            return this.optional;
        }

        @NotNull
        public JSRecordType.MemberSource getMemberSource() {
            JSRecordType.MemberSource memberSource = this.mySource;
            if (memberSource == null) {
                PropertySignatureImpl.$$$reportNull$$$0(9);
            }
            return memberSource;
        }

        public String toString() {
            return "PropertySignatureImpl@" + this.name;
        }

        public boolean isConst() {
            return this.isReadonly;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberName";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class ComputedPropertySignatureImpl
    implements JSRecordType.PropertySignature {
        @NotNull
        private final String nameRef;
        @Nullable
        private final JSType type;
        private final boolean optional;
        private final boolean isReadonly;
        @NotNull
        private final JSRecordType.MemberSource mySource;
        private static final String INVALID_NAME = "[unknown]";
        private static final Key<ParameterizedCachedValue<String, String>> PROP_NAME_KEY = new Key("ComputedPropertySignatureImpl.PROP_NAME_KEY");

        public ComputedPropertySignatureImpl(@NotNull String propertyNameRef, @Nullable JSType type, boolean optional, boolean isReadonly, @NotNull JSRecordType.MemberSource source) {
            if (propertyNameRef == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(0);
            }
            if (source == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(1);
            }
            this.nameRef = propertyNameRef;
            this.type = type;
            this.optional = optional;
            this.isReadonly = isReadonly;
            this.mySource = source;
        }

        @NotNull
        public String getMemberName() {
            PsiElement psiElement = this.mySource.getSingleElement();
            assert (psiElement instanceof JSComputedPropertyNameOwner);
            return ComputedPropertySignatureImpl.computeValue(((JSComputedPropertyNameOwner)psiElement).getComputedPropertyName(), this.nameRef);
        }

        public boolean isConst() {
            return this.isReadonly;
        }

        public boolean hasValidName() {
            return this.getMemberName() != INVALID_NAME;
        }

        @NotNull
        private static String computeValue(@Nullable ES6ComputedName computedName, @NotNull String nameRef) {
            if (nameRef == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(2);
            }
            if (computedName == null) {
                return INVALID_NAME;
            }
            String string = (String)CachedValuesManager.getManager((Project)computedName.getProject()).getParameterizedCachedValue((UserDataHolder)computedName, PROP_NAME_KEY, actualNameRef -> {
                JSType type = TypeScriptLiteralKeyUtil.getTypeForComputedName((PsiElement)computedName, actualNameRef);
                String name = TypeScriptTypeMemberParser.getComputedPropNameFromType(type);
                return new CachedValueProvider.Result((Object)(name == null ? INVALID_NAME : name), new Object[]{computedName});
            }, false, (Object)nameRef);
            if (string == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public JSType getJSType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.optional;
        }

        @NotNull
        public JSRecordType.MemberSource getMemberSource() {
            JSRecordType.MemberSource memberSource = this.mySource;
            if (memberSource == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(4);
            }
            return memberSource;
        }

        public String toString() {
            return "ComputedPropertySignatureImpl@" + this.nameRef;
        }

        @NotNull
        public JSRecordType.PropertySignature copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
            JSType type;
            JSType oldType;
            if (childTransform == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(5);
            }
            if ((oldType = this.getJSType()) == (type = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform))) {
                ComputedPropertySignatureImpl computedPropertySignatureImpl = this;
                if (computedPropertySignatureImpl == null) {
                    ComputedPropertySignatureImpl.$$$reportNull$$$0(6);
                }
                return computedPropertySignatureImpl;
            }
            JSRecordType.MemberSource sourceElement = this.getMemberSource();
            return new ComputedPropertySignatureImpl(this.nameRef, type, this.isOptional(), this.isConst(), sourceElement);
        }

        public int resolvedHashCode() {
            return Objects.hash(ComputedPropertySignatureImpl.class.hashCode(), this.nameRef, JSTypeResolvedHashCodeUtil.getResolvedHashCodeSafe(this.getJSType()), this.isOptional());
        }

        public boolean isEquivalentTo(@Nullable JSRecordType.TypeMember other, @Nullable ProcessingContext context, boolean allowResolve) {
            return ComputedPropertySignatureImpl.arePropertySignaturesEqual(this, other, context, allowResolve);
        }

        static boolean arePropertySignaturesEqual(@NotNull ComputedPropertySignatureImpl first, @Nullable JSRecordType.TypeMember otherRaw, @Nullable ProcessingContext processingContext, boolean allowResolve) {
            if (first == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(7);
            }
            if (allowResolve) {
                return PropertySignatureCommonImpl.arePropertySignaturesEqual(first, otherRaw, processingContext, true);
            }
            if (otherRaw == first) {
                return true;
            }
            if (!(otherRaw instanceof ComputedPropertySignatureImpl)) {
                return false;
            }
            ComputedPropertySignatureImpl other = (ComputedPropertySignatureImpl)otherRaw;
            return first.nameRef.equals(other.nameRef) && (first.getJSType() != null ? first.getJSType().isEquivalentTo(other.getJSType(), processingContext, false) : other.getJSType() == null) && first.isOptional() == other.isOptional();
        }

        public void appendMemberPresentation(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder, @NotNull String typeSeparator, char quote) {
            if (format == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(8);
            }
            if (builder == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(9);
            }
            if (typeSeparator == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(10);
            }
            PropertySignatureCommonImpl.appendPresentation(this, format, builder, typeSeparator, quote, format == JSType.TypeTextFormat.PRESENTABLE ? this.getMemberName() : "[" + this.nameRef + "]");
        }

        public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
            JSType type;
            if (visitor == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(11);
            }
            if ((type = this.getJSType()) != null) {
                type.accept(visitor);
            }
        }

        @NotNull
        public String getNameRef() {
            String string = this.nameRef;
            if (string == null) {
                ComputedPropertySignatureImpl.$$$reportNull$$$0(12);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyNameRef";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameRef";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$ComputedPropertySignatureImpl";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childTransform";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeSeparator";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$ComputedPropertySignatureImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberSource";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copyTypeHierarchy";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameRef";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "computeValue";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 12: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "copyTypeHierarchy";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "arePropertySignaturesEqual";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "appendMemberPresentation";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptChildren";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class IndexSignatureImpl
    implements IndexSignatureCommonImpl {
        @Nullable
        private final JSType parameterType;
        @Nullable
        private final JSType type;
        private final boolean myIsForComputedProperty;
        @NotNull
        private final JSRecordType.MemberSource mySource;

        public IndexSignatureImpl(@Nullable JSType parameterType, @Nullable JSType type, @Nullable PsiElement singleSource, boolean isForComputedProperty) {
            this(parameterType, type, JSRecordMemberSourceFactory.createSource(singleSource), isForComputedProperty);
        }

        public IndexSignatureImpl(@Nullable JSType parameterType, @Nullable JSType type, @NotNull JSRecordType.MemberSource source, boolean isForComputedProperty) {
            if (source == null) {
                IndexSignatureImpl.$$$reportNull$$$0(0);
            }
            this.mySource = source;
            this.parameterType = parameterType;
            this.type = type;
            this.myIsForComputedProperty = isForComputedProperty;
        }

        @NotNull
        public final JSType getMemberParameterType() {
            Object object = this.parameterType != null ? this.parameterType : JSAnyType.get(null, false);
            if (object == null) {
                IndexSignatureImpl.$$$reportNull$$$0(1);
            }
            return object;
        }

        @NotNull
        public JSRecordType.IndexSignatureKind getIndexSignatureKind() {
            return IndexSignatureImpl.getIndexerKindFromType(this.getMemberParameterType());
        }

        @NotNull
        public final JSType getMemberType() {
            Object object = this.type != null ? this.type : JSAnyType.get(null, false);
            if (object == null) {
                IndexSignatureImpl.$$$reportNull$$$0(2);
            }
            return object;
        }

        @NotNull
        public final JSRecordType.MemberSource getMemberSource() {
            JSRecordType.MemberSource memberSource = this.mySource;
            if (memberSource == null) {
                IndexSignatureImpl.$$$reportNull$$$0(3);
            }
            return memberSource;
        }

        public boolean isForComputedProperty() {
            return this.myIsForComputedProperty;
        }

        @NotNull
        public static JSRecordType.IndexSignatureKind getIndexerKindFromType(@Nullable JSType memberParameterType) {
            if (memberParameterType instanceof JSStringType) {
                JSRecordType.IndexSignatureKind indexSignatureKind = JSRecordType.IndexSignatureKind.STRING;
                if (indexSignatureKind == null) {
                    IndexSignatureImpl.$$$reportNull$$$0(4);
                }
                return indexSignatureKind;
            }
            if (memberParameterType instanceof JSNumberType) {
                JSRecordType.IndexSignatureKind indexSignatureKind = JSRecordType.IndexSignatureKind.NUMERIC;
                if (indexSignatureKind == null) {
                    IndexSignatureImpl.$$$reportNull$$$0(5);
                }
                return indexSignatureKind;
            }
            JSRecordType.IndexSignatureKind indexSignatureKind = JSRecordType.IndexSignatureKind.UNKNOWN;
            if (indexSignatureKind == null) {
                IndexSignatureImpl.$$$reportNull$$$0(6);
            }
            return indexSignatureKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignatureImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignatureImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberParameterType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberSource";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexerKindFromType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class CallSignatureImpl
    implements CallSignatureCommonImpl {
        private final boolean hasNew;
        @NotNull
        private final JSFunctionType functionType;

        public CallSignatureImpl(boolean hasNew, @NotNull JSFunctionType functionType) {
            if (functionType == null) {
                CallSignatureImpl.$$$reportNull$$$0(0);
            }
            this.hasNew = hasNew;
            this.functionType = functionType;
        }

        public boolean hasNew() {
            return this.hasNew;
        }

        @NotNull
        public JSFunctionType getFunctionType() {
            JSFunctionType jSFunctionType = this.functionType;
            if (jSFunctionType == null) {
                CallSignatureImpl.$$$reportNull$$$0(1);
            }
            return jSFunctionType;
        }

        @NotNull
        public JSRecordType.MemberSource getMemberSource() {
            JSRecordType.MemberSource memberSource = JSRecordMemberSourceFactory.createSource(this.functionType.getSource().getSourceElement());
            if (memberSource == null) {
                CallSignatureImpl.$$$reportNull$$$0(2);
            }
            return memberSource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignatureImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignatureImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFunctionType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface PropertyTypeChecker {
        public boolean check(@NotNull ProcessingContext var1);
    }
}

