/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMethodDescriptor
implements MethodDescriptor<JSParameterInfo, String> {
    protected final JSFunction myMethod;
    protected final boolean myForceConstructor;
    private final JSQualifiedNamedElement myMember;

    public JSMethodDescriptor(JSFunction method, boolean forceConstructor) {
        this.myMethod = method;
        this.myMember = JSChangeSignatureUtil.getMemberFromFunction(method);
        this.myForceConstructor = forceConstructor;
    }

    public String getName() {
        return StringUtil.notNullize((String)this.myMethod.getName());
    }

    public List<JSParameterInfo> getParameters() {
        return JSMethodDescriptor.getParameters(this.myMethod);
    }

    public String getReturnType() {
        JSType returnType = this.myMethod.getReturnType();
        return StringUtil.notNullize((String)(returnType != null ? returnType.getResolvedTypeText() : null));
    }

    public int getParametersCount() {
        JSParameterList parameterList = this.myMethod.getParameterList();
        return parameterList == null ? 0 : parameterList.getParameters().length;
    }

    public String getVisibility() {
        if (!this.isActionScript()) {
            return JSAttributeList.AccessType.PACKAGE_LOCAL.name();
        }
        return this.getVisibilityImpl(JSAttributeList.AccessType.PACKAGE_LOCAL);
    }

    protected final String getVisibilityImpl(JSAttributeList.AccessType defaultAccessType) {
        JSAttributeList.AccessType accessType;
        JSAttributeList attributeList = this.getAttributeList();
        JSAttributeList.AccessType accessType2 = accessType = attributeList != null ? attributeList.getAccessType() : defaultAccessType;
        if (!this.canChangeVisibility() && this.isClassMember() && accessType != JSAttributeList.AccessType.PUBLIC) {
            accessType = JSAttributeList.AccessType.PUBLIC;
        } else if (JSResolveUtil.isConstructorFunction((PsiElement)this.myMethod) && accessType != JSAttributeList.AccessType.PUBLIC && accessType != JSAttributeList.AccessType.PACKAGE_LOCAL) {
            accessType = JSAttributeList.AccessType.PUBLIC;
        }
        return accessType.name();
    }

    public List<JSAttributeList.AccessType> getPossibleVisibility() {
        if (this.myMethod.isConstructor()) {
            return ContainerUtil.newArrayList((Object[])new JSAttributeList.AccessType[]{JSAttributeList.AccessType.PUBLIC, JSAttributeList.AccessType.PACKAGE_LOCAL});
        }
        return ContainerUtil.newArrayList((Object[])new JSAttributeList.AccessType[]{JSAttributeList.AccessType.PRIVATE, JSAttributeList.AccessType.PACKAGE_LOCAL, JSAttributeList.AccessType.PROTECTED, JSAttributeList.AccessType.PUBLIC});
    }

    public boolean isConstructor() {
        return this.myForceConstructor || this.myMethod.isConstructor();
    }

    public JSFunction getMethod() {
        return this.myMethod;
    }

    public boolean canChangeVisibility() {
        if (!this.isActionScript()) {
            return false;
        }
        return this.canChangeVisibilityImpl();
    }

    public boolean resolveTypes() {
        return this.isActionScript();
    }

    protected final boolean canChangeVisibilityImpl() {
        JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)this.myMember);
        return clazz != null && !clazz.isInterface();
    }

    public boolean canChangeParameters() {
        return !this.myMethod.isGetProperty();
    }

    public MethodDescriptor.ReadWriteOption canChangeReturnType() {
        if (this.isConstructor() || !this.isActionScript()) {
            return MethodDescriptor.ReadWriteOption.None;
        }
        if (this.myMethod.isSetProperty()) {
            return MethodDescriptor.ReadWriteOption.Read;
        }
        return MethodDescriptor.ReadWriteOption.ReadWrite;
    }

    boolean isActionScript() {
        return DialectDetector.isActionScript((PsiElement)this.myMethod);
    }

    boolean isTypeScript() {
        return DialectDetector.isTypeScript((PsiElement)this.myMethod);
    }

    boolean isEcmaScript6() {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)this.myMethod);
        return holder != null && holder.isECMA6;
    }

    @Nullable
    DialectOptionHolder dialect() {
        return DialectDetector.dialectOfElement((PsiElement)this.myMethod);
    }

    boolean canHaveOptional() {
        return !this.isActionScript() && !this.isEcmaScript6();
    }

    boolean canHaveType() {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)this.myMethod);
        return holder != null && holder.hasFeature(JSLanguageFeature.TYPES);
    }

    boolean canHaveInitializers() {
        return this.isActionScript() || this.isEcmaScript6();
    }

    String getFunctionNameWithKeyword(String methodName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getFunctionPrefix());
        if (this.getMethod().isGetProperty()) {
            buffer.append(" get");
        } else if (this.getMethod().isSetProperty()) {
            buffer.append(" set");
        }
        if (buffer.length() > 0) {
            buffer.append(" ");
        }
        if (StringUtil.isNotEmpty((String)methodName)) {
            buffer.append(methodName);
        }
        return buffer.toString();
    }

    protected String getFunctionPrefix() {
        return JSClassUtils.isES6ClassImplementation((PsiElement)this.myMethod) && this.isClassMember() ? "" : "function";
    }

    @Nullable
    JSLanguageDialect getFileLanguage() {
        return DialectDetector.languageDialectOfElement((PsiElement)this.myMethod);
    }

    public boolean canChangeName() {
        if (this.myMethod instanceof JSFunctionExpression) {
            PsiElement parent = this.myMethod.getParent();
            return parent instanceof JSVariable || parent instanceof JSAssignmentExpression || parent instanceof JSProperty || parent instanceof ES6ExportDefaultAssignment && this.myMethod.getName() != null;
        }
        return !this.isConstructor();
    }

    protected boolean isClassMember() {
        return JSUtils.getMemberContainingClass((PsiElement)this.myMember) != null;
    }

    @Nullable
    public JSAttributeList getAttributeList() {
        JSFunction element = this.myMember instanceof JSAttributeListOwner ? (JSAttributeListOwner)this.myMember : this.myMethod;
        return element.getAttributeList();
    }

    @NotNull
    public static List<JSParameterInfo> getParameters(JSFunction method) {
        return JSMethodDescriptor.getParameters(method, Collections.emptyMap());
    }

    @NotNull
    public static List<JSParameterInfo> getParameters(@NotNull JSFunction method, @NotNull Map<String, String> typeOverrides) {
        if (method == null) {
            JSMethodDescriptor.$$$reportNull$$$0(0);
        }
        if (typeOverrides == null) {
            JSMethodDescriptor.$$$reportNull$$$0(1);
        }
        return JSMethodDescriptor.getParameters(method.getParameters(), typeOverrides);
    }

    @NotNull
    public static List<JSParameterInfo> getParameters(JSParameterListElement @NotNull [] parameters, @NotNull Map<String, String> typeOverrides) {
        if (typeOverrides == null) {
            JSMethodDescriptor.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            JSMethodDescriptor.$$$reportNull$$$0(3);
        }
        ArrayList<JSParameterInfo> result2 = new ArrayList<JSParameterInfo>();
        for (int i = 0; i < parameters.length; ++i) {
            String overridden;
            JSParameterListElement parameter = parameters[i];
            JSParameterInfo info = JSParameterInfo.build(parameter, i);
            if (parameter instanceof JSParameter) {
                JSMethodDescriptor.setOldModifiersText(info, ((JSParameter)parameter).getAttributeList());
            }
            if ((overridden = typeOverrides.get(parameter.getName())) != null) {
                info.setTypeText(overridden);
            }
            result2.add(info);
        }
        ArrayList<JSParameterInfo> arrayList = result2;
        if (arrayList == null) {
            JSMethodDescriptor.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static void setOldModifiersText(JSParameterInfo info, JSAttributeList list2) {
        String readonlyPostfix;
        if (list2 == null) {
            return;
        }
        boolean isReadonly = list2.hasModifier(JSAttributeList.ModifierType.READONLY);
        JSAttributeList.AccessType accessType = list2.getExplicitAccessType();
        String string = readonlyPostfix = isReadonly ? " readonly" : "";
        if (accessType == JSAttributeList.AccessType.PRIVATE) {
            info.setOldModifiers("private" + readonlyPostfix);
        } else if (accessType == JSAttributeList.AccessType.PROTECTED) {
            info.setOldModifiers("protected" + readonlyPostfix);
        } else if (accessType == JSAttributeList.AccessType.PUBLIC || isReadonly) {
            info.setOldModifiers("public" + readonlyPostfix);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOverrides";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/changeSignature/JSMethodDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSMethodDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

