/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.inspections.unusedsymbols.JSUnusedGlobalSymbolCache;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.refactoring.inline.JSFunctionInliner;
import com.intellij.lang.javascript.refactoring.inline.JSInlineHandler;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSVarOrFieldInliner
extends JSInlineHandler.Inliner {
    @NotNull
    private final JSVariable myElement;
    private final JSFunction myContainingFunction;
    private final MySettings mySettings;
    private final boolean myLocalVar;
    private final boolean myDependsOnContext;

    JSVarOrFieldInliner(@NotNull JSVariable element, MySettings settings) {
        if (element == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(0);
        }
        super((PsiElement)element);
        this.myElement = element;
        this.mySettings = settings;
        this.myLocalVar = JSVarOrFieldInliner.isLocalVariable(element);
        this.myContainingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class);
        this.myDependsOnContext = JSBaseIntroduceHandler.calcDependsOnContext((PsiElement)settings.initialized, null, false, false);
    }

    @Override
    protected void checkReadAccess(@NotNull MultiMap<PsiElement, String> conflicts, PsiElement referenceElement) {
        if (conflicts == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(1);
        }
        if (this.isDefinition(referenceElement)) {
            return;
        }
        super.checkReadAccess(conflicts, referenceElement);
    }

    private boolean isDefinition(PsiElement referenceElement) {
        JSNamedElement target = this.mySettings.getTarget();
        return target instanceof JSDefinitionExpression && !JSVarOrFieldInliner.referencesOurDefinition(referenceElement, (JSDefinitionExpression)target);
    }

    @Override
    public void checkConflicts(@NotNull PsiReference reference, final @NotNull MultiMap<PsiElement, String> conflicts) {
        if (reference == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(2);
        }
        if (conflicts == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(3);
        }
        super.checkConflicts(reference, conflicts);
        final PsiElement expression = reference.getElement();
        if (this.isDefinition(expression)) {
            return;
        }
        JSFunction usageContainingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunction.class);
        if (this.myLocalVar && this.myDependsOnContext && this.myContainingFunction != usageContainingFunction) {
            final boolean isArrowFunction = usageContainingFunction != null && usageContainingFunction.isArrowFunction();
            JSExpression initializer = this.myElement.getInitializer();
            if (initializer != null) {
                initializer.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){
                    final Set<String> processed = new THashSet();

                    public void visitJSReferenceExpression(JSReferenceExpression node) {
                        PsiElement resolve;
                        String referenced;
                        super.visitJSReferenceExpression(node);
                        if (node.getQualifier() == null && (referenced = node.getReferenceName()) != null && this.processed.add(referenced) && conflicts.size() == 0 && (resolve = node.resolve()) != null) {
                            JSFunction funScope = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)resolve, JSFunction.class);
                            Object scope = funScope != null ? resolve.getUseScope() : GlobalSearchScope.fileScope((PsiFile)node.getContainingFile());
                            for (PsiReference ref : ReferencesSearch.search((PsiElement)resolve, (SearchScope)scope).findAll()) {
                                if (JSReadWriteAccessDetector.ourInstance.getExpressionAccess(ref.getElement()) == ReadWriteAccessDetector.Access.Read) continue;
                                conflicts.putValue((Object)expression, (Object)JavaScriptBundle.message((String)"javascript.refactoring.variable.value.is.changed.when.accessed.from.closure", (Object[])new Object[0]));
                            }
                        }
                    }

                    public void visitJSThisExpression(JSThisExpression node) {
                        super.visitJSThisExpression(node);
                        if (!isArrowFunction) {
                            conflicts.putValue((Object)expression, (Object)JavaScriptBundle.message((String)"javascript.refactoring.variable.value.is.changed.when.accessed.from.closure", (Object[])new Object[0]));
                        }
                    }
                });
            }
        }
    }

    @Override
    @Nullable
    PsiElement doInlineUsage(@NotNull JSReferenceExpression usageElement) {
        JSNamedElement target;
        if (usageElement == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(4);
        }
        if ((target = this.mySettings.getTarget()) instanceof JSDefinitionExpression && !JSVarOrFieldInliner.referencesOurDefinition((PsiElement)usageElement, (JSDefinitionExpression)target)) {
            return null;
        }
        JSExpression initializer = this.mySettings.initialized;
        JSExpression qualifier = usageElement.getQualifier();
        String s = JSFunctionInliner.buildReplacement(target, (PsiElement)initializer, (JSExpression)usageElement, Collections.emptyMap(), ContainerUtil.emptyList(), qualifier, false);
        PsiElement parent = usageElement.getParent();
        if (parent instanceof ES6Property && ((ES6Property)parent).isShorthanded()) {
            return parent.replace((PsiElement)ES6ChangeUtil.expandShorthandPropertyWithValue((JSProperty)((ES6Property)parent), s));
        }
        JSExpression replacementExpression = (JSExpression)JSInheritedLanguagesHelper.createExpressionFromText(s, (PsiElement)initializer);
        return JSFunctionInliner.performExpressionReplacement((JSExpression)usageElement, replacementExpression);
    }

    private static boolean referencesOurDefinition(@NotNull PsiElement usageElement, @NotNull JSDefinitionExpression target) {
        if (usageElement == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(5);
        }
        if (target == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(6);
        }
        return usageElement instanceof JSReferenceExpression && JSVarOrFieldInliner.findDefinition((JSReferenceExpression)usageElement) == target;
    }

    @Nullable
    private static PsiElement findDefinition(@NotNull JSReferenceExpression usageElement) {
        if (usageElement == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(7);
        }
        PsiElement usageElementParent = usageElement.getParent();
        String referencedName = usageElement.getReferenceName();
        if (usageElementParent instanceof JSNamedElement || referencedName == null) {
            return null;
        }
        SinkResolveProcessor<ResolveResultSink> p = new SinkResolveProcessor<ResolveResultSink>(referencedName, true, new ResolveResultSink(null, referencedName));
        p.setLocalResolve(true);
        JSResolveUtil.treeWalkUp(p, (PsiElement)usageElement, usageElementParent, (PsiElement)usageElement);
        return p.getResult();
    }

    static boolean isLocalVariable(JSVariable jsVariable) {
        return !(jsVariable instanceof JSParameter) && jsVariable.getUseScope() instanceof LocalSearchScope;
    }

    private static boolean hasInitializerInDestructuring(PsiElement elementToInline) {
        JSInitializerOwner parentDeclaration = JSVarOrFieldInliner.findOwner(elementToInline);
        if (parentDeclaration == null) {
            return false;
        }
        for (PsiElement el = elementToInline; el != null && !PsiTreeUtil.isAncestor((PsiElement)el, (PsiElement)parentDeclaration, (boolean)false); el = el.getParent()) {
            if (!(el instanceof JSInitializerOwner) || ((JSInitializerOwner)el).getInitializer() == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static JSInitializerOwner findOwner(PsiElement elementToInline) {
        PsiElement parent = JSDestructuringUtil.getParentSkippingDestructuring((JSElement)elementToInline);
        if (!(parent instanceof JSVarStatement)) {
            return null;
        }
        JSInitializerOwner parentDeclaration = null;
        for (JSInitializerOwner declaration : ((JSVarStatement)parent).getDeclarations()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)declaration, (PsiElement)elementToInline, (boolean)false)) continue;
            parentDeclaration = declaration;
            break;
        }
        return parentDeclaration;
    }

    @Nullable
    public static MySettings handleVariable(JSVariable element, @Nullable Editor editor, @Nullable PsiReference invocationReference, NotNullLazyValue<Collection<PsiReference>> deferredUsages, boolean isInvokedOnReference) {
        JSInitializerOwner owner;
        PsiElement elementParent = element.getParent();
        boolean destructuring = JSDestructuringUtil.isDestructuring(elementParent);
        if (destructuring && (elementParent instanceof JSDestructuringArrayRestElement || elementParent instanceof JSDestructuringProperty && ((JSDestructuringProperty)elementParent).isRest())) {
            JSVarOrFieldInliner.showErrorHint((PsiElement)element, editor, JavaScriptBundle.message((String)"javascript.refactoring.cannot.inline.destructuring.rest.variable", (Object[])new Object[0]));
            return null;
        }
        if (destructuring && JSVarOrFieldInliner.hasInitializerInDestructuring((PsiElement)element)) {
            JSVarOrFieldInliner.showErrorHint((PsiElement)element, editor, JavaScriptBundle.message((String)"javascript.refactoring.cannot.inline.destructuring.variable.with.default", (Object[])new Object[0]));
            return null;
        }
        if (destructuring && ((owner = JSVarOrFieldInliner.findOwner((PsiElement)element)) == null || owner.getInitializer() == null)) {
            JSVarOrFieldInliner.showErrorHint((PsiElement)element, editor, JavaScriptBundle.message((String)"javascript.refactoring.cannot.inline.not.initialized.variable", (Object[])new Object[0]));
            return null;
        }
        if (destructuring || element.getInitializer() != null) {
            return new MySettings((JSNamedElement)element, deferredUsages, isInvokedOnReference);
        }
        if (invocationReference != null) {
            JSDefinitionExpression expr = null;
            if (invocationReference instanceof JSReferenceExpression) {
                PsiElement grandParent;
                PsiElement parent = invocationReference.getElement().getParent();
                if (!(parent instanceof JSDefinitionExpression)) {
                    parent = JSVarOrFieldInliner.findDefinition((JSReferenceExpression)invocationReference);
                }
                if (parent instanceof JSDefinitionExpression && (grandParent = parent.getParent()) instanceof JSAssignmentExpression && ((JSAssignmentExpression)grandParent).getROperand() != null) {
                    expr = (JSDefinitionExpression)parent;
                }
            }
            if (expr != null) {
                for (PsiReference ref : (Collection)deferredUsages.getValue()) {
                    if (!JSVarOrFieldInliner.referencesOurDefinition(ref.getElement(), expr)) continue;
                    return new MySettings((JSNamedElement)expr, deferredUsages, true);
                }
                JSVarOrFieldInliner.showErrorHint((PsiElement)element, editor, JavaScriptBundle.message((String)"javascript.refactoring.cannot.find.usages.of.definition.to.inline", (Object[])new Object[0]));
                return null;
            }
        }
        JSVarOrFieldInliner.showErrorHint((PsiElement)element, editor, JavaScriptBundle.message((String)"javascript.refactoring.cannot.inline.not.initialized.variable", (Object[])new Object[0]));
        return null;
    }

    private static void showErrorHint(@NotNull PsiElement element, @Nullable Editor editor, String message) {
        if (element == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(8);
        }
        CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)message, (String)JavaScriptBundle.message((String)"javascript.refactoring.inline.variable.title", (Object[])new Object[0]), (String)"refactoring.inlineVariable");
    }

    @Override
    public void removeDefinition(@NotNull PsiElement element) {
        boolean b;
        JSExpressionStatement expressionStatement;
        JSNamedElement toRemove;
        if (element == null) {
            JSVarOrFieldInliner.$$$reportNull$$$0(9);
        }
        if ((toRemove = this.mySettings.getTarget()) instanceof JSDefinitionExpression && (expressionStatement = (JSExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)toRemove, JSExpressionStatement.class)) != null) {
            toRemove = expressionStatement;
        }
        JSInlineHandler.deleteElementWithReformat((PsiElement)toRemove);
        if (element instanceof JSNamedElement && toRemove != element && (b = JSUnusedGlobalSymbolCache.calcUnused(element))) {
            JSInlineHandler.deleteElementWithReformat(element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/JSVarOrFieldInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReadAccess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConflicts";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doInlineUsage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "referencesOurDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findDefinition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorHint";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class MySettings
    extends JSInlineHandler.Settings {
        private final SmartPsiElementPointer<JSNamedElement> myTargetPointer;
        private JSExpression initialized;

        MySettings(JSNamedElement target, NotNullLazyValue<Collection<PsiReference>> deferredUsages, boolean invokedOnReference) {
            super(deferredUsages, invokedOnReference);
            this.myTargetPointer = SmartPointerManager.createPointer((PsiElement)target);
            if (target instanceof JSVariable) {
                this.initialized = JSDestructuringUtil.isDestructuring(target.getParent()) ? MySettings.createDestructuringTail(target) : ((JSVariable)target).getInitializer();
            } else if (target instanceof JSDefinitionExpression) {
                this.initialized = ((JSAssignmentExpression)target.getParent()).getROperand();
            }
            assert (this.initialized != null);
        }

        @NotNull
        private static JSExpression createDestructuringTail(@NotNull JSNamedElement target) {
            if (target == null) {
                MySettings.$$$reportNull$$$0(0);
            }
            JSInitializerOwner owner = JSVarOrFieldInliner.findOwner((PsiElement)target);
            assert (owner != null);
            JSExpression initializer = owner.getInitializer();
            assert (initializer != null);
            StringBuilder tail = new StringBuilder();
            JSNamedElement element = target;
            while (element != null) {
                PsiElement parent;
                if (element instanceof JSDestructuringProperty) {
                    ES6ComputedName computedName = ((JSDestructuringProperty)element).getComputedPropertyName();
                    if (computedName != null) {
                        tail.insert(0, computedName.getText());
                    } else {
                        tail.insert(0, "." + ((JSDestructuringProperty)element).getName());
                    }
                }
                if ((parent = element.getParent()) instanceof JSDestructuringArray) {
                    int index = ArrayUtil.indexOf((Object[])((JSDestructuringArray)parent).getElements(), (Object)element);
                    tail.insert(0, "[" + index + "]");
                }
                element = parent;
            }
            JSExpression jSExpression = JSPsiElementFactory.createJSExpression(initializer.getText() + tail, (PsiElement)initializer);
            if (jSExpression == null) {
                MySettings.$$$reportNull$$$0(1);
            }
            return jSExpression;
        }

        public JSNamedElement getTarget() {
            return (JSNamedElement)this.myTargetPointer.getElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/inline/JSVarOrFieldInliner$MySettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/inline/JSVarOrFieldInliner$MySettings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDestructuringTail";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createDestructuringTail";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

