/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.util;

import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMemberInfo
extends MemberInfoBase<JSAttributeListOwner> {
    public static final JSMemberInfo[] EMPTY_ARRAY = new JSMemberInfo[0];
    private static final int DEFAULT_FORMAT_OPTIONS = 7;
    private final boolean myExtendsList;
    private static final Comparator<JSMemberInfo> BY_OFFSET_COMPARATOR = (o1, o2) -> {
        JSAttributeListOwner member1 = (JSAttributeListOwner)o1.getMember();
        JSAttributeListOwner member2 = (JSAttributeListOwner)o2.getMember();
        if (member1 instanceof JSClass && member2 instanceof JSClass) {
            return Comparing.compare((Comparable)((Object)member1.getName()), (Comparable)((Object)member2.getName()));
        }
        if (member1 instanceof JSClass) {
            return -1;
        }
        if (member2 instanceof JSClass) {
            return 1;
        }
        return member1.getTextOffset() - member2.getTextOffset();
    };

    private JSMemberInfo(@NotNull JSField field) {
        if (field == null) {
            JSMemberInfo.$$$reportNull$$$0(0);
        }
        super((PsiElement)field);
        this.myExtendsList = false;
        this.isStatic = JSMemberInfo.isStatic((JSAttributeListOwner)field);
        this.displayName = JSMemberInfo.getFieldName(field);
        this.overrides = JSMemberInfo.determineOverrides((JSElement)field);
    }

    public JSMemberInfo(@NotNull JSParameter parameter) {
        if (parameter == null) {
            JSMemberInfo.$$$reportNull$$$0(1);
        }
        super((PsiElement)parameter);
        this.myExtendsList = false;
        this.isStatic = false;
        this.displayName = JSFormatUtil.formatField((JSTypeDeclarationOwner)parameter, 7);
        this.overrides = JSMemberInfo.determineOverrides((JSElement)parameter);
    }

    @NotNull
    public static String getFieldName(@NotNull JSField field) {
        if (field == null) {
            JSMemberInfo.$$$reportNull$$$0(2);
        }
        String string = JSFormatUtil.formatField((JSTypeDeclarationOwner)field, 7);
        if (string == null) {
            JSMemberInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    private JSMemberInfo(@NotNull JSFunction method) {
        if (method == null) {
            JSMemberInfo.$$$reportNull$$$0(4);
        }
        super((PsiElement)method);
        this.myExtendsList = false;
        this.isStatic = JSMemberInfo.isStatic((JSAttributeListOwner)method);
        this.displayName = JSMemberInfo.getFunctionName(method);
        this.overrides = JSMemberInfo.determineOverrides((JSElement)method);
    }

    private JSMemberInfo(@NotNull TypeScriptTypeMember member) {
        if (member == null) {
            JSMemberInfo.$$$reportNull$$$0(5);
        }
        super((PsiElement)member);
        this.myExtendsList = false;
        this.isStatic = JSMemberInfo.isStatic((JSAttributeListOwner)member);
        this.displayName = JSMemberInfo.getInterfaceMemberName(member);
        this.overrides = JSMemberInfo.determineOverrides((JSElement)member);
    }

    private JSMemberInfo(@NotNull JSClass aClass, boolean extendsNotImplements) {
        if (aClass == null) {
            JSMemberInfo.$$$reportNull$$$0(6);
        }
        super((PsiElement)aClass);
        this.myExtendsList = extendsNotImplements;
        this.displayName = RefactoringBundle.message((String)(extendsNotImplements ? "member.info.extends.0" : "member.info.implements.0"), (Object[])new Object[]{aClass.getName()});
        this.overrides = Boolean.FALSE;
    }

    @NotNull
    public static String getFunctionName(@NotNull JSFunction method) {
        if (method == null) {
            JSMemberInfo.$$$reportNull$$$0(7);
        }
        String string = JSFormatUtil.formatMethod(method, 263, 7);
        if (string == null) {
            JSMemberInfo.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static String getInterfaceMemberName(@NotNull TypeScriptTypeMember member) {
        if (member == null) {
            JSMemberInfo.$$$reportNull$$$0(9);
        }
        return JSFormatUtil.formatTypeMember(member, 263, 7);
    }

    @Nullable
    private static Boolean determineOverrides(JSElement method) {
        if (method instanceof JSPsiElementBase && !JSInheritanceUtil.findNearestOverriddenMembers((JSPsiElementBase)method, true).isEmpty()) {
            return true;
        }
        if (method instanceof JSFunction && !JSInheritanceUtil.findImplementedMethods((JSFunction)method).isEmpty()) {
            return false;
        }
        return null;
    }

    public static void extractStaticMembers(@NotNull JSClass clazz, @NotNull List<? super JSMemberInfo> result2, final @NotNull MemberInfoBase.Filter<? super JSAttributeListOwner> filter) {
        if (clazz == null) {
            JSMemberInfo.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            JSMemberInfo.$$$reportNull$$$0(11);
        }
        if (filter == null) {
            JSMemberInfo.$$$reportNull$$$0(12);
        }
        JSMemberInfo.extractClassMembers(clazz, result2, (MemberInfoBase.Filter<? super JSAttributeListOwner>)new MemberInfoBase.Filter<JSAttributeListOwner>(){

            public boolean includeMember(JSAttributeListOwner member) {
                return (member instanceof JSVariable || member instanceof JSFunction) && JSMemberInfo.isStatic(member) && filter.includeMember((PsiElement)member);
            }
        });
    }

    public static void extractClassMembers(@NotNull JSClass clazz, @NotNull List<? super JSMemberInfo> result2, @NotNull MemberInfoBase.Filter<? super JSAttributeListOwner> filter) {
        JSReferenceList interfacesList;
        if (clazz == null) {
            JSMemberInfo.$$$reportNull$$$0(13);
        }
        if (result2 == null) {
            JSMemberInfo.$$$reportNull$$$0(14);
        }
        if (filter == null) {
            JSMemberInfo.$$$reportNull$$$0(15);
        }
        if (clazz instanceof TypeScriptInterface) {
            TypeScriptObjectType body = ((TypeScriptInterface)clazz).getBody();
            if (body == null) {
                return;
            }
            for (TypeScriptTypeMember element : body.getTypeMembers()) {
                if (!filter.includeMember((PsiElement)element)) continue;
                result2.add(new JSMemberInfo(element));
            }
            return;
        }
        JSReferenceList jSReferenceList = interfacesList = clazz.isInterface() ? clazz.getExtendsList() : clazz.getImplementsList();
        if (interfacesList != null) {
            for (JSClass anInterface : interfacesList.getReferencedClasses()) {
                if (!filter.includeMember((PsiElement)anInterface) || !anInterface.isInterface()) continue;
                result2.add(new JSMemberInfo(anInterface, clazz.isInterface()));
            }
        }
        for (JSElement element : clazz.getMembers()) {
            JSParameter parameter;
            if (element instanceof JSFunction) {
                JSFunction method = (JSFunction)element;
                if (!filter.includeMember((PsiElement)method) || method.getKind() == JSFunction.FunctionKind.CONSTRUCTOR || method.isSetProperty() && clazz.findFunctionByNameAndKind(method.getName(), JSFunction.FunctionKind.GETTER) != null || method.getContainingFile().getContext() == null && !method.getContainingFile().equals(clazz.getContainingFile())) continue;
                result2.add(new JSMemberInfo(method));
            }
            if (element instanceof JSField) {
                JSField field = (JSField)element;
                if (!filter.includeMember((PsiElement)field)) continue;
                result2.add(new JSMemberInfo(field));
            }
            if (!(element instanceof JSParameter) || !filter.includeMember((PsiElement)(parameter = (JSParameter)element)) || !TypeScriptPsiUtil.isFieldParameter(parameter)) continue;
            result2.add(new JSMemberInfo(parameter));
        }
    }

    public boolean isExtendsNotImplements() {
        return this.myExtendsList;
    }

    public void setChecked(Collection<JSElement> selected) {
        JSAttributeListOwner member = (JSAttributeListOwner)this.getMember();
        this.setChecked(selected.contains(member) || member instanceof JSFunction && ((JSFunction)member).isGetProperty() && selected.contains(JSUtils.getMemberContainingClass((PsiElement)member).findFunctionByNameAndKind(member.getName(), JSFunction.FunctionKind.SETTER)));
    }

    public static JSMemberInfo @NotNull [] getSelected(Collection<? extends JSMemberInfo> memberInfos, JSClass clazz, Condition<? super JSMemberInfo> filter) {
        ArrayList<JSMemberInfo> result2 = new ArrayList<JSMemberInfo>();
        for (JSMemberInfo jSMemberInfo : memberInfos) {
            JSFunction setter;
            if (!filter.value((Object)jSMemberInfo) || !jSMemberInfo.isChecked()) continue;
            result2.add(jSMemberInfo);
            JSAttributeListOwner member = (JSAttributeListOwner)jSMemberInfo.getMember();
            if (!(member instanceof JSFunction) || !((JSFunction)member).isGetProperty() || (setter = clazz.findFunctionByNameAndKind(member.getName(), JSFunction.FunctionKind.SETTER)) == null) continue;
            JSMemberInfo setterInfo = new JSMemberInfo(setter);
            setterInfo.setChecked(true);
            setterInfo.setToAbstract(jSMemberInfo.isToAbstract());
            result2.add(setterInfo);
        }
        JSMemberInfo[] jSMemberInfoArray = result2.toArray(new JSMemberInfo[0]);
        if (jSMemberInfoArray == null) {
            JSMemberInfo.$$$reportNull$$$0(16);
        }
        return jSMemberInfoArray;
    }

    @NotNull
    public static Collection<JSAttributeListOwner> getStatics(JSMemberInfo @NotNull [] members) {
        if (members == null) {
            JSMemberInfo.$$$reportNull$$$0(17);
        }
        ArrayList<JSAttributeListOwner> staticMembers = new ArrayList<JSAttributeListOwner>();
        for (JSMemberInfo memberInfo : members) {
            if (!memberInfo.isStatic()) continue;
            staticMembers.add((JSAttributeListOwner)memberInfo.getMember());
        }
        ArrayList<JSAttributeListOwner> arrayList = staticMembers;
        if (arrayList == null) {
            JSMemberInfo.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    public static void sortByOffset(JSMemberInfo[] memberInfos) {
        Arrays.sort(memberInfos, BY_OFFSET_COMPARATOR);
    }

    public static void sortByOffset(List<? extends JSMemberInfo> memberInfos) {
        Collections.sort(memberInfos, BY_OFFSET_COMPARATOR);
    }

    public static void extractSameMembers(JSClass from, final JSClass originalClass, JSMemberInfo[] originalClassSelectedMembers, List<? super JSMemberInfo> result2) {
        final HashSet<PsiElement> selectedMembers = new HashSet<PsiElement>();
        for (JSMemberInfo originalMember : originalClassSelectedMembers) {
            selectedMembers.add(originalMember.getMember());
        }
        JSMemberInfo.extractClassMembers(from, result2, (MemberInfoBase.Filter<? super JSAttributeListOwner>)new MemberInfoBase.Filter<JSAttributeListOwner>(){

            public boolean includeMember(JSAttributeListOwner member) {
                if (member instanceof JSFunction) {
                    return selectedMembers.contains(originalClass.findFunctionByNameAndKind(member.getName(), ((JSFunction)member).getKind()));
                }
                if (member instanceof JSField) {
                    return selectedMembers.contains(originalClass.findFieldByName(member.getName()));
                }
                if (member instanceof JSClass) {
                    return JSPsiImplUtils.containsEquivalent(selectedMembers, (PsiElement)member);
                }
                LOG.error((Object)member);
                return false;
            }
        });
    }

    private static boolean isStatic(@NotNull JSAttributeListOwner member) {
        if (member == null) {
            JSMemberInfo.$$$reportNull$$$0(19);
        }
        return JSPsiImplUtils.hasModifier(member, JSAttributeList.ModifierType.STATIC);
    }

    @NotNull
    public static List<JSMemberInfo> selectMembers(@NotNull JSClass sourceClass, @Nullable JSElement selectedElement, @NotNull MemberInfoBase.Filter<? super JSAttributeListOwner> filter) {
        if (sourceClass == null) {
            JSMemberInfo.$$$reportNull$$$0(20);
        }
        if (filter == null) {
            JSMemberInfo.$$$reportNull$$$0(21);
        }
        ArrayList<JSMemberInfo> result2 = new ArrayList<JSMemberInfo>();
        JSMemberInfo.extractClassMembers(sourceClass, result2, filter);
        JSMemberInfo.sortByOffset(result2);
        for (JSMemberInfo memberInfo : result2) {
            memberInfo.setChecked(Collections.singletonList(selectedElement));
        }
        ArrayList<JSMemberInfo> arrayList = result2;
        if (arrayList == null) {
            JSMemberInfo.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 16: 
            case 18: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 16: 
            case 18: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 3: 
            case 8: 
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/util/JSMemberInfo";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/util/JSMemberInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelected";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatics";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "selectMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFieldName";
                break;
            }
            case 3: 
            case 8: 
            case 16: 
            case 18: 
            case 22: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInterfaceMemberName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractStaticMembers";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractClassMembers";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStatics";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isStatic";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "selectMembers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 16: 
            case 18: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

