/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeGuardFixHelper;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.validation.JSReferenceInspectionProblemReporter;
import com.intellij.lang.javascript.validation.TypedJSReferenceChecker;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReferenceChecker
extends TypedJSReferenceChecker {
    public TypeScriptReferenceChecker(@NotNull JSReferenceInspectionProblemReporter reporter) {
        if (reporter == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(0);
        }
        super(reporter);
    }

    @Override
    protected boolean processExpressionResolveResult(@Nullable JSExpression expression, @Nullable PsiElement resolved) {
        JSFunction function2;
        JSAttributeList list2;
        if (expression instanceof JSReferenceExpression && ((JSReferenceExpression)expression).getQualifier() instanceof JSSuperExpression && resolved instanceof JSFunction && (list2 = (function2 = (JSFunction)resolved).getAttributeList()) != null && list2.hasModifier(JSAttributeList.ModifierType.ABSTRACT)) {
            String message = JavaScriptBundle.message((String)"typescript.validation.message.abstract.member.access.super", (Object[])new Object[]{function2.getName()});
            this.myReporter.reportUnresolvedFunctionError((PsiElement)expression, this.getUnresolvedReferenceHighlightType((JSReferenceExpression)expression), message, null);
            return true;
        }
        return false;
    }

    @Override
    protected void addCreateFromUsageFixesForCall(@NotNull JSReferenceExpression methodExpression, boolean isNewExpression, ResolveResult @NotNull [] resolveResults, @NotNull List<LocalQuickFix> quickFixes) {
        if (methodExpression == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(1);
        }
        if (quickFixes == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(2);
        }
        if (resolveResults == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(3);
        }
        if (methodExpression.getQualifier() == null && resolveResults.length == 0) {
            quickFixes.addAll(JSFixFactory.getInstance().typeScriptAddImportStatementFix(methodExpression.getReferenceName(), (PsiElement)methodExpression));
        }
        super.addCreateFromUsageFixesForCall(methodExpression, isNewExpression, resolveResults, quickFixes);
    }

    @Override
    protected boolean addCreateFromUsageFixes(JSReferenceExpression node, ResolveResult[] resolveResults, List<LocalQuickFix> fixes, boolean inTypeContext, boolean ecma) {
        if (node.getQualifier() == null && resolveResults.length == 0) {
            fixes.addAll(JSFixFactory.getInstance().typeScriptAddImportStatementFix(node.getReferenceName(), (PsiElement)node));
        }
        return super.addCreateFromUsageFixes(node, resolveResults, fixes, inTypeContext, ecma);
    }

    @Override
    protected void addSurroundWithTypeGuardFix(@NotNull JSExpression qualifier, @NotNull List<LocalQuickFix> fixes, @NotNull String name) {
        if (qualifier == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(4);
        }
        if (fixes == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(5);
        }
        if (name == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(6);
        }
        TypeScriptTypeGuardFixHelper.addTypeGuardFixes(qualifier, fixes, name);
    }

    @Override
    protected void modifyUnresolvedErrorMessage(@NotNull Ref<? super String> message, ResolveResult @NotNull [] results, @Nullable JSExpression qualifier, @NotNull JSReferenceExpression node, boolean inTypeContext) {
        JSType type;
        JSTypeCastUtil.NullableState nullableState;
        if (message == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(7);
        }
        if (node == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(8);
        }
        if (results == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(9);
        }
        if (results.length == 0 && !inTypeContext && qualifier != null && (nullableState = JSTypeCastUtil.getNullableState(type = JSResolveUtil.getExpressionJSType(qualifier))) != JSTypeCastUtil.NullableState.NOT_NULLABLE) {
            JSType typeWithoutNull = JSTypeUtils.removeNullableComponents(type);
            String referenceName = node.getReferenceName();
            if (typeWithoutNull != null && referenceName != null && typeWithoutNull != type && typeWithoutNull.asRecordType().hasProperty(referenceName)) {
                if (nullableState == JSTypeCastUtil.NullableState.HAS_NULL_AND_UNDEFINED) {
                    message.set((Object)JavaScriptBundle.message((String)"javascript.unresolved.variable.null.or.undefined.qualifier.message", (Object[])new Object[]{referenceName}));
                } else if (nullableState == JSTypeCastUtil.NullableState.HAS_NULL) {
                    message.set((Object)JavaScriptBundle.message((String)"javascript.unresolved.variable.null.qualifier.message", (Object[])new Object[]{referenceName}));
                } else {
                    message.set((Object)JavaScriptBundle.message((String)"javascript.unresolved.variable.undefined.qualifier.message", (Object[])new Object[]{referenceName}));
                }
            }
        }
    }

    @Override
    @Nullable
    public ProblemHighlightType getUnresolvedReferenceHighlightType(@NotNull JSReferenceExpression node) {
        JSExpression qualifier;
        if (node == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(10);
        }
        if (node instanceof TypeScriptEntityName && (qualifier = node.getQualifier()) instanceof TypeScriptEntityName && this.isErrorReported((JSReferenceExpression)qualifier)) {
            return ProblemHighlightType.INFORMATION;
        }
        if (TypeScriptUtil.resolveIsStrict(node)) {
            return ProblemHighlightType.ERROR;
        }
        return super.getUnresolvedReferenceHighlightType(node);
    }

    @Override
    protected void addFixesForDistinctResolveProblem(JSReferenceExpression node, List<LocalQuickFix> fixes, String resolveProblemKey, PsiElement element) {
        if (resolveProblemKey == "javascript.element.need.to.be.included.to.config") {
            fixes.addAll(JSFixFactory.getInstance().typeScriptConfigFixes((JSElement)node, element));
        }
        if (TypeScriptReferenceChecker.isAcceptableResolveKey(node, resolveProblemKey, element)) {
            fixes.addAll(JSFixFactory.getInstance().typeScriptAddImportStatementFix(node.getReferenceName(), (PsiElement)node));
        }
        super.addFixesForDistinctResolveProblem(node, fixes, resolveProblemKey, element);
    }

    @Override
    protected void checkCallReferences(JSReferenceExpression methodExpression, boolean isNewExpression) {
        if (TypeScriptReferenceChecker.shouldSkipResolveError(methodExpression)) {
            return;
        }
        super.checkCallReferences(methodExpression, isNewExpression);
    }

    @Override
    protected void checkRefExpression(@NotNull JSReferenceExpression node) {
        if (node == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(11);
        }
        if (TypeScriptReferenceChecker.shouldSkipResolveError(node)) {
            return;
        }
        super.checkRefExpression(node);
    }

    private static boolean shouldSkipResolveError(@NotNull JSReferenceExpression methodExpression) {
        ResolveResult[] resolveResults;
        if (methodExpression == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(12);
        }
        if ((resolveResults = methodExpression.multiResolve(false)).length > 0 && !resolveResults[0].isValidResult() && resolveResults[0] instanceof JSResolveResult) {
            String key = ((JSResolveResult)resolveResults[0]).getResolveProblemKey();
            if (key != null) {
                key = JavaScriptBundle.message((String)key, (Object[])new Object[0]);
            }
            if (methodExpression.getContainingFile().getVirtualFile() instanceof VirtualFileWindow && JavaScriptBundle.message((String)"javascript.element.need.to.be.included.to.config", (Object[])new Object[0]).equals(key)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAcceptableResolveKey(@NotNull JSReferenceExpression node, @Nullable String resolveProblemKey, @Nullable PsiElement element) {
        if (node == null) {
            TypeScriptReferenceChecker.$$$reportNull$$$0(13);
        }
        return (resolveProblemKey == "javascript.element.is.not.accessible.message" || resolveProblemKey == "javascript.element.need.to.be.exported") && element instanceof TypeScriptImportStatement && node.getQualifier() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/TypeScriptReferenceChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addCreateFromUsageFixesForCall";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addSurroundWithTypeGuardFix";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyUnresolvedErrorMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnresolvedReferenceHighlightType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRefExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSkipResolveError";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptableResolveKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

