/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeLanguageLevelFix
implements IntentionAction,
LocalQuickFix {
    private final JSLanguageLevel myProposedLevel;

    public ChangeLanguageLevelFix(JSLanguageLevel proposedLevel) {
        this.myProposedLevel = proposedLevel;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)"javascript.change.language.level.message", (Object[])new Object[]{this.myProposedLevel});
        if (string == null) {
            ChangeLanguageLevelFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            ChangeLanguageLevelFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"javascript.change.language.level.family", (Object[])new Object[0]);
        if (string == null) {
            ChangeLanguageLevelFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            ChangeLanguageLevelFix.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            ChangeLanguageLevelFix.$$$reportNull$$$0(4);
        }
        this.invoke(project, null, descriptor2.getPsiElement().getContainingFile());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            ChangeLanguageLevelFix.$$$reportNull$$$0(5);
        }
        JSRootConfiguration.getInstance(project).storeLanguageLevelAndUpdateCaches(this.myProposedLevel);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            ChangeLanguageLevelFix.$$$reportNull$$$0(6);
        }
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public static JSLanguageLevel defineMinimalLanguageLevel(JSLanguageFeature feature, JSLanguageLevel currentLevel) {
        JSLanguageLevel candidateBefore;
        JSLanguageLevel[] values = JSLanguageLevel.values();
        JSLanguageLevel candidate = null;
        block0: do {
            candidateBefore = candidate;
            for (JSLanguageLevel value : values) {
                if (!value.getDialect().getOptionHolder().hasFeature(feature) || !value.isAtLeast(currentLevel) || candidate != null && (candidate == value || !candidate.isAtLeast(value))) continue;
                candidate = value;
                continue block0;
            }
        } while (candidate != candidateBefore);
        return candidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/ChangeLanguageLevelFix";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/ChangeLanguageLevelFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

