/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class TypeScriptCompilerVfsListener
implements BulkFileListener {
    @NotNull
    private final ExecutorService myExecutorService = ApplicationManager.getApplication().isUnitTestMode() ? EdtExecutorService.getInstance() : SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"TypeScript VFS Events Processing");

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            TypeScriptCompilerVfsListener.$$$reportNull$$$0(0);
        }
        this.afterImpl(events);
    }

    private void afterImpl(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            TypeScriptCompilerVfsListener.$$$reportNull$$$0(1);
        }
        SmartList filesToProcess = null;
        boolean cleanAllCache = false;
        Collection changedConfigs = null;
        boolean hasCreateTsFileEvent = false;
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2;
            if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || (file2 = vFileEvent.getFile()) == null) continue;
            boolean isDeleteEvent = vFileEvent instanceof VFileDeleteEvent;
            if (isDeleteEvent && (Boolean.TRUE.equals(file2.getUserData(JSLanguageServiceQueue.GENERATED_FILE_MARKER)) || file2.isDirectory())) {
                cleanAllCache = true;
                continue;
            }
            if (file2.isDirectory()) continue;
            CharSequence sequence = file2.getNameSequence();
            if (TypeScriptCompilerVfsListener.isTypeScriptFile(sequence)) {
                TypeScriptCompilerVfsListener.logTypeScriptEvent(vFileEvent, file2);
                hasCreateTsFileEvent |= vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileCopyEvent;
                if (filesToProcess == null) {
                    filesToProcess = new SmartList();
                }
                TypeScriptCompilerVfsListener.fillCreateAndChangeFiles(filesToProcess, vFileEvent);
                continue;
            }
            if (!TypeScriptCompilerVfsListener.isConfigFile(sequence)) continue;
            if (changedConfigs == null) {
                changedConfigs = new THashSet();
            }
            changedConfigs.add(file2);
        }
        this.afterProcessing(filesToProcess == null ? ContainerUtil.emptyList() : filesToProcess, changedConfigs == null ? ContainerUtil.emptyList() : changedConfigs, cleanAllCache, hasCreateTsFileEvent);
    }

    private void afterProcessing(@NotNull List<VirtualFile> filesToProcess, @NotNull Collection<VirtualFile> changedConfigs, boolean cleanAllCache, boolean hasCreateTsFileEvent) {
        if (filesToProcess == null) {
            TypeScriptCompilerVfsListener.$$$reportNull$$$0(2);
        }
        if (changedConfigs == null) {
            TypeScriptCompilerVfsListener.$$$reportNull$$$0(3);
        }
        if (!changedConfigs.isEmpty() || cleanAllCache || !ContainerUtil.isEmpty(filesToProcess)) {
            this.executeRunnableInReadAction((ThrowableRunnable<RuntimeException>)((ThrowableRunnable)() -> {
                Project[] projects;
                for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                    TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
                    ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
                    if (cleanAllCache || hasCreateTsFileEvent && TypeScriptCompilerVfsListener.hasConfigParameter(settings)) {
                        TypeScriptCompilerService.sendCleanCommand(project, new TypeScriptServiceCommandClean(true));
                    } else if (!changedConfigs.isEmpty()) {
                        for (VirtualFile config2 : changedConfigs) {
                            if (!fileIndex.isInContent(config2)) continue;
                            TypeScriptCompilerService.sendCleanCommand(project, new TypeScriptServiceCommandClean(TypeScriptCompilerConfigUtil.getConfigIdByConfig(config2)));
                        }
                    }
                    if (ContainerUtil.isEmpty((Collection)filesToProcess)) continue;
                    List filtered = ((StreamEx)StreamEx.of((Collection)filesToProcess).filter(el -> fileIndex.isInContent(el))).toList();
                    TypeScriptCompilerService.processVfsChangesForFiles(project, filtered);
                }
            }));
        }
    }

    private void executeRunnableInReadAction(@NotNull ThrowableRunnable<RuntimeException> runnable) {
        if (runnable == null) {
            TypeScriptCompilerVfsListener.$$$reportNull$$$0(4);
        }
        this.myExecutorService.execute(() -> ReadAction.run((ThrowableRunnable)runnable));
    }

    private static void logTypeScriptEvent(@NotNull VFileEvent event, @NotNull VirtualFile file2) {
        if (event == null) {
            TypeScriptCompilerVfsListener.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            TypeScriptCompilerVfsListener.$$$reportNull$$$0(6);
        }
        if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.LOGGER.debug("TypeScript Vfs Events Processing: " + event.getClass() + " file " + file2 + " " + event.getRequestor());
        }
    }

    private static boolean isConfigFile(@NotNull CharSequence fileNameSequence) {
        if (fileNameSequence == null) {
            TypeScriptCompilerVfsListener.$$$reportNull$$$0(7);
        }
        if (!StringUtil.endsWith((CharSequence)fileNameSequence, (CharSequence)".json")) {
            return false;
        }
        return FileTypeManager.getInstance().getFileTypeByFileName(fileNameSequence) instanceof TypeScriptConfigFileType;
    }

    private static boolean isTypeScriptFile(@NotNull CharSequence sequence) {
        if (sequence == null) {
            TypeScriptCompilerVfsListener.$$$reportNull$$$0(8);
        }
        return StringUtil.endsWith((CharSequence)sequence, (CharSequence)".ts") || StringUtil.endsWith((CharSequence)sequence, (CharSequence)".tsx");
    }

    private static boolean hasConfigParameter(@NotNull TypeScriptCompilerSettings settings) {
        if (settings == null) {
            TypeScriptCompilerVfsListener.$$$reportNull$$$0(9);
        }
        if (!settings.useService()) {
            return true;
        }
        String params = settings.getDefaultServiceOptions();
        if (StringUtil.isEmpty((String)params)) {
            return false;
        }
        for (String s : ParametersListUtil.parse((String)params)) {
            if (StringUtil.isEmpty((String)s) || !ArrayUtil.contains((String)s, (String[])TypeScriptCompilerSettings.CONFIG_PARAMS)) continue;
            return true;
        }
        return false;
    }

    private static void fillCreateAndChangeFiles(@NotNull List<? super VirtualFile> filesToUpdateState, @NotNull VFileEvent event) {
        if (filesToUpdateState == null) {
            TypeScriptCompilerVfsListener.$$$reportNull$$$0(10);
        }
        if (event == null) {
            TypeScriptCompilerVfsListener.$$$reportNull$$$0(11);
        }
        if (event instanceof VFileCreateEvent || event instanceof VFileCopyEvent || event instanceof VFileContentChangeEvent) {
            filesToUpdateState.add((VirtualFile)event.getFile());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToProcess";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedConfigs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameSequence";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToUpdateState";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptCompilerVfsListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "after";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "afterImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "afterProcessing";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "executeRunnableInReadAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "logTypeScriptEvent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isTypeScriptFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "hasConfigParameter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCreateAndChangeFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

