/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.typescript.inspection.TypeScriptSpecifyTypeExplicitlyQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix
implements LocalQuickFix {
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"typescript.specify.all.param.types.explicitly", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix.$$$reportNull$$$0(2);
        }
        JSParameter element = (JSParameter)PsiTreeUtil.getParentOfType((PsiElement)descriptor2.getPsiElement(), JSParameter.class);
        assert (element != null);
        TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix.doSpecifyAllParameterTypes(element);
    }

    public static void doSpecifyAllParameterTypes(@NotNull JSParameter element) {
        if (element == null) {
            TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix.$$$reportNull$$$0(3);
        }
        PsiElement parent = element.getParent();
        assert (parent instanceof JSParameterList);
        for (JSParameterListElement parameter : ((JSParameterList)parent).getParameters()) {
            TypeScriptSpecifyTypeExplicitlyQuickFix.doSpecifyExplicitType((JSElement)parameter);
        }
    }

    public static boolean shouldSuggestMultiParamFix(JSParameter parameter) {
        PsiElement parent = parameter.getParent();
        if (!(parent instanceof JSParameterList)) {
            return false;
        }
        JSParameterListElement[] parameters = ((JSParameterList)parent).getParameters();
        if (parameters.length < 2) {
            return false;
        }
        int simpleParamCount = 0;
        for (JSParameterListElement parameterListElement : parameters) {
            if (!(parameterListElement instanceof JSParameter) || parameterListElement.getTypeElement() != null) continue;
            ++simpleParamCount;
        }
        return simpleParamCount > 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspection/TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptSpecifyAllParameterTypesExplicitlyQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doSpecifyAllParameterTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

