/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.Nullable;

public class IncrementDecrementResultUsedJSInspection
extends JavaScriptInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("result.of.increment.or.decrement.expression.used.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSPrefixExpression(JSPrefixExpression jsPrefixExpression) {
            IElementType sign = jsPrefixExpression.getOperationSign();
            if (!JSTokenTypes.PLUSPLUS.equals(sign) && !JSTokenTypes.MINUSMINUS.equals(sign)) {
                return;
            }
            PsiElement parent = jsPrefixExpression.getParent();
            if (parent == null) {
                return;
            }
            if (parent instanceof JSExpressionStatement || parent instanceof JSForInStatement || parent instanceof JSForStatement || parent instanceof JSCommaExpression) {
                return;
            }
            this.registerError((PsiElement)jsPrefixExpression);
        }

        public void visitJSPostfixExpression(JSPostfixExpression jsPostfixExpression) {
            IElementType sign = jsPostfixExpression.getOperationSign();
            if (!JSTokenTypes.PLUSPLUS.equals(sign) && !JSTokenTypes.MINUSMINUS.equals(sign)) {
                return;
            }
            PsiElement parent = jsPostfixExpression.getParent();
            if (parent == null) {
                return;
            }
            if (parent instanceof JSExpressionStatement || parent instanceof JSForInStatement || parent instanceof JSForStatement || parent instanceof JSCommaExpression) {
                return;
            }
            this.registerError((PsiElement)jsPostfixExpression);
        }
    }
}

