/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.dom;

import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.Nullable;

public class PlatformDetectionJSInspection
extends JavaScriptInspection {
    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("platform.detection.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSReferenceExpression(JSReferenceExpression referenceExpression) {
            super.visitJSReferenceExpression(referenceExpression);
            JSReferenceExpression qualifier = (JSReferenceExpression)ObjectUtils.tryCast((Object)referenceExpression.getQualifier(), JSReferenceExpression.class);
            if (qualifier == null || qualifier.getQualifier() != null) {
                return;
            }
            String qualifierText = qualifier.getReferenceName();
            if ("navigator".equalsIgnoreCase(qualifierText)) {
                String methodName = referenceExpression.getReferenceName();
                if (!("userAgent".equalsIgnoreCase(methodName) || "appName".equalsIgnoreCase(methodName) || "appCodeName".equalsIgnoreCase(methodName) || "platform".equalsIgnoreCase(methodName) || "oscpu".equalsIgnoreCase(methodName))) {
                    return;
                }
                this.registerError((PsiElement)referenceExpression);
            } else if ("document".equalsIgnoreCase(qualifierText)) {
                String methodName = referenceExpression.getReferenceName();
                if (!"all".equalsIgnoreCase(methodName) && !"layers".equalsIgnoreCase(methodName)) {
                    return;
                }
                this.registerError((PsiElement)referenceExpression);
            }
        }
    }
}

