/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.validity;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSBranchInstruction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnreachableCodeJSInspection
extends JavaScriptInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("unreachable.code.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static boolean isUnreachableInstruction(@NotNull Instruction instruction) {
        Collection instructions;
        if (instruction == null) {
            UnreachableCodeJSInspection.$$$reportNull$$$0(0);
        }
        if ((instructions = instruction.allPred()).isEmpty()) {
            return true;
        }
        if (instruction instanceof JSBranchInstruction) {
            return false;
        }
        return instructions.stream().allMatch(el -> el instanceof JSBranchInstruction && !((JSBranchInstruction)el).isReachable());
    }

    private static boolean isFirstInstruction(Instruction instruction) {
        return instruction.num() == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/sixrr/inspectjs/validity/UnreachableCodeJSInspection", "isUnreachableInstruction"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFile(JSFile file2) {
            this.visitExecutionScope((JSExecutionScope)file2);
            super.visitJSFile(file2);
        }

        public void visitJSElement(JSElement node) {
            if (node instanceof JSExecutionScope) {
                this.visitExecutionScope((JSExecutionScope)node);
            }
            super.visitJSElement(node);
        }

        private void visitExecutionScope(@NotNull JSExecutionScope node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            JSControlFlowService.JSControlFlow flow = JSControlFlowService.getService(node.getProject()).getControlFlow((JSElement)node);
            Instruction[] instructions = flow.getInstructions();
            ArrayList unreachable = new ArrayList();
            ArrayList unreachableVariables = new ArrayList();
            if (instructions.length > 0) {
                ControlFlowUtil.iteratePrev((int)(instructions.length - 1), (Instruction[])instructions, instruction -> {
                    if (!UnreachableCodeJSInspection.isFirstInstruction(instruction) && UnreachableCodeJSInspection.isUnreachableInstruction(instruction)) {
                        PsiElement element = instruction.getElement();
                        if (element instanceof JSSourceElement && !(element instanceof JSFunction)) {
                            unreachable.add((JSSourceElement)element);
                        } else if (element instanceof JSVariable && !(element instanceof JSParameter) && !(element instanceof JSField)) {
                            unreachableVariables.add((JSVariable)element);
                        }
                    }
                    return ControlFlowUtil.Operation.NEXT;
                });
            }
            unreachable.forEach(el -> {
                if (el instanceof JSBlockStatement) {
                    JSSourceElement[] statements = ((JSBlockStatement)el).getStatementListItems();
                    for (int i = statements.length - 1; i >= 0; --i) {
                        JSSourceElement statement = statements[i];
                        if (statement instanceof JSFunction) continue;
                        this.registerStatementError(statements[0], new Object[0]);
                        return;
                    }
                }
                this.registerStatementError((JSSourceElement)el, new Object[0]);
            });
            unreachableVariables.forEach(el -> {
                for (JSSourceElement element : unreachable) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)el, (boolean)true)) continue;
                    return;
                }
                ASTNode eq = el.getNode().findChildByType(JSTokenTypes.EQ);
                if (eq != null) {
                    this.registerError(eq.getPsi());
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/sixrr/inspectjs/validity/UnreachableCodeJSInspection$Visitor", "visitExecutionScope"));
        }
    }
}

