/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcs.log.visible.filters.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogDateFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import com.intellij.vcs.log.visible.filters.VcsLogHashFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogMultiplePatternsTextFilter;
import com.intellij.vcs.log.visible.filters.VcsLogRangeFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogRegexTextFilter;
import com.intellij.vcs.log.visible.filters.VcsLogRevisionFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogRootFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogTextFilterImpl;
import com.intellij.vcs.log.visible.filters.VcsLogUserFilterImpl;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0007\u001a\u00020\u00042\u0016\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\t\"\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J$\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0007J\u0016\u0010\u0014\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0016\u0010\u001b\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016H\u0007J\u001c\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010 H\u0007J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"H\u0007J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0006H\u0007J\u0016\u0010&\u001a\u00020$2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0007J\u0016\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0011H\u0007J$\u0010,\u001a\u00020-2\u0006\u0010%\u001a\u00020\u00062\b\b\u0002\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u00020/H\u0007J \u00101\u001a\u00020-2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\b\b\u0002\u00100\u001a\u00020/H\u0007J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u0006H\u0007J\u0016\u00103\u001a\u0002042\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u0016H\u0007J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0007J\u0016\u0010=\u001a\u00020:2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020<0\u0011H\u0007J \u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u000e\b\u0002\u0010C\u001a\b\u0012\u0004\u0012\u00020B0\u0013H\u0007J\u001e\u0010D\u001a\u00020@2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010F\u001a\u00020GH\u0007J8\u0010D\u001a\u00020@2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020B0I2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020B0\u0013H\u0007J\u0016\u0010J\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020<0\u0011H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/intellij/vcs/log/visible/filters/VcsLogFilterObject;", "", "()V", "EMPTY_COLLECTION", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "ME", "", "collection", "filters", "", "Lcom/intellij/vcs/log/VcsLogFilter;", "([Lcom/intellij/vcs/log/VcsLogFilter;)Lcom/intellij/vcs/log/VcsLogFilterCollection;", "fromBranch", "Lcom/intellij/vcs/log/VcsLogBranchFilter;", "branchName", "fromBranchPatterns", "strings", "", "existingBranches", "", "fromBranches", "branchNames", "", "fromCommit", "Lcom/intellij/vcs/log/VcsLogRevisionFilter;", "commit", "Lcom/intellij/vcs/log/CommitId;", "fromCommits", "commits", "fromDates", "Lcom/intellij/vcs/log/VcsLogDateFilter;", "after", "Ljava/util/Date;", "before", "", "fromHash", "Lcom/intellij/vcs/log/VcsLogHashFilter;", "text", "fromHashes", "hashes", "fromPaths", "Lcom/intellij/vcs/log/VcsLogStructureFilter;", "files", "Lcom/intellij/openapi/vcs/FilePath;", "fromPattern", "Lcom/intellij/vcs/log/VcsLogTextFilter;", "isRegexpAllowed", "", "isMatchCase", "fromPatternsList", "patterns", "fromRange", "Lcom/intellij/vcs/log/VcsLogRangeFilter;", "exclusiveRef", "inclusiveRef", "ranges", "Lcom/intellij/vcs/log/VcsLogRangeFilter$RefRange;", "fromRoot", "Lcom/intellij/vcs/log/VcsLogRootFilter;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "fromRoots", "roots", "fromUser", "Lcom/intellij/vcs/log/VcsLogUserFilter;", "user", "Lcom/intellij/vcs/log/VcsUser;", "allUsers", "fromUserNames", "userNames", "vcsLogData", "Lcom/intellij/vcs/log/data/VcsLogData;", "meData", "", "fromVirtualFiles", "intellij.platform.vcs.log.impl"})
public final class VcsLogFilterObject {
    @NotNull
    public static final String ME = "*";
    @JvmField
    @NotNull
    public static final VcsLogFilterCollection EMPTY_COLLECTION;
    public static final VcsLogFilterObject INSTANCE;

    @JvmStatic
    @NotNull
    public static final VcsLogTextFilter fromPattern(@NotNull String text2, boolean isRegexpAllowed, boolean isMatchCase) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        if (isRegexpAllowed && VcsLogUtil.maybeRegexp(text2)) {
            try {
                Pattern pattern = Pattern.compile(text2, isMatchCase ? 0 : 2);
                Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(text, if\u2026Pattern.CASE_INSENSITIVE)");
                return new VcsLogRegexTextFilter(pattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return new VcsLogTextFilterImpl(text2, isMatchCase);
    }

    public static /* synthetic */ VcsLogTextFilter fromPattern$default(String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return VcsLogFilterObject.fromPattern(string, bl, bl2);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogTextFilter fromPatternsList(@NotNull List<String> patterns, boolean isMatchCase) {
        Intrinsics.checkParameterIsNotNull(patterns, (String)"patterns");
        if (patterns.isEmpty()) {
            return VcsLogFilterObject.fromPattern("", false, isMatchCase);
        }
        if (patterns.size() == 1) {
            return VcsLogFilterObject.fromPattern((String)CollectionsKt.single(patterns), false, isMatchCase);
        }
        return new VcsLogMultiplePatternsTextFilter(patterns, isMatchCase);
    }

    public static /* synthetic */ VcsLogTextFilter fromPatternsList$default(List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return VcsLogFilterObject.fromPatternsList(list, bl);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogBranchFilter fromBranch(@NotNull String branchName) {
        Intrinsics.checkParameterIsNotNull((Object)branchName, (String)"branchName");
        return VcsLogFilterObject.fromBranches(CollectionsKt.listOf((Object)branchName));
    }

    @JvmStatic
    @NotNull
    public static final VcsLogBranchFilter fromBranches(@NotNull List<String> branchNames) {
        Intrinsics.checkParameterIsNotNull(branchNames, (String)"branchNames");
        return new VcsLogBranchFilterImpl(branchNames, CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    @JvmStatic
    @NotNull
    public static final VcsLogRangeFilter fromRange(@NotNull String exclusiveRef, @NotNull String inclusiveRef) {
        Intrinsics.checkParameterIsNotNull((Object)exclusiveRef, (String)"exclusiveRef");
        Intrinsics.checkParameterIsNotNull((Object)inclusiveRef, (String)"inclusiveRef");
        return VcsLogFilterObject.fromRange(CollectionsKt.listOf((Object)new VcsLogRangeFilter.RefRange(exclusiveRef, inclusiveRef)));
    }

    @JvmStatic
    @NotNull
    public static final VcsLogRangeFilter fromRange(@NotNull List<VcsLogRangeFilter.RefRange> ranges) {
        Intrinsics.checkParameterIsNotNull(ranges, (String)"ranges");
        return new VcsLogRangeFilterImpl(ranges);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogBranchFilter fromBranchPatterns(@NotNull Collection<String> strings, @NotNull Set<String> existingBranches) {
        Intrinsics.checkParameterIsNotNull(strings, (String)"strings");
        Intrinsics.checkParameterIsNotNull(existingBranches, (String)"existingBranches");
        ArrayList<String> branchNames = new ArrayList<String>();
        ArrayList<String> excludedBranches = new ArrayList<String>();
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        ArrayList<Pattern> excludedPatterns = new ArrayList<Pattern>();
        for (String s : strings) {
            boolean isRegexp;
            String string;
            boolean bl;
            boolean isExcluded = StringsKt.startsWith$default((String)s, (String)"-", (boolean)false, (int)2, null);
            if (isExcluded) {
                String string2 = s;
                int n = 1;
                bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n);
                string = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string = s;
            }
            String string5 = string;
            Collection collection = existingBranches;
            bl = false;
            boolean bl2 = isRegexp = !collection.isEmpty() && !existingBranches.contains(string5) || existingBranches.isEmpty() && VcsLogUtil.maybeRegexp(string5);
            if (isRegexp) {
                try {
                    Pattern pattern = Pattern.compile(string5);
                    if (isExcluded) {
                        excludedPatterns.add(pattern);
                        continue;
                    }
                    patterns.add(pattern);
                }
                catch (PatternSyntaxException e) {
                    VcsLogFiltersKt.access$getLOG$p().warn("Pattern " + string5 + " is not a proper regular expression and no branch can be found with that name.", (Throwable)e);
                    if (isExcluded) {
                        excludedBranches.add(string5);
                        continue;
                    }
                    branchNames.add(string5);
                }
                continue;
            }
            if (isExcluded) {
                excludedBranches.add(string5);
                continue;
            }
            branchNames.add(string5);
        }
        return new VcsLogBranchFilterImpl((List<String>)branchNames, (List<Pattern>)patterns, (List<String>)excludedBranches, (List<Pattern>)excludedPatterns);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogRevisionFilter fromCommit(@NotNull CommitId commit) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        return new VcsLogRevisionFilterImpl(CollectionsKt.listOf((Object)commit));
    }

    @JvmStatic
    @NotNull
    public static final VcsLogRevisionFilter fromCommits(@NotNull List<? extends CommitId> commits) {
        Intrinsics.checkParameterIsNotNull(commits, (String)"commits");
        return new VcsLogRevisionFilterImpl((Collection<CommitId>)commits);
    }

    @JvmStatic
    @Nullable
    public static final VcsLogHashFilter fromHash(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        boolean bl = false;
        List hashes = new ArrayList();
        for (String word : StringUtil.split((String)text2, (String)" ")) {
            if (!VcsLogUtil.HASH_REGEX.matcher(word).matches()) {
                return null;
            }
            String string = word;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"word");
            hashes.add(string);
        }
        if (hashes.isEmpty()) {
            return null;
        }
        return VcsLogFilterObject.fromHashes(hashes);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogHashFilter fromHashes(@NotNull Collection<String> hashes) {
        Intrinsics.checkParameterIsNotNull(hashes, (String)"hashes");
        return new VcsLogHashFilterImpl(hashes);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogDateFilter fromDates(@Nullable Date after, @Nullable Date before) {
        return new VcsLogDateFilterImpl(after, before);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogDateFilter fromDates(long after, long before) {
        return VcsLogFilterObject.fromDates(after > 0L ? new Date(after) : null, before > 0L ? new Date(before) : null);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogUserFilter fromUserNames(@NotNull Collection<String> userNames, @NotNull VcsLogData vcsLogData) {
        Intrinsics.checkParameterIsNotNull(userNames, (String)"userNames");
        Intrinsics.checkParameterIsNotNull((Object)vcsLogData, (String)"vcsLogData");
        return new VcsLogUserFilterImpl(userNames, vcsLogData.getCurrentUser(), vcsLogData.getAllUsers());
    }

    @JvmStatic
    @NotNull
    public static final VcsLogUserFilter fromUser(@NotNull VcsUser user, @NotNull Set<? extends VcsUser> allUsers) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull(allUsers, (String)"allUsers");
        return VcsLogFilterObject.fromUserNames(CollectionsKt.listOf((Object)VcsUserUtil.getShortPresentation(user)), MapsKt.emptyMap(), allUsers);
    }

    public static /* synthetic */ VcsLogUserFilter fromUser$default(VcsUser vcsUser, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.setOf((Object)vcsUser);
        }
        return VcsLogFilterObject.fromUser(vcsUser, set);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogUserFilter fromUserNames(@NotNull Collection<String> userNames, @NotNull Map<VirtualFile, ? extends VcsUser> meData, @NotNull Set<? extends VcsUser> allUsers) {
        Intrinsics.checkParameterIsNotNull(userNames, (String)"userNames");
        Intrinsics.checkParameterIsNotNull(meData, (String)"meData");
        Intrinsics.checkParameterIsNotNull(allUsers, (String)"allUsers");
        return new VcsLogUserFilterImpl(userNames, meData, allUsers);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogStructureFilter fromPaths(@NotNull Collection<? extends FilePath> files) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        return new VcsLogStructureFilterImpl(files);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final VcsLogStructureFilter fromVirtualFiles(@NotNull Collection<? extends VirtualFile> files) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Iterable $this$map$iv = files;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
            collection.add(filePath);
        }
        return VcsLogFilterObject.fromPaths((List)destination$iv$iv);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogRootFilter fromRoot(@NotNull VirtualFile root) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        return VcsLogFilterObject.fromRoots(CollectionsKt.listOf((Object)root));
    }

    @JvmStatic
    @NotNull
    public static final VcsLogRootFilter fromRoots(@NotNull Collection<? extends VirtualFile> roots) {
        Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
        return new VcsLogRootFilterImpl(roots);
    }

    @JvmStatic
    @NotNull
    public static final VcsLogFilterCollection collection(VcsLogFilter ... filters) {
        Intrinsics.checkParameterIsNotNull((Object)filters, (String)"filters");
        OpenTHashSet filterSet = VcsLogFiltersKt.access$createFilterSet();
        for (VcsLogFilter f : filters) {
            if (f == null || !VcsLogFiltersKt.access$replace(filterSet, f)) continue;
            VcsLogFiltersKt.access$getLOG$p().warn("Two filters with the same key " + f.getKey() + " in filter collection. Keeping only " + f + '.');
        }
        return new VcsLogFilterCollectionImpl((Collection)filterSet);
    }

    private VcsLogFilterObject() {
    }

    static {
        VcsLogFilterObject vcsLogFilterObject;
        INSTANCE = vcsLogFilterObject = new VcsLogFilterObject();
        EMPTY_COLLECTION = VcsLogFilterObject.collection(new VcsLogFilter[0]);
    }
}

