/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.CloudConfigBundle;
import com.intellij.cloudConfig.CloudConfigManager;
import com.intellij.cloudConfig.ConfigState;
import com.intellij.cloudConfig.PluginState;
import com.intellij.cloudConfig.StatusInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.ide.plugins.PluginsTableRenderer;
import com.intellij.idea.cloudConfig.CloudConfigClientUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.messages.TwoStepConfirmationDialog;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Consumer;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import icons.CloudConfigIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusBarInfoManager {
    private static final String ID = "CloudConfig";
    public static final StatusBarInfoManager EMPTY = new StatusBarInfoManager(){

        @Override
        public void update(boolean create) {
        }
    };
    private static final NotificationGroup GROUP = new NotificationGroup("JBA Cloud Config", NotificationDisplayType.STICKY_BALLOON, true);
    private static boolean myOldRegistryValue;

    public void update(boolean create) {
        WindowManager windowManager = WindowManager.getInstance();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            StatusBar statusBar = windowManager.getStatusBar(project);
            if (statusBar == null) {
                CloudConfigManager.LOG.info("=== StatusBar.update no status bar for project: " + project + " ===");
                continue;
            }
            StatusBarWidget widget = statusBar.getWidget(ID);
            if (widget instanceof InfoComponent) {
                ((InfoComponent)widget).update();
                continue;
            }
            if (create) {
                statusBar.addWidget((StatusBarWidget)new InfoComponent());
                CloudConfigManager.LOG.info("=== StatusBar.update create ===");
                continue;
            }
            CloudConfigManager.LOG.info("=== StatusBar.update another widget: " + widget + " ===");
        }
    }

    @NotNull
    private static AnAction[] getAnActions(@NotNull StatusBar statusBar) {
        StatusBarWidget widget;
        if (statusBar == null) {
            StatusBarInfoManager.$$$reportNull$$$0(0);
        }
        if ((widget = statusBar.getWidget(ID)) instanceof InfoComponent) {
            ((InfoComponent)widget).update();
        } else {
            widget = new InfoComponent();
            statusBar.addWidget(widget);
        }
        DefaultActionGroup actions = ((InfoComponent)widget).myActions;
        AnAction[] anActionArray = actions == null ? AnAction.EMPTY_ARRAY : actions.getChildren(null);
        if (anActionArray == null) {
            StatusBarInfoManager.$$$reportNull$$$0(1);
        }
        return anActionArray;
    }

    @NotNull
    public static String getActions(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            StatusBarInfoManager.$$$reportNull$$$0(2);
        }
        String string = StringUtil.join((Object[])StatusBarInfoManager.getAnActions(statusBar), action -> action instanceof Separator ? "----" : action.getTemplateText(), (String)"\n");
        if (string == null) {
            StatusBarInfoManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static void runAction(@NotNull StatusBar statusBar, @NotNull String name) {
        if (statusBar == null) {
            StatusBarInfoManager.$$$reportNull$$$0(4);
        }
        if (name == null) {
            StatusBarInfoManager.$$$reportNull$$$0(5);
        }
        for (AnAction action : StatusBarInfoManager.getAnActions(statusBar)) {
            if (!name.equals(action.getTemplateText())) continue;
            action.actionPerformed(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)DataContext.EMPTY_CONTEXT));
            return;
        }
    }

    private static boolean isConnected() {
        return CloudConfigManager.getInstance().getStatusInfo() == StatusInfo.JBA_CONNECTED;
    }

    private static void showOfflineMessage() {
        StatusBarInfoManager.offDialogsAsSheets();
        Messages.showInfoMessage((String)CloudConfigBundle.message("offline.dialog.message", new Object[0]), (String)CloudConfigBundle.message("offline.dialog.title", new Object[0]));
        StatusBarInfoManager.resetDialogsAsSheets();
    }

    private static void showUpdateApiDialog() {
        StatusBarInfoManager.offDialogsAsSheets();
        int exitCode = Messages.showOkCancelDialog((String)CloudConfigBundle.message("update.api.dialog.message", new Object[0]), (String)CloudConfigBundle.message("dialog.title", new Object[0]), (String)CloudConfigBundle.message("update.api.dialog.button", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getInformationIcon());
        StatusBarInfoManager.resetDialogsAsSheets();
        if (exitCode == 0) {
            CloudConfigManager.getInstance().doUpdateApi();
        }
    }

    private static Runnable showPopupMessage(@Nullable Project project) {
        return () -> {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar == null) {
                return;
            }
            JComponent component = ((IdeStatusBarImpl)statusBar).getWidgetComponent(ID);
            if (component == null) {
                return;
            }
            CloudConfigManager manager = CloudConfigManager.getInstance();
            String message = CloudConfigBundle.message(manager.getStatusInfo() == StatusInfo.JBA_IO_ERROR ? "error.connected.message" : (manager.hasPluginsUpdate() ? "update.plugins.message" : "connected.message"), new Object[0]);
            IdeTooltip tooltip = new IdeTooltip((Component)component, new Point(), (JComponent)new JLabel(message), new Object[0]);
            IdeTooltipManager.getInstance().show(tooltip, true, false);
        };
    }

    public static void showStartNotification() {
        Notification notification = new Notification(GROUP.getDisplayId(), CloudConfigBundle.message("accepted.title", new Object[0]), CloudConfigBundle.message("accepted.message", new Object[0]), NotificationType.INFORMATION);
        notification.setIcon(AllIcons.General.Settings);
        notification.addAction((AnAction)new NotificationAction(CloudConfigBundle.message("enable.cloud.action", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    2.$$$reportNull$$$0(1);
                }
                Project project = e.getProject();
                notification.expire();
                StatusBarInfoManager.connectInstance(project, StatusBarInfoManager.showPopupMessage(project));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/cloudConfig/StatusBarInfoManager$2";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.notify(null);
    }

    public static void showUpdateApiNotification() {
        Notification notification = new Notification(GROUP.getDisplayId(), CloudConfigBundle.message("dialog.title", new Object[0]), CloudConfigBundle.message("update.api.notification.message", new Object[0]), NotificationType.INFORMATION);
        notification.setIcon(AllIcons.General.Settings);
        notification.addAction((AnAction)new NotificationAction(CloudConfigBundle.message("update.api.action", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    3.$$$reportNull$$$0(1);
                }
                notification.expire();
                StatusBarInfoManager.showUpdateApiDialog();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/cloudConfig/StatusBarInfoManager$3";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        notification.notify(null);
    }

    public static void showErrorMessage(@Nullable String message) {
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            message = CloudConfigBundle.message("default.error.message", new Object[0]);
        }
        StatusBarInfoManager.showErrorMessage(message, CloudConfigBundle.message("error.message.title", new Object[0]));
    }

    private static void showErrorMessage(@NotNull String message, @NotNull String title) {
        if (message == null) {
            StatusBarInfoManager.$$$reportNull$$$0(6);
        }
        if (title == null) {
            StatusBarInfoManager.$$$reportNull$$$0(7);
        }
        StatusBarInfoManager.offDialogsAsSheets();
        Messages.showErrorDialog((String)message, (String)title);
        StatusBarInfoManager.resetDialogsAsSheets();
    }

    private static void connectInstance(@Nullable Project project, @NotNull Runnable successRun) {
        block6: {
            int result;
            boolean[] autoUpdatePlugins;
            if (successRun == null) {
                StatusBarInfoManager.$$$reportNull$$$0(8);
            }
            CloudConfigManager manager = CloudConfigManager.getInstance();
            manager.recalculateInitStatus(project);
            while (true) {
                if (manager.getStatusInfo() == StatusInfo.JBA_NOT_CONNECTED) {
                    Boolean result2 = MyMessages.showDialog("connect.message", "connect.button", "connect.plugins.auto", null);
                    if (result2 != null) {
                        manager.recalculateInitStatus(project);
                        if (manager.getStatusInfo() != StatusInfo.JBA_NOT_CONNECTED) continue;
                        manager.setAutoUpdatePlugins(result2);
                        manager.connectFirstInstance(false, successRun);
                    }
                    break block6;
                }
                autoUpdatePlugins = new boolean[1];
                result = MyMessages.showCheckboxDialog(CloudConfigBundle.message("connect.this.message", StatusBarInfoManager.getUserLogin()), new String[]{CloudConfigBundle.message("connect.this.remote.button", new Object[0]), CloudConfigBundle.message("connect.this.local.button", new Object[0]), Messages.getCancelButton()}, CloudConfigBundle.message("connect.plugins.auto", new Object[0]), (PairFunction<Integer, JCheckBox, Integer>)((PairFunction)(exitCode, checkBox) -> {
                    autoUpdatePlugins[0] = checkBox.isSelected();
                    return exitCode;
                }), null);
                if (result != 0 && result != 1) break block6;
                manager.recalculateInitStatus(project);
                if (manager.getStatusInfo() != StatusInfo.JBA_NOT_CONNECTED) break;
            }
            manager.setAutoUpdatePlugins(autoUpdatePlugins[0]);
            if (result == 0) {
                manager.connectThisInstance(true, false, successRun);
            } else {
                manager.connectFirstInstance(true, successRun);
            }
        }
    }

    private static void offDialogsAsSheets() {
        if (SystemInfo.isMac) {
            RegistryValue value = Registry.get((String)"ide.mac.message.dialogs.as.sheets");
            myOldRegistryValue = value.asBoolean();
            value.setValue(false);
        }
    }

    private static void resetDialogsAsSheets() {
        if (SystemInfo.isMac) {
            Registry.get((String)"ide.mac.message.dialogs.as.sheets").setValue(myOldRegistryValue);
        }
    }

    private static void showLoginDialog() {
        CloudConfigClientUtil.showLoginDialog((boolean)CloudConfigManager.getInstance().isLocalConnected(), () -> CloudConfigManager.getInstance().updateClient(), (Logger)CloudConfigManager.LOG);
    }

    @NotNull
    private static String getUserLogin() {
        String string = StringUtil.defaultIfEmpty((String)CloudConfigClientUtil.getUserLogin(), (String)"User from Toolbox App");
        if (string == null) {
            StatusBarInfoManager.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cloudConfig/StatusBarInfoManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successRun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserLogin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnActions";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showErrorMessage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "connectInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EditPluginState {
        private final PluginState myState;
        private PluginState.Operation myOperation;

        EditPluginState(@NotNull PluginState state) {
            if (state == null) {
                EditPluginState.$$$reportNull$$$0(0);
            }
            this.myOperation = PluginState.Operation.Auto;
            this.myState = state;
            if (state.skip) {
                this.myOperation = state.local ? PluginState.Operation.SkipLocally : PluginState.Operation.SkipEverywhere;
            }
        }

        private EditPluginState(@NotNull PluginState.Operation operation) {
            if (operation == null) {
                EditPluginState.$$$reportNull$$$0(1);
            }
            this.myOperation = PluginState.Operation.Auto;
            this.myState = null;
            this.myOperation = operation;
        }

        public static EditPluginState @NotNull [] getStates() {
            PluginState.Operation[] values = PluginState.Operation.values();
            EditPluginState[] states = new EditPluginState[values.length];
            int length = values.length;
            for (int i = 0; i < length; ++i) {
                states[i] = new EditPluginState(values[i]);
            }
            if (states == null) {
                EditPluginState.$$$reportNull$$$0(2);
            }
            return states;
        }

        @NotNull
        public String getPluginStatus() {
            switch (this.myState.type) {
                case Install: {
                    return "Not Installed";
                }
                case Uninstall: {
                    return "Installed";
                }
                case Disable: {
                    return "Enabled";
                }
            }
            return "Disabled";
        }

        @NotNull
        public String getOperationName(PluginState.Operation operation) {
            switch (operation) {
                case Revert: {
                    return this.getRevertName();
                }
                case SkipEverywhere: {
                    return "Skip Everywhere";
                }
                case SkipLocally: {
                    return "Skip";
                }
            }
            String string = this.myState.type.name();
            if (string == null) {
                EditPluginState.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        private String getRevertName() {
            switch (this.myState.type) {
                case Install: {
                    return "Uninstall Everywhere";
                }
                case Uninstall: {
                    return "Install Everywhere";
                }
                case Disable: {
                    return "Enable Everywhere";
                }
            }
            return "Disable Everywhere";
        }

        @Nullable
        public PluginState.Operation getOperation() {
            if (this.myState.skip && (this.myState.local ? this.myOperation == PluginState.Operation.SkipLocally : this.myOperation == PluginState.Operation.SkipEverywhere)) {
                return null;
            }
            return this.myOperation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EditPluginState)) {
                return false;
            }
            EditPluginState state = (EditPluginState)o;
            return this.myOperation == state.myOperation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/cloudConfig/StatusBarInfoManager$EditPluginState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$EditPluginState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStates";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOperationName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PluginModel
    extends PluginTableModel {
        final Map<IdeaPluginDescriptor, EditPluginState> myStates = new HashMap<IdeaPluginDescriptor, EditPluginState>();
        Runnable myOkHandler;

        PluginModel() {
            this.columns = new ColumnInfo[]{new PluginManagerColumnInfo(0){

                public TableCellRenderer getRenderer(IdeaPluginDescriptor descriptor) {
                    return descriptor == null ? null : new PluginsTableRenderer(descriptor, false){
                        {
                            super(x0, x1);
                            this.myName.setFont(UIUtil.getLabelFont());
                        }

                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                            this.myName.append(" ").append(myStates.get(this.myPluginDescriptor).getPluginStatus(), isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES);
                            ((JComponent)component).setToolTipText(null);
                            this.myName.setForeground((Color)UIUtil.getCellColors((JTable)table, (boolean)isSelected, (int)row, (int)column).getFirst());
                            return component;
                        }
                    };
                }
            }, new ColumnInfo<IdeaPluginDescriptor, EditPluginState>(""){

                @Nullable
                public EditPluginState valueOf(IdeaPluginDescriptor descriptor) {
                    return descriptor == null ? null : myStates.get(descriptor);
                }

                public boolean isCellEditable(IdeaPluginDescriptor descriptor) {
                    return true;
                }

                @Nullable
                public TableCellRenderer getRenderer(IdeaPluginDescriptor descriptor) {
                    return descriptor == null ? null : new ComboBoxTableRenderer<EditPluginState>(null){

                        protected String getTextFor(@NotNull EditPluginState value) {
                            if (value == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return value.getOperationName(value.myOperation);
                        }

                        protected void customizeComponent(EditPluginState value, JTable table, boolean isSelected) {
                            super.customizeComponent((Object)value, table, isSelected);
                            if (!isSelected && value.getOperation() == null) {
                                this.setForeground(SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor());
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/cloudConfig/StatusBarInfoManager$PluginModel$2$1", "getTextFor"));
                        }
                    };
                }

                public TableCellEditor getEditor(IdeaPluginDescriptor descriptor) {
                    return new ComboBoxTableRenderer<EditPluginState>(EditPluginState.getStates()){
                        private EditPluginState myValue;

                        public boolean isCellEditable(EventObject event) {
                            if (event instanceof MouseEvent) {
                                return ((MouseEvent)event).getClickCount() >= 1;
                            }
                            return false;
                        }

                        protected String getTextFor(@NotNull EditPluginState value) {
                            if (value == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            return this.myValue.getOperationName(value.myOperation);
                        }

                        protected ListSeparator getSeparatorAbove(EditPluginState value) {
                            return value.myOperation == PluginState.Operation.SkipLocally ? new ListSeparator() : null;
                        }

                        protected void customizeComponent(EditPluginState value, JTable table, boolean isSelected) {
                            this.myValue = value;
                            super.customizeComponent((Object)value, table, isSelected);
                            if (value.getOperation() == null) {
                                this.setForeground(SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor());
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/cloudConfig/StatusBarInfoManager$PluginModel$2$2", "getTextFor"));
                        }
                    };
                }

                public void setValue(IdeaPluginDescriptor descriptor, EditPluginState value) {
                    myStates.get(descriptor).myOperation = value.myOperation;
                    myOkHandler.run();
                }
            }};
            CloudConfigManager manager = CloudConfigManager.getInstance();
            this.addItems(manager.getInstalledUninstalledPlugins());
            this.addItems(manager.getEnabledDisabledPlugins());
        }

        public void setOkButton(@NotNull Action okButton) {
            if (okButton == null) {
                PluginModel.$$$reportNull$$$0(0);
            }
            this.myOkHandler = () -> {
                boolean result = false;
                for (EditPluginState renderer : this.myStates.values()) {
                    if (renderer.getOperation() == null) continue;
                    result = true;
                    break;
                }
                okButton.setEnabled(result);
            };
            this.myOkHandler.run();
        }

        private void addItems(@NotNull List<PluginState> states) {
            if (states == null) {
                PluginModel.$$$reportNull$$$0(1);
            }
            for (PluginState state : states) {
                if (this.myStates.containsKey(state.plugin)) continue;
                this.view.add(state.plugin);
                this.myStates.put(state.plugin, new EditPluginState(state));
            }
        }

        public int getNameColumn() {
            return 0;
        }

        public boolean isSortable() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "okButton";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "states";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$PluginModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setOkButton";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addItems";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyMessages
    extends Messages {
        private MyMessages() {
        }

        public static int showCheckboxDialog(String message, String @NotNull [] options, String checkboxText, @Nullable PairFunction<Integer, JCheckBox, Integer> exitFunc, final @Nullable Computable<JCheckBox> secondCheckboxProvider) {
            if (options == null) {
                MyMessages.$$$reportNull$$$0(0);
            }
            StatusBarInfoManager.offDialogsAsSheets();
            TwoStepConfirmationDialog dialog = new TwoStepConfirmationDialog(message, CloudConfigBundle.message("dialog.title", new Object[0]), options, checkboxText, false, 0, 0, Messages.getInformationIcon(), exitFunc){

                protected JComponent createSouthPanel() {
                    this.setButtonsAlignment(4);
                    return super.createSouthPanel();
                }

                @NotNull
                protected JPanel createButtonsPanel(@NotNull List<? extends JButton> buttons) {
                    if (buttons == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    NonOpaquePanel panel = new NonOpaquePanel();
                    for (JButton jButton : buttons) {
                        panel.add(jButton);
                    }
                    panel.setLayout(new LayoutManager(){
                        final int hgap = SystemInfo.isMacOSLeopard ? (UIUtil.isUnderIntelliJLaF() ? 8 : 0) : 5;

                        @Override
                        public void addLayoutComponent(String name, Component comp) {
                        }

                        @Override
                        public void removeLayoutComponent(Component comp) {
                        }

                        @Override
                        public Dimension minimumLayoutSize(Container parent) {
                            return this.preferredLayoutSize(parent);
                        }

                        @Override
                        public Dimension preferredLayoutSize(Container parent) {
                            Insets insets = parent.getInsets();
                            int components = parent.getComponentCount() - 1;
                            Dimension size = this.calculateSize(parent);
                            int lastWidth = parent.getComponent((int)components).getPreferredSize().width + JBUIScale.scale((int)50);
                            return new Dimension(insets.left + insets.right + components * size.width + lastWidth + components * this.hgap, insets.top + insets.bottom + size.height);
                        }

                        @NotNull
                        private Dimension calculateSize(@NotNull Container parent) {
                            if (parent == null) {
                                MyMessages.1.$$$reportNull$$$0(0);
                            }
                            int components = parent.getComponentCount();
                            Dimension size = new Dimension();
                            for (int i = 0; i < components; ++i) {
                                Component component = parent.getComponent(i);
                                Dimension d = component.getPreferredSize();
                                if (size.width < d.width) {
                                    size.width = d.width;
                                }
                                if (size.height >= d.height) continue;
                                size.height = d.height;
                            }
                            Dimension dimension = size;
                            if (dimension == null) {
                                MyMessages.1.$$$reportNull$$$0(1);
                            }
                            return dimension;
                        }

                        @Override
                        public void layoutContainer(Container parent) {
                            Insets insets = parent.getInsets();
                            Dimension size = this.calculateSize(parent);
                            int index = parent.getComponentCount() - 1;
                            Component lastButton = parent.getComponent(index--);
                            int lastWidth = lastButton.getPreferredSize().width;
                            int x = parent.getWidth() - insets.right - lastWidth;
                            int y = insets.top;
                            lastButton.setBounds(x, y, lastWidth, size.height);
                            while (index >= 0) {
                                parent.getComponent(index--).setBounds(x -= this.hgap + size.width, y, size.width, size.height);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 1: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 3;
                                    break;
                                }
                                case 1: {
                                    n2 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "parent";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$1$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$1$1";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "calculateSize";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "calculateSize";
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 1: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    });
                    NonOpaquePanel nonOpaquePanel = panel;
                    if (nonOpaquePanel == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return nonOpaquePanel;
                }

                protected JComponent createNorthPanel() {
                    if (SystemInfo.isMac && !this.myMessage.contains("\n")) {
                        JPanel panel = this.createIconPanel();
                        JPanel messagePanel = new JPanel((LayoutManager)new VerticalLayout(JBUIScale.scale((int)12)));
                        messagePanel.add(new JLabel(this.myMessage));
                        messagePanel.add(this.createCheckComponent());
                        panel.add((Component)messagePanel, "Center");
                        return panel;
                    }
                    return super.createNorthPanel();
                }

                @NotNull
                protected JComponent createCheckComponent() {
                    JComponent component = super.createCheckComponent();
                    this.applyCheckboxBorder(component);
                    if (secondCheckboxProvider != null) {
                        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(SystemInfo.isWindows ? 0 : JBUIScale.scale((int)12)));
                        panel.add(component);
                        JCheckBox checkBox = (JCheckBox)secondCheckboxProvider.compute();
                        this.applyCheckboxBorder(checkBox);
                        panel.add(checkBox);
                        JPanel jPanel = panel;
                        if (jPanel == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return jPanel;
                    }
                    JComponent jComponent = component;
                    if (jComponent == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return jComponent;
                }

                private void applyCheckboxBorder(@NotNull JComponent component) {
                    if (component == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (SystemInfo.isWindows) {
                        int top = JBUIScale.scale((int)7);
                        int bottom = StartupUiUtil.isUnderDarcula() ? 0 : top;
                        component.setBorder(BorderFactory.createEmptyBorder(top, 0, bottom, 0));
                    } else if (SystemInfo.isMac && this.myMessage.contains("\n")) {
                        int offset = JBUIScale.scale((int)(StartupUiUtil.isUnderDarcula() ? 6 : 7));
                        component.setBorder(BorderFactory.createEmptyBorder(offset, 0, offset, 0));
                    } else if (SystemInfo.isLinux) {
                        component.setBorder(BorderFactory.createEmptyBorder(JBUIScale.scale((int)7), 0, 0, 0));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "buttons";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$1";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "component";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createButtonsPanel";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createCheckComponent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createButtonsPanel";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            break;
                        }
                        case 4: {
                            objectArray = objectArray;
                            objectArray[2] = "applyCheckboxBorder";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            dialog.show();
            StatusBarInfoManager.resetDialogsAsSheets();
            return dialog.getExitCode();
        }

        @Nullable
        public static Boolean showDialog(@NotNull String messageKey, @NotNull String okButtonKey, @NotNull String checkBoxKey, @Nullable Computable<JCheckBox> secondCheckbox) {
            int result;
            if (messageKey == null) {
                MyMessages.$$$reportNull$$$0(1);
            }
            if (okButtonKey == null) {
                MyMessages.$$$reportNull$$$0(2);
            }
            if (checkBoxKey == null) {
                MyMessages.$$$reportNull$$$0(3);
            }
            return (result = MyMessages.showCheckboxDialog(CloudConfigBundle.message(messageKey, new Object[0]), new String[]{CloudConfigBundle.message(okButtonKey, new Object[0]), MyMessages.getCancelButton()}, CloudConfigBundle.message(checkBoxKey, new Object[0]), (PairFunction<Integer, JCheckBox, Integer>)((PairFunction)(exitCode, checkBox) -> exitCode == 0 ? (checkBox.isSelected() ? 0 : 1) : 2), secondCheckbox)) == 2 ? null : Boolean.valueOf(result == 0);
        }

        public static void showSelfSettingsDialog() {
            final SelfConfigsModel model = new SelfConfigsModel();
            StatusBarInfoManager.offDialogsAsSheets();
            TwoStepConfirmationDialog dialog = new TwoStepConfirmationDialog(CloudConfigBundle.message("self.settings.dialog.message", new Object[0]), CloudConfigBundle.message("self.settings.dialog.title", new Object[0]), new String[]{CloudConfigBundle.message("plugins.dialog.button", new Object[0]), MyMessages.getCancelButton()}, null, false, 0, 0, null, (exitCode, checkBox) -> exitCode){
                JBTable myTable;

                protected String getDimensionServiceKey() {
                    return "cloudConfig.SelfSettingsDialog";
                }

                protected JComponent createNorthPanel() {
                    return null;
                }

                protected JComponent createCenterPanel() {
                    JPanel messagePanel = this.createMessagePanel();
                    messagePanel.add(this.createCheckComponent());
                    return messagePanel;
                }

                @NotNull
                protected JComponent createCheckComponent() {
                    this.setButtonsAlignment(4);
                    this.myTable = new JBTable(model){

                        public TableCellRenderer getCellRenderer(int row, int column) {
                            return model.getRenderer(column);
                        }
                    };
                    this.myTable.setSelectionMode(0);
                    this.myTable.setShowGrid(false);
                    this.myTable.setTableHeader(null);
                    TableColumnModel columnModel = this.myTable.getColumnModel();
                    columnModel.setColumnMargin(0);
                    JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
                    int width = this.myTable.getPreferredScrollableViewportSize().width;
                    pane.setPreferredSize(new Dimension(width, JBUIScale.scale((int)200)));
                    int size = columnModel.getColumnCount();
                    for (int i = 0; i < size; ++i) {
                        columnModel.getColumn(i).setCellEditor(model.getEditor(i));
                    }
                    TableColumn column1 = columnModel.getColumn(1);
                    int columnWidth = JBUIScale.scale((int)150);
                    column1.setMinWidth(columnWidth);
                    column1.setMaxWidth(columnWidth);
                    JScrollPane jScrollPane = pane;
                    if (jScrollPane == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return jScrollPane;
                }

                public JComponent getPreferredFocusedComponent() {
                    return this.myTable;
                }

                protected Action @NotNull [] createActions() {
                    Action[] actions = super.createActions();
                    model.setOkButton(actions[0]);
                    if (actions == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return actions;
                }

                protected String getHelpId() {
                    return "cloud-config.self-settings-dialog";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createCheckComponent";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createActions";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            dialog.show();
            StatusBarInfoManager.resetDialogsAsSheets();
            if (dialog.getExitCode() == 0) {
                ArrayList<Pair<ConfigState, ConfigState.Type>> newStates = new ArrayList<Pair<ConfigState, ConfigState.Type>>();
                for (EditConfigState state : model.myStates) {
                    if (!state.isModified()) continue;
                    state.getResult(newStates);
                }
                CloudConfigManager.getInstance().editStates(newStates);
            }
        }

        private static void customizeColor(@NotNull JComponent component, @NotNull ConfigState.Type value, boolean isSelected) {
            if (component == null) {
                MyMessages.$$$reportNull$$$0(4);
            }
            if (value == null) {
                MyMessages.$$$reportNull$$$0(5);
            }
            if (!isSelected && value != ConfigState.Type.Enable) {
                component.setForeground(SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor());
            }
        }

        public static void showPluginsDialog() {
            final PluginModel pluginModel = new PluginModel();
            StatusBarInfoManager.offDialogsAsSheets();
            TwoStepConfirmationDialog dialog = new TwoStepConfirmationDialog(CloudConfigBundle.message("plugins.dialog.message", new Object[0]), CloudConfigBundle.message("plugins.dialog.title", new Object[0]), new String[]{CloudConfigBundle.message("plugins.dialog.button", new Object[0]), MyMessages.getCancelButton()}, null, false, 0, 0, null, (exitCode, checkBox) -> exitCode){
                PluginTable myTable;

                protected String getDimensionServiceKey() {
                    return "cloudConfig.PluginsDialog";
                }

                protected JComponent createNorthPanel() {
                    return null;
                }

                protected JComponent createCenterPanel() {
                    JPanel messagePanel = this.createMessagePanel();
                    messagePanel.add(this.createCheckComponent());
                    return messagePanel;
                }

                @NotNull
                protected JComponent createCheckComponent() {
                    this.setButtonsAlignment(4);
                    this.myTable = new PluginTable((PluginTableModel)pluginModel);
                    JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
                    int width = this.myTable.getPreferredScrollableViewportSize().width;
                    pane.setPreferredSize(new Dimension(width, JBUIScale.scale((int)200)));
                    this.myTable.setColumnWidth(1, JBUIScale.scale((int)150));
                    JScrollPane jScrollPane = pane;
                    if (jScrollPane == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return jScrollPane;
                }

                public JComponent getPreferredFocusedComponent() {
                    return this.myTable;
                }

                protected Action @NotNull [] createActions() {
                    Action[] actions = super.createActions();
                    pluginModel.setOkButton(actions[0]);
                    if (actions == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return actions;
                }

                protected String getHelpId() {
                    return "cloud-config.plugin-dialog";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createCheckComponent";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createActions";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
            dialog.show();
            StatusBarInfoManager.resetDialogsAsSheets();
            if (dialog.getExitCode() == 0) {
                CloudConfigManager.getInstance().executePlugins(pluginModel.myStates.values().stream().filter(editState -> editState.getOperation() != null).map(editState -> Pair.create((Object)((EditPluginState)editState).myState, (Object)((Object)editState.getOperation()))).collect(Collectors.toList()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messageKey";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "okButtonKey";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "checkBoxKey";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showCheckboxDialog";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showDialog";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeColor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class EditConfigState {
            public ConfigState state;
            public ConfigState.Type type;
            private List<ConfigState> myChildStates;

            private EditConfigState(@NotNull ConfigState state) {
                if (state == null) {
                    EditConfigState.$$$reportNull$$$0(0);
                }
                this.state = state;
                this.type = state.type;
            }

            public boolean isModified() {
                return this.type != this.state.type;
            }

            public void addChild(@NotNull ConfigState childState) {
                if (childState == null) {
                    EditConfigState.$$$reportNull$$$0(1);
                }
                assert (this.type == childState.type);
                if (this.myChildStates == null) {
                    this.myChildStates = new ArrayList<ConfigState>();
                }
                this.myChildStates.add(childState);
            }

            public void getResult(@NotNull List<Pair<ConfigState, ConfigState.Type>> newStates) {
                if (newStates == null) {
                    EditConfigState.$$$reportNull$$$0(2);
                }
                newStates.add((Pair<ConfigState, ConfigState.Type>)Pair.create((Object)this.state, (Object)((Object)this.type)));
                if (this.myChildStates != null) {
                    for (ConfigState childState : this.myChildStates) {
                        newStates.add((Pair<ConfigState, ConfigState.Type>)Pair.create((Object)childState, (Object)((Object)this.type)));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "childState";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newStates";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$EditConfigState";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addChild";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getResult";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class SelfConfigsModel
        extends AbstractTableModel {
            final List<EditConfigState> myStates = new ArrayList<EditConfigState>();
            Runnable myOkHandler;

            private SelfConfigsModel() {
                HashMap<String, EditConfigState> titleToState = new HashMap<String, EditConfigState>();
                for (ConfigState setting : CloudConfigManager.getInstance().getSelfSettings()) {
                    String title = setting.info.description;
                    EditConfigState state = (EditConfigState)titleToState.get(title);
                    if (state == null) {
                        state = new EditConfigState(setting);
                        this.myStates.add(state);
                        titleToState.put(title, state);
                        continue;
                    }
                    state.addChild(setting);
                }
            }

            @Override
            public int getRowCount() {
                return this.myStates.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @NotNull
            public TableCellRenderer getRenderer(int column) {
                return column == 0 ? new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        MyMessages.customizeColor(this, myStates.get((int)row).type, isSelected);
                        return this;
                    }
                } : new ComboBoxTableRenderer<ConfigState.Type>(null){

                    protected void customizeComponent(ConfigState.Type value, JTable table, boolean isSelected) {
                        super.customizeComponent((Object)value, table, isSelected);
                        MyMessages.customizeColor((JComponent)((Object)this), value, isSelected);
                    }

                    protected String getTextFor(@NotNull ConfigState.Type value) {
                        if (value == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return value.getText();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$SelfConfigsModel$2", "getTextFor"));
                    }
                };
            }

            @Nullable
            public TableCellEditor getEditor(int column) {
                return column == 0 ? null : new ComboBoxTableRenderer<ConfigState.Type>(ConfigState.Type.values()){

                    public boolean isCellEditable(EventObject event) {
                        if (event instanceof MouseEvent) {
                            return ((MouseEvent)event).getClickCount() >= 1;
                        }
                        return false;
                    }

                    protected boolean isApplicable(ConfigState.Type value, int row) {
                        if (value == ConfigState.Type.DisableLocally) {
                            return myStates.get((int)row).state.type != ConfigState.Type.Disable;
                        }
                        return true;
                    }

                    protected String getTextFor(@NotNull ConfigState.Type value) {
                        if (value == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return value.getText();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$SelfConfigsModel$3", "getTextFor"));
                    }
                };
            }

            @Override
            public Object getValueAt(int row, int column) {
                EditConfigState state = this.myStates.get(row);
                return column == 0 ? state.state.info.description : state.type;
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                this.myStates.get((int)row).type = (ConfigState.Type)((Object)value);
                this.myOkHandler.run();
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }

            public void setOkButton(@NotNull Action okButton) {
                if (okButton == null) {
                    SelfConfigsModel.$$$reportNull$$$0(0);
                }
                this.myOkHandler = () -> {
                    boolean modified = false;
                    boolean enabled = false;
                    for (EditConfigState state : this.myStates) {
                        if (state.isModified()) {
                            modified = true;
                        }
                        if (state.type == ConfigState.Type.Enable) {
                            enabled = true;
                        }
                        if (!modified || !enabled) continue;
                        break;
                    }
                    okButton.setEnabled(modified && enabled);
                };
                this.myOkHandler.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "okButton", "com/intellij/cloudConfig/StatusBarInfoManager$MyMessages$SelfConfigsModel", "setOkButton"));
            }
        }
    }

    private static class InfoComponent
    implements StatusBarWidget,
    StatusBarWidget.IconPresentation,
    DumbAware {
        private StatusBar myStatusBar;
        private Icon myIcon = EmptyIcon.ICON_16;
        private String myTooltip;
        private DefaultActionGroup myActions;
        private String myPopupTitle;
        private String myPopupBottomTitle;

        private InfoComponent() {
        }

        public void install(@NotNull StatusBar statusBar) {
            if (statusBar == null) {
                InfoComponent.$$$reportNull$$$0(0);
            }
            this.myStatusBar = statusBar;
            this.update();
        }

        public void update() {
            this.myActions = null;
            this.myTooltip = null;
            this.myPopupBottomTitle = null;
            this.myPopupTitle = null;
            CloudConfigManager manager = CloudConfigManager.getInstance();
            switch (manager.getStatusInfo()) {
                case JBA_NOT_FOUND: {
                    if (manager.isLocalConnected()) {
                        this.myIcon = CloudConfigIcons.Not_connected;
                        this.myTooltip = CloudConfigBundle.message("login.message", new Object[0]);
                        break;
                    }
                }
                case OFFLINE: {
                    if (manager.isOfflineWithJBA()) {
                        this.myIcon = CloudConfigIcons.Not_connected;
                        this.myTooltip = CloudConfigBundle.message("offline.message", new Object[0]);
                        break;
                    }
                }
                case DISABLED: {
                    this.myStatusBar.removeWidget(StatusBarInfoManager.ID);
                    return;
                }
                case JBA_IO_ERROR: {
                    this.myIcon = CloudConfigIcons.Io_error;
                    if (manager.getErrorMessage() == null) {
                        this.myTooltip = CloudConfigBundle.message("error.connected.message", new Object[0]);
                        break;
                    }
                    if ("401".equals(manager.getErrorMessage())) {
                        this.myTooltip = CloudConfigBundle.message("error.401.message", new Object[0]);
                        break;
                    }
                    this.myTooltip = CloudConfigBundle.message("error.connected.full.message", manager.getErrorMessage());
                    break;
                }
                case JBA_NOT_ACCEPTED: {
                    this.myIcon = CloudConfigIcons.Not_connected;
                    this.myTooltip = CloudConfigBundle.message("not.accepted.message", new Object[0]);
                    this.createNotAcceptedActions();
                    break;
                }
                case JBA_IO_OPERATION: {
                    this.myIcon = CloudConfigIcons.Io_operation;
                    this.myTooltip = CloudConfigBundle.message("io.operation.message", new Object[0]);
                    break;
                }
                case JBA_NOT_CONNECTED: 
                case JBA_THIS_NOT_CONNECTED: {
                    this.myIcon = CloudConfigIcons.Not_connected;
                    this.myTooltip = CloudConfigBundle.message("not.connected.message", new Object[0]);
                    this.createNotConnectedActions();
                    break;
                }
                case JBA_CONNECTED: {
                    if (manager.hasPluginsUpdate() || manager.hasUpdateApi()) {
                        this.myIcon = CloudConfigIcons.Update;
                        this.myTooltip = CloudConfigBundle.message(manager.hasUpdateApi() ? "update.api.message" : "update.plugins.message", new Object[0]);
                    } else {
                        this.myIcon = CloudConfigIcons.Connected;
                        this.myTooltip = CloudConfigBundle.message("connected.message", new Object[0]);
                    }
                    this.createConnectedActions();
                }
            }
            this.myStatusBar.updateWidget(StatusBarInfoManager.ID);
        }

        private void createNotConnectedActions() {
            this.myActions = new DefaultActionGroup();
            this.myPopupTitle = CloudConfigBundle.message("not.connected.popup.title", new Object[0]);
            this.myActions.addAction((AnAction)new DumbAwareAction(CloudConfigBundle.message("enable.cloud.action", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    StatusBarInfoManager.connectInstance(e.getProject(), EmptyRunnable.INSTANCE);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cloudConfig/StatusBarInfoManager$InfoComponent$1", "actionPerformed"));
                }
            });
            this.myActions.addSeparator();
            this.myActions.addAction((AnAction)new DumbAwareAction(CloudConfigBundle.message("change.account.action", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    StatusBarInfoManager.showLoginDialog();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cloudConfig/StatusBarInfoManager$InfoComponent$2", "actionPerformed"));
                }
            });
            this.createHideAction();
        }

        private void createHideAction() {
            this.myActions.addSeparator();
            this.myActions.addAction((AnAction)new DumbAwareAction(CloudConfigBundle.message("hide.cloud.action", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    CloudConfigManager.getInstance().disable();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cloudConfig/StatusBarInfoManager$InfoComponent$3", "actionPerformed"));
                }
            });
        }

        private void createConnectedActions() {
            this.myActions = new DefaultActionGroup();
            this.myPopupBottomTitle = CloudConfigBundle.message("connected.popup.bottom.title", StatusBarInfoManager.getUserLogin());
            CloudConfigManager manager = CloudConfigManager.getInstance();
            this.myPopupTitle = CloudConfigBundle.message(manager.hasPluginsUpdate() ? "plugins.popup.title" : "connected.popup.title", new Object[0]);
            if (manager.hasUpdateApi()) {
                this.myActions.add((AnAction)new MyUpdateApiAction());
            }
            this.myActions.addAction((AnAction)new MySelfSettingsAction());
            if (manager.hasPluginsUpdate() || manager.hasPluginsAnyUpdate()) {
                this.myActions.addAction((AnAction)new MyPluginsAction());
            }
            this.myActions.add((AnAction)new MyToggleAction());
            this.myActions.addSeparator();
            this.myActions.addAction((AnAction)new MyDisableAction());
        }

        private void createNotAcceptedActions() {
            this.myActions = new DefaultActionGroup();
            this.myPopupTitle = CloudConfigBundle.message("not.connected.popup.title", new Object[0]);
            this.createHideAction();
        }

        public void dispose() {
            this.myStatusBar = null;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                InfoComponent.$$$reportNull$$$0(1);
            }
            return icon;
        }

        @Nullable
        public String getTooltipText() {
            return this.myTooltip;
        }

        @Nullable
        public Consumer<MouseEvent> getClickConsumer() {
            return event -> {
                CloudConfigManager manager = CloudConfigManager.getInstance();
                StatusInfo state = manager.getStatusInfo();
                if (this.myActions == null) {
                    if (state == StatusInfo.JBA_IO_ERROR) {
                        if ("401".equals(manager.getErrorMessage())) {
                            StatusBarInfoManager.showLoginDialog();
                        } else {
                            manager.updateIO(StatusBarInfoManager.showPopupMessage(this.myStatusBar.getProject()));
                        }
                    } else if (state == StatusInfo.OFFLINE) {
                        StatusBarInfoManager.showOfflineMessage();
                    } else if (state == StatusInfo.JBA_NOT_FOUND) {
                        StatusBarInfoManager.showLoginDialog();
                    }
                } else {
                    final Component component = event.getComponent();
                    final ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("  " + this.myPopupTitle + "  ", (ActionGroup)this.myActions, DataManager.getInstance().getDataContext(component), false, null, this.myActions.getChildrenCount());
                    if (this.myPopupBottomTitle != null) {
                        popup.setAdText(this.myPopupBottomTitle, 0);
                    }
                    popup.addListener(new JBPopupListener(){
                        String myIconTooltip;

                        public void beforeShown(@NotNull LightweightWindowEvent event) {
                            if (event == null) {
                                4.$$$reportNull$$$0(0);
                            }
                            this.myIconTooltip = myTooltip;
                            myTooltip = null;
                            Point location = component.getLocationOnScreen();
                            Dimension size = popup.getSize();
                            popup.setLocation(new Point(location.x + component.getWidth() - size.width, location.y - size.height));
                        }

                        public void onClosed(@NotNull LightweightWindowEvent event) {
                            if (event == null) {
                                4.$$$reportNull$$$0(1);
                            }
                            myTooltip = this.myIconTooltip;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            objectArray2[0] = "event";
                            objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$InfoComponent$4";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "beforeShown";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "onClosed";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                    popup.show(component);
                }
            };
        }

        @Nullable
        public StatusBarWidget.WidgetPresentation getPresentation() {
            return this;
        }

        @NotNull
        public String ID() {
            return StatusBarInfoManager.ID;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statusBar";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/cloudConfig/StatusBarInfoManager$InfoComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$InfoComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "install";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MyUpdateApiAction
    extends DumbAwareAction {
        public MyUpdateApiAction() {
            super(CloudConfigBundle.messagePointer("update.api.action", new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyUpdateApiAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabledAndVisible(StatusBarInfoManager.isConnected() && CloudConfigManager.getInstance().hasUpdateApi());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyUpdateApiAction.$$$reportNull$$$0(1);
            }
            StatusBarInfoManager.showUpdateApiDialog();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$MyUpdateApiAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyDisableAction
    extends DumbAwareAction {
        public MyDisableAction() {
            super(CloudConfigBundle.messagePointer("disable.cloud.action", new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyDisableAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabledAndVisible(StatusBarInfoManager.isConnected());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JCheckBox copySettingsBack;
            Boolean result;
            if (e == null) {
                MyDisableAction.$$$reportNull$$$0(1);
            }
            if ((result = MyMessages.showDialog("disconnect.message", "disconnect.button", "disconnect.remove.data", (Computable<JCheckBox>)((Computable)() -> MyDisableAction.lambda$actionPerformed$0(copySettingsBack = new JCheckBox(CloudConfigBundle.message("disconnect.copy.data", new Object[0])))))) != null) {
                CloudConfigManager.getInstance().disconnect(result, copySettingsBack.isSelected());
            }
        }

        private static /* synthetic */ JCheckBox lambda$actionPerformed$0(JCheckBox copySettingsBack) {
            return copySettingsBack;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$MyDisableAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MyPluginsAction
    extends DumbAwareAction {
        public MyPluginsAction() {
            super(CloudConfigBundle.messagePointer("update.plugins.action", new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyPluginsAction.$$$reportNull$$$0(0);
            }
            CloudConfigManager manager = CloudConfigManager.getInstance();
            e.getPresentation().setEnabledAndVisible(StatusBarInfoManager.isConnected() && (manager.hasPluginsUpdate() || manager.hasPluginsAnyUpdate()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyPluginsAction.$$$reportNull$$$0(1);
            }
            MyMessages.showPluginsDialog();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$MyPluginsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MySelfSettingsAction
    extends DumbAwareAction {
        public MySelfSettingsAction() {
            super(CloudConfigBundle.messagePointer("self.settings.action", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelfSettingsAction.$$$reportNull$$$0(0);
            }
            MyMessages.showSelfSettingsDialog();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cloudConfig/StatusBarInfoManager$MySelfSettingsAction", "actionPerformed"));
        }
    }

    public static class MyToggleAction
    extends ToggleAction
    implements DumbAware {
        public MyToggleAction() {
            super(CloudConfigBundle.messagePointer("plugins.auto.update", new Object[0]));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyToggleAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setEnabledAndVisible(StatusBarInfoManager.isConnected());
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyToggleAction.$$$reportNull$$$0(1);
            }
            return CloudConfigManager.getInstance().isAutoUpdatePlugins();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyToggleAction.$$$reportNull$$$0(2);
            }
            CloudConfigManager.getInstance().setAutoUpdatePlugins(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$MyToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MenuAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            CloudConfigManager manager;
            StatusInfo state;
            if (e == null) {
                MenuAction.$$$reportNull$$$0(0);
            }
            if ((state = (manager = CloudConfigManager.getInstance()).getStatusInfo()) == StatusInfo.OFFLINE && CloudConfigManager.isExclusiveStreamProviderEnabled()) {
                e.getPresentation().setEnabled(false);
                return;
            }
            boolean value = state.in(StatusInfo.OFFLINE, StatusInfo.JBA_THIS_NOT_CONNECTED);
            if (state == StatusInfo.JBA_IO_ERROR && manager.isConnectedState()) {
                value = false;
            }
            e.getPresentation().setEnabledAndVisible(value);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CloudConfigManager manager;
            StatusInfo state;
            if (e == null) {
                MenuAction.$$$reportNull$$$0(1);
            }
            if ((state = (manager = CloudConfigManager.getInstance()).getStatusInfo()) == StatusInfo.JBA_NOT_FOUND) {
                StatusBarInfoManager.showLoginDialog();
                return;
            }
            if (state == StatusInfo.OFFLINE) {
                StatusBarInfoManager.showOfflineMessage();
                return;
            }
            Project project = e.getProject();
            if (state == StatusInfo.DISABLED || state == StatusInfo.JBA_IO_ERROR) {
                manager.recalculateInitStatus(project);
            }
            if (manager.getStatusInfo() == StatusInfo.JBA_IO_ERROR) {
                StatusBarInfoManager.showErrorMessage(manager.getErrorMessage());
            } else {
                StatusBarInfoManager.connectInstance(project, StatusBarInfoManager.showPopupMessage(project));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/cloudConfig/StatusBarInfoManager$MenuAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MenuGroup
    extends DefaultActionGroup
    implements DumbAware {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MenuGroup.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabledAndVisible(StatusBarInfoManager.isConnected());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cloudConfig/StatusBarInfoManager$MenuGroup", "update"));
        }
    }

    public static class MyStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(0);
            }
            if (!ApplicationManager.getApplication().isUnitTestMode() && CloudConfigManager.getInstance().getStatusInfo().notDisabled()) {
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
                StatusBarWidget widget = statusBar.getWidget(StatusBarInfoManager.ID);
                if (widget == null) {
                    statusBar.addWidget((StatusBarWidget)new InfoComponent());
                    CloudConfigManager.LOG.info("=== StatusBar.start create ===");
                } else {
                    CloudConfigManager.LOG.info("=== StatusBar.start another widget: " + widget + " ===");
                }
            } else {
                CloudConfigManager.LOG.info("=== StatusBar ignored ===");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/cloudConfig/StatusBarInfoManager$MyStartupActivity", "runActivity"));
        }
    }
}

