/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import git4idea.GitUtil;
import git4idea.actions.GitOngoingOperationAction;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitSelectRootDialog;
import git4idea.repo.GitRepository;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0002J\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lgit4idea/actions/GitOperationActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lgit4idea/actions/GitOngoingOperationAction;", "repositoryState", "Lcom/intellij/dvcs/repo/Repository$State;", "(Lcom/intellij/dvcs/repo/Repository$State;)V", "operationName", "", "getOperationName", "()Ljava/lang/String;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "chooseRepository", "Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "getAffectedRepositories", "isEnabled", "", "repository", "update", "intellij.vcs.git"})
public abstract class GitOperationActionBase
extends DumbAwareAction
implements GitOngoingOperationAction {
    private final Repository.State repositoryState;

    @NotNull
    protected abstract String getOperationName();

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(!this.getAffectedRepositories(e.getProject()).isEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"e.getRequiredData(CommonDataKeys.PROJECT)");
        Project project = (Project)object;
        GitRepository repository = this.chooseRepository(project, this.getAffectedRepositories(project));
        if (repository != null) {
            this.performInBackground(repository);
        }
    }

    @Override
    public boolean isEnabled(@NotNull GitRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        return repository.getState() == this.repositoryState;
    }

    private final Collection<GitRepository> getAffectedRepositories(Project project) {
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Collection<GitRepository> collection = GitUtil.getRepositoriesInState(project, this.repositoryState);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"GitUtil.getRepositoriesI\u2026project, repositoryState)");
        return collection;
    }

    private final GitRepository chooseRepository(Project project, Collection<? extends GitRepository> repositories) {
        if (repositories.size() == 1) {
            return (GitRepository)CollectionsKt.single((Iterable)repositories);
        }
        Presentation presentation = this.getTemplatePresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
        String string = presentation.getText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = GitBundle.message("operation.action.message", this.getOperationName());
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"GitBundle.message(\"opera\u2026.message\", operationName)");
        return new GitSelectRootDialog(project, string, string2, repositories, null).selectRoot();
    }

    public GitOperationActionBase(@NotNull Repository.State repositoryState) {
        Intrinsics.checkParameterIsNotNull((Object)repositoryState, (String)"repositoryState");
        this.repositoryState = repositoryState;
    }
}

