/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.i18n.GitBundle;
import git4idea.index.GitFileStatus;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a \u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004\u001a\u001e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004\u001a\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0002\u001a\u0014\u0010\u0018\u001a\u00020\u00042\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0003\u001a\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0004\u001a\f\u0010\u0018\u001a\u00020\u0004*\u00020\u0007H\u0007\u001a\f\u0010\u0018\u001a\u00020\u0004*\u00020\u001bH\u0003\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\u0007\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u0004*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f*\n\u0010\u001f\"\u00020\u00162\u00020\u0016\u00a8\u0006 "}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NUL", "", "color", "Ljava/awt/Color;", "Lgit4idea/index/GitFileStatus;", "getColor", "(Lgit4idea/index/GitFileStatus;)Ljava/awt/Color;", "repositoryPath", "getRepositoryPath", "(Lgit4idea/index/GitFileStatus;)Ljava/lang/String;", "getFilePath", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "executable", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "status", "", "Lgit4idea/index/StatusCode;", "getPresentation", "parseGitStatusOutput", "", "Lgit4idea/index/GitFileStatus$StatusRecord;", "output", "isTracked", "", "StatusCode", "intellij.vcs.git"})
public final class GitIndexStatusUtilKt {
    @NotNull
    public static final String NUL = "\u0000";
    private static final Logger LOG;

    @NotNull
    public static final GitFileStatus getFileStatus(@NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull String executable) throws VcsException {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)executable, (String)"executable");
        GitLineHandler h = new GitLineHandler(null, VfsUtilCore.virtualToIoFile((VirtualFile)root), executable, GitCommand.STATUS, CollectionsKt.emptyList());
        h.setSilent(true);
        h.addParameters("--porcelain", "-z");
        GitVersion gitVersion = GitExecutableManager.getInstance().getVersion(executable);
        Intrinsics.checkExpressionValueIsNotNull((Object)gitVersion, (String)"GitExecutableManager.get\u2026().getVersion(executable)");
        GitVersion gitVersion2 = gitVersion;
        if (GitVersionSpecialty.STATUS_SUPPORTS_NO_RENAMES.existsIn(gitVersion2)) {
            h.addParameters("--no-renames");
        }
        if (GitVersionSpecialty.STATUS_SUPPORTS_IGNORED_MODES.existsIn(gitVersion2)) {
            h.addParameters("--ignored=matching");
        } else {
            h.addParameters("--ignored");
        }
        h.endOptions();
        h.addRelativePaths(filePath);
        String string = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Git.getInstance().runCommand(h).getOutputOrThrow()");
        String output = string;
        CharSequence charSequence = output;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            List<GitFileStatus.StatusRecord> gitStatusOutput = GitIndexStatusUtilKt.parseGitStatusOutput(output);
            GitFileStatus.StatusRecord statusRecord = (GitFileStatus.StatusRecord)CollectionsKt.firstOrNull(gitStatusOutput);
            return statusRecord != null ? (GitFileStatus)statusRecord : (GitFileStatus)GitFileStatus.Blank.INSTANCE;
        }
        String string2 = GitIndexStatusUtilKt.getFilePath(root, filePath, executable);
        if (string2 == null) {
            return GitFileStatus.Blank.INSTANCE;
        }
        String repositoryPath = string2;
        return new GitFileStatus.NotChanged(repositoryPath);
    }

    @Nullable
    public static final String getFilePath(@NotNull VirtualFile root, @NotNull FilePath filePath, @NotNull String executable) throws VcsException {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)executable, (String)"executable");
        GitLineHandler handler = new GitLineHandler(null, VfsUtilCore.virtualToIoFile((VirtualFile)root), executable, GitCommand.LS_FILES, CollectionsKt.emptyList());
        handler.addParameters("--full-name");
        handler.addRelativePaths(filePath);
        handler.setSilent(true);
        String string = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Git.getInstance().runCom\u2026ndler).getOutputOrThrow()");
        return (String)CollectionsKt.firstOrNull((List)StringsKt.lines((CharSequence)string));
    }

    @NotNull
    public static final List<GitFileStatus.StatusRecord> parseGitStatusOutput(@NotNull String output) throws VcsException {
        String[] split;
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        boolean bl = false;
        List result2 = new ArrayList();
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)output, (String[])new String[]{NUL}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        for (String line : split = stringArray) {
            String pathPart;
            if (StringUtil.isEmptyOrSpaces((String)line)) continue;
            if (line.length() < 4 || line.charAt(2) != ' ') {
                LOG.error("Could not parse status line '" + line + '\'');
                continue;
            }
            char xStatus = line.charAt(0);
            char yStatus = line.charAt(1);
            String string = line;
            int n = 3;
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2.substring(n), (String)"(this as java.lang.String).substring(startIndex)");
            result2.add(new GitFileStatus.StatusRecord(xStatus, yStatus, pathPart, null, 8, null));
        }
        return result2;
    }

    private static final FileStatus getFileStatus(char status) throws VcsException {
        FileStatus fileStatus;
        switch (status) {
            case ' ': {
                fileStatus = null;
                break;
            }
            case 'C': 
            case 'M': 
            case 'R': 
            case 'T': {
                fileStatus = FileStatus.MODIFIED;
                break;
            }
            case 'A': {
                fileStatus = FileStatus.ADDED;
                break;
            }
            case 'D': {
                fileStatus = FileStatus.DELETED;
                break;
            }
            case 'U': {
                fileStatus = FileStatus.MERGED_WITH_CONFLICTS;
                break;
            }
            case '!': {
                fileStatus = FileStatus.IGNORED;
                break;
            }
            case '?': {
                fileStatus = FileStatus.UNKNOWN;
                break;
            }
            default: {
                throw (Throwable)new VcsException("Unexpected symbol as status: " + status);
            }
        }
        return fileStatus;
    }

    public static final boolean isTracked(@NotNull GitFileStatus $this$isTracked) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$isTracked, (String)"$this$isTracked");
        GitFileStatus gitFileStatus = $this$isTracked;
        if (Intrinsics.areEqual((Object)gitFileStatus, (Object)GitFileStatus.Blank.INSTANCE)) {
            bl = false;
        } else if (gitFileStatus instanceof GitFileStatus.NotChanged) {
            bl = true;
        } else if (gitFileStatus instanceof GitFileStatus.StatusRecord) {
            bl = !SetsKt.setOf((Object[])new Character[]{Character.valueOf('?'), Character.valueOf('!')}).contains(Character.valueOf(((GitFileStatus.StatusRecord)$this$isTracked).getIndex()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Nullable
    public static final String getRepositoryPath(@NotNull GitFileStatus $this$repositoryPath) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$repositoryPath, (String)"$this$repositoryPath");
        GitFileStatus gitFileStatus = $this$repositoryPath;
        if (Intrinsics.areEqual((Object)gitFileStatus, (Object)GitFileStatus.Blank.INSTANCE)) {
            string = null;
        } else if (gitFileStatus instanceof GitFileStatus.NotChanged) {
            string = ((GitFileStatus.NotChanged)$this$repositoryPath).getPath();
        } else if (gitFileStatus instanceof GitFileStatus.StatusRecord) {
            if (!GitIndexStatusUtilKt.isTracked($this$repositoryPath) || ((GitFileStatus.StatusRecord)$this$repositoryPath).getIndex() == 'A' || ((GitFileStatus.StatusRecord)$this$repositoryPath).getWorkTree() == 'A') {
                string = null;
            } else {
                string = ((GitFileStatus.StatusRecord)$this$repositoryPath).getOrigPath();
                if (string == null) {
                    string = ((GitFileStatus.StatusRecord)$this$repositoryPath).getPath();
                }
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Nullable
    public static final Color getColor(@NotNull GitFileStatus $this$color) {
        Intrinsics.checkParameterIsNotNull((Object)$this$color, (String)"$this$color");
        return $this$color.getFileStatus$intellij_vcs_git().getColor();
    }

    @Nls
    @NotNull
    public static final String getPresentation(@NotNull GitFileStatus $this$getPresentation) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$getPresentation, (String)"$this$getPresentation");
        GitFileStatus gitFileStatus = $this$getPresentation;
        if (Intrinsics.areEqual((Object)gitFileStatus, (Object)GitFileStatus.Blank.INSTANCE) || gitFileStatus instanceof GitFileStatus.NotChanged) {
            string = "";
        } else if (gitFileStatus instanceof GitFileStatus.StatusRecord) {
            string = GitIndexStatusUtilKt.getPresentation((GitFileStatus.StatusRecord)$this$getPresentation);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Nls
    private static final String getPresentation(@NotNull GitFileStatus.StatusRecord $this$getPresentation) {
        String string;
        String string2;
        String string3 = PathUtil.getFileName((String)$this$getPresentation.getPath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"PathUtil.getFileName(path)");
        String fileName = string3;
        if ($this$getPresentation.getIndex() == '!' || $this$getPresentation.getWorkTree() == '!' || $this$getPresentation.getIndex() == '?' || $this$getPresentation.getWorkTree() == '?') {
            return fileName + ": " + GitIndexStatusUtilKt.getPresentation($this$getPresentation.getIndex());
        }
        if ($this$getPresentation.isConflicted$intellij_vcs_git()) {
            String string4;
            if ($this$getPresentation.getIndex() == $this$getPresentation.getWorkTree()) {
                Object[] objectArray = new Object[1];
                FileStatus fileStatus = GitIndexStatusUtilKt.getFileStatus($this$getPresentation.getIndex() == 'U' ? (char)'M' : (char)$this$getPresentation.getIndex());
                if (fileStatus == null) {
                    Intrinsics.throwNpe();
                }
                String string5 = fileStatus.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"getFileStatus(if (index \u2026') 'M' else index)!!.text");
                String string6 = string5;
                int n = 0;
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = objectArray;
                String string7 = "git.status.unmerged.both";
                boolean bl = false;
                String string8 = string6;
                if (string8 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).toLowerCase()");
                String string10 = string9;
                objectArray2[n] = string10;
                string4 = GitBundle.message(string7, objectArray3);
            } else {
                String string11;
                String string12;
                String string13;
                Object[] objectArray;
                Object[] objectArray4;
                int n;
                String string14;
                if ($this$getPresentation.getIndex() == 'U') {
                    string14 = "";
                } else {
                    String string15 = GitIndexStatusUtilKt.getPresentation($this$getPresentation.getIndex());
                    n = 0;
                    objectArray = objectArray4 = new Object[1];
                    string13 = "git.status.unmerged.index";
                    boolean bl = false;
                    String string16 = string15;
                    if (string16 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string17 = string16.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string17, (String)"(this as java.lang.String).toLowerCase()");
                    string12 = string17;
                    objectArray4[n] = string12;
                    String string18 = GitBundle.message(string13, objectArray);
                    string14 = string18;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string18, (String)"GitBundle.message(\"git.s\u2026ion(index).toLowerCase())");
                }
                String indexPresentation = string14;
                if ($this$getPresentation.getWorkTree() == 'U') {
                    string11 = "";
                } else {
                    String string19 = GitIndexStatusUtilKt.getPresentation($this$getPresentation.getWorkTree());
                    n = 0;
                    objectArray = objectArray4 = new Object[1];
                    string13 = "git.status.unmerged.work.tree";
                    boolean bl = false;
                    String string20 = string19;
                    if (string20 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string21 = string20.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string21, (String)"(this as java.lang.String).toLowerCase()");
                    string12 = string21;
                    objectArray4[n] = string12;
                    String string22 = GitBundle.message(string13, objectArray);
                    string11 = string22;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string22, (String)"GitBundle.message(\"git.s\u2026(workTree).toLowerCase())");
                }
                String workTreePresentation = string11;
                string4 = StringsKt.isBlank((CharSequence)indexPresentation) ? workTreePresentation : (StringsKt.isBlank((CharSequence)workTreePresentation) ? indexPresentation : indexPresentation + ", " + workTreePresentation);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"if (index == workTree) {\u2026esentation\"\n      }\n    }");
            String status = string4;
            return fileName + ": " + GitIndexStatusUtilKt.getPresentation('U') + " (" + status + ')';
        }
        if ($this$getPresentation.getIndex() == ' ') {
            string2 = "";
        } else {
            String string23 = GitBundle.message("git.status.index", GitIndexStatusUtilKt.getPresentation($this$getPresentation.getIndex()));
            string2 = string23;
            Intrinsics.checkExpressionValueIsNotNull((Object)string23, (String)"GitBundle.message(\"git.s\u2026, getPresentation(index))");
        }
        String indexPresentation = string2;
        if ($this$getPresentation.getWorkTree() == ' ') {
            string = "";
        } else {
            String string24 = GitBundle.message("git.status.work.tree", GitIndexStatusUtilKt.getPresentation($this$getPresentation.getWorkTree()));
            string = string24;
            Intrinsics.checkExpressionValueIsNotNull((Object)string24, (String)"GitBundle.message(\"git.s\u2026etPresentation(workTree))");
        }
        String workTreePresentation = string;
        if (StringsKt.isBlank((CharSequence)indexPresentation)) {
            return fileName + ": " + workTreePresentation;
        }
        if (StringsKt.isBlank((CharSequence)workTreePresentation)) {
            return fileName + ": " + indexPresentation;
        }
        return fileName + ":<br/>" + indexPresentation + "<br/>" + workTreePresentation;
    }

    @Nls
    private static final String getPresentation(char status) {
        String string;
        switch (status) {
            case ' ': {
                String string2 = GitBundle.message("git.status.not.changed", new Object[0]);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"GitBundle.message(\"git.status.not.changed\")");
                break;
            }
            case 'R': {
                String string3 = GitBundle.message("git.status.renamed", new Object[0]);
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"GitBundle.message(\"git.status.renamed\")");
                break;
            }
            case 'C': {
                String string4 = GitBundle.message("git.status.copied", new Object[0]);
                string = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"GitBundle.message(\"git.status.copied\")");
                break;
            }
            case 'T': {
                String string5 = GitBundle.message("git.status.type.changed", new Object[0]);
                string = string5;
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"GitBundle.message(\"git.status.type.changed\")");
                break;
            }
            case 'U': {
                String string6 = GitBundle.message("git.status.unmerged", new Object[0]);
                string = string6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"GitBundle.message(\"git.status.unmerged\")");
                break;
            }
            case '?': {
                String string7 = GitBundle.message("git.status.untracked", new Object[0]);
                string = string7;
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"GitBundle.message(\"git.status.untracked\")");
                break;
            }
            default: {
                FileStatus fileStatus = GitIndexStatusUtilKt.getFileStatus(status);
                if (fileStatus == null) {
                    Intrinsics.throwNpe();
                }
                String string8 = fileStatus.getText();
                string = string8;
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"getFileStatus(status)!!.text");
            }
        }
        return string;
    }

    static {
        Logger logger = Logger.getInstance((String)"#git4idea.index.GitIndexStatusUtil");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#git\u2026ndex.GitIndexStatusUtil\")");
        LOG = logger;
    }

    public static final /* synthetic */ FileStatus access$getFileStatus(char status) {
        return GitIndexStatusUtilKt.getFileStatus(status);
    }
}

