/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;

public abstract class AssignableNode
extends Node {
    private Node valueNode;

    public AssignableNode(SourcePosition position) {
        super(position);
    }

    public AssignableNode(SourcePosition position, Node valueNode) {
        super(position);
        this.valueNode = this.adopt(valueNode);
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        AssignableNode other = (AssignableNode)node;
        if (this.getValue() == null && other.getValue() == null) {
            return true;
        }
        if (this.getValue() == null || other.getValue() == null) {
            return false;
        }
        return this.getValue().isSame(other.getValue());
    }

    public Node getValue() {
        return this.valueNode;
    }

    @Deprecated
    public Node getValueNode() {
        return this.getValue();
    }

    public void setValue(Node valueNode) {
        this.valueNode = this.adopt(valueNode);
    }

    @Deprecated
    public void setValueNode(Node valueNode) {
        this.setValue(valueNode);
    }

    public SourcePosition getLeftHandSidePosition() {
        if (!(this instanceof INameNode)) {
            throw new UnsupportedOperationException("getLeftHandSidePosition() needs impl");
        }
        SourcePosition position = this.getPosition();
        return new SourcePosition(position.getFile(), position.getStartLine(), position.getEndLine(), position.getStartOffset(), position.getStartOffset() + ((INameNode)((Object)this)).getName().length());
    }
}

