/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public class ShellVariablesRegistry {
    @NotNull
    private final MultiMap<String, TextMateShellVariable> myVariables = MultiMap.create();

    public void fillVariablesFromPlist(@NotNull CharSequence scopeName, @NotNull Plist plist) {
        PListValue shellVariables;
        if (scopeName == null) {
            ShellVariablesRegistry.$$$reportNull$$$0(0);
        }
        if (plist == null) {
            ShellVariablesRegistry.$$$reportNull$$$0(1);
        }
        if ((shellVariables = plist.getPlistValue("shellVariables")) != null) {
            for (PListValue variable : shellVariables.getArray()) {
                Plist variablePlist = variable.getPlist();
                String name = variablePlist.getPlistValue("name", "").getString();
                String value = variablePlist.getPlistValue("value", "").getString();
                if (name.isEmpty()) continue;
                this.myVariables.putValue((Object)name, (Object)new TextMateShellVariable(scopeName, name, value));
            }
        }
    }

    @Nullable
    public TextMateShellVariable getVariableValue(@NotNull String name, @Nullable CharSequence scopeSelector) {
        if (name == null) {
            ShellVariablesRegistry.$$$reportNull$$$0(2);
        }
        if (scopeSelector == null) {
            return null;
        }
        return (TextMateShellVariable)new TextMateScopeComparator(scopeSelector).max(this.myVariables.get((Object)name));
    }

    public void clear() {
        this.myVariables.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillVariablesFromPlist";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariableValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

