/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.Searcher;
import org.jetbrains.plugins.textmate.regex.StringWithId;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.exception.JOniException;

public class RegexFacade {
    private static final Regex FAILED_REGEX = new Regex("^$", (Encoding)UTF8Encoding.INSTANCE);
    private static final Logger LOGGER = Logger.getInstance(RegexFacade.class);
    @NotNull
    private final Regex myRegex;
    private final ThreadLocal<LastMatch> matchResult;
    private static final LoadingCache<String, RegexFacade> REGEX_CACHE = CacheBuilder.newBuilder().maximumSize(1024L).softValues().build(CacheLoader.from(regexString -> new RegexFacade(Objects.requireNonNull(regexString))));

    private RegexFacade(@NotNull String regexString) {
        Regex regex;
        if (regexString == null) {
            RegexFacade.$$$reportNull$$$0(0);
        }
        this.matchResult = new ThreadLocal();
        byte[] bytes = regexString.getBytes(StandardCharsets.UTF_8);
        try {
            regex = new Regex(bytes, 0, bytes.length, 256, (Encoding)UTF8Encoding.INSTANCE);
        }
        catch (JOniException e) {
            LOGGER.info("Failed to parse textmate regex", (Throwable)e);
            regex = FAILED_REGEX;
        }
        this.myRegex = regex;
    }

    public MatchData match(StringWithId string) {
        return this.match(string, 0);
    }

    public MatchData match(@NotNull StringWithId string, int byteOffset) {
        MatchData lastMatch;
        LastMatch lastResult;
        if (string == null) {
            RegexFacade.$$$reportNull$$$0(1);
        }
        Object lastId = (lastResult = this.matchResult.get()) != null ? lastResult.lastId : null;
        int lastOffset = lastResult != null ? lastResult.lastOffset : Integer.MAX_VALUE;
        MatchData matchData = lastMatch = lastResult != null ? lastResult.lastMatch : MatchData.NOT_MATCHED;
        if (!(lastId != string.id || lastOffset > byteOffset || lastMatch.matched() && lastMatch.byteOffset().getStartOffset() < byteOffset)) {
            RegexFacade.checkMatched(lastMatch, string);
            return lastMatch;
        }
        ProgressManager.checkCanceled();
        lastId = string.id;
        lastOffset = byteOffset;
        Matcher matcher = this.myRegex.matcher(string.bytes);
        int matchIndex = matcher.search(byteOffset, string.bytes.length, 256);
        lastMatch = matchIndex > -1 ? MatchData.fromRegion(matcher.getEagerRegion()) : MatchData.NOT_MATCHED;
        RegexFacade.checkMatched(lastMatch, string);
        this.matchResult.set(new LastMatch(lastId, lastOffset, lastMatch));
        return lastMatch;
    }

    private static void checkMatched(MatchData match, StringWithId string) {
        if (match.matched() && match.byteOffset().getEndOffset() > string.bytes.length) {
            throw new IllegalStateException("Match data out of bounds: " + match.byteOffset().getStartOffset() + " > " + string.bytes.length + "\n" + new String(string.bytes, StandardCharsets.UTF_8));
        }
    }

    public Searcher searcher(byte[] stringBytes) {
        return new Searcher(stringBytes, this.myRegex.matcher(stringBytes, 0, stringBytes.length));
    }

    @NotNull
    public static RegexFacade regex(@NotNull String regexString) {
        RegexFacade regexFacade;
        if (regexString == null) {
            RegexFacade.$$$reportNull$$$0(2);
        }
        try {
            regexFacade = (RegexFacade)REGEX_CACHE.get((Object)regexString);
        }
        catch (ExecutionException e) {
            return new RegexFacade(regexString);
        }
        if (regexFacade == null) {
            RegexFacade.$$$reportNull$$$0(3);
        }
        return regexFacade;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/regex/RegexFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/regex/RegexFacade";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "regex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "regex";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LastMatch {
        private final Object lastId;
        private final int lastOffset;
        private final MatchData lastMatch;

        private LastMatch(Object id, int offset, MatchData data) {
            this.lastId = id;
            this.lastOffset = offset;
            this.lastMatch = data;
        }
    }
}

